/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.natives.test;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.ObjectValue;

public class MockRegistry {
    public static final String ANY = "__ANY__";
    private static MockRegistry instance = new MockRegistry();
    private Map<String, Object> casesMap = new HashMap<String, Object>();
    private Map<String, Integer> memberFuncHitsMap = new HashMap<String, Integer>();

    public static MockRegistry getInstance() {
        return instance;
    }

    public void registerCase(ObjectValue mockObject, String functionName, ArrayValue argsList, Object returnVal, int hittingCount) {
        String caseId = this.constructCaseId(mockObject, functionName, argsList);
        if (!this.hasHitCount(caseId)) {
            this.memberFuncHitsMap.put(caseId, 1);
        }
        caseId = caseId + "-" + hittingCount;
        this.casesMap.put(caseId, returnVal);
    }

    public void registerCase(ObjectValue mockObject, String functionName, ArrayValue argsList, Object returnVal) {
        String caseId = this.constructCaseId(mockObject, functionName, argsList);
        this.casesMap.put(caseId, returnVal);
    }

    private String constructCaseId(ObjectValue mockObject, String functionName, ArrayValue argsList) {
        StringBuilder caseIdBuilder = new StringBuilder();
        if (mockObject != null) {
            caseIdBuilder.append(mockObject.hashCode());
            if (functionName != null) {
                caseIdBuilder.append("-").append(functionName);
            }
            if (argsList != null && argsList.size() > 0) {
                IteratorValue argIterator = argsList.getIterator();
                while (argIterator.hasNext()) {
                    caseIdBuilder.append("-").append(argIterator.next().toString());
                }
            }
        }
        return caseIdBuilder.toString();
    }

    public Object getReturnValue(String caseId) {
        return this.casesMap.get(caseId);
    }

    public boolean hasCase(String caseId) {
        return this.casesMap.containsKey(caseId);
    }

    public Map<String, Integer> getMemberFuncHitsMap() {
        return this.memberFuncHitsMap;
    }

    public boolean hasHitCount(String caseId) {
        return this.memberFuncHitsMap.containsKey(caseId);
    }
}

