/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.task.utils;

import java.util.Objects;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.stdlib.task.exceptions.SchedulingException;
import org.ballerinalang.stdlib.task.objects.Appointment;
import org.ballerinalang.stdlib.task.objects.ServiceInformation;
import org.ballerinalang.stdlib.task.objects.Timer;
import org.ballerinalang.stdlib.task.utils.TaskConstants;
import org.quartz.CronExpression;

public class Utils {
    private static final int VALID_RESOURCE_COUNT = 1;

    public static ErrorValue createTaskError(String message) {
        return Utils.createTaskError("{ballerina/task}ListenerError", message);
    }

    public static ErrorValue createTaskError(String reason, String message) {
        MapValue<String, Object> detail = Utils.createTaskDetailRecord(message);
        return BallerinaErrors.createError((String)reason, detail);
    }

    private static MapValue<String, Object> createTaskDetailRecord(String message) {
        return Utils.createTaskDetailRecord(message, null);
    }

    private static MapValue<String, Object> createTaskDetailRecord(String message, ErrorValue cause) {
        MapValue detail = BallerinaValues.createRecordValue((BPackage)TaskConstants.TASK_PACKAGE_ID, (String)"Detail");
        return BallerinaValues.createRecord((MapValue)detail, (Object[])new Object[]{message, cause});
    }

    public static String getCronExpressionFromAppointmentRecord(Object record) throws SchedulingException {
        String cronExpression;
        if ("AppointmentData".equals(TypeChecker.getType((Object)record).getName())) {
            cronExpression = Utils.buildCronExpression((MapValue<String, Object>)((MapValue)record));
            if (!CronExpression.isValidExpression((String)cronExpression)) {
                throw new SchedulingException("AppointmentData \"" + record.toString() + "\" is invalid.");
            }
        } else {
            cronExpression = record.toString();
            if (!CronExpression.isValidExpression((String)cronExpression)) {
                throw new SchedulingException("Cron Expression \"" + cronExpression + "\" is invalid.");
            }
        }
        return cronExpression;
    }

    private static String buildCronExpression(MapValue<String, Object> record) {
        String cronExpression = Utils.getStringFieldValue(record, "seconds") + " " + Utils.getStringFieldValue(record, "minutes") + " " + Utils.getStringFieldValue(record, "hours") + " " + Utils.getStringFieldValue(record, "daysOfMonth") + " " + Utils.getStringFieldValue(record, "months") + " " + Utils.getStringFieldValue(record, "daysOfWeek") + " " + Utils.getStringFieldValue(record, "year");
        return cronExpression.trim();
    }

    private static String getStringFieldValue(MapValue<String, Object> record, String fieldName) {
        if ("daysOfMonth".equals(fieldName) && Objects.isNull(record.get((Object)"daysOfMonth"))) {
            return "?";
        }
        if (Objects.nonNull(record.get((Object)fieldName))) {
            return record.get((Object)fieldName).toString();
        }
        return "*";
    }

    public static void validateService(ServiceInformation serviceInformation) throws SchedulingException {
        AttachedFunction[] resources = serviceInformation.getService().getType().getAttachedFunctions();
        if (resources.length != 1) {
            throw new SchedulingException("Invalid number of resources found in service '" + serviceInformation.getServiceName() + "'. Task service should include only one resource.");
        }
        AttachedFunction resource = resources[0];
        if (!"onTrigger".equals(resource.getName())) {
            throw new SchedulingException("Invalid resource function found: " + resource.getName() + ". Expected: '" + "onTrigger" + "'.");
        }
        Utils.validateOnTriggerResource(resource.getReturnParameterType());
    }

    private static void validateOnTriggerResource(BType returnParameterType) throws SchedulingException {
        if (returnParameterType != BTypes.typeNull) {
            throw new SchedulingException("Invalid resource function signature: 'onTrigger' should not return a value.");
        }
    }

    public static Timer processTimer(MapValue<String, Object> configurations) throws SchedulingException {
        Timer task;
        long interval = ((Long)configurations.get((Object)"intervalInMillis")).intValue();
        long delay = ((Long)configurations.get((Object)"initialDelayInMillis")).intValue();
        if (configurations.get((Object)"noOfRecurrences") == null) {
            task = new Timer(delay, interval);
        } else {
            long noOfRuns = ((Long)configurations.get((Object)"noOfRecurrences")).intValue();
            task = new Timer(delay, interval, noOfRuns);
        }
        return task;
    }

    public static Appointment processAppointment(MapValue<String, Object> configurations) throws SchedulingException {
        Appointment appointment;
        Object appointmentDetails = configurations.get((Object)"appointmentDetails");
        String cronExpression = Utils.getCronExpressionFromAppointmentRecord(appointmentDetails);
        if (configurations.get((Object)"noOfRecurrences") == null) {
            appointment = new Appointment(cronExpression);
        } else {
            long noOfRuns = ((Long)configurations.get((Object)"noOfRecurrences")).intValue();
            appointment = new Appointment(cronExpression, noOfRuns);
        }
        return appointment;
    }
}

