/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.basic.consumer;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.observability.NatsMetricsUtil;

public class Detach {
    private static final PrintStream console = System.out;

    public static Object basicDetach(ObjectValue listener, ObjectValue service) {
        ObjectValue connectionObject = (ObjectValue)listener.get("conn");
        List serviceList = (List)connectionObject.getNativeData("service_list");
        NatsMetricsUtil natsMetricsUtil = (NatsMetricsUtil)connectionObject.getNativeData("nats_metric_util");
        MapValue<String, Object> subscriptionConfig = Utils.getSubscriptionConfig(service.getType().getAnnotation("ballerina/nats", "SubscriptionConfig"));
        if (subscriptionConfig == null) {
            return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)"Error occurred while un-subscribing, Cannot find subscription configuration");
        }
        ConcurrentHashMap dispatcherList = (ConcurrentHashMap)listener.getNativeData("dispatcher_list");
        String subject = subscriptionConfig.getStringValue("subject");
        Dispatcher dispatcher = (Dispatcher)dispatcherList.get(service.getType().getName());
        try {
            dispatcher.unsubscribe(subject);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)("Error occurred while un-subscribing " + ex.getMessage()));
        }
        console.println("[ballerina/nats] Client unsubscribed from subject " + subject);
        serviceList.remove(service);
        dispatcherList.remove(service.getType().getName());
        Connection natsConnection = (Connection)((ObjectValue)listener.get("conn")).getNativeData("nats_connection");
        if (natsConnection != null) {
            natsMetricsUtil.reportUnsubscription(subject);
        }
        return null;
    }
}

