/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.basic.consumer;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.services.ErrorHandlerUtils;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.observability.NatsMetricsUtil;

public class ErrorHandler {
    static void dispatchError(ObjectValue serviceObject, ObjectValue msgObj, ErrorValue e, BRuntime runtime, NatsMetricsUtil natsMetricsUtil) {
        boolean onErrorResourcePresent = Arrays.stream(serviceObject.getType().getAttachedFunctions()).anyMatch(resource -> resource.getName().equals("onError"));
        if (onErrorResourcePresent) {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            runtime.invokeMethodAsync(serviceObject, "onError", (CallableUnitCallback)new ResponseCallback(countDownLatch, msgObj.getStringValue("subject"), natsMetricsUtil), new Object[]{msgObj, true, e, true});
            try {
                countDownLatch.await();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw Utils.createNatsError("Internal error occurred. The current thread got interrupted.");
            }
        }
    }

    private ErrorHandler() {
    }

    public static class ResponseCallback
    implements CallableUnitCallback {
        private CountDownLatch countDownLatch;
        private String subject;
        private NatsMetricsUtil natsMetricsUtil;

        ResponseCallback(CountDownLatch countDownLatch, String subject, NatsMetricsUtil natsMetricsUtil) {
            this.countDownLatch = countDownLatch;
            this.natsMetricsUtil = natsMetricsUtil;
            this.subject = subject;
        }

        public void notifySuccess() {
            this.countDownLatch.countDown();
            this.natsMetricsUtil.reportConsumerError(this.subject, "message_received");
        }

        public void notifyFailure(ErrorValue error) {
            ErrorHandlerUtils.printError((Throwable)error);
            this.natsMetricsUtil.reportConsumerError(this.subject, "on_error");
            this.countDownLatch.countDown();
        }
    }
}

