/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.basic.consumer;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.observability.NatsMetricsUtil;
import org.ballerinalang.nats.observability.NatsTracingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulStop {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulStop.class);

    public static void basicGracefulStop(ObjectValue listenerObject) {
        NatsTracingUtil.traceResourceInvocation(Scheduler.getStrand(), listenerObject);
        ObjectValue connectionObject = (ObjectValue)listenerObject.get("conn");
        NatsMetricsUtil natsMetricsUtil = (NatsMetricsUtil)connectionObject.getNativeData("nats_metric_util");
        Connection natsConnection = (Connection)connectionObject.getNativeData("nats_connection");
        if (natsConnection == null) {
            NatsMetricsUtil.reportConsumerError("close");
            LOG.debug("NATS connection does not exist. Possibly the connection is already closed.");
            return;
        }
        ConcurrentHashMap dispatcherList = (ConcurrentHashMap)listenerObject.getNativeData("dispatcher_list");
        Iterator dispatchers = dispatcherList.entrySet().iterator();
        while (dispatchers.hasNext()) {
            Map.Entry pair = dispatchers.next();
            natsConnection.closeDispatcher((Dispatcher)pair.getValue());
            dispatchers.remove();
        }
        ArrayList subscriptionsList = (ArrayList)listenerObject.getNativeData("BasicSubscriptionList");
        natsMetricsUtil.reportBulkUnsubscription(subscriptionsList);
        int clientsCount = ((AtomicInteger)connectionObject.getNativeData("connected_clients")).decrementAndGet();
        if (clientsCount == 0) {
            try {
                natsConnection.drain(Duration.ZERO);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                natsMetricsUtil.reportConsumerError("unknown", "close");
                throw Utils.createNatsError("Listener interrupted on graceful stop.");
            }
            catch (TimeoutException e) {
                natsMetricsUtil.reportConsumerError("unknown", "close");
                throw Utils.createNatsError("Timeout error occurred, on graceful stop.");
            }
            catch (IllegalStateException e) {
                natsMetricsUtil.reportConsumerError("unknown", "close");
                throw Utils.createNatsError("Connection is already closed.");
            }
        }
    }
}

