/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.basic.producer;

import io.nats.client.Connection;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.observability.NatsMetricsUtil;
import org.ballerinalang.nats.observability.NatsTracingUtil;

public class Publish {
    public static Object externPublish(ObjectValue producerObject, String subject, Object data, Object replyTo) {
        NatsTracingUtil.traceResourceInvocation(Scheduler.getStrand(), producerObject, subject);
        Object connection = producerObject.get("conn");
        if (TypeChecker.getType((Object)connection).getTag() == 34) {
            ObjectValue connectionObject = (ObjectValue)connection;
            Connection natsConnection = (Connection)connectionObject.getNativeData("nats_connection");
            NatsMetricsUtil natsMetricsUtil = (NatsMetricsUtil)connectionObject.getNativeData("nats_metric_util");
            if (natsConnection == null) {
                natsMetricsUtil.reportProducerError(subject, "publish");
                return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)("Error while publishing message to subject " + subject + ". NATS connection doesn't exist."));
            }
            byte[] byteContent = Utils.convertDataIntoByteArray(data);
            try {
                if (TypeChecker.getType((Object)replyTo).getTag() == 5) {
                    natsConnection.publish(subject, (String)replyTo, byteContent);
                } else if (TypeChecker.getType((Object)replyTo).getTag() == 19) {
                    MapValue<String, Object> subscriptionConfig = Publish.getSubscriptionConfig(((ObjectValue)replyTo).getType().getAnnotation("ballerina/nats", "SubscriptionConfig"));
                    if (subscriptionConfig == null) {
                        natsMetricsUtil.reportProducerError(subject, "publish");
                        return Utils.createNatsError("Cannot find subscription configuration");
                    }
                    String replyToSubject = subscriptionConfig.getStringValue("subject");
                    natsConnection.publish(subject, replyToSubject, byteContent);
                } else {
                    natsConnection.publish(subject, byteContent);
                }
                natsMetricsUtil.reportPublish(subject, byteContent.length);
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                natsMetricsUtil.reportProducerError(subject, "publish");
                return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)("Error while publishing message to subject " + subject + ". " + ex.getMessage()));
            }
        } else {
            NatsMetricsUtil.reportProducerError("publish");
            return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)("Error while publishing message to subject " + subject + ". Producer is logically disconnected."));
        }
        return null;
    }

    private static MapValue<String, Object> getSubscriptionConfig(Object annotationData) {
        MapValue annotationRecord = null;
        if (TypeChecker.getType((Object)annotationData).getTag() == 12) {
            annotationRecord = (MapValue)annotationData;
        }
        return annotationRecord;
    }
}

