/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.streaming.consumer;

import io.nats.streaming.StreamingConnection;
import io.nats.streaming.Subscription;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.observability.NatsMetricsUtil;

public class Detach {
    public static void streamingDetach(ObjectValue streamingListener, ObjectValue service) {
        ConcurrentHashMap serviceListenerMap = (ConcurrentHashMap)streamingListener.getNativeData("StreamingDispatcherList");
        ConcurrentHashMap subscriptionsMap = (ConcurrentHashMap)streamingListener.getNativeData("StreamingSubscriptionsList");
        Subscription subscription = (Subscription)subscriptionsMap.get(service);
        try {
            if (subscription == null) {
                return;
            }
            subscription.unsubscribe();
            subscriptionsMap.remove(service);
            serviceListenerMap.remove(service);
            StreamingConnection streamingConnection = (StreamingConnection)streamingListener.getNativeData("nats_streaming_connection");
            if (streamingConnection != null) {
                NatsMetricsUtil.reportStreamingUnsubscription(streamingConnection.getNatsConnection().getConnectedUrl(), subscription.getSubject());
            }
        }
        catch (IOException e) {
            throw Utils.createNatsError("Error occurred while un-subscribing: " + e.getMessage());
        }
    }
}

