/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.streaming.producer;

import io.nats.streaming.AckHandler;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.observability.NatsMetricsUtil;

public class AckListener
implements AckHandler {
    private NonBlockingCallback nonBlockingCallback;
    private String subject;
    private NatsMetricsUtil natsMetricsUtil;

    AckListener(NonBlockingCallback nonBlockingCallback, String subject, NatsMetricsUtil natsMetricsUtil) {
        this.nonBlockingCallback = nonBlockingCallback;
        this.subject = subject;
        this.natsMetricsUtil = natsMetricsUtil;
    }

    public void onAck(String nuid, Exception ex) {
        if (ex == null) {
            this.natsMetricsUtil.reportAcknowledgement(this.subject);
            this.nonBlockingCallback.setReturnValues((Object)nuid);
        } else {
            this.natsMetricsUtil.reportProducerError(this.subject, "acknowledgement");
            ErrorValue error = Utils.createNatsError(nuid, ex.getMessage());
            this.nonBlockingCallback.setReturnValues((Object)error);
        }
        this.nonBlockingCallback.notifySuccess();
    }
}

