/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.NodeKind;
import org.wso2.ballerinalang.compiler.PackageLoader;
import org.wso2.ballerinalang.compiler.bir.writer.CPEntry;
import org.wso2.ballerinalang.compiler.packaging.RepoHierarchy;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeParamAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstructorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BStructureTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.TaintRecord;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnnotationType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangConstantValue;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;
import org.wso2.ballerinalang.programfile.CompiledBinaryFile;
import org.wso2.ballerinalang.util.Flags;
import org.wso2.ballerinalang.util.LambdaExceptionUtils;

public class BIRPackageSymbolEnter {
    private final PackageLoader packageLoader;
    private final SymbolResolver symbolResolver;
    private final SymbolTable symTable;
    private final Names names;
    private final TypeParamAnalyzer typeParamAnalyzer;
    private final BLangDiagnosticLogHelper dlog;
    private BIRTypeReader typeReader;
    private BIRPackageSymbolEnv env;
    private List<BStructureTypeSymbol> structureTypes;
    private BStructureTypeSymbol currentStructure = null;
    private LinkedList<Object> compositeStack = new LinkedList();
    private static final CompilerContext.Key<BIRPackageSymbolEnter> COMPILED_PACKAGE_SYMBOL_ENTER_KEY = new CompilerContext.Key();

    public static BIRPackageSymbolEnter getInstance(CompilerContext context) {
        BIRPackageSymbolEnter packageReader = context.get(COMPILED_PACKAGE_SYMBOL_ENTER_KEY);
        if (packageReader == null) {
            packageReader = new BIRPackageSymbolEnter(context);
        }
        return packageReader;
    }

    private BIRPackageSymbolEnter(CompilerContext context) {
        context.put(COMPILED_PACKAGE_SYMBOL_ENTER_KEY, this);
        this.packageLoader = PackageLoader.getInstance(context);
        this.symbolResolver = SymbolResolver.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.names = Names.getInstance(context);
        this.typeParamAnalyzer = TypeParamAnalyzer.getInstance(context);
        this.dlog = BLangDiagnosticLogHelper.getInstance(context);
    }

    public BPackageSymbol definePackage(PackageID packageId, RepoHierarchy packageRepositoryHierarchy, byte[] packageBinaryContent) {
        BPackageSymbol pkgSymbol = this.definePackage(packageId, packageRepositoryHierarchy, new ByteArrayInputStream(packageBinaryContent));
        byte[] modifiedPkgBinaryContent = Arrays.copyOfRange(packageBinaryContent, 8, packageBinaryContent.length);
        pkgSymbol.birPackageFile = new CompiledBinaryFile.BIRPackageFile(modifiedPkgBinaryContent);
        SymbolEnv builtinEnv = this.symTable.pkgEnvMap.get(this.symTable.langAnnotationModuleSymbol);
        SymbolEnv pkgEnv = SymbolEnv.createPkgEnv(null, pkgSymbol.scope, builtinEnv);
        this.symTable.pkgEnvMap.put(pkgSymbol, pkgEnv);
        return pkgSymbol;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BPackageSymbol definePackage(PackageID packageId, RepoHierarchy packageRepositoryHierarchy, InputStream programFileInStream) {
        try (DataInputStream dataInStream = new DataInputStream(programFileInStream);){
            BIRPackageSymbolEnv prevEnv = this.env;
            this.env = new BIRPackageSymbolEnv();
            this.env.requestedPackageId = packageId;
            this.env.repoHierarchy = packageRepositoryHierarchy;
            BPackageSymbol pkgSymbol = this.definePackage(dataInStream);
            this.env = prevEnv;
            BPackageSymbol bPackageSymbol = pkgSymbol;
            return bPackageSymbol;
        }
        catch (IOException e) {
            throw new BLangCompilerException(e.getMessage(), e);
        }
        catch (Throwable e) {
            throw new BLangCompilerException(e.getMessage(), e);
        }
    }

    private BPackageSymbol definePackage(DataInputStream dataInStream) throws IOException {
        byte[] magic = new byte[4];
        dataInStream.read(magic, 0, 4);
        if (!Arrays.equals(magic, CompiledBinaryFile.BIRPackageFile.BIR_MAGIC)) {
            throw new BLangCompilerException("invalid magic number " + Arrays.toString(magic));
        }
        int version = dataInStream.readInt();
        if (version != 51) {
            throw new BLangCompilerException("unsupported program file version " + version);
        }
        this.env.constantPool = this.readConstantPool(dataInStream);
        int pkgCPIndex = dataInStream.readInt();
        return this.definePackage(dataInStream, pkgCPIndex);
    }

    private BPackageSymbol definePackage(DataInputStream dataInStream, int pkgCpIndex) throws IOException {
        CPEntry.PackageCPEntry pkgCpEntry = (CPEntry.PackageCPEntry)this.env.constantPool[pkgCpIndex];
        String orgName = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.orgNameCPIndex]).value;
        String pkgName = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.pkgNameCPIndex]).value;
        String pkgVersion = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.versionCPIndex]).value;
        PackageID pkgId = this.createPackageID(orgName, pkgName, pkgVersion);
        this.env.pkgSymbol = Symbols.createPackageSymbol(pkgId, this.symTable);
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineImportPackage));
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineConstant));
        this.structureTypes = new ArrayList<BStructureTypeSymbol>();
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineTypeDef));
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::definePackageLevelVariables));
        this.readTypeDefBodies(dataInStream);
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineFunction));
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineAnnotations));
        this.typeReader = null;
        return this.env.pkgSymbol;
    }

    private void readTypeDefBodies(DataInputStream dataInStream) throws IOException {
        Iterator<BStructureTypeSymbol> iterator = this.structureTypes.iterator();
        while (iterator.hasNext()) {
            BStructureTypeSymbol structureTypeSymbol;
            this.currentStructure = structureTypeSymbol = iterator.next();
            this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineFunction));
            this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::readBType));
        }
        this.currentStructure = null;
    }

    private CPEntry[] readConstantPool(DataInputStream dataInStream) throws IOException {
        int constantPoolSize = dataInStream.readInt();
        CPEntry[] constantPool = new CPEntry[constantPoolSize];
        this.env.constantPool = constantPool;
        for (int i = 0; i < constantPoolSize; ++i) {
            byte cpTag = dataInStream.readByte();
            CPEntry.Type cpEntryType = CPEntry.Type.values()[cpTag - 1];
            constantPool[i] = this.readCPEntry(dataInStream, constantPool, cpEntryType, i);
        }
        return constantPool;
    }

    private CPEntry readCPEntry(DataInputStream dataInStream, CPEntry[] constantPool, CPEntry.Type cpEntryType, int i) throws IOException {
        switch (cpEntryType) {
            case CP_ENTRY_INTEGER: {
                return new CPEntry.IntegerCPEntry(dataInStream.readLong());
            }
            case CP_ENTRY_FLOAT: {
                return new CPEntry.FloatCPEntry(dataInStream.readDouble());
            }
            case CP_ENTRY_BOOLEAN: {
                return new CPEntry.BooleanCPEntry(dataInStream.readBoolean());
            }
            case CP_ENTRY_STRING: {
                int length = dataInStream.readInt();
                String strValue = null;
                if (length >= 0) {
                    byte[] bytes = new byte[length];
                    dataInStream.read(bytes, 0, length);
                    strValue = new String(bytes);
                }
                return new CPEntry.StringCPEntry(strValue);
            }
            case CP_ENTRY_PACKAGE: {
                return new CPEntry.PackageCPEntry(dataInStream.readInt(), dataInStream.readInt(), dataInStream.readInt());
            }
            case CP_ENTRY_SHAPE: {
                this.env.unparsedBTypeCPs.put(i, this.readByteArray(dataInStream));
                return null;
            }
            case CP_ENTRY_BYTE: {
                return new CPEntry.ByteCPEntry(dataInStream.readInt());
            }
        }
        throw new IllegalStateException("unsupported constant pool entry type: " + cpEntryType.name());
    }

    private byte[] readByteArray(DataInputStream dataInStream) throws IOException {
        int length = dataInStream.readInt();
        byte[] bytes = new byte[length];
        dataInStream.readFully(bytes);
        return bytes;
    }

    private void defineSymbols(DataInputStream dataInStream, Consumer<DataInputStream> symbolDefineFunc) throws IOException {
        int symbolCount = dataInStream.readInt();
        for (int i = 0; i < symbolCount; ++i) {
            symbolDefineFunc.accept(dataInStream);
        }
    }

    private void defineImportPackage(DataInputStream dataInStream) throws IOException {
        String orgName = this.getStringCPEntryValue(dataInStream);
        String pkgName = this.getStringCPEntryValue(dataInStream);
        String pkgVersion = this.getStringCPEntryValue(dataInStream);
        PackageID importPkgID = this.createPackageID(orgName, pkgName, pkgVersion);
        BPackageSymbol importPackageSymbol = this.packageLoader.loadPackageSymbol(importPkgID, this.env.pkgSymbol.pkgID, this.env.repoHierarchy);
        this.env.pkgSymbol.scope.define(importPkgID.name, importPackageSymbol);
        this.env.pkgSymbol.imports.add(importPackageSymbol);
    }

    private void defineFunction(DataInputStream dataInStream) throws IOException {
        dataInStream.readInt();
        dataInStream.readInt();
        dataInStream.readInt();
        dataInStream.readInt();
        String source = this.getStringCPEntryValue(dataInStream);
        String funcName = this.getStringCPEntryValue(dataInStream);
        String workerName = this.getStringCPEntryValue(dataInStream);
        int flags = dataInStream.readInt();
        BInvokableType funcType = (BInvokableType)this.readBType(dataInStream);
        BInvokableSymbol invokableSymbol = Symbols.createFunctionSymbol(flags, this.names.fromString(funcName), this.env.pkgSymbol.pkgID, funcType, this.env.pkgSymbol, Symbols.isFlagOn(flags, 2));
        invokableSymbol.source = source;
        invokableSymbol.retType = funcType.retType;
        Scope scopeToDefine = this.env.pkgSymbol.scope;
        if (this.currentStructure != null) {
            BType attachedType = this.currentStructure.type;
            invokableSymbol.owner = attachedType.tsymbol;
            invokableSymbol.name = this.names.fromString(Symbols.getAttachedFuncSymbolName(attachedType.tsymbol.name.value, funcName));
            if (attachedType.tag == 32 || attachedType.tag == 12) {
                scopeToDefine = attachedType.tag == 32 ? ((BObjectTypeSymbol)attachedType.tsymbol).methodScope : attachedType.tsymbol.scope;
                BAttachedFunction attachedFunc = new BAttachedFunction(this.names.fromString(funcName), invokableSymbol, funcType);
                BStructureTypeSymbol structureTypeSymbol = (BStructureTypeSymbol)attachedType.tsymbol;
                if (Names.USER_DEFINED_INIT_SUFFIX.value.equals(funcName) || funcName.equals(Names.INIT_FUNCTION_SUFFIX.value)) {
                    structureTypeSymbol.initializerFunc = attachedFunc;
                } else if (funcName.equals(Names.GENERATED_INIT_SUFFIX.value)) {
                    ((BObjectTypeSymbol)structureTypeSymbol).generatedInitializerFunc = attachedFunc;
                } else {
                    structureTypeSymbol.attachedFuncs.add(attachedFunc);
                }
            }
        }
        dataInStream.skip(dataInStream.readLong());
        this.setParamSymbols(invokableSymbol, dataInStream);
        this.readTaintTable(invokableSymbol, dataInStream);
        this.defineMarkDownDocAttachment(invokableSymbol, this.readDocBytes(dataInStream));
        dataInStream.skip(dataInStream.readLong());
        scopeToDefine.define(invokableSymbol.name, invokableSymbol);
    }

    private void skipPosition(DataInputStream dataInStream) throws IOException {
        dataInStream.readInt();
        dataInStream.readInt();
        dataInStream.readInt();
        dataInStream.readInt();
        dataInStream.readInt();
    }

    private void defineTypeDef(DataInputStream dataInStream) throws IOException {
        this.skipPosition(dataInStream);
        String typeDefName = this.getStringCPEntryValue(dataInStream);
        int flags = dataInStream.readInt();
        boolean isLabel = dataInStream.readByte() == 1;
        byte[] docBytes = this.readDocBytes(dataInStream);
        BType type = this.readBType(dataInStream);
        if (type.tag == 16) {
            this.setInvokableTypeSymbol((BInvokableType)type);
        }
        flags = Symbols.isFlagOn(type.tsymbol.flags, 4096) ? flags | 0x1000 : flags;
        flags = Symbols.isFlagOn(type.tsymbol.flags, 131072) ? flags | 0x20000 : flags;
        BTypeSymbol symbol = isLabel ? type.tsymbol.createLabelSymbol() : type.tsymbol;
        this.defineMarkDownDocAttachment(symbol, docBytes);
        symbol.name = this.names.fromString(typeDefName);
        symbol.type = type;
        symbol.pkgID = this.env.pkgSymbol.pkgID;
        symbol.flags = flags;
        if (type.tag == 12 || type.tag == 32) {
            this.structureTypes.add((BStructureTypeSymbol)symbol);
        }
        this.env.pkgSymbol.scope.define(symbol.name, symbol);
        if (type.tag == 27) {
            this.defineErrorConstructor(this.env.pkgSymbol.scope, symbol);
        }
    }

    private void setInvokableTypeSymbol(BInvokableType invokableType) {
        BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)invokableType.tsymbol;
        ArrayList<BVarSymbol> params = new ArrayList<BVarSymbol>();
        for (BType paramType : invokableType.paramTypes) {
            BVarSymbol varSymbol = new BVarSymbol(paramType.flags, Names.EMPTY, this.env.pkgSymbol.pkgID, paramType, null);
            params.add(varSymbol);
        }
        tsymbol.params = params;
        if (invokableType.restType != null) {
            tsymbol.restParam = new BVarSymbol(0, Names.EMPTY, this.env.pkgSymbol.pkgID, invokableType.restType, null);
        }
        tsymbol.returnType = invokableType.retType;
    }

    private void defineMarkDownDocAttachment(BSymbol symbol, byte[] docBytes) throws IOException {
        DataInputStream dataInStream = new DataInputStream(new ByteArrayInputStream(docBytes));
        boolean docPresent = dataInStream.readBoolean();
        if (!docPresent) {
            return;
        }
        MarkdownDocAttachment markdownDocAttachment = new MarkdownDocAttachment();
        int descCPIndex = dataInStream.readInt();
        int retDescCPIndex = dataInStream.readInt();
        markdownDocAttachment.description = descCPIndex >= 0 ? this.getStringCPEntryValue(descCPIndex) : null;
        markdownDocAttachment.returnValueDescription = retDescCPIndex >= 0 ? this.getStringCPEntryValue(retDescCPIndex) : null;
        int paramLength = dataInStream.readInt();
        for (int i = 0; i < paramLength; ++i) {
            int nameCPIndex = dataInStream.readInt();
            int paramDescCPIndex = dataInStream.readInt();
            String name = nameCPIndex >= 0 ? this.getStringCPEntryValue(nameCPIndex) : null;
            String description = paramDescCPIndex >= 0 ? this.getStringCPEntryValue(paramDescCPIndex) : null;
            MarkdownDocAttachment.Parameter parameter = new MarkdownDocAttachment.Parameter(name, description);
            markdownDocAttachment.parameters.add(parameter);
        }
        symbol.markdownDocumentation = markdownDocAttachment;
    }

    private void defineErrorConstructor(Scope scope, BTypeSymbol typeDefSymbol) {
        BConstructorSymbol symbol = new BConstructorSymbol(0x4000100, typeDefSymbol.flags, typeDefSymbol.name, typeDefSymbol.pkgID, typeDefSymbol.type, typeDefSymbol.owner);
        symbol.kind = SymbolKind.ERROR_CONSTRUCTOR;
        symbol.scope = new Scope(symbol);
        symbol.retType = typeDefSymbol.type;
        scope.define(symbol.name, symbol);
        ((BErrorTypeSymbol)typeDefSymbol).ctorSymbol = symbol;
    }

    private BType readBType(DataInputStream dataInStream) throws IOException {
        int typeCpIndex = dataInStream.readInt();
        CPEntry cpEntry = this.env.constantPool[typeCpIndex];
        BType type = null;
        if (cpEntry != null) {
            type = ((CPEntry.ShapeCPEntry)cpEntry).shape;
            if (type.tag != 16) {
                return type;
            }
        }
        if (type == null) {
            byte[] e = this.env.unparsedBTypeCPs.get(typeCpIndex);
            type = new BIRTypeReader(new DataInputStream(new ByteArrayInputStream(e))).readType(typeCpIndex);
            this.addShapeCP(type, typeCpIndex);
        }
        if (type.tag == 16) {
            return this.createClonedInvokableTypeWithTsymbol((BInvokableType)type);
        }
        return type;
    }

    private BInvokableType createClonedInvokableTypeWithTsymbol(BInvokableType bInvokableType) {
        BInvokableType clonedType = new BInvokableType(bInvokableType.paramTypes, bInvokableType.restType, bInvokableType.retType, null);
        clonedType.tsymbol = Symbols.createInvokableTypeSymbol(33554460, bInvokableType.flags, this.env.pkgSymbol.pkgID, null, this.env.pkgSymbol.owner);
        return clonedType;
    }

    private void addShapeCP(BType bType, int typeCpIndex) {
        this.env.constantPool[typeCpIndex] = new CPEntry.ShapeCPEntry(bType);
    }

    private void defineAnnotations(DataInputStream dataInStream) throws IOException {
        String name = this.getStringCPEntryValue(dataInStream);
        int flags = dataInStream.readInt();
        int attachPointCount = dataInStream.readInt();
        HashSet<AttachPoint> attachPoints = new HashSet<AttachPoint>(attachPointCount);
        for (int i = 0; i < attachPointCount; ++i) {
            attachPoints.add(AttachPoint.getAttachmentPoint(this.getStringCPEntryValue(dataInStream), dataInStream.readBoolean()));
        }
        BType annotationType = this.readBType(dataInStream);
        BAnnotationSymbol annotationSymbol = Symbols.createAnnotationSymbol(flags, attachPoints, this.names.fromString(name), this.env.pkgSymbol.pkgID, null, (BSymbol)this.env.pkgSymbol);
        annotationSymbol.type = new BAnnotationType(annotationSymbol);
        this.defineMarkDownDocAttachment(annotationSymbol, this.readDocBytes(dataInStream));
        this.env.pkgSymbol.scope.define(annotationSymbol.name, annotationSymbol);
        if (annotationType != this.symTable.noType) {
            annotationSymbol.attachedType = annotationType.tsymbol;
        }
    }

    private void defineConstant(DataInputStream dataInStream) throws IOException {
        String constantName = this.getStringCPEntryValue(dataInStream);
        int flags = dataInStream.readInt();
        byte[] docBytes = this.readDocBytes(dataInStream);
        BType type = this.readBType(dataInStream);
        Scope enclScope = this.env.pkgSymbol.scope;
        BConstantSymbol constantSymbol = new BConstantSymbol(flags, this.names.fromString(constantName), this.env.pkgSymbol.pkgID, null, type, enclScope.owner);
        this.defineMarkDownDocAttachment(constantSymbol, docBytes);
        dataInStream.readLong();
        constantSymbol.value = this.readConstLiteralValue(dataInStream);
        constantSymbol.literalType = constantSymbol.value.type;
        enclScope.define(constantSymbol.name, constantSymbol);
    }

    private BLangConstantValue readConstLiteralValue(DataInputStream dataInStream) throws IOException {
        BType valueType = this.readBType(dataInStream);
        switch (valueType.tag) {
            case 1: {
                return new BLangConstantValue(this.getIntCPEntryValue(dataInStream), this.symTable.intType);
            }
            case 2: {
                return new BLangConstantValue(this.getByteCPEntryValue(dataInStream), this.symTable.byteType);
            }
            case 3: {
                return new BLangConstantValue(this.getFloatCPEntryValue(dataInStream), this.symTable.floatType);
            }
            case 5: {
                return new BLangConstantValue(this.getStringCPEntryValue(dataInStream), this.symTable.stringType);
            }
            case 4: {
                return new BLangConstantValue(this.getStringCPEntryValue(dataInStream), this.symTable.decimalType);
            }
            case 6: {
                return new BLangConstantValue(dataInStream.readByte() == 1, this.symTable.booleanType);
            }
            case 10: {
                return new BLangConstantValue(null, this.symTable.nilType);
            }
            case 15: {
                int size = dataInStream.readInt();
                LinkedHashMap<String, BLangConstantValue> keyValuePairs = new LinkedHashMap<String, BLangConstantValue>();
                for (int i = 0; i < size; ++i) {
                    String key = this.getStringCPEntryValue(dataInStream);
                    BLangConstantValue value = this.readConstLiteralValue(dataInStream);
                    keyValuePairs.put(key, value);
                }
                return new BLangConstantValue(keyValuePairs, valueType);
            }
        }
        throw new RuntimeException("unexpected type: " + valueType);
    }

    private void definePackageLevelVariables(DataInputStream dataInStream) throws IOException {
        BVarSymbol varSymbol;
        dataInStream.readByte();
        String varName = this.getStringCPEntryValue(dataInStream);
        int flags = dataInStream.readInt();
        byte[] docBytes = this.readDocBytes(dataInStream);
        BType varType = this.readBType(dataInStream);
        Scope enclScope = this.env.pkgSymbol.scope;
        if (varType.tag == 16) {
            varSymbol = new BInvokableSymbol(52, flags, this.names.fromString(varName), this.env.pkgSymbol.pkgID, varType, enclScope.owner);
        } else {
            varSymbol = new BVarSymbol(flags, this.names.fromString(varName), this.env.pkgSymbol.pkgID, varType, enclScope.owner);
            if (varType.tsymbol != null && Symbols.isFlagOn(varType.tsymbol.flags, 131072)) {
                varSymbol.tag = 32820;
            }
        }
        this.defineMarkDownDocAttachment(varSymbol, docBytes);
        enclScope.define(varSymbol.name, varSymbol);
    }

    private void setParamSymbols(BInvokableSymbol invokableSymbol, DataInputStream dataInStream) throws IOException {
        int requiredParamCount = dataInStream.readInt();
        BInvokableType invokableType = (BInvokableType)invokableSymbol.type;
        for (int i = 0; i < requiredParamCount; ++i) {
            String paramName = this.getStringCPEntryValue(dataInStream);
            int flags = dataInStream.readInt();
            BVarSymbol varSymbol = new BVarSymbol(flags, this.names.fromString(paramName), this.env.pkgSymbol.pkgID, invokableType.paramTypes.get(i), invokableSymbol);
            varSymbol.defaultableParam = (flags & 0x2000) == 8192;
            invokableSymbol.params.add(varSymbol);
        }
        if (dataInStream.readBoolean()) {
            String paramName = this.getStringCPEntryValue(dataInStream);
            invokableSymbol.restParam = new BVarSymbol(0, this.names.fromString(paramName), this.env.pkgSymbol.pkgID, invokableType.restType, invokableSymbol);
        }
        BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)invokableType.tsymbol;
        tsymbol.flags = invokableSymbol.flags;
        tsymbol.params = invokableSymbol.params;
        tsymbol.restParam = invokableSymbol.restParam;
        tsymbol.returnType = invokableSymbol.retType;
        boolean hasReceiver = dataInStream.readBoolean();
        if (hasReceiver) {
            dataInStream.readByte();
            this.readBType(dataInStream);
            this.getStringCPEntryValue(dataInStream);
        }
    }

    private void readTaintTable(BInvokableSymbol invokableSymbol, DataInputStream dataInStream) throws IOException {
        long length = dataInStream.readLong();
        if (length <= 0L) {
            return;
        }
        int rowCount = dataInStream.readShort();
        int columnCount = dataInStream.readShort();
        invokableSymbol.taintTable = new HashMap<Integer, TaintRecord>();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            short paramIndex = dataInStream.readShort();
            TaintRecord.TaintedStatus returnTaintedStatus = this.convertByteToTaintedStatus(dataInStream.readByte());
            ArrayList<TaintRecord.TaintedStatus> parameterTaintedStatusList = new ArrayList<TaintRecord.TaintedStatus>();
            for (int columnIndex = 1; columnIndex < columnCount; ++columnIndex) {
                parameterTaintedStatusList.add(this.convertByteToTaintedStatus(dataInStream.readByte()));
            }
            TaintRecord taintRecord = new TaintRecord(returnTaintedStatus, parameterTaintedStatusList);
            invokableSymbol.taintTable.put(Integer.valueOf(paramIndex), taintRecord);
        }
    }

    private TaintRecord.TaintedStatus convertByteToTaintedStatus(byte readByte) {
        return EnumSet.allOf(TaintRecord.TaintedStatus.class).stream().filter(taintedStatus -> readByte == taintedStatus.getByteValue()).findFirst().get();
    }

    private String getStringCPEntryValue(DataInputStream dataInStream) throws IOException {
        int pkgNameCPIndex = dataInStream.readInt();
        CPEntry.StringCPEntry stringCPEntry = (CPEntry.StringCPEntry)this.env.constantPool[pkgNameCPIndex];
        return stringCPEntry.value;
    }

    private String getStringCPEntryValue(int cpIndex) throws IOException {
        CPEntry.StringCPEntry stringCPEntry = (CPEntry.StringCPEntry)this.env.constantPool[cpIndex];
        return stringCPEntry.value;
    }

    private long getIntCPEntryValue(DataInputStream dataInStream) throws IOException {
        int pkgNameCPIndex = dataInStream.readInt();
        CPEntry.IntegerCPEntry intCPEntry = (CPEntry.IntegerCPEntry)this.env.constantPool[pkgNameCPIndex];
        return intCPEntry.value;
    }

    private int getByteCPEntryValue(DataInputStream dataInStream) throws IOException {
        int byteCpIndex = dataInStream.readInt();
        CPEntry.ByteCPEntry byteCPEntry = (CPEntry.ByteCPEntry)this.env.constantPool[byteCpIndex];
        return byteCPEntry.value;
    }

    private String getFloatCPEntryValue(DataInputStream dataInStream) throws IOException {
        int floatCpIndex = dataInStream.readInt();
        CPEntry.FloatCPEntry floatCPEntry = (CPEntry.FloatCPEntry)this.env.constantPool[floatCpIndex];
        return Double.toString(floatCPEntry.value);
    }

    private PackageID createPackageID(String orgName, String pkgName, String pkgVersion) {
        if (orgName == null || orgName.isEmpty()) {
            throw new BLangCompilerException("invalid module name '" + pkgName + "' in compiled package file");
        }
        return new PackageID(this.names.fromString(orgName), this.names.fromString(pkgName), this.names.fromString(pkgVersion));
    }

    private byte[] readDocBytes(DataInputStream inputStream) throws IOException {
        byte[] docBytes;
        int noOfBytesRead;
        int docLength = inputStream.readInt();
        if (docLength != (noOfBytesRead = inputStream.read(docBytes = new byte[docLength]))) {
            throw new RuntimeException("Failed to read Markdown Documenation");
        }
        return docBytes;
    }

    private PackageID getPackageId(int pkgCPIndex) {
        CPEntry.PackageCPEntry pkgCpEntry = (CPEntry.PackageCPEntry)this.env.constantPool[pkgCPIndex];
        String orgName = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.orgNameCPIndex]).value;
        String pkgName = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.pkgNameCPIndex]).value;
        String version = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.versionCPIndex]).value;
        return new PackageID(this.names.fromString(orgName), this.names.fromString(pkgName), this.names.fromString(version));
    }

    private void defineValueSpace(DataInputStream dataInStream, BFiniteType finiteType, BIRTypeReader typeReader) throws IOException {
        BType valueType = typeReader.readTypeFromCp();
        BLangLiteral litExpr = this.createLiteralBasedOnType(valueType);
        switch (valueType.tag) {
            case 1: {
                int integerCpIndex = dataInStream.readInt();
                CPEntry.IntegerCPEntry integerCPEntry = (CPEntry.IntegerCPEntry)this.env.constantPool[integerCpIndex];
                litExpr.value = integerCPEntry.value;
                break;
            }
            case 2: {
                int byteCpIndex = dataInStream.readInt();
                CPEntry.ByteCPEntry byteCPEntry = (CPEntry.ByteCPEntry)this.env.constantPool[byteCpIndex];
                litExpr.value = byteCPEntry.value;
                break;
            }
            case 3: {
                int floatCpIndex = dataInStream.readInt();
                CPEntry.FloatCPEntry floatCPEntry = (CPEntry.FloatCPEntry)this.env.constantPool[floatCpIndex];
                litExpr.value = Double.toString(floatCPEntry.value);
                break;
            }
            case 4: 
            case 5: {
                litExpr.value = this.getStringCPEntryValue(dataInStream);
                break;
            }
            case 6: {
                litExpr.value = dataInStream.readByte() == 1;
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("finite type value is not supported for type: " + valueType);
            }
        }
        litExpr.type = valueType;
        finiteType.addValue(litExpr);
    }

    private BLangLiteral createLiteralBasedOnType(BType valueType) {
        NodeKind nodeKind = valueType.tag <= 4 ? NodeKind.NUMERIC_LITERAL : NodeKind.LITERAL;
        return nodeKind == NodeKind.LITERAL ? (BLangLiteral)TreeBuilder.createLiteralExpression() : (BLangLiteral)TreeBuilder.createNumericLiteralExpression();
    }

    private class BIRTypeReader {
        public static final int SERVICE_TYPE_TAG = 51;
        private DataInputStream inputStream;

        public BIRTypeReader(DataInputStream inputStream) {
            this.inputStream = inputStream;
        }

        private BType readTypeFromCp() throws IOException {
            return BIRPackageSymbolEnter.this.readBType(this.inputStream);
        }

        public BType readType(int cpI) throws IOException {
            byte tag = this.inputStream.readByte();
            Name name = BIRPackageSymbolEnter.this.names.fromString(BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream));
            int flags = this.inputStream.readInt();
            this.inputStream.readInt();
            switch (tag) {
                case 1: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.intType, name, flags);
                }
                case 2: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.byteType, name, flags);
                }
                case 3: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.floatType, name, flags);
                }
                case 4: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.decimalType, name, flags);
                }
                case 5: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.stringType, name, flags);
                }
                case 6: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.booleanType, name, flags);
                }
                case 7: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.jsonType;
                }
                case 8: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.xmlType;
                }
                case 9: {
                    BTableType bTableType = new BTableType(9, null, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.tableType.tsymbol);
                    bTableType.constraint = this.readTypeFromCp();
                    return bTableType;
                }
                case 10: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.nilType;
                }
                case 11: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.anydataType, name, flags);
                }
                case 12: {
                    boolean isInitAvailable;
                    int pkgCpIndex = this.inputStream.readInt();
                    PackageID pkgId = BIRPackageSymbolEnter.this.getPackageId(pkgCpIndex);
                    String recordName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                    BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(Flags.asMask(EnumSet.of(Flag.PUBLIC)), BIRPackageSymbolEnter.this.names.fromString(recordName), ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol.pkgID, null, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol);
                    recordSymbol.scope = new Scope(recordSymbol);
                    BRecordType recordType = new BRecordType(recordSymbol);
                    recordSymbol.type = recordType;
                    BIRPackageSymbolEnter.this.compositeStack.push(recordType);
                    BIRPackageSymbolEnter.this.addShapeCP(recordType, cpI);
                    recordType.sealed = this.inputStream.readBoolean();
                    recordType.restFieldType = this.readTypeFromCp();
                    int recordFields = this.inputStream.readInt();
                    for (int i = 0; i < recordFields; ++i) {
                        String fieldName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                        int fieldFlags = this.inputStream.readInt();
                        byte[] docBytes = BIRPackageSymbolEnter.this.readDocBytes(this.inputStream);
                        BType fieldType = this.readTypeFromCp();
                        BVarSymbol varSymbol = new BVarSymbol(fieldFlags, BIRPackageSymbolEnter.this.names.fromString(fieldName), recordSymbol.pkgID, fieldType, recordSymbol.scope.owner);
                        BIRPackageSymbolEnter.this.defineMarkDownDocAttachment(varSymbol, docBytes);
                        BField structField = new BField(varSymbol.name, null, varSymbol);
                        recordType.fields.add(structField);
                        recordSymbol.scope.define(varSymbol.name, varSymbol);
                    }
                    boolean bl = isInitAvailable = this.inputStream.readByte() == 1;
                    if (isInitAvailable) {
                        String recordInitFuncName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                        int recordInitFuncFlags = this.inputStream.readInt();
                        BInvokableType recordInitFuncType = (BInvokableType)this.readTypeFromCp();
                        Name initFuncName = BIRPackageSymbolEnter.this.names.fromString(recordInitFuncName);
                        boolean isNative = Symbols.isFlagOn(recordInitFuncFlags, 2);
                        BInvokableSymbol recordInitFuncSymbol = Symbols.createFunctionSymbol(recordInitFuncFlags, initFuncName, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol.pkgID, recordInitFuncType, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol, isNative);
                        recordInitFuncSymbol.retType = recordInitFuncType.retType;
                        recordSymbol.initializerFunc = new BAttachedFunction(initFuncName, recordInitFuncSymbol, recordInitFuncType);
                        recordSymbol.scope.define(initFuncName, recordInitFuncSymbol);
                    }
                    Object poppedRecordType = BIRPackageSymbolEnter.this.compositeStack.pop();
                    assert (poppedRecordType == recordType);
                    if (pkgId.equals(((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol.pkgID)) {
                        return recordType;
                    }
                    BPackageSymbol pkgSymbol = BIRPackageSymbolEnter.this.packageLoader.loadPackageSymbol(pkgId, null, null);
                    SymbolEnv pkgEnv = ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.pkgEnvMap.get(pkgSymbol);
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symbolResolver.lookupSymbolInMainSpace((SymbolEnv)pkgEnv, (Name)((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).names.fromString((String)recordName)).type;
                }
                case 13: {
                    BTypedescType typedescType = new BTypedescType(null, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.typeDesc.tsymbol);
                    typedescType.constraint = this.readTypeFromCp();
                    return typedescType;
                }
                case 14: {
                    boolean hasError;
                    BStreamType bStreamType = new BStreamType(14, null, null, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.streamType.tsymbol);
                    bStreamType.constraint = this.readTypeFromCp();
                    boolean bl = hasError = this.inputStream.readByte() == 1;
                    if (hasError) {
                        bStreamType.error = this.readTypeFromCp();
                    }
                    return bStreamType;
                }
                case 15: {
                    BMapType bMapType = new BMapType(15, null, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.mapType.tsymbol);
                    bMapType.constraint = this.readTypeFromCp();
                    return bMapType;
                }
                case 16: {
                    BInvokableType bInvokableType = new BInvokableType(null, null, null, null);
                    bInvokableType.flags = flags;
                    int paramCount = this.inputStream.readInt();
                    ArrayList<BType> paramTypes = new ArrayList<BType>();
                    for (int i = 0; i < paramCount; ++i) {
                        paramTypes.add(this.readTypeFromCp());
                    }
                    bInvokableType.paramTypes = paramTypes;
                    if (this.inputStream.readBoolean()) {
                        bInvokableType.restType = this.readTypeFromCp();
                    }
                    bInvokableType.retType = this.readTypeFromCp();
                    return bInvokableType;
                }
                case 17: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.anyType, name, flags);
                }
                case 35: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.handleType;
                }
                case 18: {
                    break;
                }
                case 19: {
                    byte state = this.inputStream.readByte();
                    int size = this.inputStream.readInt();
                    BTypeSymbol arrayTypeSymbol = Symbols.createTypeSymbol(8388636, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol.pkgID, null, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol.owner);
                    BArrayType bArrayType = new BArrayType(null, arrayTypeSymbol, size, BArrayState.valueOf(state));
                    bArrayType.eType = this.readTypeFromCp();
                    return bArrayType;
                }
                case 20: {
                    BTypeSymbol unionTypeSymbol = Symbols.createTypeSymbol(2097180, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol.pkgID, null, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol.owner);
                    BUnionType unionType = BUnionType.create(unionTypeSymbol, new LinkedHashSet<BType>());
                    int unionMemberCount = this.inputStream.readInt();
                    for (int i = 0; i < unionMemberCount; ++i) {
                        unionType.add(this.readTypeFromCp());
                    }
                    return unionType;
                }
                case 21: {
                    break;
                }
                case 22: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.noType;
                }
                case 23: {
                    break;
                }
                case 24: {
                    break;
                }
                case 25: {
                    break;
                }
                case 26: {
                    break;
                }
                case 27: {
                    BErrorTypeSymbol errorSymbol = new BErrorTypeSymbol(589852, 1, Names.EMPTY, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol.pkgID, null, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol.owner);
                    BErrorType errorType = new BErrorType(errorSymbol);
                    BIRPackageSymbolEnter.this.addShapeCP(errorType, cpI);
                    BIRPackageSymbolEnter.this.compositeStack.push(errorType);
                    int pkgCpIndex = this.inputStream.readInt();
                    PackageID pkgId = BIRPackageSymbolEnter.this.getPackageId(pkgCpIndex);
                    String errorName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                    BType reasonType = this.readTypeFromCp();
                    BType detailsType = this.readTypeFromCp();
                    errorType.reasonType = reasonType;
                    errorType.detailType = detailsType;
                    errorSymbol.type = errorType;
                    errorSymbol.pkgID = pkgId;
                    errorSymbol.name = BIRPackageSymbolEnter.this.names.fromString(errorName);
                    Object poppedErrorType = BIRPackageSymbolEnter.this.compositeStack.pop();
                    assert (poppedErrorType == errorType);
                    if (!((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol.pkgID.equals(PackageID.ANNOTATIONS) && Symbols.isFlagOn(flags, 2)) {
                        return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.errorType;
                    }
                    return errorType;
                }
                case 28: {
                    break;
                }
                case 29: {
                    BTypeSymbol tupleTypeSymbol = Symbols.createTypeSymbol(4194332, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol.pkgID, null, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol.owner);
                    BTupleType bTupleType = new BTupleType(tupleTypeSymbol, null);
                    int tupleMemberCount = this.inputStream.readInt();
                    ArrayList<BType> tupleMemberTypes = new ArrayList<BType>();
                    for (int i = 0; i < tupleMemberCount; ++i) {
                        tupleMemberTypes.add(this.readTypeFromCp());
                    }
                    bTupleType.tupleTypes = tupleMemberTypes;
                    return bTupleType;
                }
                case 30: {
                    BFutureType bFutureType = new BFutureType(30, null, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.futureType.tsymbol);
                    bFutureType.constraint = this.readTypeFromCp();
                    return bFutureType;
                }
                case 31: {
                    String finiteTypeName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                    int finiteTypeFlags = this.inputStream.readInt();
                    BTypeSymbol symbol = Symbols.createTypeSymbol(0x10001C, finiteTypeFlags, BIRPackageSymbolEnter.this.names.fromString(finiteTypeName), ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol.pkgID, null, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol);
                    symbol.scope = new Scope(symbol);
                    BFiniteType finiteType = new BFiniteType(symbol);
                    symbol.type = finiteType;
                    int valueSpaceSize = this.inputStream.readInt();
                    for (int i = 0; i < valueSpaceSize; ++i) {
                        BIRPackageSymbolEnter.this.defineValueSpace(this.inputStream, finiteType, this);
                    }
                    return finiteType;
                }
                case 32: {
                    boolean constructorPresent;
                    boolean service = this.inputStream.readByte() == 1;
                    int pkgCpIndex = this.inputStream.readInt();
                    PackageID pkgId = BIRPackageSymbolEnter.this.getPackageId(pkgCpIndex);
                    String objName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                    int objFlags = (this.inputStream.readBoolean() ? 4096 : 0) | 1;
                    objFlags = this.inputStream.readBoolean() ? objFlags | 0x20000 : objFlags;
                    BObjectTypeSymbol objectSymbol = (BObjectTypeSymbol)Symbols.createObjectSymbol(objFlags, BIRPackageSymbolEnter.this.names.fromString(objName), ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol.pkgID, null, ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol);
                    objectSymbol.scope = new Scope(objectSymbol);
                    objectSymbol.methodScope = new Scope(objectSymbol);
                    BObjectType objectType = service ? new BServiceType(objectSymbol) : new BObjectType(objectSymbol);
                    objectSymbol.type = objectType;
                    BIRPackageSymbolEnter.this.addShapeCP(objectType, cpI);
                    BIRPackageSymbolEnter.this.compositeStack.push(objectType);
                    int fieldCount = this.inputStream.readInt();
                    for (int i = 0; i < fieldCount; ++i) {
                        String fieldName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                        int fieldFlags = this.inputStream.readInt();
                        byte[] docBytes = BIRPackageSymbolEnter.this.readDocBytes(this.inputStream);
                        BType fieldType = this.readTypeFromCp();
                        BVarSymbol objectVarSymbol = new BVarSymbol(fieldFlags, BIRPackageSymbolEnter.this.names.fromString(fieldName), objectSymbol.pkgID, fieldType, objectSymbol.scope.owner);
                        BIRPackageSymbolEnter.this.defineMarkDownDocAttachment(objectVarSymbol, docBytes);
                        BField structField = new BField(objectVarSymbol.name, null, objectVarSymbol);
                        objectType.fields.add(structField);
                        objectSymbol.scope.define(objectVarSymbol.name, objectVarSymbol);
                    }
                    boolean generatedConstructorPresent = this.inputStream.readBoolean();
                    if (generatedConstructorPresent) {
                        this.ignoreAttachedFunc();
                    }
                    if (constructorPresent = this.inputStream.readBoolean()) {
                        this.ignoreAttachedFunc();
                    }
                    int funcCount = this.inputStream.readInt();
                    for (int i = 0; i < funcCount; ++i) {
                        this.ignoreAttachedFunc();
                    }
                    Object poppedObjType = BIRPackageSymbolEnter.this.compositeStack.pop();
                    assert (poppedObjType == objectType);
                    if (pkgId.equals(((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).env.pkgSymbol.pkgID)) {
                        return objectType;
                    }
                    BPackageSymbol pkgSymbol = BIRPackageSymbolEnter.this.packageLoader.loadPackageSymbol(pkgId, null, null);
                    SymbolEnv pkgEnv = ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.pkgEnvMap.get(pkgSymbol);
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symbolResolver.lookupSymbolInMainSpace((SymbolEnv)pkgEnv, (Name)((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).names.fromString((String)objName)).type;
                }
                case 33: {
                    break;
                }
                case 34: {
                    break;
                }
                case 51: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.anyServiceType;
                }
                case 36: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.signed32IntType;
                }
                case 37: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.signed16IntType;
                }
                case 38: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.signed8IntType;
                }
                case 39: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.unsigned32IntType;
                }
                case 40: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.unsigned16IntType;
                }
                case 41: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.unsigned8IntType;
                }
                case 42: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.charStringType;
                }
                case 43: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.xmlElementType;
                }
                case 44: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.xmlPIType;
                }
                case 45: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.xmlCommentType;
                }
                case 46: {
                    return ((BIRPackageSymbolEnter)BIRPackageSymbolEnter.this).symTable.xmlTextType;
                }
            }
            return null;
        }

        private void ignoreAttachedFunc() throws IOException {
            BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
            this.inputStream.readInt();
            this.readTypeFromCp();
        }
    }

    private static class UnresolvedType {
        String typeSig;
        Consumer<BType> completer;

        UnresolvedType(String typeSig, Consumer<BType> completer) {
            this.typeSig = typeSig;
            this.completer = completer;
        }
    }

    private static class BIRPackageSymbolEnv {
        PackageID requestedPackageId;
        RepoHierarchy repoHierarchy;
        Map<Integer, byte[]> unparsedBTypeCPs = new HashMap<Integer, byte[]>();
        BPackageSymbol pkgSymbol;
        CPEntry[] constantPool;
        List<UnresolvedType> unresolvedTypes = new ArrayList<UnresolvedType>();

        BIRPackageSymbolEnv() {
        }
    }
}

