/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.repository.CompiledPackage;
import org.ballerinalang.repository.CompilerOutputEntry;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.converters.PathConverter;
import org.wso2.ballerinalang.compiler.util.FileUtils;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.util.LambdaExceptionUtils;

public class FileSystemProgramDirectory
implements SourceDirectory {
    private final Path programDirPath;
    private static PrintStream outStream = System.out;

    public FileSystemProgramDirectory(Path programDirPath) {
        this.programDirPath = programDirPath;
    }

    @Override
    public boolean canHandle(Path dirPath) {
        return true;
    }

    @Override
    public Path getPath() {
        return this.programDirPath;
    }

    @Override
    public List<String> getSourceFileNames() {
        List<String> fileNames = Collections.emptyList();
        if (!Files.isDirectory(this.programDirPath, new LinkOption[0])) {
            return fileNames;
        }
        try {
            try (Stream<Path> stream = Files.list(this.programDirPath);){
                fileNames = stream.map(ProjectDirs::getLastComp).filter(ProjectDirs::isSourceFile).map(Path::toString).collect(Collectors.toList());
            }
            return fileNames;
        }
        catch (SecurityException | AccessDeniedException e) {
            throw new BLangCompilerException("permission denied: " + this.programDirPath.toString());
        }
        catch (IOException e) {
            throw new BLangCompilerException("error reading directory: " + this.programDirPath.toString());
        }
    }

    @Override
    public List<String> getSourcePackageNames() {
        return new ArrayList<String>(0);
    }

    @Override
    public InputStream getManifestContent() {
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public InputStream getLockFileContent() {
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public Path saveCompiledProgram(InputStream source, String fileName) {
        Path targetFilePath = Paths.get(fileName, new String[0]);
        try {
            outStream.println("    " + fileName);
            Files.copy(source, targetFilePath, StandardCopyOption.REPLACE_EXISTING);
            return targetFilePath;
        }
        catch (DirectoryNotEmptyException e) {
            throw new BLangCompilerException("A directory exists with the same name as the file name '" + targetFilePath.toString() + "'");
        }
        catch (IOException e) {
            throw new BLangCompilerException("failed to write the compiled program to '" + targetFilePath.toString() + "'");
        }
    }

    @Override
    public void saveCompiledPackage(CompiledPackage compiledPackage, Path dirPath, String fileName) throws IOException {
        Files.createDirectories(dirPath, new FileAttribute[0]);
        Path compiledPkgPath = dirPath.resolve(fileName);
        FileUtils.deleteFile(compiledPkgPath);
        HashMap<String, String> fsEnv = new HashMap<String, String>(){
            {
                this.put("create", "true");
            }
        };
        URI filepath = compiledPkgPath.toUri();
        try {
            URI zipFileURI = new URI("jar:" + filepath.getScheme(), filepath.getUserInfo(), filepath.getHost(), filepath.getPort(), filepath.getPath() + "!/", filepath.getQuery(), filepath.getFragment());
            try (FileSystem fs = FileSystems.newFileSystem(zipFileURI, fsEnv);){
                compiledPackage.getAllEntries().forEach(LambdaExceptionUtils.rethrow(entry -> this.addCompilerOutputEntry(fs, (CompilerOutputEntry)entry)));
            }
        }
        catch (URISyntaxException e) {
            throw new BLangCompilerException("error creating artifact: " + compiledPkgPath.getFileName());
        }
    }

    private void addCompilerOutputEntry(FileSystem fs, CompilerOutputEntry outputEntry) throws IOException {
        String rootDirName = this.getTopLevelDirNameInPackage(outputEntry.getEntryKind(), fs);
        Path rootDirPath = fs.getPath(rootDirName, new String[0]);
        Path destPath = rootDirPath.resolve(outputEntry.getEntryName());
        Path parent = destPath.getParent();
        if (Files.notExists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.copy(outputEntry.getInputStream(), destPath, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public Converter<Path> getConverter() {
        return new PathConverter(this.programDirPath);
    }

    private String getTopLevelDirNameInPackage(CompilerOutputEntry.Kind kind, FileSystem fs) {
        switch (kind) {
            case SRC: 
            case BIR: 
            case OBJ: {
                return kind.getValue();
            }
            case ROOT: {
                return fs.getSeparator();
            }
        }
        return null;
    }
}

