/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.toml.exceptions.TomlException;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.parser.ManifestProcessor;
import org.wso2.ballerinalang.compiler.FileSystemProgramDirectory;
import org.wso2.ballerinalang.compiler.FileSystemProjectDirectory;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.util.RepoUtils;

public class SourceDirectoryManager {
    private static final CompilerContext.Key<SourceDirectoryManager> PROJECT_DIR_KEY = new CompilerContext.Key();
    private final CompilerOptions options;
    private final Names names;
    private final SourceDirectory sourceDirectory;

    public static SourceDirectoryManager getInstance(CompilerContext context) {
        SourceDirectoryManager sourceDirectoryManager = context.get(PROJECT_DIR_KEY);
        if (sourceDirectoryManager == null) {
            sourceDirectoryManager = new SourceDirectoryManager(context);
        }
        return sourceDirectoryManager;
    }

    private SourceDirectoryManager(CompilerContext context) {
        context.put(PROJECT_DIR_KEY, this);
        this.names = Names.getInstance(context);
        this.options = CompilerOptions.getInstance(context);
        this.sourceDirectory = this.initializeAndGetSourceDirectory(context);
    }

    public Stream<PackageID> listSourceFilesAndPackages() {
        List<String> sourceFileNames = this.sourceDirectory.getSourceFileNames();
        List<String> packageNames = this.sourceDirectory.getSourcePackageNames();
        return Stream.concat(sourceFileNames.stream().map(this::getPackageID), packageNames.stream().map(this::getPackageID));
    }

    private Manifest getManifest() {
        Manifest manifest = new Manifest();
        try {
            if (this.sourceDirectory instanceof FileSystemProjectDirectory) {
                manifest = ManifestProcessor.parseTomlContentAsStream(this.sourceDirectory.getManifestContent());
            }
        }
        catch (TomlException tomlException) {
            throw new BLangCompilerException(tomlException.getMessage());
        }
        if (manifest.getProject().getVersion().isEmpty()) {
            manifest.getProject().setVersion(Names.DEFAULT_VERSION.getValue());
        }
        return manifest;
    }

    public PackageID getPackageID(String sourcePackage) {
        List<String> sourceFileNames = this.sourceDirectory.getSourceFileNames();
        Manifest manifest = this.getManifest();
        Name orgName = this.getOrgName(manifest);
        Name version = new Name(manifest.getProject().getVersion());
        if (orgName.equals(Names.BUILTIN_ORG)) {
            return new PackageID(orgName, this.names.fromString(sourcePackage), Names.EMPTY);
        }
        if (sourceFileNames.contains(sourcePackage)) {
            return new PackageID(sourcePackage);
        }
        List<String> packageNames = this.sourceDirectory.getSourcePackageNames();
        if (packageNames.contains(sourcePackage)) {
            return new PackageID(orgName, this.names.fromString(sourcePackage), version);
        }
        return null;
    }

    public SourceDirectory getSourceDirectory() {
        return this.sourceDirectory;
    }

    private SourceDirectory initializeAndGetSourceDirectory(CompilerContext context) {
        try {
            SourceDirectory srcDirectory = context.get(SourceDirectory.class);
            if (srcDirectory != null) {
                return srcDirectory;
            }
            String srcDirPathName = this.options.get(CompilerOptionName.PROJECT_DIR);
            if (srcDirPathName == null || srcDirPathName.isEmpty()) {
                throw new IllegalArgumentException("invalid project directory path");
            }
            Path sourceRoot = Paths.get(srcDirPathName, new String[0]);
            if (Files.notExists(sourceRoot, new LinkOption[0])) {
                throw new BLangCompilerException("'" + sourceRoot + "' project directory does not exist.");
            }
            if (!Files.isDirectory(sourceRoot, new LinkOption[0])) {
                throw new BLangCompilerException("'" + sourceRoot + "' project directory does not exist.");
            }
            if (Files.isSymbolicLink(sourceRoot)) {
                throw new BLangCompilerException("'" + sourceRoot + "' project directory is symlink.");
            }
            if (!Files.isWritable(sourceRoot)) {
                throw new BLangCompilerException("'" + sourceRoot + "' is not writable.");
            }
            sourceRoot = sourceRoot.normalize().toAbsolutePath();
            String sourceType = this.options.get(CompilerOptionName.SOURCE_TYPE);
            if (null != sourceType) {
                switch (sourceType) {
                    case "SINGLE_BAL_FILE": {
                        srcDirectory = new FileSystemProgramDirectory(sourceRoot);
                        break;
                    }
                    case "SINGLE_MODULE": 
                    case "ALL_MODULES": {
                        if (Files.notExists(sourceRoot.resolve("src"), new LinkOption[0])) {
                            throw new BLangCompilerException("cannot find module(s) to build/compile as 'src' directory is missing. modules should be placed inside an 'src' directory of the project.");
                        }
                        srcDirectory = new FileSystemProjectDirectory(sourceRoot);
                        break;
                    }
                }
            } else {
                srcDirectory = new FileSystemProjectDirectory(sourceRoot);
                if (!srcDirectory.canHandle(sourceRoot)) {
                    srcDirectory = new FileSystemProgramDirectory(sourceRoot);
                }
            }
            if (srcDirectory instanceof FileSystemProjectDirectory) {
                Path manifestPath = sourceRoot.resolve("Ballerina.toml");
                ManifestProcessor.parseTomlContentFromFile(manifestPath);
            }
            context.put(SourceDirectory.class, srcDirectory);
            return srcDirectory;
        }
        catch (IOException e) {
            throw new BLangCompilerException("error occurred in finding manifest");
        }
        catch (TomlException tomlException) {
            throw new BLangCompilerException(tomlException.getMessage());
        }
    }

    private Name getOrgName(Manifest manifest) {
        return manifest.getProject().getOrgName() == null || manifest.getProject().getOrgName().isEmpty() ? Names.ANON_ORG : this.names.fromString(manifest.getProject().getOrgName());
    }

    boolean checkIfSourcesExists(String pkg) {
        if (ProjectDirs.isProject(this.sourceDirectory.getPath()) && !RepoUtils.isBallerinaStandaloneFile(this.sourceDirectory.getPath().resolve(pkg))) {
            return ProjectDirs.containsSourceFiles(this.sourceDirectory.getPath().resolve("src").resolve(pkg));
        }
        return ProjectDirs.containsSourceFiles(this.sourceDirectory.getPath().resolve(pkg));
    }
}

