/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import org.ballerinalang.compiler.BLangCompilerException;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmLabelGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.Nilable;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JType;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class JvmCastGen {
    static void generatePlatformCheckCast(MethodVisitor mv, JvmMethodGen.BalToJVMIndexMap indexMap, BType sourceType, BType targetType) {
        if (sourceType.tag == Integer.MAX_VALUE) {
            JvmCastGen.generateJToBCheckCast(mv, indexMap, (JType)sourceType, targetType);
        } else {
            JvmCastGen.generateBToJCheckCast(mv, sourceType, (JType)targetType);
        }
    }

    public static void generateBToJCheckCast(MethodVisitor mv, BType sourceType, JType targetType) {
        if (targetType.jTag == 1) {
            JvmCastGen.generateCheckCastBToJByte(mv, sourceType);
        } else if (targetType.jTag == 2) {
            JvmCastGen.generateCheckCastBToJChar(mv, sourceType);
        } else if (targetType.jTag == 3) {
            JvmCastGen.generateCheckCastBToJShort(mv, sourceType);
        } else if (targetType.jTag == 4) {
            JvmCastGen.generateCheckCastBToJInt(mv, sourceType);
        } else if (targetType.jTag == 5) {
            JvmCastGen.generateCheckCastBToJLong(mv, sourceType);
        } else if (targetType.jTag == 6) {
            JvmCastGen.generateCheckCastBToJFloat(mv, sourceType);
        } else if (targetType.jTag == 7) {
            JvmCastGen.generateCheckCastBToJDouble(mv, sourceType);
        } else if (targetType.jTag == 10) {
            if (((JType.JRefType)targetType).typeValue.equals("org/ballerinalang/jvm/values/api/BString")) {
                JvmCastGen.generateCheckCastBToJString(mv, sourceType);
            } else {
                JvmCastGen.generateCheckCastBToJRef(mv, sourceType, targetType);
            }
        } else if (targetType.jTag == 9) {
            JvmCastGen.generateCheckCastBToJRef(mv, sourceType, targetType);
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java %s'", sourceType, targetType));
        }
    }

    private static void generateCheckCastBToJString(MethodVisitor mv, BType sourceType) {
        if (!TypeTags.isStringTypeTag(sourceType.tag)) {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java byte'", sourceType));
        }
        mv.visitMethodInsn(184, "org/ballerinalang/jvm/StringUtils", "fromString", String.format("(L%s;)L%s;", "java/lang/String", "org/ballerinalang/jvm/values/api/BString"), false);
    }

    private static void generateCheckCastBToJByte(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag != 2) {
            if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
                mv.visitInsn(136);
                mv.visitInsn(145);
            } else if (sourceType.tag == 3) {
                mv.visitInsn(142);
                mv.visitInsn(145);
            } else if (sourceType.tag == 35) {
                mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
            } else if (sourceType.tag == 31) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToByte", String.format("(L%s;)I", "java/lang/Object"), false);
                mv.visitInsn(145);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java byte'", sourceType));
            }
        }
    }

    private static void generateCheckCastBToJChar(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag == 2) {
            mv.visitInsn(146);
        } else if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(136);
            mv.visitInsn(146);
        } else if (sourceType.tag == 3) {
            mv.visitInsn(142);
            mv.visitInsn(146);
        } else if (sourceType.tag == 35) {
            mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
        } else if (sourceType.tag == 31) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToInt", String.format("(L%s;)J", "java/lang/Object"), false);
            mv.visitInsn(136);
            mv.visitInsn(146);
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java char'", sourceType));
        }
    }

    private static void generateCheckCastBToJShort(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag == 2) {
            mv.visitInsn(147);
        } else if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(136);
            mv.visitInsn(147);
        } else if (sourceType.tag == 3) {
            mv.visitInsn(142);
            mv.visitInsn(147);
        } else if (sourceType.tag == 35) {
            mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
        } else if (sourceType.tag == 31) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToInt", String.format("(L%s;)J", "java/lang/Object"), false);
            mv.visitInsn(136);
            mv.visitInsn(147);
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java short'", sourceType));
        }
    }

    private static void generateCheckCastBToJInt(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag != 2) {
            if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
                mv.visitInsn(136);
            } else if (sourceType.tag == 3) {
                mv.visitInsn(142);
            } else if (sourceType.tag == 35) {
                mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
            } else if (sourceType.tag == 31) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToInt", String.format("(L%s;)J", "java/lang/Object"), false);
                mv.visitInsn(136);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java int'", sourceType));
            }
        }
    }

    private static void generateCheckCastBToJLong(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag == 2) {
            mv.visitInsn(133);
        } else if (!TypeTags.isIntegerTypeTag(sourceType.tag)) {
            if (sourceType.tag == 3) {
                mv.visitInsn(143);
            } else if (sourceType.tag == 35) {
                mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
            } else if (sourceType.tag == 31) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToInt", String.format("(L%s;)J", "java/lang/Object"), false);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java long'", sourceType));
            }
        }
    }

    private static void generateCheckCastBToJFloat(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag == 2) {
            mv.visitInsn(134);
        } else if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(137);
        } else if (sourceType.tag == 3) {
            mv.visitInsn(144);
        } else if (sourceType.tag == 35) {
            mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
        } else if (sourceType.tag == 31) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToFloat", String.format("(L%s;)D", "java/lang/Object"), false);
            mv.visitInsn(144);
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java float'", sourceType));
        }
    }

    private static void generateCheckCastBToJDouble(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag == 2) {
            mv.visitInsn(135);
        } else if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(138);
        } else if (sourceType.tag != 3) {
            if (sourceType.tag == 35) {
                mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
            } else if (sourceType.tag == 31) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToFloat", String.format("(L%s;)D", "java/lang/Object"), false);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'java double'", sourceType));
            }
        }
    }

    private static void generateCheckCastBToJRef(MethodVisitor mv, BType sourceType, JType targetType) {
        if (sourceType.tag == 35) {
            if (targetType.jTag == 10) {
                JType.JRefType jRefType = (JType.JRefType)targetType;
                if (jRefType.typeValue.equals("org/ballerinalang/jvm/values/HandleValue") || jRefType.typeValue.equals("org/ballerinalang/jvm/values/api/BHandle")) {
                    return;
                }
            }
            mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
            String sig = InteropMethodGen.getSignatureForJType(targetType);
            mv.visitTypeInsn(192, sig);
        } else {
            if (sourceType.tag == 4) {
                return;
            }
            if (targetType.jTag == 10) {
                JvmInstructionGen.addBoxInsn(mv, sourceType);
                mv.visitTypeInsn(192, ((JType.JRefType)targetType).typeValue);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to '%s'", sourceType, targetType));
            }
        }
    }

    private static void generateJToBCheckCast(MethodVisitor mv, JvmMethodGen.BalToJVMIndexMap indexMap, JType sourceType, BType targetType) {
        if (TypeTags.isIntegerTypeTag(targetType.tag)) {
            JvmCastGen.generateCheckCastJToBInt(mv, sourceType);
        } else if (targetType.tag == 3) {
            JvmCastGen.generateCheckCastJToBFloat(mv, sourceType);
        } else if (TypeTags.isStringTypeTag(targetType.tag)) {
            JvmCastGen.generateCheckCastJToBString(mv, sourceType);
        } else if (targetType.tag == 4) {
            JvmCastGen.generateCheckCastJToBDecimal(mv, sourceType);
        } else if (targetType.tag == 6) {
            JvmCastGen.generateCheckCastJToBBoolean(mv, sourceType);
        } else if (targetType.tag == 2) {
            JvmCastGen.generateCheckCastJToBByte(mv, sourceType);
        } else if (targetType.tag != 10) {
            if (targetType.tag == 20) {
                JvmCastGen.generateCheckCastJToBUnionType(mv, indexMap, sourceType, (BUnionType)targetType);
            } else if (targetType.tag == 11) {
                JvmCastGen.generateCheckCastJToBAnyData(mv, indexMap, sourceType);
            } else if (targetType.tag == 35) {
                JvmCastGen.generateJCastToBHandle(mv, sourceType);
            } else if (targetType.tag == 17) {
                JvmCastGen.generateJCastToBAny(mv, indexMap, sourceType, targetType);
            } else if (targetType.tag == 7) {
                JvmCastGen.generateCheckCastJToBJSON(mv, indexMap, sourceType);
            } else if (targetType.tag == 31) {
                JvmCastGen.generateCheckCastJToBFiniteType(mv, indexMap, sourceType, targetType);
            }
            JvmCastGen.checkCast(mv, targetType);
            String targetTypeClass = JvmCastGen.getTargetClass(targetType);
            if (targetTypeClass != null) {
                mv.visitTypeInsn(192, targetTypeClass);
            }
        }
    }

    private static void generateCheckCastJToBInt(MethodVisitor mv, JType sourceType) {
        if (sourceType.jTag == 1) {
            mv.visitInsn(145);
            mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
            mv.visitInsn(133);
        } else if (sourceType.jTag == 2) {
            mv.visitInsn(133);
        } else if (sourceType.jTag == 3) {
            mv.visitInsn(133);
        } else if (sourceType.jTag == 4) {
            mv.visitInsn(133);
        } else if (sourceType.jTag != 5) {
            if (sourceType.jTag == 10) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToJLong", String.format("(L%s;)J", "java/lang/Object"), false);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int'", sourceType));
            }
        }
    }

    private static void generateCheckCastJToBFloat(MethodVisitor mv, JType sourceType) {
        if (sourceType.jTag == 1) {
            mv.visitInsn(145);
            mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
            mv.visitInsn(135);
        } else if (sourceType.jTag == 2) {
            mv.visitInsn(135);
        } else if (sourceType.jTag == 3) {
            mv.visitInsn(135);
        } else if (sourceType.jTag == 4) {
            mv.visitInsn(135);
        } else if (sourceType.jTag == 5) {
            mv.visitInsn(138);
        } else if (sourceType.jTag == 6) {
            mv.visitInsn(141);
        } else if (sourceType.jTag != 7) {
            if (sourceType.jTag == 10) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToJDouble", String.format("(L%s;)D", "java/lang/Object"), false);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'float'", sourceType));
            }
        }
    }

    private static void generateCheckCastJToBString(MethodVisitor mv, JType sourceType) {
        if (sourceType.jTag == 10) {
            String typeValue = ((JType.JRefType)sourceType).typeValue;
            if (typeValue.equals("org/ballerinalang/jvm/values/StringValue")) {
                mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/StringValue", "getValue", String.format("()L%s;", "java/lang/String"), true);
                return;
            }
            if (typeValue.equals("org/ballerinalang/jvm/values/api/BString")) {
                mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/api/BString", "getValue", String.format("()L%s;", "java/lang/String"), true);
                return;
            }
        }
        throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'string'", sourceType));
    }

    private static void generateCheckCastJToBDecimal(MethodVisitor mv, JType sourceType) {
        if (sourceType.jTag == 1) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/values/DecimalValue", "valueOfJ", String.format("(B)L%s;", "org/ballerinalang/jvm/values/DecimalValue"), false);
        } else if (sourceType.jTag == 2) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/values/DecimalValue", "valueOfJ", String.format("(C)L%s;", "org/ballerinalang/jvm/values/DecimalValue"), false);
        } else if (sourceType.jTag == 3) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/values/DecimalValue", "valueOfJ", String.format("(S)L%s;", "org/ballerinalang/jvm/values/DecimalValue"), false);
        } else if (sourceType.jTag == 4) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/values/DecimalValue", "valueOfJ", String.format("(I)L%s;", "org/ballerinalang/jvm/values/DecimalValue"), false);
        } else if (sourceType.jTag == 5) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/values/DecimalValue", "valueOfJ", String.format("(J)L%s;", "org/ballerinalang/jvm/values/DecimalValue"), false);
        } else if (sourceType.jTag == 6) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/values/DecimalValue", "valueOfJ", String.format("(F)L%s;", "org/ballerinalang/jvm/values/DecimalValue"), false);
        } else if (sourceType.jTag == 7) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/values/DecimalValue", "valueOfJ", String.format("(D)L%s;", "org/ballerinalang/jvm/values/DecimalValue"), false);
        } else if (sourceType.jTag == 10) {
            mv.visitTypeInsn(192, "org/ballerinalang/jvm/values/DecimalValue");
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'decimal'", sourceType));
        }
    }

    private static void generateCheckCastJToBBoolean(MethodVisitor mv, JType sourceType) {
        if (sourceType.jTag != 8) {
            if (sourceType.jTag == 10) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToBoolean", String.format("(L%s;)Z", "java/lang/Object"), false);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'boolean'", sourceType));
            }
        }
    }

    private static void generateCheckCastJToBByte(MethodVisitor mv, JType sourceType) {
        if (sourceType.jTag != 1) {
            if (sourceType.jTag == 10) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToByte", String.format("(L%s;)I", "java/lang/Object"), false);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'byte'", sourceType));
            }
        }
    }

    private static void generateCheckCastJToBUnionType(MethodVisitor mv, JvmMethodGen.BalToJVMIndexMap indexMap, JType sourceType, BUnionType targetType) {
        JvmCastGen.generateJCastToBAny(mv, indexMap, sourceType, targetType);
    }

    private static void generateCheckCastJToBAnyData(MethodVisitor mv, JvmMethodGen.BalToJVMIndexMap indexMap, JType sourceType) {
        if (sourceType.jTag != 10 && sourceType.jTag != 9) {
            JvmCastGen.generateJCastToBAny(mv, indexMap, sourceType, JvmPackageGen.symbolTable.anydataType);
        }
    }

    private static void generateJCastToBHandle(MethodVisitor mv, JType sourceType) {
        JvmLabelGen.LabelGenerator labelGen = new JvmLabelGen.LabelGenerator();
        Label afterHandle = labelGen.getLabel("after_handle");
        mv.visitInsn(89);
        mv.visitTypeInsn(193, "org/ballerinalang/jvm/values/api/BHandle");
        mv.visitJumpInsn(154, afterHandle);
        mv.visitMethodInsn(184, "org/ballerinalang/jvm/values/HandleValue", "valueOfJ", String.format("(L%s;)L%s;", "java/lang/Object", "org/ballerinalang/jvm/values/HandleValue"), false);
        mv.visitLabel(afterHandle);
    }

    private static void generateJCastToBAny(MethodVisitor mv, JvmMethodGen.BalToJVMIndexMap indexMap, JType sourceType, BType targetType) {
        if (sourceType.jTag == 8) {
            mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", String.format("(Z)L%s;", "java/lang/Boolean"), false);
        } else if (sourceType.jTag == 1) {
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", String.format("(I)L%s;", "java/lang/Integer"), false);
        } else if (sourceType.jTag == 2) {
            mv.visitInsn(133);
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", String.format("(J)L%s;", "java/lang/Long"), false);
        } else if (sourceType.jTag == 3) {
            mv.visitInsn(133);
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", String.format("(J)L%s;", "java/lang/Long"), false);
        } else if (sourceType.jTag == 4) {
            mv.visitInsn(133);
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", String.format("(J)L%s;", "java/lang/Long"), false);
        } else if (sourceType.jTag == 5) {
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", String.format("(J)L%s;", "java/lang/Long"), false);
        } else if (sourceType.jTag == 6) {
            mv.visitInsn(141);
            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", String.format("(D)L%s;", "java/lang/Double"), false);
        } else if (sourceType.jTag == 7) {
            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", String.format("(D)L%s;", "java/lang/Double"), false);
        } else if (sourceType.jTag == 10) {
            Label afterHandle = new Label();
            if (((JType.JRefType)sourceType).typeValue.equals("java/lang/Object")) {
                mv.visitInsn(89);
                mv.visitTypeInsn(193, "org/ballerinalang/jvm/values/ErrorValue");
                mv.visitJumpInsn(154, afterHandle);
                mv.visitInsn(89);
                mv.visitTypeInsn(193, "java/lang/Number");
                mv.visitJumpInsn(154, afterHandle);
                mv.visitInsn(89);
                mv.visitTypeInsn(193, "java/lang/Boolean");
                mv.visitJumpInsn(154, afterHandle);
                mv.visitInsn(89);
                mv.visitTypeInsn(193, "org/ballerinalang/jvm/values/SimpleValue");
                mv.visitJumpInsn(154, afterHandle);
            }
            if (JvmCastGen.isNillable(targetType)) {
                mv.visitInsn(89);
                mv.visitJumpInsn(198, afterHandle);
            }
            mv.visitInsn(89);
            mv.visitTypeInsn(193, "org/ballerinalang/jvm/values/RefValue");
            mv.visitJumpInsn(154, afterHandle);
            BIRNode.BIRVariableDcl retJObjectVarDcl = new BIRNode.BIRVariableDcl(null, JvmPackageGen.symbolTable.anyType, new Name("$_ret_jobject_val_$"), VarScope.FUNCTION, VarKind.LOCAL, "");
            int returnJObjectVarRefIndex = indexMap.getIndex(retJObjectVarDcl);
            mv.visitVarInsn(58, returnJObjectVarRefIndex);
            mv.visitTypeInsn(187, "org/ballerinalang/jvm/values/HandleValue");
            mv.visitInsn(89);
            mv.visitVarInsn(25, returnJObjectVarRefIndex);
            mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/HandleValue", "<init>", "(Ljava/lang/Object;)V", false);
            mv.visitLabel(afterHandle);
        } else if (sourceType.jTag != 9) {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'any'", sourceType));
        }
    }

    private static boolean isNillable(BType targetType) {
        if (targetType.tag == 10 || targetType.tag == 7 || targetType.tag == 17 || targetType.tag == 11) {
            return true;
        }
        if (targetType.tag == 20) {
            return targetType.isNullable();
        }
        if (targetType.tag == 31) {
            return targetType.isNullable();
        }
        return false;
    }

    private static void generateCheckCastJToBJSON(MethodVisitor mv, JvmMethodGen.BalToJVMIndexMap indexMap, JType sourceType) {
        if (sourceType.jTag != 10 && sourceType.jTag != 9) {
            JvmCastGen.generateJCastToBAny(mv, indexMap, sourceType, JvmPackageGen.symbolTable.jsonType);
        }
    }

    private static void generateCheckCastJToBFiniteType(MethodVisitor mv, JvmMethodGen.BalToJVMIndexMap indexMap, JType sourceType, BType targetType) {
        if (sourceType.jTag != 10 && sourceType.jTag != 9) {
            JvmCastGen.generateJCastToBAny(mv, indexMap, sourceType, targetType);
        }
    }

    static void generateCheckCast(MethodVisitor mv, BType sourceType, BType targetType, JvmMethodGen.BalToJVMIndexMap indexMap) {
        if (targetType.tag == 1) {
            JvmCastGen.generateCheckCastToInt(mv, sourceType);
            return;
        }
        if (targetType.tag == 36) {
            JvmCastGen.generateCheckCastToSigned32(mv, sourceType);
            return;
        }
        if (targetType.tag == 37) {
            JvmCastGen.generateCheckCastToSigned16(mv, sourceType);
            return;
        }
        if (targetType.tag == 38) {
            JvmCastGen.generateCheckCastToSigned8(mv, sourceType);
            return;
        }
        if (targetType.tag == 39) {
            JvmCastGen.generateCheckCastToUnsigned32(mv, sourceType);
            return;
        }
        if (targetType.tag == 40) {
            JvmCastGen.generateCheckCastToUnsigned16(mv, sourceType);
            return;
        }
        if (targetType.tag == 41) {
            JvmCastGen.generateCheckCastToUnsigned8(mv, sourceType);
            return;
        }
        if (targetType.tag == 3) {
            JvmCastGen.generateCheckCastToFloat(mv, sourceType);
            return;
        }
        if (targetType.tag == 5) {
            JvmCastGen.generateCheckCastToString(mv, sourceType, indexMap);
            return;
        }
        if (targetType.tag == 42) {
            JvmCastGen.generateCheckCastToChar(mv, sourceType);
            return;
        }
        if (targetType.tag == 4) {
            JvmCastGen.generateCheckCastToDecimal(mv, sourceType);
            return;
        }
        if (targetType.tag == 6) {
            JvmCastGen.generateCheckCastToBoolean(mv, sourceType);
            return;
        }
        if (targetType.tag == 2) {
            JvmCastGen.generateCheckCastToByte(mv, sourceType);
            return;
        }
        if (targetType.tag == 10) {
            JvmCastGen.checkCast(mv, targetType);
            return;
        }
        if (targetType.tag == 20) {
            JvmCastGen.generateCheckCastToUnionType(mv, sourceType, (BUnionType)targetType);
            return;
        }
        if (targetType.tag == 11) {
            JvmCastGen.generateCheckCastToAnyData(mv, sourceType);
            return;
        }
        if (targetType.tag == 17) {
            JvmCastGen.generateCastToAny(mv, sourceType);
            return;
        }
        if (targetType.tag == 7) {
            JvmCastGen.generateCheckCastToJSON(mv, sourceType);
            return;
        }
        if (TypeTags.isXMLTypeTag(sourceType.tag) && targetType.tag == 15) {
            JvmCastGen.generateXMLToAttributesMap(mv, sourceType);
            return;
        }
        if (targetType.tag == 31) {
            JvmCastGen.generateCheckCastToFiniteType(mv, sourceType, (BFiniteType)targetType);
            return;
        }
        if (sourceType.tag != 12 || targetType.tag != 15 || ((BMapType)targetType).constraint.tag != 17) {
            JvmCastGen.checkCast(mv, targetType);
        }
        String targetTypeClass = JvmCastGen.getTargetClass(targetType);
        if (targetTypeClass != null) {
            mv.visitTypeInsn(192, targetTypeClass);
        }
    }

    private static void generateCheckCastToInt(MethodVisitor mv, BType sourceType) {
        if (!TypeTags.isIntegerTypeTag(sourceType.tag)) {
            if (sourceType.tag == 2) {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
            } else if (sourceType.tag == 3) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "floatToInt", "(D)J", false);
            } else if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 4 || sourceType.tag == 7 || sourceType.tag == 31) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToInt", String.format("(L%s;)J", "java/lang/Object"), false);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int'", sourceType));
            }
        }
    }

    private static void generateCheckCastToSigned32(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "intToSigned32", "(J)J", false);
        } else if (sourceType.tag == 2) {
            mv.visitInsn(145);
            mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
            mv.visitInsn(133);
        } else if (sourceType.tag == 3) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "floatToSigned32", "(D)J", false);
        } else if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 4 || sourceType.tag == 7 || sourceType.tag == 31) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToSigned32", String.format("(L%s;)J", "java/lang/Object"), false);
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int:Signed32'", sourceType));
        }
    }

    private static void generateCheckCastToSigned16(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "intToSigned16", "(J)J", false);
        } else if (sourceType.tag == 2) {
            mv.visitInsn(145);
            mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
            mv.visitInsn(133);
        } else if (sourceType.tag == 3) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "floatToSigned16", "(D)J", false);
        } else if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 4 || sourceType.tag == 7 || sourceType.tag == 31) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToSigned16", String.format("(L%s;)J", "java/lang/Object"), false);
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int:Signed16'", sourceType));
        }
    }

    private static void generateCheckCastToSigned8(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "intToSigned8", "(J)J", false);
        } else if (sourceType.tag == 2) {
            mv.visitInsn(145);
            mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
            mv.visitInsn(133);
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "intToSigned8", "(J)J", false);
        } else if (sourceType.tag == 3) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "floatToSigned8", "(D)J", false);
        } else if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 4 || sourceType.tag == 7 || sourceType.tag == 31) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToSigned8", String.format("(L%s;)J", "java/lang/Object"), false);
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int:Signed8'", sourceType));
        }
    }

    private static void generateCheckCastToUnsigned32(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "intToUnsigned32", "(J)J", false);
        } else if (sourceType.tag == 2) {
            mv.visitInsn(145);
            mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
            mv.visitInsn(133);
        } else if (sourceType.tag == 3) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "floatToUnsigned32", "(D)J", false);
        } else if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 4 || sourceType.tag == 7 || sourceType.tag == 31) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToUnsigned32", String.format("(L%s;)J", "java/lang/Object"), false);
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int:Unsigned32'", sourceType));
        }
    }

    private static void generateCheckCastToUnsigned16(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "intToUnsigned16", "(J)J", false);
        } else if (sourceType.tag == 2) {
            mv.visitInsn(145);
            mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
            mv.visitInsn(133);
        } else if (sourceType.tag == 3) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "floatToUnsigned16", "(D)J", false);
        } else if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 4 || sourceType.tag == 7 || sourceType.tag == 31) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToUnsigned16", String.format("(L%s;)J", "java/lang/Object"), false);
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int:Unsigned16'", sourceType));
        }
    }

    private static void generateCheckCastToUnsigned8(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "intToUnsigned8", "(J)J", false);
        } else if (sourceType.tag == 2) {
            mv.visitInsn(145);
            mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
            mv.visitInsn(133);
        } else if (sourceType.tag == 3) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "floatToUnsigned8", "(D)J", false);
        } else if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 4 || sourceType.tag == 7 || sourceType.tag == 31) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToUnsigned8", String.format("(L%s;)J", "java/lang/Object"), false);
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int:Unsigned8'", sourceType));
        }
    }

    private static void generateCheckCastToFloat(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag != 3) {
            if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
                mv.visitInsn(138);
            } else if (sourceType.tag == 2) {
                mv.visitInsn(135);
            } else if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 4 || sourceType.tag == 7 || sourceType.tag == 31) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToFloat", String.format("(L%s;)D", "java/lang/Object"), false);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'float'", sourceType));
            }
        }
    }

    private static void generateCheckCastToDecimal(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag != 4) {
            if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 7 || sourceType.tag == 31) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToDecimal", String.format("(L%s;)L%s;", "java/lang/Object", "org/ballerinalang/jvm/values/DecimalValue"), false);
            } else if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/values/DecimalValue", "valueOf", String.format("(J)L%s;", "org/ballerinalang/jvm/values/DecimalValue"), false);
            } else if (sourceType.tag == 3) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/values/DecimalValue", "valueOf", String.format("(D)L%s;", "org/ballerinalang/jvm/values/DecimalValue"), false);
            } else if (sourceType.tag == 2) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/values/DecimalValue", "valueOf", String.format("(I)L%s;", "org/ballerinalang/jvm/values/DecimalValue"), false);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'decimal'", sourceType));
            }
        }
    }

    private static void generateCheckCastToString(MethodVisitor mv, BType sourceType, JvmMethodGen.BalToJVMIndexMap indexMap) {
        if (TypeTags.isStringTypeTag(sourceType.tag)) {
            return;
        }
        if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 7 || sourceType.tag == 31) {
            JvmCastGen.checkCast(mv, JvmPackageGen.symbolTable.stringType);
            if (JvmInstructionGen.isBString) {
                mv.visitTypeInsn(192, "org/ballerinalang/jvm/values/api/BString");
            } else {
                mv.visitTypeInsn(192, "java/lang/String");
            }
            return;
        }
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "java/lang/Long", "toString", String.format("(J)L%s;", "java/lang/String"), false);
        } else if (sourceType.tag == 3) {
            mv.visitMethodInsn(184, "java/lang/Double", "toString", String.format("(D)L%s;", "java/lang/String"), false);
        } else if (sourceType.tag == 6) {
            mv.visitMethodInsn(184, "java/lang/Boolean", "toString", String.format("(Z)L%s;", "java/lang/String"), false);
        } else if (sourceType.tag == 4) {
            mv.visitMethodInsn(184, "java/lang/String", "valueOf", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/String"), false);
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'string'", sourceType));
        }
        JvmCastGen.generateNonBMPStringValue(mv, indexMap);
    }

    static void generateNonBMPStringValue(MethodVisitor mv, JvmMethodGen.BalToJVMIndexMap indexMap) {
        BIRNode.BIRVariableDcl strVar = new BIRNode.BIRVariableDcl(null, JvmPackageGen.symbolTable.anyType, new Name("str"), VarScope.FUNCTION, VarKind.LOCAL, "");
        int tmpVarIndex = indexMap.getIndex(strVar);
        mv.visitVarInsn(58, tmpVarIndex);
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/values/BmpStringValue");
        mv.visitInsn(89);
        mv.visitVarInsn(25, tmpVarIndex);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/BmpStringValue", "<init>", String.format("(L%s;)V", "java/lang/String"), false);
    }

    private static void generateCheckCastToChar(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isStringTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "stringToChar", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/String"), false);
        } else if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 7 || sourceType.tag == 31 || TypeTags.isIntegerTypeTag(sourceType.tag) || sourceType.tag == 3 || sourceType.tag == 6 || sourceType.tag == 4) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "anyToChar", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/String"), false);
        } else {
            throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'char'", sourceType));
        }
    }

    private static void generateCheckCastToBoolean(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag != 6) {
            if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 7 || sourceType.tag == 31) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToBoolean", String.format("(L%s;)Z", "java/lang/Object"), false);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'boolean'", sourceType));
            }
        }
    }

    static void generateCheckCastToByte(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "intToByte", "(J)I", false);
        } else if (sourceType.tag == 3) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeConverter", "floatToByte", "(D)I", false);
        } else if (sourceType.tag == 4) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToByte", String.format("(L%s;)I", "java/lang/Object"), false);
        } else if (sourceType.tag != 2) {
            if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 31 || sourceType.tag == 7) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToByte", String.format("(L%s;)I", "java/lang/Object"), false);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'byte'", sourceType));
            }
        }
    }

    private static void generateCheckCastToAnyData(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag == 17 || sourceType.tag == 20) {
            JvmCastGen.checkCast(mv, JvmPackageGen.symbolTable.anydataType);
        } else {
            JvmCastGen.generateCastToAny(mv, sourceType);
        }
    }

    private static void generateCheckCastToJSON(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag == 17 || sourceType.tag == 20 || sourceType.tag == 15) {
            JvmCastGen.checkCast(mv, JvmPackageGen.symbolTable.jsonType);
        } else {
            JvmCastGen.generateCastToAny(mv, sourceType);
        }
    }

    private static void generateCheckCastToUnionType(MethodVisitor mv, BType sourceType, BUnionType targetType) {
        JvmCastGen.generateCastToAny(mv, sourceType);
        JvmCastGen.checkCast(mv, targetType);
    }

    private static void checkCast(MethodVisitor mv, BType targetType) {
        JvmTypeGen.loadType(mv, targetType);
        mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "checkCast", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "org/ballerinalang/jvm/types/BType", "java/lang/Object"), false);
    }

    @Nilable
    static String getTargetClass(BType targetType) {
        String targetTypeClass;
        if (targetType.tag == 19 || targetType.tag == 29) {
            targetTypeClass = "org/ballerinalang/jvm/values/ArrayValue";
        } else if (targetType.tag == 15) {
            targetTypeClass = "org/ballerinalang/jvm/values/MapValue";
        } else if (targetType.tag == 12) {
            targetTypeClass = "org/ballerinalang/jvm/values/MapValue";
        } else if (targetType.tag == 9) {
            targetTypeClass = "org/ballerinalang/jvm/values/TableValue";
        } else if (targetType.tag == 14) {
            targetTypeClass = "org/ballerinalang/jvm/values/StreamValue";
        } else if (targetType.tag == 32) {
            targetTypeClass = "org/ballerinalang/jvm/values/ObjectValue";
        } else if (targetType.tag == 27) {
            targetTypeClass = "org/ballerinalang/jvm/values/ErrorValue";
        } else if (TypeTags.isXMLTypeTag(targetType.tag)) {
            targetTypeClass = "org/ballerinalang/jvm/values/XMLValue";
        } else if (targetType.tag == 13) {
            targetTypeClass = "org/ballerinalang/jvm/values/TypedescValue";
        } else if (targetType.tag == 16) {
            targetTypeClass = "org/ballerinalang/jvm/values/FPValue";
        } else if (targetType.tag == 30) {
            targetTypeClass = "org/ballerinalang/jvm/values/FutureValue";
        } else if (targetType.tag == 35) {
            targetTypeClass = "org/ballerinalang/jvm/values/HandleValue";
        } else {
            return null;
        }
        return targetTypeClass;
    }

    private static void generateCheckCastToFiniteType(MethodVisitor mv, BType sourceType, BFiniteType targetType) {
        JvmCastGen.generateCastToAny(mv, sourceType);
        JvmCastGen.checkCast(mv, targetType);
    }

    static void generateCast(MethodVisitor mv, BType sourceType, BType targetType) {
        if (TypeTags.isIntegerTypeTag(targetType.tag)) {
            JvmCastGen.generateCastToInt(mv, sourceType);
            return;
        }
        if (targetType.tag == 3) {
            JvmCastGen.generateCastToFloat(mv, sourceType);
            return;
        }
        if (TypeTags.isStringTypeTag(targetType.tag)) {
            JvmCastGen.generateCastToString(mv, sourceType);
            return;
        }
        if (targetType.tag == 6) {
            JvmCastGen.generateCastToBoolean(mv, sourceType);
            return;
        }
        if (targetType.tag == 2) {
            JvmCastGen.generateCastToByte(mv, sourceType);
            return;
        }
        if (targetType.tag == 4) {
            JvmCastGen.generateCastToDecimal(mv, sourceType);
            return;
        }
        if (targetType.tag == 10) {
            return;
        }
        if (targetType.tag == 20 || targetType.tag == 11 || targetType.tag == 17 || targetType.tag == 7 || targetType.tag == 31) {
            JvmCastGen.generateCastToAny(mv, sourceType);
            return;
        }
        String targetTypeClass = JvmCastGen.getTargetClass(targetType);
        if (targetTypeClass != null) {
            mv.visitTypeInsn(192, targetTypeClass);
        }
    }

    private static void generateCastToInt(MethodVisitor mv, BType sourceType) {
        if (!TypeTags.isIntegerTypeTag(sourceType.tag)) {
            if (sourceType.tag == 2) {
                mv.visitInsn(133);
            } else if (sourceType.tag == 3) {
                mv.visitInsn(143);
            } else if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 7) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToInt", String.format("(L%s;)J", "java/lang/Object"), false);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'int'", sourceType));
            }
        }
    }

    private static void generateCastToFloat(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag != 3) {
            if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
                mv.visitInsn(138);
            } else if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 7) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToFloat", String.format("(L%s;)D", "java/lang/Object"), false);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'float'", sourceType));
            }
        }
    }

    private static void generateCastToString(MethodVisitor mv, BType sourceType) {
        if (!TypeTags.isStringTypeTag(sourceType.tag)) {
            if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
                mv.visitMethodInsn(184, "java/lang/Long", "toString", String.format("(J)L%s;", "java/lang/String"), false);
            } else if (sourceType.tag == 3) {
                mv.visitMethodInsn(184, "java/lang/Double", "toString", String.format("(D)L%s;", "java/lang/String"), false);
            } else if (sourceType.tag == 6) {
                mv.visitMethodInsn(184, "java/lang/Boolean", "toString", String.format("(Z)L%s;", "java/lang/String"), false);
            } else if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 7) {
                if (JvmInstructionGen.isBString) {
                    mv.visitTypeInsn(192, "org/ballerinalang/jvm/values/api/BString");
                } else {
                    mv.visitTypeInsn(192, "java/lang/String");
                }
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'string'", sourceType));
            }
        }
    }

    private static void generateCastToDecimal(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag != 4) {
            if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/values/DecimalValue", "valueOf", String.format("(J)L%s;", "org/ballerinalang/jvm/values/DecimalValue"), false);
            } else if (sourceType.tag == 3) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/values/DecimalValue", "valueOf", String.format("(D)L%s;", "org/ballerinalang/jvm/values/DecimalValue"), false);
            } else if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 7) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToDecimal", String.format("(L%s;)L%s;", "java/lang/Object", "org/ballerinalang/jvm/values/DecimalValue"), false);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'decimal'", sourceType));
            }
        }
    }

    private static void generateCastToBoolean(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag != 6) {
            if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 7) {
                mv.visitTypeInsn(192, "java/lang/Boolean");
                mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'boolean'", sourceType));
            }
        }
    }

    private static void generateCastToByte(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(136);
        } else if (sourceType.tag != 2) {
            if (sourceType.tag == 17 || sourceType.tag == 11 || sourceType.tag == 20 || sourceType.tag == 7) {
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToByte", String.format("(L%s;)I", "java/lang/Object"), false);
            } else {
                throw new BLangCompilerException(String.format("Casting is not supported from '%s' to 'byte'", sourceType));
            }
        }
    }

    private static void generateCastToAny(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", String.format("(J)L%s;", "java/lang/Long"), false);
        } else if (sourceType.tag == 2) {
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", String.format("(I)L%s;", "java/lang/Integer"), false);
        } else if (sourceType.tag == 3) {
            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", String.format("(D)L%s;", "java/lang/Double"), false);
        } else if (sourceType.tag == 6) {
            mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", String.format("(Z)L%s;", "java/lang/Boolean"), false);
        }
    }

    private static void generateXMLToAttributesMap(MethodVisitor mv, BType sourceType) {
        mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/XMLValue", "getAttributesMap", String.format("()L%s;", "org/ballerinalang/jvm/values/MapValue"), false);
    }
}

