/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import java.util.ArrayList;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTerminatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmValueGen;
import org.wso2.ballerinalang.compiler.bir.codegen.Nilable;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInsKind;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JType;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.SchedulerPolicy;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class JvmInstructionGen {
    public static final String I_STRING_VALUE = "org/ballerinalang/jvm/values/StringValue";
    public static final String B_STRING_VALUE = "org/ballerinalang/jvm/values/api/BString";
    public static final String NON_BMP_STRING_VALUE = "org/ballerinalang/jvm/values/NonBmpStringValue";
    public static boolean isBString = false;

    static void addBoxInsn(MethodVisitor mv, @Nilable BType bType) {
        if (bType != null) {
            JvmCastGen.generateCast(mv, bType, JvmPackageGen.symbolTable.anyType);
        }
    }

    public static void addUnboxInsn(MethodVisitor mv, @Nilable BType bType) {
        if (bType != null) {
            JvmCastGen.generateCast(mv, JvmPackageGen.symbolTable.anyType, bType);
        }
    }

    static void addJUnboxInsn(MethodVisitor mv, @Nilable JType jType) {
        if (jType == null) {
            return;
        }
        if (jType.jTag == 1) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToJByte", String.format("(L%s;)B", "java/lang/Object"), false);
        } else if (jType.jTag == 2) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToJChar", String.format("(L%s;)C", "java/lang/Object"), false);
        } else if (jType.jTag == 3) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToJShort", String.format("(L%s;)S", "java/lang/Object"), false);
        } else if (jType.jTag == 4) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToJInt", String.format("(L%s;)I", "java/lang/Object"), false);
        } else if (jType.jTag == 5) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToJLong", String.format("(L%s;)J", "java/lang/Object"), false);
        } else if (jType.jTag == 6) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToJFloat", String.format("(L%s;)F", "java/lang/Object"), false);
        } else if (jType.jTag == 7) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToJDouble", String.format("(L%s;)D", "java/lang/Object"), false);
        } else if (jType.jTag == 8) {
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "anyToJBoolean", String.format("(L%s;)Z", "java/lang/Object"), false);
        } else if (jType.jTag == 10) {
            mv.visitTypeInsn(192, ((JType.JRefType)jType).typeValue);
        }
    }

    public static void generateVarLoad(MethodVisitor mv, BIRNode.BIRVariableDcl varDcl, String currentPackageName, int valueIndex) {
        BType bType = varDcl.type;
        if (varDcl.kind == VarKind.GLOBAL) {
            BIRNode.BIRGlobalVariableDcl globalVar = (BIRNode.BIRGlobalVariableDcl)varDcl;
            PackageID modId = globalVar.pkgId;
            String moduleName = JvmPackageGen.getPackageName(modId.orgName, modId.name);
            String varName = varDcl.name.value;
            String className = JvmPackageGen.lookupGlobalVarClassName(moduleName, varName);
            String typeSig = JvmTypeGen.getTypeDesc(bType);
            mv.visitFieldInsn(178, className, varName, typeSig);
            return;
        }
        if (varDcl.kind == VarKind.SELF) {
            mv.visitVarInsn(25, 0);
            return;
        }
        if (varDcl.kind == VarKind.CONSTANT) {
            String varName = varDcl.name.value;
            PackageID moduleId = ((BIRNode.BIRGlobalVariableDcl)varDcl).pkgId;
            String pkgName = JvmPackageGen.getPackageName(moduleId.orgName, moduleId.name);
            String className = JvmPackageGen.lookupGlobalVarClassName(pkgName, varName);
            String typeSig = JvmTypeGen.getTypeDesc(bType);
            mv.visitFieldInsn(178, className, varName, typeSig);
            return;
        }
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            mv.visitVarInsn(22, valueIndex);
        } else if (bType.tag == 2) {
            mv.visitVarInsn(21, valueIndex);
            mv.visitInsn(145);
            mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
        } else if (bType.tag == 3) {
            mv.visitVarInsn(24, valueIndex);
        } else if (bType.tag == 6) {
            mv.visitVarInsn(21, valueIndex);
        } else if (bType.tag == 19 || TypeTags.isStringTypeTag(bType.tag) || bType.tag == 15 || bType.tag == 9 || bType.tag == 14 || bType.tag == 17 || bType.tag == 11 || bType.tag == 10 || bType.tag == 20 || bType.tag == 29 || bType.tag == 12 || bType.tag == 27 || bType.tag == 7 || bType.tag == 30 || bType.tag == 32 || bType.tag == 4 || TypeTags.isXMLTypeTag(bType.tag) || bType.tag == 16 || bType.tag == 31 || bType.tag == 35 || bType.tag == 13) {
            mv.visitVarInsn(25, valueIndex);
        } else if (bType.tag == Integer.MAX_VALUE) {
            JvmInstructionGen.generateJVarLoad(mv, (JType)bType, currentPackageName, valueIndex);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", bType));
        }
    }

    private static void generateJVarLoad(MethodVisitor mv, JType jType, String currentPackageName, int valueIndex) {
        if (jType.jTag == 1) {
            mv.visitVarInsn(21, valueIndex);
        } else if (jType.jTag == 2) {
            mv.visitVarInsn(21, valueIndex);
        } else if (jType.jTag == 3) {
            mv.visitVarInsn(21, valueIndex);
        } else if (jType.jTag == 4) {
            mv.visitVarInsn(21, valueIndex);
        } else if (jType.jTag == 5) {
            mv.visitVarInsn(22, valueIndex);
        } else if (jType.jTag == 6) {
            mv.visitVarInsn(23, valueIndex);
        } else if (jType.jTag == 7) {
            mv.visitVarInsn(24, valueIndex);
        } else if (jType.jTag == 8) {
            mv.visitVarInsn(21, valueIndex);
        } else if (jType.jTag == 9 || jType.jTag == 10) {
            mv.visitVarInsn(25, valueIndex);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", jType));
        }
    }

    public static void generateVarStore(MethodVisitor mv, BIRNode.BIRVariableDcl varDcl, String currentPackageName, int valueIndex) {
        BType bType = varDcl.type;
        if (varDcl.kind == VarKind.GLOBAL) {
            String varName = varDcl.name.value;
            String className = JvmPackageGen.lookupGlobalVarClassName(currentPackageName, varName);
            String typeSig = JvmTypeGen.getTypeDesc(bType);
            mv.visitFieldInsn(179, className, varName, typeSig);
            return;
        }
        if (varDcl.kind == VarKind.CONSTANT) {
            String varName = varDcl.name.value;
            PackageID moduleId = ((BIRNode.BIRGlobalVariableDcl)varDcl).pkgId;
            String pkgName = JvmPackageGen.getPackageName(moduleId.orgName, moduleId.name);
            String className = JvmPackageGen.lookupGlobalVarClassName(pkgName, varName);
            String typeSig = JvmTypeGen.getTypeDesc(bType);
            mv.visitFieldInsn(179, className, varName, typeSig);
            return;
        }
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            mv.visitVarInsn(55, valueIndex);
        } else if (bType.tag == 2) {
            mv.visitVarInsn(54, valueIndex);
        } else if (bType.tag == 3) {
            mv.visitVarInsn(57, valueIndex);
        } else if (bType.tag == 6) {
            mv.visitVarInsn(54, valueIndex);
        } else if (bType.tag == 19 || TypeTags.isStringTypeTag(bType.tag) || bType.tag == 15 || bType.tag == 9 || bType.tag == 14 || bType.tag == 17 || bType.tag == 11 || bType.tag == 10 || bType.tag == 20 || bType.tag == 29 || bType.tag == 4 || bType.tag == 12 || bType.tag == 27 || bType.tag == 7 || bType.tag == 30 || bType.tag == 32 || bType.tag == 32 || TypeTags.isXMLTypeTag(bType.tag) || bType.tag == 16 || bType.tag == 31 || bType.tag == 35 || bType.tag == 13) {
            mv.visitVarInsn(58, valueIndex);
        } else if (bType.tag == Integer.MAX_VALUE) {
            JvmInstructionGen.generateJVarStore(mv, (JType)bType, currentPackageName, valueIndex);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", bType));
        }
    }

    private static void generateJVarStore(MethodVisitor mv, JType jType, String currentPackageName, int valueIndex) {
        if (jType.jTag == 1) {
            mv.visitVarInsn(54, valueIndex);
        } else if (jType.jTag == 2) {
            mv.visitVarInsn(54, valueIndex);
        } else if (jType.jTag == 3) {
            mv.visitVarInsn(54, valueIndex);
        } else if (jType.jTag == 4) {
            mv.visitVarInsn(54, valueIndex);
        } else if (jType.jTag == 5) {
            mv.visitVarInsn(55, valueIndex);
        } else if (jType.jTag == 6) {
            mv.visitVarInsn(56, valueIndex);
        } else if (jType.jTag == 7) {
            mv.visitVarInsn(57, valueIndex);
        } else if (jType.jTag == 8) {
            mv.visitVarInsn(54, valueIndex);
        } else if (jType.jTag == 9 || jType.jTag == 10) {
            mv.visitVarInsn(58, valueIndex);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", jType));
        }
    }

    private static int[] listHighSurrogates(String str) {
        ArrayList<Integer> highSurrogates = new ArrayList<Integer>();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isHighSurrogate(c)) continue;
            highSurrogates.add(i - highSurrogates.size());
        }
        int[] highSurrogatesArr = new int[highSurrogates.size()];
        for (int i = 0; i < highSurrogates.size(); ++i) {
            Integer highSurrogate = (Integer)highSurrogates.get(i);
            highSurrogatesArr[i] = highSurrogate;
        }
        return highSurrogatesArr;
    }

    static void loadConstantValue(BType bType, Object constVal, MethodVisitor mv) {
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            long intValue = constVal instanceof Long ? (Long)constVal : Long.parseLong(String.valueOf(constVal));
            mv.visitLdcInsn((Object)intValue);
        } else if (bType.tag == 2) {
            int byteValue = ((Number)constVal).intValue();
            mv.visitLdcInsn((Object)byteValue);
        } else if (bType.tag == 3) {
            double doubleValue = constVal instanceof Double ? (Double)constVal : Double.parseDouble(String.valueOf(constVal));
            mv.visitLdcInsn((Object)doubleValue);
        } else if (bType.tag == 6) {
            boolean booleanVal = constVal instanceof Boolean ? (Boolean)constVal : Boolean.parseBoolean(String.valueOf(constVal));
            mv.visitLdcInsn((Object)booleanVal);
        } else if (TypeTags.isStringTypeTag(bType.tag)) {
            String val = String.valueOf(constVal);
            if (isBString) {
                int[] highSurrogates = JvmInstructionGen.listHighSurrogates(val);
                mv.visitTypeInsn(187, NON_BMP_STRING_VALUE);
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)val);
                mv.visitIntInsn(16, highSurrogates.length);
                mv.visitIntInsn(188, 10);
                int i = 0;
                for (int ch : highSurrogates) {
                    mv.visitInsn(89);
                    mv.visitIntInsn(16, i);
                    mv.visitIntInsn(16, ch);
                    ++i;
                    mv.visitInsn(79);
                }
                mv.visitMethodInsn(183, NON_BMP_STRING_VALUE, "<init>", String.format("(L%s;[I)V", "java/lang/String"), false);
            } else {
                mv.visitLdcInsn((Object)val);
            }
        } else if (bType.tag == 4) {
            mv.visitTypeInsn(187, "org/ballerinalang/jvm/values/DecimalValue");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)String.valueOf(constVal));
            mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/DecimalValue", "<init>", String.format("(L%s;)V", "java/lang/String"), false);
        } else if (bType.tag == 10) {
            mv.visitInsn(1);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type : " + String.format("%s", bType));
        }
    }

    private static void generateIntToUnsignedIntConversion(MethodVisitor mv, BType targetType) {
        switch (targetType.tag) {
            case 2: 
            case 41: {
                mv.visitInsn(136);
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedLong", "(B)J", false);
                return;
            }
            case 40: {
                mv.visitInsn(136);
                mv.visitInsn(147);
                mv.visitMethodInsn(184, "java/lang/Short", "toUnsignedLong", "(S)J", false);
                return;
            }
            case 39: {
                mv.visitInsn(136);
                mv.visitMethodInsn(184, "java/lang/Integer", "toUnsignedLong", "(I)J", false);
            }
        }
    }

    private static BType getSmallerUnsignedIntSubType(BType lhsType, BType rhsType) {
        if (TypeTags.isSignedIntegerTypeTag(lhsType.tag) || TypeTags.isSignedIntegerTypeTag(rhsType.tag)) {
            throw new BLangCompilerException("expected two unsigned int subtypes, found '" + lhsType + "' and '" + rhsType + "'");
        }
        if (lhsType.tag == 2 || rhsType.tag == 2) {
            return JvmPackageGen.symbolTable.unsigned8IntType;
        }
        if (lhsType.tag == 41 || rhsType.tag == 41) {
            return JvmPackageGen.symbolTable.unsigned8IntType;
        }
        if (lhsType.tag == 40 || rhsType.tag == 40) {
            return JvmPackageGen.symbolTable.unsigned16IntType;
        }
        return JvmPackageGen.symbolTable.unsigned32IntType;
    }

    public static class InstructionGenerator {
        MethodVisitor mv;
        JvmMethodGen.BalToJVMIndexMap indexMap;
        String currentPackageName;
        BIRNode.BIRPackage currentPackage;

        public InstructionGenerator(MethodVisitor mv, JvmMethodGen.BalToJVMIndexMap indexMap, BIRNode.BIRPackage currentPackage) {
            this.mv = mv;
            this.indexMap = indexMap;
            this.currentPackage = currentPackage;
            this.currentPackageName = JvmPackageGen.getPackageName(currentPackage.org.value, currentPackage.name.value);
        }

        void generatePlatformIns(InteropMethodGen.JInstruction ins) {
            if (ins.jKind == JInsKind.JCAST) {
                InteropMethodGen.JCast castIns = (InteropMethodGen.JCast)ins;
                BType targetType = castIns.targetType;
                this.loadVar(castIns.rhsOp.variableDcl);
                JvmCastGen.generatePlatformCheckCast(this.mv, this.indexMap, castIns.rhsOp.variableDcl.type, targetType);
                this.storeToVar(castIns.lhsOp.variableDcl);
            }
        }

        void generateMoveIns(BIRNonTerminator.Move moveIns) {
            this.loadVar(moveIns.rhsOp.variableDcl);
            this.storeToVar(moveIns.lhsOp.variableDcl);
        }

        void generateBinaryOpIns(BIRNonTerminator.BinaryOp binaryIns) {
            InstructionKind insKind = binaryIns.kind;
            switch (insKind) {
                case ADD: {
                    this.generateAddIns(binaryIns);
                    break;
                }
                case SUB: {
                    this.generateSubIns(binaryIns);
                    break;
                }
                case MUL: {
                    this.generateMulIns(binaryIns);
                    break;
                }
                case DIV: {
                    this.generateDivIns(binaryIns);
                    break;
                }
                case MOD: {
                    this.generateRemIns(binaryIns);
                    break;
                }
                case EQUAL: {
                    this.generateEqualIns(binaryIns);
                    break;
                }
                case NOT_EQUAL: {
                    this.generateNotEqualIns(binaryIns);
                    break;
                }
                case GREATER_THAN: {
                    this.generateGreaterThanIns(binaryIns);
                    break;
                }
                case GREATER_EQUAL: {
                    this.generateGreaterEqualIns(binaryIns);
                    break;
                }
                case LESS_THAN: {
                    this.generateLessThanIns(binaryIns);
                    break;
                }
                case LESS_EQUAL: {
                    this.generateLessEqualIns(binaryIns);
                    break;
                }
                case REF_EQUAL: {
                    this.generateRefEqualIns(binaryIns);
                    break;
                }
                case REF_NOT_EQUAL: {
                    this.generateRefNotEqualIns(binaryIns);
                    break;
                }
                case CLOSED_RANGE: {
                    this.generateClosedRangeIns(binaryIns);
                    break;
                }
                case HALF_OPEN_RANGE: {
                    this.generateClosedRangeIns(binaryIns);
                    break;
                }
                case ANNOT_ACCESS: {
                    this.generateAnnotAccessIns(binaryIns);
                    break;
                }
                case BITWISE_AND: {
                    this.generateBitwiseAndIns(binaryIns);
                    break;
                }
                case BITWISE_OR: {
                    this.generateBitwiseOrIns(binaryIns);
                    break;
                }
                case BITWISE_XOR: {
                    this.generateBitwiseXorIns(binaryIns);
                    break;
                }
                case BITWISE_LEFT_SHIFT: {
                    this.generateBitwiseLeftShiftIns(binaryIns);
                    break;
                }
                case BITWISE_RIGHT_SHIFT: {
                    this.generateBitwiseRightShiftIns(binaryIns);
                    break;
                }
                case BITWISE_UNSIGNED_RIGHT_SHIFT: {
                    this.generateBitwiseUnsignedRightShiftIns(binaryIns);
                    break;
                }
                default: {
                    throw new BLangCompilerException("JVM generation is not supported for instruction kind : " + String.format("%s", new Object[]{insKind}));
                }
            }
        }

        void generateBinaryRhsAndLhsLoad(BIRNonTerminator.BinaryOp binaryIns) {
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            this.loadVar(binaryIns.rhsOp2.variableDcl);
        }

        private void generateLessThanIns(BIRNonTerminator.BinaryOp binaryIns) {
            this.generateBinaryCompareIns(binaryIns, 155);
        }

        private void generateGreaterThanIns(BIRNonTerminator.BinaryOp binaryIns) {
            this.generateBinaryCompareIns(binaryIns, 157);
        }

        private void generateLessEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
            this.generateBinaryCompareIns(binaryIns, 158);
        }

        private void generateGreaterEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
            this.generateBinaryCompareIns(binaryIns, 156);
        }

        private void generateBinaryCompareIns(BIRNonTerminator.BinaryOp binaryIns, int opcode) {
            if (opcode != 155 && opcode != 157 && opcode != 158 && opcode != 156) {
                throw new BLangCompilerException(String.format("Unsupported opcode '%s' for binary operator.", opcode));
            }
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            Label label1 = new Label();
            Label label2 = new Label();
            BType lhsOpType = binaryIns.rhsOp1.variableDcl.type;
            BType rhsOpType = binaryIns.rhsOp2.variableDcl.type;
            if (TypeTags.isIntegerTypeTag(lhsOpType.tag) && TypeTags.isIntegerTypeTag(rhsOpType.tag)) {
                this.mv.visitInsn(148);
                this.mv.visitJumpInsn(opcode, label1);
            } else if (lhsOpType.tag == 2 && rhsOpType.tag == 2) {
                if (opcode == 155) {
                    this.mv.visitJumpInsn(161, label1);
                } else if (opcode != 157) {
                    this.mv.visitJumpInsn(163, label1);
                } else if (opcode != 158) {
                    this.mv.visitJumpInsn(164, label1);
                } else if (opcode == 156) {
                    this.mv.visitJumpInsn(162, label1);
                }
            } else if (lhsOpType.tag == 3 && rhsOpType.tag == 3) {
                this.mv.visitInsn(151);
                this.mv.visitJumpInsn(opcode, label1);
            } else if (lhsOpType.tag == 4 && rhsOpType.tag == 4) {
                String compareFuncName = this.getDecimalCompareFuncName(opcode);
                this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", compareFuncName, String.format("(L%s;L%s;)Z", "org/ballerinalang/jvm/values/DecimalValue", "org/ballerinalang/jvm/values/DecimalValue"), false);
                this.storeToVar(binaryIns.lhsOp.variableDcl);
                return;
            }
            this.mv.visitInsn(3);
            this.mv.visitJumpInsn(167, label2);
            this.mv.visitLabel(label1);
            this.mv.visitInsn(4);
            this.mv.visitLabel(label2);
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        private String getDecimalCompareFuncName(int opcode) {
            if (opcode == 157) {
                return "checkDecimalGreaterThan";
            }
            if (opcode == 156) {
                return "checkDecimalGreaterThanOrEqual";
            }
            if (opcode == 155) {
                return "checkDecimalLessThan";
            }
            if (opcode == 158) {
                return "checkDecimalLessThanOrEqual";
            }
            throw new BLangCompilerException(String.format("Opcode: '%s' is not a comparison opcode.", opcode));
        }

        void generateEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            Label label1 = new Label();
            Label label2 = new Label();
            BType lhsOpType = binaryIns.rhsOp1.variableDcl.type;
            BType rhsOpType = binaryIns.rhsOp2.variableDcl.type;
            if (TypeTags.isIntegerTypeTag(lhsOpType.tag) && TypeTags.isIntegerTypeTag(rhsOpType.tag)) {
                this.mv.visitInsn(148);
                this.mv.visitJumpInsn(154, label1);
            } else if (lhsOpType.tag == 2 && rhsOpType.tag == 2) {
                this.mv.visitJumpInsn(160, label1);
            } else if (lhsOpType.tag == 3 && rhsOpType.tag == 3) {
                this.mv.visitInsn(151);
                this.mv.visitJumpInsn(154, label1);
            } else if (lhsOpType.tag == 6 && rhsOpType.tag == 6) {
                this.mv.visitJumpInsn(160, label1);
            } else {
                if (lhsOpType.tag == 4 && rhsOpType.tag == 4) {
                    this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "checkDecimalEqual", String.format("(L%s;L%s;)Z", "org/ballerinalang/jvm/values/DecimalValue", "org/ballerinalang/jvm/values/DecimalValue"), false);
                    this.storeToVar(binaryIns.lhsOp.variableDcl);
                    return;
                }
                this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "isEqual", String.format("(L%s;L%s;)Z", "java/lang/Object", "java/lang/Object"), false);
                this.storeToVar(binaryIns.lhsOp.variableDcl);
                return;
            }
            this.mv.visitInsn(4);
            this.mv.visitJumpInsn(167, label2);
            this.mv.visitLabel(label1);
            this.mv.visitInsn(3);
            this.mv.visitLabel(label2);
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        void generateNotEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            Label label1 = new Label();
            Label label2 = new Label();
            BType lhsOpType = binaryIns.rhsOp1.variableDcl.type;
            BType rhsOpType = binaryIns.rhsOp2.variableDcl.type;
            if (TypeTags.isIntegerTypeTag(lhsOpType.tag) && TypeTags.isIntegerTypeTag(rhsOpType.tag)) {
                this.mv.visitInsn(148);
                this.mv.visitJumpInsn(153, label1);
            } else if (lhsOpType.tag == 2 && rhsOpType.tag == 2) {
                this.mv.visitJumpInsn(159, label1);
            } else if (lhsOpType.tag == 3 && rhsOpType.tag == 3) {
                this.mv.visitInsn(151);
                this.mv.visitJumpInsn(153, label1);
            } else if (lhsOpType.tag == 6 && rhsOpType.tag == 6) {
                this.mv.visitJumpInsn(159, label1);
            } else if (lhsOpType.tag == 4 && rhsOpType.tag == 4) {
                this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "checkDecimalEqual", String.format("(L%s;L%s;)Z", "org/ballerinalang/jvm/values/DecimalValue", "org/ballerinalang/jvm/values/DecimalValue"), false);
                this.mv.visitJumpInsn(154, label1);
            } else {
                this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "isEqual", String.format("(L%s;L%s;)Z", "java/lang/Object", "java/lang/Object"), false);
                this.mv.visitJumpInsn(154, label1);
            }
            this.mv.visitInsn(4);
            this.mv.visitJumpInsn(167, label2);
            this.mv.visitLabel(label1);
            this.mv.visitInsn(3);
            this.mv.visitLabel(label2);
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        void generateRefEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            Label label1 = new Label();
            Label label2 = new Label();
            BType lhsOpType = binaryIns.rhsOp1.variableDcl.type;
            BType rhsOpType = binaryIns.rhsOp2.variableDcl.type;
            if (TypeTags.isIntegerTypeTag(lhsOpType.tag) && TypeTags.isIntegerTypeTag(rhsOpType.tag)) {
                this.mv.visitInsn(148);
                this.mv.visitJumpInsn(154, label1);
            } else if (lhsOpType.tag == 2 && rhsOpType.tag == 2) {
                this.mv.visitJumpInsn(160, label1);
            } else if (lhsOpType.tag == 3 && rhsOpType.tag == 3) {
                this.mv.visitInsn(151);
                this.mv.visitJumpInsn(154, label1);
            } else if (lhsOpType.tag == 6 && rhsOpType.tag == 6) {
                this.mv.visitJumpInsn(160, label1);
            } else {
                this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "isReferenceEqual", String.format("(L%s;L%s;)Z", "java/lang/Object", "java/lang/Object"), false);
                this.storeToVar(binaryIns.lhsOp.variableDcl);
                return;
            }
            this.mv.visitInsn(4);
            this.mv.visitJumpInsn(167, label2);
            this.mv.visitLabel(label1);
            this.mv.visitInsn(3);
            this.mv.visitLabel(label2);
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        void generateRefNotEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            Label label1 = new Label();
            Label label2 = new Label();
            BType lhsOpType = binaryIns.rhsOp1.variableDcl.type;
            BType rhsOpType = binaryIns.rhsOp2.variableDcl.type;
            if (TypeTags.isIntegerTypeTag(lhsOpType.tag) && TypeTags.isIntegerTypeTag(rhsOpType.tag)) {
                this.mv.visitInsn(148);
                this.mv.visitJumpInsn(153, label1);
            } else if (lhsOpType.tag == 2 && rhsOpType.tag == 2) {
                this.mv.visitJumpInsn(159, label1);
            } else if (lhsOpType.tag == 3 && rhsOpType.tag == 3) {
                this.mv.visitInsn(151);
                this.mv.visitJumpInsn(153, label1);
            } else if (lhsOpType.tag == 6 && rhsOpType.tag == 6) {
                this.mv.visitJumpInsn(159, label1);
            } else {
                this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "isReferenceEqual", String.format("(L%s;L%s;)Z", "java/lang/Object", "java/lang/Object"), false);
                this.mv.visitJumpInsn(154, label1);
            }
            this.mv.visitInsn(4);
            this.mv.visitJumpInsn(167, label2);
            this.mv.visitLabel(label1);
            this.mv.visitInsn(3);
            this.mv.visitLabel(label2);
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        void generateClosedRangeIns(BIRNonTerminator.BinaryOp binaryIns) {
            this.mv.visitTypeInsn(187, "org/ballerinalang/jvm/values/ArrayValueImpl");
            this.mv.visitInsn(89);
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitMethodInsn(184, "java/util/stream/LongStream", "rangeClosed", String.format("(JJ)L%s;", "java/util/stream/LongStream"), true);
            this.mv.visitMethodInsn(185, "java/util/stream/LongStream", "toArray", "()[J", true);
            this.mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/ArrayValueImpl", "<init>", "([J)V", false);
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        void generateAnnotAccessIns(BIRNonTerminator.BinaryOp binaryIns) {
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "getAnnotValue", String.format("(L%s;L%s;)L%s;", "org/ballerinalang/jvm/values/TypedescValue", "java/lang/String", "java/lang/Object"), false);
            BType targetType = binaryIns.lhsOp.variableDcl.type;
            JvmInstructionGen.addUnboxInsn(this.mv, targetType);
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        void generateAddIns(BIRNonTerminator.BinaryOp binaryIns) {
            BType bType = binaryIns.lhsOp.variableDcl.type;
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            if (TypeTags.isIntegerTypeTag(bType.tag)) {
                this.mv.visitInsn(97);
            } else if (bType.tag == 2) {
                this.mv.visitInsn(96);
            } else if (TypeTags.isStringTypeTag(bType.tag)) {
                if (isBString) {
                    this.mv.visitMethodInsn(185, JvmInstructionGen.B_STRING_VALUE, "concat", String.format("(L%s;)L%s;", JvmInstructionGen.B_STRING_VALUE, JvmInstructionGen.B_STRING_VALUE), true);
                } else {
                    this.mv.visitMethodInsn(182, "java/lang/String", "concat", String.format("(L%s;)L%s;", "java/lang/String", "java/lang/String"), false);
                }
            } else if (bType.tag == 4) {
                this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/DecimalValue", "add", String.format("(L%s;)L%s;", "org/ballerinalang/jvm/values/DecimalValue", "org/ballerinalang/jvm/values/DecimalValue"), false);
            } else if (bType.tag == 3) {
                this.mv.visitInsn(99);
            } else if (TypeTags.isXMLTypeTag(bType.tag)) {
                this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/XMLFactory", "concatenate", String.format("(L%s;L%s;)L%s;", "org/ballerinalang/jvm/values/XMLValue", "org/ballerinalang/jvm/values/XMLValue", "org/ballerinalang/jvm/values/XMLValue"), false);
            } else {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", binaryIns.lhsOp.variableDcl.type));
            }
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        void generateSubIns(BIRNonTerminator.BinaryOp binaryIns) {
            BType bType = binaryIns.lhsOp.variableDcl.type;
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            if (TypeTags.isIntegerTypeTag(bType.tag)) {
                this.mv.visitInsn(101);
            } else if (bType.tag == 3) {
                this.mv.visitInsn(103);
            } else if (bType.tag == 4) {
                this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/DecimalValue", "subtract", String.format("(L%s;)L%s;", "org/ballerinalang/jvm/values/DecimalValue", "org/ballerinalang/jvm/values/DecimalValue"), false);
            } else {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", binaryIns.lhsOp.variableDcl.type));
            }
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        void generateDivIns(BIRNonTerminator.BinaryOp binaryIns) {
            BType bType = binaryIns.lhsOp.variableDcl.type;
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            if (TypeTags.isIntegerTypeTag(bType.tag)) {
                this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/MathUtils", "divide", "(JJ)J", false);
            } else if (bType.tag == 3) {
                this.mv.visitInsn(111);
            } else if (bType.tag == 4) {
                this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/DecimalValue", "divide", String.format("(L%s;)L%s;", "org/ballerinalang/jvm/values/DecimalValue", "org/ballerinalang/jvm/values/DecimalValue"), false);
            } else {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", binaryIns.lhsOp.variableDcl.type));
            }
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        void generateMulIns(BIRNonTerminator.BinaryOp binaryIns) {
            BType bType = binaryIns.lhsOp.variableDcl.type;
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            if (TypeTags.isIntegerTypeTag(bType.tag)) {
                this.mv.visitInsn(105);
            } else if (bType.tag == 3) {
                this.mv.visitInsn(107);
            } else if (bType.tag == 4) {
                this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/DecimalValue", "multiply", String.format("(L%s;)L%s;", "org/ballerinalang/jvm/values/DecimalValue", "org/ballerinalang/jvm/values/DecimalValue"), false);
            } else {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", binaryIns.lhsOp.variableDcl.type));
            }
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        void generateRemIns(BIRNonTerminator.BinaryOp binaryIns) {
            BType bType = binaryIns.lhsOp.variableDcl.type;
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            if (TypeTags.isIntegerTypeTag(bType.tag)) {
                this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/MathUtils", "remainder", "(JJ)J", false);
            } else if (bType.tag == 3) {
                this.mv.visitInsn(115);
            } else if (bType.tag == 4) {
                this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/DecimalValue", "remainder", String.format("(L%s;)L%s;", "org/ballerinalang/jvm/values/DecimalValue", "org/ballerinalang/jvm/values/DecimalValue"), false);
            } else {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", binaryIns.lhsOp.variableDcl.type));
            }
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        void generateBitwiseAndIns(BIRNonTerminator.BinaryOp binaryIns) {
            BType opType1 = binaryIns.rhsOp1.variableDcl.type;
            BType opType2 = binaryIns.rhsOp2.variableDcl.type;
            int opType1Tag = opType1.tag;
            int opType2Tag = opType2.tag;
            if (opType1Tag == 2 && opType2Tag == 2) {
                this.loadVar(binaryIns.rhsOp1.variableDcl);
                JvmCastGen.generateCheckCastToByte(this.mv, opType1);
                this.loadVar(binaryIns.rhsOp2.variableDcl);
                JvmCastGen.generateCheckCastToByte(this.mv, opType2);
                this.mv.visitInsn(126);
            } else {
                boolean byteResult = false;
                this.loadVar(binaryIns.rhsOp1.variableDcl);
                if (opType1Tag == 2) {
                    this.mv.visitMethodInsn(184, "java/lang/Integer", "toUnsignedLong", "(I)J", false);
                    byteResult = true;
                }
                this.loadVar(binaryIns.rhsOp2.variableDcl);
                if (opType2Tag == 2) {
                    this.mv.visitMethodInsn(184, "java/lang/Integer", "toUnsignedLong", "(I)J", false);
                    byteResult = true;
                }
                this.mv.visitInsn(127);
                if (byteResult) {
                    JvmCastGen.generateCheckCastToByte(this.mv, JvmPackageGen.symbolTable.intType);
                }
            }
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        void generateBitwiseOrIns(BIRNonTerminator.BinaryOp binaryIns) {
            BType opType1 = binaryIns.rhsOp1.variableDcl.type;
            BType opType2 = binaryIns.rhsOp2.variableDcl.type;
            if (opType1.tag == 2 && opType2.tag == 2) {
                this.loadVar(binaryIns.rhsOp1.variableDcl);
                this.loadVar(binaryIns.rhsOp2.variableDcl);
                this.mv.visitInsn(128);
                this.storeToVar(binaryIns.lhsOp.variableDcl);
                return;
            }
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            JvmCastGen.generateCheckCast(this.mv, opType1, JvmPackageGen.symbolTable.intType, this.indexMap);
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            JvmCastGen.generateCheckCast(this.mv, opType2, JvmPackageGen.symbolTable.intType, this.indexMap);
            this.mv.visitInsn(129);
            if (!TypeTags.isSignedIntegerTypeTag(opType1.tag) && !TypeTags.isSignedIntegerTypeTag(opType2.tag)) {
                JvmInstructionGen.generateIntToUnsignedIntConversion(this.mv, JvmInstructionGen.getSmallerUnsignedIntSubType(opType1, opType2));
            }
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        void generateBitwiseXorIns(BIRNonTerminator.BinaryOp binaryIns) {
            BType opType1 = binaryIns.rhsOp1.variableDcl.type;
            BType opType2 = binaryIns.rhsOp2.variableDcl.type;
            if (opType1.tag == 2 && opType2.tag == 2) {
                this.loadVar(binaryIns.rhsOp1.variableDcl);
                this.loadVar(binaryIns.rhsOp2.variableDcl);
                this.mv.visitInsn(130);
                this.storeToVar(binaryIns.lhsOp.variableDcl);
                return;
            }
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            JvmCastGen.generateCheckCast(this.mv, opType1, JvmPackageGen.symbolTable.intType, this.indexMap);
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            JvmCastGen.generateCheckCast(this.mv, opType2, JvmPackageGen.symbolTable.intType, this.indexMap);
            this.mv.visitInsn(131);
            if (!TypeTags.isSignedIntegerTypeTag(opType1.tag) && !TypeTags.isSignedIntegerTypeTag(opType2.tag)) {
                JvmInstructionGen.generateIntToUnsignedIntConversion(this.mv, JvmInstructionGen.getSmallerUnsignedIntSubType(opType1, opType2));
            }
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        void generateBitwiseLeftShiftIns(BIRNonTerminator.BinaryOp binaryIns) {
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            BType secondOpType = binaryIns.rhsOp2.variableDcl.type;
            if (TypeTags.isIntegerTypeTag(secondOpType.tag)) {
                this.mv.visitInsn(136);
            }
            BType firstOpType = binaryIns.rhsOp1.variableDcl.type;
            if (TypeTags.isIntegerTypeTag(firstOpType.tag)) {
                this.mv.visitInsn(121);
            } else {
                this.mv.visitInsn(120);
                this.mv.visitInsn(133);
            }
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        void generateBitwiseRightShiftIns(BIRNonTerminator.BinaryOp binaryIns) {
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            if (TypeTags.isIntegerTypeTag(binaryIns.rhsOp2.variableDcl.type.tag)) {
                this.mv.visitInsn(136);
            }
            if (TypeTags.isIntegerTypeTag(binaryIns.rhsOp1.variableDcl.type.tag)) {
                this.mv.visitInsn(123);
            } else {
                this.mv.visitInsn(122);
            }
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        void generateBitwiseUnsignedRightShiftIns(BIRNonTerminator.BinaryOp binaryIns) {
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            if (TypeTags.isIntegerTypeTag(binaryIns.rhsOp2.variableDcl.type.tag)) {
                this.mv.visitInsn(136);
            }
            if (TypeTags.isIntegerTypeTag(binaryIns.rhsOp1.variableDcl.type.tag)) {
                this.mv.visitInsn(125);
            } else {
                this.mv.visitInsn(124);
            }
            this.storeToVar(binaryIns.lhsOp.variableDcl);
        }

        int getJVMIndexOfVarRef(BIRNode.BIRVariableDcl varDcl) {
            return this.indexMap.getIndex(varDcl);
        }

        void generateMapNewIns(BIRNonTerminator.NewStructure mapNewIns, int localVarOffset) {
            BType typeOfMapNewIns = mapNewIns.type;
            String className = "org/ballerinalang/jvm/values/MapValueImpl";
            if (typeOfMapNewIns.tag == 12) {
                className = mapNewIns.isExternalDef ? JvmValueGen.getTypeValueClassName(mapNewIns.externalPackageId, JvmTerminatorGen.TerminatorGenerator.toNameString(typeOfMapNewIns)) : JvmValueGen.getTypeValueClassName(this.currentPackage, JvmTerminatorGen.TerminatorGenerator.toNameString(typeOfMapNewIns));
                this.mv.visitTypeInsn(187, className);
                this.mv.visitInsn(89);
                this.mv.visitInsn(89);
                if (mapNewIns.isExternalDef) {
                    JvmTypeGen.loadExternalType(this.mv, mapNewIns.externalPackageId, mapNewIns.recordName);
                } else {
                    JvmTypeGen.loadType(this.mv, mapNewIns.type);
                }
                this.mv.visitMethodInsn(183, className, "<init>", String.format("(L%s;)V", "org/ballerinalang/jvm/types/BType"), false);
                this.mv.visitVarInsn(25, localVarOffset);
                this.mv.visitInsn(95);
                this.mv.visitMethodInsn(184, className, "$init", String.format("(L%s;L%s;)V", "org/ballerinalang/jvm/scheduling/Strand", "org/ballerinalang/jvm/values/MapValue"), false);
            } else {
                this.mv.visitTypeInsn(187, className);
                this.mv.visitInsn(89);
                JvmTypeGen.loadType(this.mv, mapNewIns.type);
                this.mv.visitMethodInsn(183, className, "<init>", String.format("(L%s;)V", "org/ballerinalang/jvm/types/BType"), false);
            }
            this.storeToVar(mapNewIns.lhsOp.variableDcl);
        }

        void generateTableNewIns(BIRNonTerminator.NewTable tableNewIns) {
            this.mv.visitTypeInsn(187, "org/ballerinalang/jvm/values/TableValue");
            this.mv.visitInsn(89);
            JvmTypeGen.loadType(this.mv, tableNewIns.type);
            this.loadVar(tableNewIns.keyColOp.variableDcl);
            this.loadVar(tableNewIns.dataOp.variableDcl);
            this.mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/TableValue", "<init>", String.format("(L%s;L%s;L%s;)V", "org/ballerinalang/jvm/types/BType", "org/ballerinalang/jvm/values/ArrayValue", "org/ballerinalang/jvm/values/ArrayValue"), false);
            this.storeToVar(tableNewIns.lhsOp.variableDcl);
        }

        void generateMapStoreIns(BIRNonTerminator.FieldAccess mapStoreIns) {
            this.loadVar(mapStoreIns.lhsOp.variableDcl);
            BType varRefType = mapStoreIns.lhsOp.variableDcl.type;
            this.loadVar(mapStoreIns.keyOp.variableDcl);
            BType valueType = mapStoreIns.rhsOp.variableDcl.type;
            this.loadVar(mapStoreIns.rhsOp.variableDcl);
            JvmInstructionGen.addBoxInsn(this.mv, valueType);
            if (varRefType.tag == 7) {
                this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/JSONUtils", "setElement", String.format("(L%s;L%s;L%s;)V", "java/lang/Object", "java/lang/String", "java/lang/Object"), false);
            } else {
                String signature = String.format("(L%s;L%s;L%s;)V", "org/ballerinalang/jvm/values/MapValue", isBString ? JvmInstructionGen.I_STRING_VALUE : "java/lang/String", "java/lang/Object");
                this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/MapUtils", "handleMapStore", signature, false);
            }
        }

        void generateMapLoadIns(BIRNonTerminator.FieldAccess mapLoadIns) {
            this.loadVar(mapLoadIns.rhsOp.variableDcl);
            BType varRefType = mapLoadIns.rhsOp.variableDcl.type;
            JvmInstructionGen.addUnboxInsn(this.mv, varRefType);
            this.loadVar(mapLoadIns.keyOp.variableDcl);
            if (varRefType.tag == 7) {
                if (mapLoadIns.optionalFieldAccess) {
                    this.mv.visitTypeInsn(192, "java/lang/String");
                    this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/JSONUtils", "getElementOrNil", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "java/lang/String", "java/lang/Object"), false);
                } else {
                    this.mv.visitTypeInsn(192, "java/lang/String");
                    this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/JSONUtils", "getElement", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "java/lang/String", "java/lang/Object"), false);
                }
            } else if (mapLoadIns.fillingRead) {
                this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/MapValue", "fillAndGet", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), true);
            } else {
                this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/MapValue", "get", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), true);
            }
            BType targetType = mapLoadIns.lhsOp.variableDcl.type;
            JvmInstructionGen.addUnboxInsn(this.mv, targetType);
            this.storeToVar(mapLoadIns.lhsOp.variableDcl);
        }

        void generateObjectLoadIns(BIRNonTerminator.FieldAccess objectLoadIns) {
            this.loadVar(objectLoadIns.rhsOp.variableDcl);
            this.loadVar(objectLoadIns.keyOp.variableDcl);
            this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ObjectValue", "get", String.format("(L%s;)L%s;", "java/lang/String", "java/lang/Object"), true);
            BType targetType = objectLoadIns.lhsOp.variableDcl.type;
            JvmInstructionGen.addUnboxInsn(this.mv, targetType);
            this.storeToVar(objectLoadIns.lhsOp.variableDcl);
        }

        void generateObjectStoreIns(BIRNonTerminator.FieldAccess objectStoreIns) {
            this.loadVar(objectStoreIns.lhsOp.variableDcl);
            this.loadVar(objectStoreIns.keyOp.variableDcl);
            BType valueType = objectStoreIns.rhsOp.variableDcl.type;
            this.loadVar(objectStoreIns.rhsOp.variableDcl);
            JvmInstructionGen.addBoxInsn(this.mv, valueType);
            this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ObjectValue", "set", String.format("(L%s;L%s;)V", isBString ? JvmInstructionGen.B_STRING_VALUE : "java/lang/String", "java/lang/Object"), true);
        }

        void generateStringLoadIns(BIRNonTerminator.FieldAccess stringLoadIns) {
            this.loadVar(stringLoadIns.rhsOp.variableDcl);
            this.loadVar(stringLoadIns.keyOp.variableDcl);
            String consVal = isBString ? JvmInstructionGen.B_STRING_VALUE : "java/lang/String";
            this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/StringUtils", "getStringAt", String.format("(L%s;J)L%s;", consVal, consVal), false);
            this.storeToVar(stringLoadIns.lhsOp.variableDcl);
        }

        void generateArrayNewIns(BIRNonTerminator.NewArray inst) {
            if (inst.type.tag == 19) {
                this.mv.visitTypeInsn(187, "org/ballerinalang/jvm/values/ArrayValueImpl");
                this.mv.visitInsn(89);
                JvmTypeGen.loadType(this.mv, inst.type);
                this.loadVar(inst.sizeOp.variableDcl);
                if (isBString) {
                    this.mv.visitInsn(4);
                    this.mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/ArrayValueImpl", "<init>", String.format("(L%s;JZ)V", "org/ballerinalang/jvm/types/BArrayType"), false);
                } else {
                    this.mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/ArrayValueImpl", "<init>", String.format("(L%s;J)V", "org/ballerinalang/jvm/types/BArrayType"), false);
                }
                this.storeToVar(inst.lhsOp.variableDcl);
            } else {
                this.mv.visitTypeInsn(187, "org/ballerinalang/jvm/values/TupleValueImpl");
                this.mv.visitInsn(89);
                JvmTypeGen.loadType(this.mv, inst.type);
                this.loadVar(inst.sizeOp.variableDcl);
                this.mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/TupleValueImpl", "<init>", String.format("(L%s;J)V", "org/ballerinalang/jvm/types/BTupleType"), false);
                this.storeToVar(inst.lhsOp.variableDcl);
            }
        }

        void generateArrayStoreIns(BIRNonTerminator.FieldAccess inst) {
            this.loadVar(inst.lhsOp.variableDcl);
            this.loadVar(inst.keyOp.variableDcl);
            this.loadVar(inst.rhsOp.variableDcl);
            BType valueType = inst.rhsOp.variableDcl.type;
            BType varRefType = inst.lhsOp.variableDcl.type;
            if (varRefType.tag == 7 || varRefType.tag == 19 && ((BArrayType)varRefType).eType instanceof BJSONType) {
                JvmInstructionGen.addBoxInsn(this.mv, valueType);
                this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/JSONUtils", "setArrayElement", String.format("(L%s;JL%s;)V", "java/lang/Object", "java/lang/Object"), false);
                return;
            }
            if (TypeTags.isIntegerTypeTag(valueType.tag)) {
                this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "add", "(JJ)V", true);
            } else if (valueType.tag == 3) {
                this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "add", "(JD)V", true);
            } else if (TypeTags.isStringTypeTag(valueType.tag)) {
                this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "add", String.format("(JL%s;)V", isBString ? JvmInstructionGen.B_STRING_VALUE : "java/lang/String"), true);
            } else if (valueType.tag == 6) {
                this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "add", "(JZ)V", true);
            } else if (valueType.tag == 2) {
                this.mv.visitInsn(145);
                this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "add", "(JB)V", true);
            } else {
                this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "add", String.format("(JL%s;)V", "java/lang/Object"), true);
            }
        }

        void generateArrayValueLoad(BIRNonTerminator.FieldAccess inst) {
            this.loadVar(inst.rhsOp.variableDcl);
            this.mv.visitTypeInsn(192, "org/ballerinalang/jvm/values/ArrayValue");
            this.loadVar(inst.keyOp.variableDcl);
            BType bType = inst.lhsOp.variableDcl.type;
            BType varRefType = inst.rhsOp.variableDcl.type;
            if (varRefType.tag == 29) {
                if (inst.fillingRead) {
                    this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "fillAndGetRefValue", String.format("(J)L%s;", "java/lang/Object"), true);
                } else {
                    this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "getRefValue", String.format("(J)L%s;", "java/lang/Object"), true);
                }
                JvmInstructionGen.addUnboxInsn(this.mv, bType);
            } else if (TypeTags.isIntegerTypeTag(bType.tag)) {
                this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "getInt", "(J)J", true);
            } else if (TypeTags.isStringTypeTag(bType.tag)) {
                if (isBString) {
                    this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "getBString", String.format("(J)L%s;", JvmInstructionGen.B_STRING_VALUE), true);
                } else {
                    this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "getString", String.format("(J)L%s;", "java/lang/String"), true);
                }
            } else if (bType.tag == 6) {
                this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "getBoolean", "(J)Z", true);
            } else if (bType.tag == 2) {
                this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "getByte", "(J)B", true);
                this.mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
            } else if (bType.tag == 3) {
                this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "getFloat", "(J)D", true);
            } else {
                if (inst.fillingRead) {
                    this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "fillAndGetRefValue", String.format("(J)L%s;", "java/lang/Object"), true);
                } else {
                    this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "getRefValue", String.format("(J)L%s;", "java/lang/Object"), true);
                }
                String targetTypeClass = JvmCastGen.getTargetClass(bType);
                if (targetTypeClass != null) {
                    this.mv.visitTypeInsn(192, targetTypeClass);
                } else {
                    JvmInstructionGen.addUnboxInsn(this.mv, bType);
                }
            }
            this.storeToVar(inst.lhsOp.variableDcl);
        }

        void generateNewErrorIns(BIRNonTerminator.NewError newErrorIns) {
            this.mv.visitTypeInsn(187, "org/ballerinalang/jvm/values/ErrorValue");
            this.mv.visitInsn(89);
            JvmTypeGen.loadType(this.mv, newErrorIns.type);
            this.loadVar(newErrorIns.reasonOp.variableDcl);
            this.loadVar(newErrorIns.detailOp.variableDcl);
            this.mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/ErrorValue", "<init>", String.format("(L%s;L%s;L%s;)V", "org/ballerinalang/jvm/types/BType", isBString ? JvmInstructionGen.B_STRING_VALUE : "java/lang/String", "java/lang/Object"), false);
            this.storeToVar(newErrorIns.lhsOp.variableDcl);
        }

        void generateCastIns(BIRNonTerminator.TypeCast typeCastIns) {
            this.loadVar(typeCastIns.rhsOp.variableDcl);
            if (typeCastIns.checkTypes) {
                JvmCastGen.generateCheckCast(this.mv, typeCastIns.rhsOp.variableDcl.type, typeCastIns.type, this.indexMap);
            } else {
                JvmCastGen.generateCast(this.mv, typeCastIns.rhsOp.variableDcl.type, typeCastIns.type);
            }
            this.storeToVar(typeCastIns.lhsOp.variableDcl);
        }

        void generateTypeTestIns(BIRNonTerminator.TypeTest typeTestIns) {
            this.loadVar(typeTestIns.rhsOp.variableDcl);
            JvmTypeGen.loadType(this.mv, typeTestIns.type);
            this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "checkIsType", String.format("(L%s;L%s;)Z", "java/lang/Object", "org/ballerinalang/jvm/types/BType"), false);
            this.storeToVar(typeTestIns.lhsOp.variableDcl);
        }

        void generateIsLikeIns(BIRNonTerminator.IsLike isLike) {
            this.loadVar(isLike.rhsOp.variableDcl);
            JvmTypeGen.loadType(this.mv, isLike.type);
            this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "checkIsLikeType", String.format("(L%s;L%s;)Z", "java/lang/Object", "org/ballerinalang/jvm/types/BType"), false);
            this.storeToVar(isLike.lhsOp.variableDcl);
        }

        void generateObjectNewIns(BIRNonTerminator.NewInstance objectNewIns, int strandIndex) {
            BType type = JvmPackageGen.lookupTypeDef(objectNewIns);
            String className = objectNewIns.isExternalDef ? JvmValueGen.getTypeValueClassName(objectNewIns.externalPackageId, objectNewIns.objectName) : JvmValueGen.getTypeValueClassName(this.currentPackage, objectNewIns.def.name.value);
            this.mv.visitTypeInsn(187, className);
            this.mv.visitInsn(89);
            if (type instanceof BServiceType) {
                JvmTypeGen.duplicateServiceTypeWithAnnots(this.mv, (BObjectType)type, this.currentPackageName, strandIndex);
            } else {
                JvmTypeGen.loadType(this.mv, type);
            }
            this.mv.visitTypeInsn(192, "org/ballerinalang/jvm/types/BObjectType");
            this.mv.visitMethodInsn(183, className, "<init>", String.format("(L%s;)V", "org/ballerinalang/jvm/types/BObjectType"), false);
            this.storeToVar(objectNewIns.lhsOp.variableDcl);
        }

        void generateFPLoadIns(BIRNonTerminator.FPLoad inst) {
            this.mv.visitTypeInsn(187, "org/ballerinalang/jvm/values/FPValue");
            this.mv.visitInsn(89);
            String lambdaName = inst.funcName.value + "$lambda" + JvmPackageGen.lambdaIndex + "$";
            ++JvmPackageGen.lambdaIndex;
            String pkgName = JvmPackageGen.getPackageName(inst.pkgId.orgName, inst.pkgId.name);
            String lookupKey = pkgName + inst.funcName.value;
            BType returnType = inst.lhsOp.variableDcl.type;
            if (returnType.tag != 16) {
                throw new BLangCompilerException("Expected BInvokableType, found " + String.format("%s", returnType));
            }
            for (BIROperand operand : inst.closureMaps) {
                if (operand == null) continue;
                this.loadVar(operand.variableDcl);
            }
            InstructionGenerator.visitInvokeDyn(this.mv, JvmPackageGen.currentClass, lambdaName, inst.closureMaps.size());
            JvmTypeGen.loadType(this.mv, returnType);
            if (inst.schedulerPolicy == SchedulerPolicy.ANY) {
                this.mv.visitInsn(4);
            } else {
                this.mv.visitInsn(3);
            }
            this.mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/FPValue", "<init>", String.format("(L%s;L%s;Z)V", "java/util/function/Function", "org/ballerinalang/jvm/types/BType"), false);
            this.mv.visitInsn(89);
            String pkgClassName = pkgName.equals(".") || pkgName.equals("") ? "___init" : JvmPackageGen.lookupGlobalVarClassName(pkgName, "$annotation_data");
            this.mv.visitFieldInsn(178, pkgClassName, "$annotation_data", String.format("L%s;", "org/ballerinalang/jvm/values/MapValue"));
            this.mv.visitLdcInsn((Object)inst.funcName.value);
            this.mv.visitMethodInsn(184, String.format("%s", "org/ballerinalang/jvm/AnnotationUtils"), "processFPValueAnnotations", String.format("(L%s;L%s;L%s;)V", "org/ballerinalang/jvm/values/FPValue", "org/ballerinalang/jvm/values/MapValue", "java/lang/String"), false);
            this.storeToVar(inst.lhsOp.variableDcl);
            JvmPackageGen.lambdas.put(lambdaName, inst);
        }

        static void visitInvokeDyn(MethodVisitor mv, String currentClass, String lambdaName, int size) {
            String mapDesc = InstructionGenerator.getMapsDesc(size);
            Handle handle = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false);
            mv.visitInvokeDynamicInsn("apply", "(" + mapDesc + ")Ljava/util/function/Function;", handle, new Object[]{Type.getType((String)"(Ljava/lang/Object;)Ljava/lang/Object;"), new Handle(6, currentClass, lambdaName, "(" + mapDesc + "[Ljava/lang/Object;)Ljava/lang/Object;", false), Type.getType((String)"([Ljava/lang/Object;)Ljava/lang/Object;")});
        }

        private static String getMapsDesc(long count) {
            StringBuilder builder = new StringBuilder();
            for (long i = count; i > 0L; --i) {
                builder.append("Lorg/ballerinalang/jvm/values/MapValue;");
            }
            return builder.toString();
        }

        void generateNewXMLElementIns(BIRNonTerminator.NewXMLElement newXMLElement) {
            this.loadVar(newXMLElement.startTagOp.variableDcl);
            this.mv.visitTypeInsn(192, "org/ballerinalang/jvm/values/XMLQName");
            this.loadVar(newXMLElement.defaultNsURIOp.variableDcl);
            this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/XMLFactory", "createXMLElement", String.format("(L%s;L%s;)L%s;", "org/ballerinalang/jvm/values/XMLQName", isBString ? JvmInstructionGen.B_STRING_VALUE : "java/lang/String", "org/ballerinalang/jvm/values/XMLValue"), false);
            this.storeToVar(newXMLElement.lhsOp.variableDcl);
        }

        void generateNewXMLQNameIns(BIRNonTerminator.NewXMLQName newXMLQName) {
            this.mv.visitTypeInsn(187, "org/ballerinalang/jvm/values/XMLQName");
            this.mv.visitInsn(89);
            this.loadVar(newXMLQName.localnameOp.variableDcl);
            this.loadVar(newXMLQName.nsURIOp.variableDcl);
            this.loadVar(newXMLQName.prefixOp.variableDcl);
            String consVal = isBString ? JvmInstructionGen.B_STRING_VALUE : "java/lang/String";
            this.mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/XMLQName", "<init>", String.format("(L%s;L%s;L%s;)V", consVal, consVal, consVal), false);
            this.storeToVar(newXMLQName.lhsOp.variableDcl);
        }

        void generateNewStringXMLQNameIns(BIRNonTerminator.NewStringXMLQName newStringXMLQName) {
            this.mv.visitTypeInsn(187, "org/ballerinalang/jvm/values/XMLQName");
            this.mv.visitInsn(89);
            this.loadVar(newStringXMLQName.stringQNameOP.variableDcl);
            this.mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/XMLQName", "<init>", String.format("(L%s;)V", "java/lang/String"), false);
            this.storeToVar(newStringXMLQName.lhsOp.variableDcl);
        }

        void generateNewXMLTextIns(BIRNonTerminator.NewXMLText newXMLText) {
            this.loadVar(newXMLText.textOp.variableDcl);
            this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/XMLFactory", "createXMLText", String.format("(L%s;)L%s;", isBString ? JvmInstructionGen.B_STRING_VALUE : "java/lang/String", "org/ballerinalang/jvm/values/XMLValue"), false);
            this.storeToVar(newXMLText.lhsOp.variableDcl);
        }

        void generateNewXMLCommentIns(BIRNonTerminator.NewXMLComment newXMLComment) {
            this.loadVar(newXMLComment.textOp.variableDcl);
            this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/XMLFactory", "createXMLComment", String.format("(L%s;)L%s;", isBString ? JvmInstructionGen.B_STRING_VALUE : "java/lang/String", "org/ballerinalang/jvm/values/XMLValue"), false);
            this.storeToVar(newXMLComment.lhsOp.variableDcl);
        }

        void generateNewXMLProcIns(BIRNonTerminator.NewXMLProcIns newXMLPI) {
            this.loadVar(newXMLPI.targetOp.variableDcl);
            this.loadVar(newXMLPI.dataOp.variableDcl);
            String consVal = isBString ? JvmInstructionGen.B_STRING_VALUE : "java/lang/String";
            this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/XMLFactory", "createXMLProcessingInstruction", String.format("(L%s;L%s;)L%s;", consVal, consVal, "org/ballerinalang/jvm/values/XMLValue"), false);
            this.storeToVar(newXMLPI.lhsOp.variableDcl);
        }

        void generateXMLStoreIns(BIRNonTerminator.XMLAccess xmlStoreIns) {
            this.loadVar(xmlStoreIns.lhsOp.variableDcl);
            this.loadVar(xmlStoreIns.rhsOp.variableDcl);
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/XMLValue", "addChildren", String.format("(L%s;)V", "org/ballerinalang/jvm/values/XMLValue"), false);
        }

        void generateXMLLoadAllIns(BIRNonTerminator.XMLAccess xmlLoadAllIns) {
            this.loadVar(xmlLoadAllIns.rhsOp.variableDcl);
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/XMLValue", "children", String.format("()L%s;", "org/ballerinalang/jvm/values/XMLValue"), false);
            this.storeToVar(xmlLoadAllIns.lhsOp.variableDcl);
        }

        void generateXMLAttrLoadIns(BIRNonTerminator.FieldAccess xmlAttrStoreIns) {
            this.loadVar(xmlAttrStoreIns.rhsOp.variableDcl);
            this.loadVar(xmlAttrStoreIns.keyOp.variableDcl);
            this.mv.visitTypeInsn(192, "org/ballerinalang/jvm/values/XMLQName");
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/XMLValue", "getAttribute", String.format("(L%s;)L%s;", "org/ballerinalang/jvm/values/api/BXMLQName", "java/lang/String"), false);
            BType targetType = xmlAttrStoreIns.lhsOp.variableDcl.type;
            this.storeToVar(xmlAttrStoreIns.lhsOp.variableDcl);
        }

        void generateXMLAttrStoreIns(BIRNonTerminator.FieldAccess xmlAttrStoreIns) {
            this.loadVar(xmlAttrStoreIns.lhsOp.variableDcl);
            this.loadVar(xmlAttrStoreIns.keyOp.variableDcl);
            this.mv.visitTypeInsn(192, "org/ballerinalang/jvm/values/XMLQName");
            this.loadVar(xmlAttrStoreIns.rhsOp.variableDcl);
            String signature = String.format("(L%s;L%s;)V", "org/ballerinalang/jvm/values/api/BXMLQName", isBString ? JvmInstructionGen.B_STRING_VALUE : "java/lang/String");
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/XMLValue", "setAttribute", signature, false);
        }

        void generateXMLLoadIns(BIRNonTerminator.FieldAccess xmlLoadIns) {
            this.loadVar(xmlLoadIns.rhsOp.variableDcl);
            this.loadVar(xmlLoadIns.keyOp.variableDcl);
            if (TypeTags.isStringTypeTag(xmlLoadIns.keyOp.variableDcl.type.tag)) {
                this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/XMLValue", "children", String.format("(L%s;)L%s;", "java/lang/String", "org/ballerinalang/jvm/values/XMLValue"), false);
            } else {
                this.mv.visitInsn(136);
                this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/XMLValue", "getItem", String.format("(I)L%s;", "org/ballerinalang/jvm/values/XMLValue"), false);
            }
            BType targetType = xmlLoadIns.lhsOp.variableDcl.type;
            this.storeToVar(xmlLoadIns.lhsOp.variableDcl);
        }

        void generateTypeofIns(BIRNonTerminator.UnaryOP unaryOp) {
            this.loadVar(unaryOp.rhsOp.variableDcl);
            JvmInstructionGen.addBoxInsn(this.mv, unaryOp.rhsOp.variableDcl.type);
            this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/TypeChecker", "getTypedesc", String.format("(L%s;)L%s;", "java/lang/Object", "org/ballerinalang/jvm/values/TypedescValue"), false);
            this.storeToVar(unaryOp.lhsOp.variableDcl);
        }

        void generateNotIns(BIRNonTerminator.UnaryOP unaryOp) {
            this.loadVar(unaryOp.rhsOp.variableDcl);
            Label label1 = new Label();
            Label label2 = new Label();
            this.mv.visitJumpInsn(154, label1);
            this.mv.visitInsn(4);
            this.mv.visitJumpInsn(167, label2);
            this.mv.visitLabel(label1);
            this.mv.visitInsn(3);
            this.mv.visitLabel(label2);
            this.storeToVar(unaryOp.lhsOp.variableDcl);
        }

        void generateNegateIns(BIRNonTerminator.UnaryOP unaryOp) {
            this.loadVar(unaryOp.rhsOp.variableDcl);
            BType btype = unaryOp.rhsOp.variableDcl.type;
            if (TypeTags.isIntegerTypeTag(btype.tag)) {
                this.mv.visitInsn(117);
            } else if (btype.tag == 2) {
                this.mv.visitInsn(116);
            } else if (btype.tag == 3) {
                this.mv.visitInsn(119);
            } else if (btype.tag == 4) {
                this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/DecimalValue", "negate", String.format("()L%s;", "org/ballerinalang/jvm/values/DecimalValue"), false);
            } else {
                throw new BLangCompilerException(String.format("Negation is not supported for type: %s", btype));
            }
            this.storeToVar(unaryOp.lhsOp.variableDcl);
        }

        void generateNewTypedescIns(BIRNonTerminator.NewTypeDesc newTypeDesc) {
            this.mv.visitTypeInsn(187, "org/ballerinalang/jvm/values/TypedescValue");
            this.mv.visitInsn(89);
            JvmTypeGen.loadType(this.mv, newTypeDesc.type);
            this.mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/TypedescValue", "<init>", String.format("(L%s;)V", "org/ballerinalang/jvm/types/BType"), false);
            this.storeToVar(newTypeDesc.lhsOp.variableDcl);
        }

        private void loadVar(BIRNode.BIRVariableDcl varDcl) {
            JvmInstructionGen.generateVarLoad(this.mv, varDcl, this.currentPackageName, this.getJVMIndexOfVarRef(varDcl));
        }

        private void storeToVar(BIRNode.BIRVariableDcl varDcl) {
            JvmInstructionGen.generateVarStore(this.mv, varDcl, this.currentPackageName, this.getJVMIndexOfVarRef(varDcl));
        }

        void generateConstantLoadIns(BIRNonTerminator.ConstantLoad loadIns) {
            JvmInstructionGen.loadConstantValue(loadIns.type, loadIns.value, this.mv);
            this.storeToVar(loadIns.lhsOp.variableDcl);
        }
    }
}

