/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.util.diagnostic.DiagnosticCode;
import org.objectweb.asm.ClassTooLargeException;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodTooLargeException;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.CodeGenerator;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmDesugarPhase;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTerminatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmValueGen;
import org.wso2.ballerinalang.compiler.bir.codegen.Nilable;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ExternalMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidator;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInteropException;
import org.wso2.ballerinalang.compiler.bir.model.BIRInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class JvmPackageGen {
    public static Map<String, BIRFunctionWrapper> birFunctionMap;
    public static Map<String, BIRInstruction> lambdas;
    public static String currentClass;
    public static SymbolTable symbolTable;
    static int lambdaIndex;
    static Map<String, String> externalMapCache;
    private static Map<String, String> globalVarClassNames;
    private static Map<String, PackageID> dependentModules;

    static void intiPackageGen() {
        birFunctionMap = new HashMap<String, BIRFunctionWrapper>();
        globalVarClassNames = new HashMap<String, String>();
        lambdas = new HashMap<String, BIRInstruction>();
        externalMapCache = new HashMap<String, String>();
        dependentModules = new LinkedHashMap<String, PackageID>();
        currentClass = "";
        lambdaIndex = 0;
        symbolTable = null;
        String bStringProp = System.getProperty("ballerina.bstring");
        JvmInstructionGen.isBString = bStringProp != null && !"".equals(bStringProp);
    }

    static BType lookupTypeDef(BIRNonTerminator.NewInstance objectNewIns) {
        BObjectTypeSymbol objectTypeSymbol;
        if (!objectNewIns.isExternalDef) {
            return objectNewIns.def.type;
        }
        PackageID id = objectNewIns.externalPackageId;
        BPackageSymbol symbol = CodeGenerator.packageCache.getSymbol(id.orgName + "/" + id.name);
        if (symbol != null && (objectTypeSymbol = (BObjectTypeSymbol)symbol.scope.lookup((Name)new Name((String)objectNewIns.objectName)).symbol) != null) {
            return objectTypeSymbol.type;
        }
        throw new BLangCompilerException("Reference to unknown type " + objectNewIns.externalPackageId + "/" + objectNewIns.objectName);
    }

    static BIRFunctionWrapper getBIRFunctionWrapper(@Nilable BIRFunctionWrapper wrapper) {
        if (wrapper == null) {
            throw new BLangCompilerException("invalid bir function linking");
        }
        return wrapper;
    }

    static String lookupGlobalVarClassName(String pkgName, String varName) {
        String key = pkgName + varName;
        if (!globalVarClassNames.containsKey(key)) {
            return pkgName + "___init";
        }
        return globalVarClassNames.get(key);
    }

    private static void generateDependencyList(BPackageSymbol packageSymbol, JarFile jarFile, InteropValidator interopValidator) {
        if (packageSymbol.bir != null) {
            JvmPackageGen.generatePackage(packageSymbol.bir, jarFile, interopValidator, false);
        } else {
            for (BPackageSymbol importPkgSymbol : packageSymbol.imports) {
                if (importPkgSymbol == null) continue;
                JvmPackageGen.generateDependencyList(importPkgSymbol, jarFile, interopValidator);
            }
        }
        PackageID moduleId = packageSymbol.pkgID;
        String pkgName = JvmPackageGen.getPackageName(moduleId.orgName, moduleId.name);
        if (!dependentModules.containsKey(pkgName)) {
            dependentModules.put(pkgName, moduleId);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void generatePackage(BIRNode.BIRPackage module, JarFile jarFile, InteropValidator interopValidator, boolean isEntry) {
        String orgName = module.org.value;
        String moduleName = module.name.value;
        String pkgName = JvmPackageGen.getPackageName(orgName, moduleName);
        LinkedHashSet<PackageID> dependentModuleSet = new LinkedHashSet<PackageID>();
        JvmPackageGen.addBuiltinImports(module, dependentModuleSet);
        for (BIRNode.BIRImportModule importModule : module.importModules) {
            BPackageSymbol pkgSymbol = CodeGenerator.packageCache.getSymbol(JvmPackageGen.getBvmAlias(importModule.org.value, importModule.name.value));
            JvmPackageGen.generateDependencyList(pkgSymbol, jarFile, interopValidator);
            if (CodeGenerator.dlog.getErrorCount() <= 0) continue;
            return;
        }
        JvmTypeGen.typeOwnerClass = JvmPackageGen.getModuleLevelClassName(orgName, moduleName, "___init");
        Map<String, JavaClass> jvmClassMap = JvmPackageGen.generateClassNameMappings(module, pkgName, JvmTypeGen.typeOwnerClass, interopValidator, isEntry);
        if (!isEntry || CodeGenerator.dlog.getErrorCount() > 0) {
            return;
        }
        ExternalMethodGen.injectDefaultParamInits(module);
        JvmValueGen.injectDefaultParamInitsToAttachedFuncs(module);
        JvmPackageGen.createDependantModuleFlatArray(dependentModuleSet);
        ArrayList<PackageID> dependentModuleArray = new ArrayList<PackageID>(dependentModuleSet);
        JvmMethodGen.enrichPkgWithInitializers(jvmClassMap, JvmTypeGen.typeOwnerClass, module, dependentModuleArray);
        JvmPackageGen.generateShutdownSignalListener(JvmTypeGen.typeOwnerClass, jarFile.pkgEntries);
        boolean serviceEPAvailable = JvmTypeGen.isServiceDefAvailable(module.typeDefs);
        JvmDesugarPhase.rewriteRecordInits(module.typeDefs);
        JvmValueGen.ObjectGenerator objGen = new JvmValueGen.ObjectGenerator(module);
        objGen.generateValueClasses(module.typeDefs, jarFile.pkgEntries);
        JvmMethodGen.generateFrameClasses(module, jarFile.pkgEntries);
        for (Map.Entry<String, JavaClass> entry : jvmClassMap.entrySet()) {
            String moduleClass = entry.getKey();
            JavaClass v = entry.getValue();
            BallerinaClassWriter cw = new BallerinaClassWriter(2);
            currentClass = moduleClass;
            if (Objects.equals(moduleClass, JvmTypeGen.typeOwnerClass)) {
                void var18_24;
                cw.visit(52, 33, moduleClass, null, "org/ballerinalang/jvm/values/ValueCreator", null);
                JvmMethodGen.generateDefaultConstructor(cw, "org/ballerinalang/jvm/values/ValueCreator");
                JvmTypeGen.generateUserDefinedTypeFields(cw, module.typeDefs);
                JvmTypeGen.generateValueCreatorMethods(cw, module.typeDefs, module);
                for (BIRNode.BIRGlobalVariableDcl bIRGlobalVariableDcl : module.globalVars) {
                    if (bIRGlobalVariableDcl == null) continue;
                    JvmPackageGen.generatePackageVariable(bIRGlobalVariableDcl, cw);
                }
                BIRNode.BIRFunction mainFunc = JvmMethodGen.getMainFunc(module.functions);
                String string = "";
                if (mainFunc != null) {
                    String string2 = JvmPackageGen.getModuleLevelClassName(orgName, moduleName, JvmMethodGen.cleanupPathSeperators(JvmMethodGen.cleanupBalExt(mainFunc.pos.getSource().cUnitName)));
                }
                JvmMethodGen.generateMainMethod(mainFunc, cw, module, (String)var18_24, moduleClass, serviceEPAvailable);
                if (mainFunc != null) {
                    JvmMethodGen.generateLambdaForMain(mainFunc, cw, module, (String)var18_24, moduleClass);
                }
                JvmMethodGen.generateLambdaForPackageInits(cw, module, (String)var18_24, moduleClass, dependentModuleArray);
                jarFile.manifestEntries.put("Main-Class", moduleClass);
                JvmPackageGen.generateLockForVariable(cw);
                JvmPackageGen.generateStaticInitializer(cw, moduleClass, serviceEPAvailable);
                JvmTypeGen.generateCreateTypesMethod(cw, module.typeDefs);
                JvmMethodGen.generateModuleInitializer(cw, module);
                JvmMethodGen.generateExecutionStopMethod(cw, JvmTypeGen.typeOwnerClass, module, dependentModuleArray);
            } else {
                cw.visit(52, 33, moduleClass, null, "java/lang/Object", null);
                JvmMethodGen.generateDefaultConstructor(cw, "java/lang/Object");
            }
            cw.visitSource(v.sourceFileName, null);
            for (BIRNode.BIRFunction bIRFunction : v.functions) {
                String workerName = JvmMethodGen.getFunction((BIRNode.BIRFunction)bIRFunction).workerName == null ? null : bIRFunction.workerName.value;
                JvmMethodGen.generateMethod(JvmMethodGen.getFunction(bIRFunction), cw, module, null, false, workerName);
            }
            for (Map.Entry entry2 : lambdas.entrySet()) {
                String name = (String)entry2.getKey();
                BIRInstruction call = (BIRInstruction)entry2.getValue();
                JvmMethodGen.generateLambdaMethod(call, cw, name);
            }
            lambdas = new HashMap<String, BIRInstruction>();
            lambdaIndex = 0;
            cw.visitEnd();
            byte[] bytes = JvmPackageGen.getBytes(cw, module);
            jarFile.pkgEntries.put(moduleClass + ".class", bytes);
        }
    }

    private static String getBvmAlias(String orgName, String moduleName) {
        if (Names.ANON_ORG.value.equals(orgName)) {
            return moduleName;
        }
        return orgName + "/" + moduleName;
    }

    private static void createDependantModuleFlatArray(Set<PackageID> dependentModuleArray) {
        for (Map.Entry<String, PackageID> entry : dependentModules.entrySet()) {
            PackageID id = entry.getValue();
            dependentModuleArray.add(id);
        }
    }

    private static void addBuiltinImports(BIRNode.BIRPackage currentModule, Set<PackageID> dependentModuleArray) {
        Name ballerinaOrgName = new Name("ballerina");
        Name builtInVersion = new Name("");
        PackageID annotationsModule = new PackageID(ballerinaOrgName, new Name("lang.annotations"), builtInVersion);
        if (JvmPackageGen.isSameModule(currentModule, annotationsModule)) {
            return;
        }
        dependentModuleArray.add(annotationsModule);
        if (JvmPackageGen.isLangModule(currentModule)) {
            return;
        }
        PackageID internalModule = new PackageID(ballerinaOrgName, new Name("lang.__internal"), builtInVersion);
        if (JvmPackageGen.isSameModule(currentModule, internalModule)) {
            return;
        }
        dependentModuleArray.add(internalModule);
        PackageID langArrayModule = new PackageID(ballerinaOrgName, new Name("lang.array"), builtInVersion);
        PackageID langDecimalModule = new PackageID(ballerinaOrgName, new Name("lang.decimal"), builtInVersion);
        PackageID langErrorModule = new PackageID(ballerinaOrgName, new Name("lang.error"), builtInVersion);
        PackageID langFloatModule = new PackageID(ballerinaOrgName, new Name("lang.float"), builtInVersion);
        PackageID langFutureModule = new PackageID(ballerinaOrgName, new Name("lang.future"), builtInVersion);
        PackageID langIntModule = new PackageID(ballerinaOrgName, new Name("lang.int"), builtInVersion);
        PackageID langMapModule = new PackageID(ballerinaOrgName, new Name("lang.map"), builtInVersion);
        PackageID langObjectModule = new PackageID(ballerinaOrgName, new Name("lang.object"), builtInVersion);
        PackageID langStreamModule = new PackageID(ballerinaOrgName, new Name("lang.stream"), builtInVersion);
        PackageID langStringModule = new PackageID(ballerinaOrgName, new Name("lang.string"), builtInVersion);
        PackageID langTableModule = new PackageID(ballerinaOrgName, new Name("lang.table"), builtInVersion);
        PackageID langValueModule = new PackageID(ballerinaOrgName, new Name("lang.value"), builtInVersion);
        PackageID langXmlModule = new PackageID(ballerinaOrgName, new Name("lang.xml"), builtInVersion);
        PackageID langTypedescModule = new PackageID(ballerinaOrgName, new Name("lang.typedesc"), builtInVersion);
        PackageID langBooleanModule = new PackageID(ballerinaOrgName, new Name("lang.boolean"), builtInVersion);
        dependentModuleArray.add(langArrayModule);
        dependentModuleArray.add(langDecimalModule);
        dependentModuleArray.add(langErrorModule);
        dependentModuleArray.add(langFloatModule);
        dependentModuleArray.add(langFutureModule);
        dependentModuleArray.add(langIntModule);
        dependentModuleArray.add(langMapModule);
        dependentModuleArray.add(langObjectModule);
        dependentModuleArray.add(langStreamModule);
        dependentModuleArray.add(langStringModule);
        dependentModuleArray.add(langTableModule);
        dependentModuleArray.add(langValueModule);
        dependentModuleArray.add(langXmlModule);
        dependentModuleArray.add(langTypedescModule);
        dependentModuleArray.add(langBooleanModule);
    }

    private static boolean isSameModule(BIRNode.BIRPackage moduleId, PackageID importModule) {
        if (!moduleId.org.value.equals(importModule.orgName.value)) {
            return false;
        }
        if (!moduleId.name.value.equals(importModule.name.value)) {
            return false;
        }
        return moduleId.version.value.equals(importModule.version.value);
    }

    private static boolean isLangModule(BIRNode.BIRPackage moduleId) {
        if (!"ballerina".equals(moduleId.org.value)) {
            return false;
        }
        return moduleId.name.value.indexOf("lang.") == 0;
    }

    private static void generatePackageVariable(BIRNode.BIRGlobalVariableDcl globalVar, ClassWriter cw) {
        String varName = globalVar.name.value;
        BType bType = globalVar.type;
        JvmMethodGen.generateField(cw, bType, varName, true);
    }

    private static void generateLockForVariable(ClassWriter cw) {
        String lockStoreClass = "Lorg/ballerinalang/jvm/BLockStore;";
        FieldVisitor fv = cw.visitField(25, "LOCK_STORE", lockStoreClass, null, null);
        fv.visitEnd();
    }

    private static void generateStaticInitializer(ClassWriter cw, String className, boolean serviceEPAvailable) {
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        String lockStoreClass = "Lorg/ballerinalang/jvm/BLockStore;";
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/BLockStore");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/BLockStore", "<init>", "()V", false);
        mv.visitFieldInsn(179, className, "LOCK_STORE", lockStoreClass);
        JvmPackageGen.setServiceEPAvailableField(cw, mv, serviceEPAvailable, className);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void setServiceEPAvailableField(ClassWriter cw, MethodVisitor mv, boolean serviceEPAvailable, String initClass) {
        FieldVisitor fv = cw.visitField(9, "serviceEPAvailable", "Z", null, null);
        fv.visitEnd();
        if (serviceEPAvailable) {
            mv.visitInsn(4);
            mv.visitFieldInsn(179, initClass, "serviceEPAvailable", "Z");
        } else {
            mv.visitInsn(3);
            mv.visitFieldInsn(179, initClass, "serviceEPAvailable", "Z");
        }
    }

    static String computeLockNameFromString(String varName) {
        return "$lock" + varName;
    }

    static String getModuleLevelClassName(String orgName, String moduleName, String sourceFileName) {
        String className = JvmPackageGen.cleanupSourceFileName(sourceFileName);
        if (className.startsWith("/")) {
            className = className.substring(1);
        }
        if (!moduleName.equals(".")) {
            className = JvmPackageGen.cleanupName(moduleName) + "/" + className;
        }
        if (!orgName.equalsIgnoreCase("$anon")) {
            className = JvmPackageGen.cleanupName(orgName) + "/" + className;
        }
        return className;
    }

    static String getPackageName(Name orgName, Name moduleName) {
        return JvmPackageGen.getPackageName(orgName.getValue(), moduleName.getValue());
    }

    public static String getPackageName(String orgName, String moduleName) {
        String packageName = "";
        if (!moduleName.equals(".")) {
            packageName = JvmPackageGen.cleanupName(moduleName) + "/";
        }
        if (!orgName.equalsIgnoreCase("$anon")) {
            packageName = JvmPackageGen.cleanupName(orgName) + "/" + packageName;
        }
        return packageName;
    }

    private static String cleanupName(String name) {
        return name.replace(".", "_");
    }

    private static String cleanupSourceFileName(String name) {
        return name.replace(".", "$$$");
    }

    public static String cleanupPackageName(String pkgName) {
        int index = pkgName.lastIndexOf("/");
        if (index > 0) {
            return pkgName.substring(0, index);
        }
        return pkgName;
    }

    private static Map<String, JavaClass> generateClassNameMappings(BIRNode.BIRPackage module, String pkgName, String initClass, InteropValidator interopValidator, boolean isEntry) {
        String orgName = module.org.value;
        String moduleName = module.name.value;
        String version = module.version.value;
        HashMap<String, JavaClass> jvmClassMap = new HashMap<String, JavaClass>();
        if (isEntry) {
            for (BIRNode.BIRConstant constant : module.constants) {
                module.globalVars.add(new BIRNode.BIRGlobalVariableDcl(constant.pos, constant.flags, constant.type, null, constant.name, VarScope.GLOBAL, VarKind.CONSTANT, ""));
            }
        }
        for (BIRNode.BIRGlobalVariableDcl globalVar : module.globalVars) {
            if (globalVar == null) continue;
            globalVarClassNames.put(pkgName + globalVar.name.value, initClass);
        }
        globalVarClassNames.put(pkgName + "LOCK_STORE", initClass);
        List<BIRNode.BIRFunction> functions = module.functions;
        if (functions.size() > 0) {
            int funcSize = functions.size();
            int count = 0;
            BIRNode.BIRFunction initFunc = functions.get(0);
            String functionName = initFunc.name.value;
            JavaClass klass = new JavaClass(initFunc.pos.src.cUnitName, initClass);
            klass.functions.add(0, initFunc);
            JvmMethodGen.addInitAndTypeInitInstructions(module, initFunc);
            jvmClassMap.put(initClass, klass);
            birFunctionMap.put(pkgName + functionName, JvmPackageGen.getFunctionWrapper(initFunc, orgName, moduleName, version, initClass));
            ++count;
            BIRNode.BIRFunction startFunc = functions.get(1);
            functionName = startFunc.name.value;
            birFunctionMap.put(pkgName + functionName, JvmPackageGen.getFunctionWrapper(startFunc, orgName, moduleName, version, initClass));
            klass.functions.add(1, startFunc);
            ++count;
            BIRNode.BIRFunction stopFunc = functions.get(2);
            functionName = stopFunc.name.value;
            birFunctionMap.put(pkgName + functionName, JvmPackageGen.getFunctionWrapper(stopFunc, orgName, moduleName, version, initClass));
            klass.functions.add(2, stopFunc);
            ++count;
            while (count < funcSize) {
                BIRFunctionWrapper birFuncWrapperOrError;
                BIRNode.BIRFunction birFunc = functions.get(count);
                ++count;
                String birFuncName = birFunc.name.value;
                String balFileName = birFunc.pos == null ? "___init" : birFunc.pos.src.cUnitName;
                String birModuleClassName = JvmPackageGen.getModuleLevelClassName(orgName, moduleName, JvmMethodGen.cleanupPathSeperators(JvmMethodGen.cleanupBalExt(balFileName)));
                if (!ExternalMethodGen.isBallerinaBuiltinModule(orgName, moduleName)) {
                    JavaClass javaClass = (JavaClass)jvmClassMap.get(birModuleClassName);
                    if (javaClass != null) {
                        javaClass.functions.add(birFunc);
                    } else {
                        klass = new JavaClass(balFileName, birModuleClassName);
                        klass.functions.add(0, birFunc);
                        jvmClassMap.put(birModuleClassName, klass);
                    }
                }
                interopValidator.setEntryModuleValidation(isEntry);
                try {
                    if (JvmMethodGen.isExternFunc(JvmMethodGen.getFunction(birFunc))) {
                        birFuncWrapperOrError = ExternalMethodGen.createExternalFunctionWrapper(interopValidator, birFunc, orgName, moduleName, version, birModuleClassName);
                    } else {
                        if (isEntry) {
                            JvmDesugarPhase.addDefaultableBooleanVarsToSignature(birFunc);
                        }
                        birFuncWrapperOrError = JvmPackageGen.getFunctionWrapper(birFunc, orgName, moduleName, version, birModuleClassName);
                    }
                }
                catch (JInteropException e) {
                    CodeGenerator.dlog.error(birFunc.pos, e.getCode(), e.getMessage());
                    continue;
                }
                birFunctionMap.put(pkgName + birFuncName, birFuncWrapperOrError);
            }
        }
        List<BIRNode.BIRTypeDefinition> typeDefs = module.typeDefs;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            BIRNode.BIRTypeDefinition typeDef = JvmMethodGen.getTypeDef(optionalTypeDef);
            BType bType = typeDef.type;
            if ((bType.tag != 32 || Symbols.isFlagOn(((BObjectType)bType).tsymbol.flags, 4096)) && !(bType instanceof BServiceType)) continue;
            List<BIRNode.BIRFunction> attachedFuncs = JvmMethodGen.getFunctions(typeDef.attachedFuncs);
            String typeName = JvmTerminatorGen.TerminatorGenerator.toNameString(bType);
            for (BIRNode.BIRFunction func : attachedFuncs) {
                BIRNode.BIRFunction currentFunc = JvmMethodGen.getFunction(func);
                String functionName = currentFunc.name.value;
                String lookupKey = typeName + "." + functionName;
                if (!JvmMethodGen.isExternFunc(currentFunc)) {
                    String className = JvmValueGen.getTypeValueClassName(module, typeName);
                    birFunctionMap.put(pkgName + lookupKey, JvmPackageGen.getFunctionWrapper(currentFunc, orgName, moduleName, version, className));
                    continue;
                }
                String jClassName = JvmPackageGen.lookupExternClassName(JvmPackageGen.cleanupPackageName(pkgName), lookupKey);
                if (jClassName != null) {
                    ExternalMethodGen.OldStyleExternalFunctionWrapper wrapper = ExternalMethodGen.createOldStyleExternalFunctionWrapper(currentFunc, orgName, moduleName, version, jClassName, jClassName, isEntry);
                    birFunctionMap.put(pkgName + lookupKey, wrapper);
                    continue;
                }
                throw new BLangCompilerException("native function not available: " + pkgName + lookupKey);
            }
        }
        return jvmClassMap;
    }

    public static BIRFunctionWrapper getFunctionWrapper(BIRNode.BIRFunction currentFunc, String orgName, String moduleName, String version, String moduleClass) {
        BInvokableType functionTypeDesc = currentFunc.type;
        BIRNode.BIRVariableDcl receiver = currentFunc.receiver;
        BType attachedType = receiver != null ? receiver.type : null;
        String jvmMethodDescription = JvmMethodGen.getMethodDesc(functionTypeDesc.paramTypes, functionTypeDesc.retType, attachedType, false);
        String jvmMethodDescriptionBString = JvmMethodGen.getMethodDesc(functionTypeDesc.paramTypes, functionTypeDesc.retType, attachedType, false);
        return new BIRFunctionWrapper(orgName, moduleName, version, currentFunc, moduleClass, jvmMethodDescription, jvmMethodDescriptionBString);
    }

    static PackageID packageToModuleId(BIRNode.BIRPackage mod) {
        return new PackageID(mod.org, mod.name, mod.version);
    }

    @Nilable
    public static String lookupExternClassName(String pkgName, String functionName) {
        return externalMapCache.get(JvmPackageGen.cleanupName(pkgName) + "/" + functionName);
    }

    private static void generateShutdownSignalListener(String initClass, Map<String, byte[]> jarEntries) {
        String innerClassName = initClass + "$SignalListener";
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        cw.visit(52, 32, innerClassName, null, "java/lang/Thread", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Thread", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "run", "()V", null, null);
        mv.visitCode();
        mv.visitMethodInsn(184, initClass, "$moduleStop", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        jarEntries.put(innerClassName + ".class", cw.toByteArray());
    }

    public static byte[] getBytes(ClassWriter cw, BIRNode node) {
        byte[] result;
        try {
            return cw.toByteArray();
        }
        catch (MethodTooLargeException e) {
            String funcName = e.getMethodName();
            BIRNode.BIRFunction func = JvmPackageGen.findFunction(node, funcName);
            CodeGenerator.dlog.error(func.pos, DiagnosticCode.METHOD_TOO_LARGE, func.name.value);
            result = new byte[]{};
        }
        catch (ClassTooLargeException e) {
            CodeGenerator.dlog.error(node.pos, DiagnosticCode.FILE_TOO_LARGE, e.getClassName());
            result = new byte[]{};
        }
        catch (Exception e) {
            throw new BLangCompilerException(e.getMessage(), e);
        }
        return result;
    }

    private static BIRNode.BIRFunction findFunction(BIRNode parentNode, String funcName) {
        BIRNode.BIRFunction func;
        if (parentNode instanceof BIRNode.BIRTypeDefinition) {
            BIRNode.BIRTypeDefinition typeDef = (BIRNode.BIRTypeDefinition)parentNode;
            func = JvmPackageGen.findFunction(typeDef.attachedFuncs, funcName);
        } else if (parentNode instanceof BIRNode.BIRPackage) {
            BIRNode.BIRPackage pkg = (BIRNode.BIRPackage)parentNode;
            func = JvmPackageGen.findFunction(pkg.functions, funcName);
        } else {
            throw new IllegalStateException();
        }
        return func;
    }

    private static BIRNode.BIRFunction findFunction(List<BIRNode.BIRFunction> functions, String funcName) {
        for (BIRNode.BIRFunction func : functions) {
            if (!JvmMethodGen.cleanupFunctionName(func.name.value).equals(funcName)) continue;
            return func;
        }
        throw new IllegalStateException("cannot find function: '" + funcName + "'");
    }

    public static class BIRFunctionWrapper {
        public String orgName;
        public String moduleName;
        public String version;
        public BIRNode.BIRFunction func;
        public String fullQualifiedClassName;
        public String jvmMethodDescription;
        @Nilable
        public String jvmMethodDescriptionBString;

        protected BIRFunctionWrapper(String orgName, String moduleName, String version, BIRNode.BIRFunction func, String fullQualifiedClassName, String jvmMethodDescription, String jvmMethodDescriptionBString) {
            this.orgName = orgName;
            this.moduleName = moduleName;
            this.version = version;
            this.func = func;
            this.fullQualifiedClassName = fullQualifiedClassName;
            this.jvmMethodDescription = jvmMethodDescription;
            this.jvmMethodDescriptionBString = jvmMethodDescriptionBString;
        }
    }

    static class JavaClass {
        String sourceFileName;
        String moduleClass;
        @Nilable
        List<BIRNode.BIRFunction> functions = new ArrayList<BIRNode.BIRFunction>();

        JavaClass(String sourceFileName, String moduleClass) {
            this.sourceFileName = sourceFileName;
            this.moduleClass = moduleClass;
        }
    }

    static class JarFile {
        Map<String, String> manifestEntries = new HashMap<String, String>();
        Map<String, byte[]> pkgEntries = new HashMap<String, byte[]>();

        JarFile() {
        }
    }
}

