/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.CodeGenerator;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmErrorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmLabelGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmObservabilityGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.Nilable;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ExternalMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JType;
import org.wso2.ballerinalang.compiler.bir.model.BIRInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class JvmTerminatorGen {
    private static void genYieldCheckForLock(MethodVisitor mv, JvmLabelGen.LabelGenerator labelGen, String funcName, int localVarOffset) {
        mv.visitVarInsn(25, localVarOffset);
        mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Strand", "isYielded", "()Z", false);
        Label yieldLabel = labelGen.getLabel(funcName + "yield");
        mv.visitJumpInsn(154, yieldLabel);
    }

    static void loadChannelDetails(MethodVisitor mv, List<BIRNode.ChannelDetails> channels) {
        mv.visitIntInsn(16, channels.size());
        mv.visitTypeInsn(189, "org/ballerinalang/jvm/values/ChannelDetails");
        int index = 0;
        for (BIRNode.ChannelDetails ch : channels) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, index);
            ++index;
            mv.visitTypeInsn(187, "org/ballerinalang/jvm/values/ChannelDetails");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)ch.name);
            if (ch.channelInSameStrand) {
                mv.visitInsn(4);
            } else {
                mv.visitInsn(3);
            }
            if (ch.send) {
                mv.visitInsn(4);
            } else {
                mv.visitInsn(3);
            }
            mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/ChannelDetails", "<init>", String.format("(L%s;ZZ)V", "java/lang/String"), false);
            mv.visitInsn(83);
        }
    }

    static String cleanupObjectTypeName(String typeName) {
        int index = typeName.lastIndexOf(".");
        if (index > 0) {
            return typeName.substring(index + 1);
        }
        return typeName;
    }

    static boolean isExternStaticFunctionCall(BIRInstruction callIns) {
        PackageID packageID;
        String methodName;
        InstructionKind kind = callIns.getKind();
        if (kind == InstructionKind.CALL) {
            BIRTerminator.Call call = (BIRTerminator.Call)callIns;
            if (call.isVirtual) {
                return false;
            }
            methodName = call.name.value;
            packageID = call.calleePkg;
        } else if (kind == InstructionKind.ASYNC_CALL) {
            BIRTerminator.AsyncCall asyncCall = (BIRTerminator.AsyncCall)callIns;
            methodName = asyncCall.name.value;
            packageID = asyncCall.calleePkg;
        } else if (kind == InstructionKind.FP_LOAD) {
            BIRNonTerminator.FPLoad fpLoad = (BIRNonTerminator.FPLoad)callIns;
            methodName = fpLoad.funcName.value;
            packageID = fpLoad.pkgId;
        } else {
            throw new BLangCompilerException("JVM static function call generation is not supported for instruction " + String.format("%s", callIns));
        }
        String key = JvmPackageGen.getPackageName(packageID.orgName.value, packageID.name.value) + methodName;
        if (JvmPackageGen.birFunctionMap.containsKey(key)) {
            JvmPackageGen.BIRFunctionWrapper functionWrapper = JvmPackageGen.getBIRFunctionWrapper(JvmPackageGen.birFunctionMap.get(key));
            return JvmMethodGen.isExternFunc(functionWrapper.func);
        }
        return false;
    }

    public static class TerminatorGenerator {
        MethodVisitor mv;
        JvmMethodGen.BalToJVMIndexMap indexMap;
        JvmLabelGen.LabelGenerator labelGen;
        JvmErrorGen.ErrorHandlerGenerator errorGen;
        BIRNode.BIRPackage module;
        String currentPackageName;

        public TerminatorGenerator(MethodVisitor mv, JvmMethodGen.BalToJVMIndexMap indexMap, JvmLabelGen.LabelGenerator labelGen, JvmErrorGen.ErrorHandlerGenerator errorGen, BIRNode.BIRPackage module) {
            this.mv = mv;
            this.indexMap = indexMap;
            this.labelGen = labelGen;
            this.errorGen = errorGen;
            this.module = module;
            this.currentPackageName = JvmPackageGen.getPackageName(this.module.org.value, this.module.name.value);
        }

        void genTerminator(BIRTerminator terminator, BIRNode.BIRFunction func, String funcName, int localVarOffset, int returnVarRefIndex, @Nilable BType attachedType, boolean isObserved) {
            switch (terminator.kind) {
                case LOCK: {
                    this.genLockTerm((BIRTerminator.Lock)terminator, funcName, localVarOffset);
                    return;
                }
                case UNLOCK: {
                    this.genUnlockTerm((BIRTerminator.Unlock)terminator, funcName, attachedType);
                    return;
                }
                case GOTO: {
                    this.genGoToTerm((BIRTerminator.GOTO)terminator, funcName);
                    return;
                }
                case CALL: {
                    this.genCallTerm((BIRTerminator.Call)terminator, funcName, localVarOffset);
                    return;
                }
                case ASYNC_CALL: {
                    this.genAsyncCallTerm((BIRTerminator.AsyncCall)terminator, localVarOffset);
                    return;
                }
                case BRANCH: {
                    this.genBranchTerm((BIRTerminator.Branch)terminator, funcName);
                    return;
                }
                case RETURN: {
                    this.genReturnTerm((BIRTerminator.Return)terminator, returnVarRefIndex, func, isObserved, localVarOffset);
                    return;
                }
                case PANIC: {
                    this.errorGen.genPanic((BIRTerminator.Panic)terminator);
                    return;
                }
                case WAIT: {
                    this.generateWaitIns((BIRTerminator.Wait)terminator, funcName, localVarOffset);
                    return;
                }
                case WAIT_ALL: {
                    this.genWaitAllIns((BIRTerminator.WaitAll)terminator, funcName, localVarOffset);
                    return;
                }
                case FP_CALL: {
                    this.genFPCallIns((BIRTerminator.FPCall)terminator, funcName, localVarOffset);
                    return;
                }
                case WK_SEND: {
                    this.genWorkerSendIns((BIRTerminator.WorkerSend)terminator, funcName, localVarOffset);
                    return;
                }
                case WK_RECEIVE: {
                    this.genWorkerReceiveIns((BIRTerminator.WorkerReceive)terminator, funcName, localVarOffset);
                    return;
                }
                case FLUSH: {
                    this.genFlushIns((BIRTerminator.Flush)terminator, funcName, localVarOffset);
                    return;
                }
                case PLATFORM: {
                    if (terminator instanceof ExternalMethodGen.JavaMethodCall) {
                        this.genJCallTerm((ExternalMethodGen.JavaMethodCall)terminator, funcName, attachedType, localVarOffset);
                        return;
                    }
                    if (terminator instanceof InteropMethodGen.JIMethodCall) {
                        this.genJICallTerm((InteropMethodGen.JIMethodCall)terminator, funcName, attachedType, localVarOffset);
                        return;
                    }
                    if (!(terminator instanceof InteropMethodGen.JIConstructorCall)) break;
                    this.genJIConstructorTerm((InteropMethodGen.JIConstructorCall)terminator, funcName, attachedType, localVarOffset);
                    return;
                }
            }
            throw new BLangCompilerException("JVM generation is not supported for terminator instruction " + String.format("%s", terminator));
        }

        void genGoToTerm(BIRTerminator.GOTO gotoIns, String funcName) {
            Label gotoLabel = this.labelGen.getLabel(funcName + gotoIns.targetBB.id.value);
            this.mv.visitJumpInsn(167, gotoLabel);
        }

        void genLockTerm(BIRTerminator.Lock lockIns, String funcName, int localVarOffset) {
            Label gotoLabel = this.labelGen.getLabel(funcName + lockIns.lockedBB.id.value);
            String lockStore = "Lorg/ballerinalang/jvm/BLockStore;";
            String initClassName = JvmPackageGen.lookupGlobalVarClassName(this.currentPackageName, "LOCK_STORE");
            this.mv.visitFieldInsn(178, initClassName, "LOCK_STORE", lockStore);
            this.mv.visitLdcInsn((Object)"global");
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/BLockStore", "getLockFromMap", String.format("(L%s;)L%s;", "java/lang/String", "org/ballerinalang/jvm/BLock"), false);
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/BLock", "lock", String.format("(L%s;)Z", "org/ballerinalang/jvm/scheduling/Strand"), false);
            this.mv.visitInsn(87);
            JvmTerminatorGen.genYieldCheckForLock(this.mv, this.labelGen, funcName, localVarOffset);
            this.mv.visitJumpInsn(167, gotoLabel);
        }

        public static String toNameString(BType t) {
            return t.tsymbol.name.value;
        }

        void genUnlockTerm(BIRTerminator.Unlock unlockIns, String funcName, @Nilable BType attachedType) {
            Label gotoLabel = this.labelGen.getLabel(funcName + unlockIns.unlockBB.id.value);
            String lockStore = "Lorg/ballerinalang/jvm/BLockStore;";
            String initClassName = JvmPackageGen.lookupGlobalVarClassName(this.currentPackageName, "LOCK_STORE");
            this.mv.visitFieldInsn(178, initClassName, "LOCK_STORE", lockStore);
            this.mv.visitLdcInsn((Object)"global");
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/BLockStore", "getLockFromMap", String.format("(L%s;)L%s;", "java/lang/String", "org/ballerinalang/jvm/BLock"), false);
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/BLock", "unlock", "()V", false);
            this.mv.visitJumpInsn(167, gotoLabel);
        }

        void handleErrorRetInUnion(int returnVarRefIndex, List<BIRNode.ChannelDetails> channels, BUnionType bType) {
            if (channels.size() == 0) {
                return;
            }
            boolean errorIncluded = false;
            for (BType member : bType.getMemberTypes()) {
                if (member.tag != 27) continue;
                errorIncluded = true;
                break;
            }
            if (errorIncluded) {
                this.mv.visitVarInsn(25, returnVarRefIndex);
                this.mv.visitVarInsn(25, 0);
                JvmTerminatorGen.loadChannelDetails(this.mv, channels);
                this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/scheduling/WorkerUtils", "handleWorkerError", String.format("(L%s;L%s;[L%s;)V", "org/ballerinalang/jvm/values/RefValue", "org/ballerinalang/jvm/scheduling/Strand", "org/ballerinalang/jvm/values/ChannelDetails"), false);
            }
        }

        void notifyChannels(List<BIRNode.ChannelDetails> channels, int retIndex) {
            if (channels.size() == 0) {
                return;
            }
            this.mv.visitVarInsn(25, 0);
            JvmTerminatorGen.loadChannelDetails(this.mv, channels);
            this.mv.visitVarInsn(25, retIndex);
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Strand", "handleChannelError", String.format("([L%s;L%s;)V", "org/ballerinalang/jvm/values/ChannelDetails", "org/ballerinalang/jvm/values/ErrorValue"), false);
        }

        void genBranchTerm(BIRTerminator.Branch branchIns, String funcName) {
            String trueBBId = branchIns.trueBB.id.value;
            String falseBBId = branchIns.falseBB.id.value;
            this.loadVar(branchIns.op.variableDcl);
            Label trueBBLabel = this.labelGen.getLabel(funcName + trueBBId);
            this.mv.visitJumpInsn(157, trueBBLabel);
            Label falseBBLabel = this.labelGen.getLabel(funcName + falseBBId);
            this.mv.visitJumpInsn(167, falseBBLabel);
        }

        void genCallTerm(BIRTerminator.Call callIns, String funcName, int localVarOffset) {
            PackageID calleePkgId = callIns.calleePkg;
            String orgName = calleePkgId.orgName.value;
            String moduleName = calleePkgId.name.value;
            this.genCall(callIns, orgName, moduleName, localVarOffset);
            this.storeReturnFromCallIns(callIns.lhsOp != null ? callIns.lhsOp.variableDcl : null);
        }

        void genJCallTerm(ExternalMethodGen.JavaMethodCall callIns, String funcName, @Nilable BType attachedType, int localVarOffset) {
            Label blockedOnExternLabel = new Label();
            Label notBlockedOnExternLabel = new Label();
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Strand", "isBlockedOnExtern", "()Z", false);
            this.mv.visitJumpInsn(153, blockedOnExternLabel);
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitInsn(3);
            this.mv.visitFieldInsn(181, "org/ballerinalang/jvm/scheduling/Strand", "blockedOnExtern", "Z");
            if (callIns.lhsOp != null && callIns.lhsOp.variableDcl != null) {
                this.mv.visitVarInsn(25, localVarOffset);
                this.mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "returnValue", "Ljava/lang/Object;");
                BIRNode.BIRVariableDcl lhsOpVarDcl = callIns.lhsOp.variableDcl;
                if (lhsOpVarDcl != null) {
                    JvmInstructionGen.addUnboxInsn(this.mv, callIns.lhsOp.variableDcl.type);
                    this.storeToVar(lhsOpVarDcl);
                }
            }
            this.mv.visitJumpInsn(167, notBlockedOnExternLabel);
            this.mv.visitLabel(blockedOnExternLabel);
            int argIndex = 0;
            if (attachedType == null) {
                this.mv.visitVarInsn(25, localVarOffset);
            } else {
                this.mv.visitVarInsn(25, localVarOffset);
                BIRNode.BIRVariableDcl selfArg = JvmMethodGen.getVariableDcl(callIns.args.get((int)0).variableDcl);
                this.loadVar(selfArg);
                this.mv.visitTypeInsn(192, "org/ballerinalang/jvm/values/ObjectValue");
                ++argIndex;
            }
            int argsCount = callIns.args.size();
            while (argIndex < argsCount) {
                BIROperand arg = callIns.args.get(argIndex);
                this.visitArg(arg);
                ++argIndex;
            }
            String jClassName = callIns.jClassName;
            String jMethodName = callIns.name + (JvmInstructionGen.isBString ? "_bstring" : "");
            String jMethodVMSig = JvmInstructionGen.isBString ? callIns.jMethodVMSigBString : callIns.jMethodVMSig;
            this.mv.visitMethodInsn(184, jClassName, jMethodName, jMethodVMSig, false);
            if (callIns.lhsOp != null && callIns.lhsOp.variableDcl != null) {
                this.storeToVar(callIns.lhsOp.variableDcl);
            }
            this.mv.visitLabel(notBlockedOnExternLabel);
        }

        void genJICallTerm(InteropMethodGen.JIMethodCall callIns, String funcName, @Nilable BType attachedType, int localVarOffset) {
            BIROperand arg;
            int argsCount;
            Label blockedOnExternLabel = new Label();
            Label notBlockedOnExternLabel = new Label();
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Strand", "isBlockedOnExtern", "()Z", false);
            this.mv.visitJumpInsn(153, blockedOnExternLabel);
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitInsn(3);
            this.mv.visitFieldInsn(181, "org/ballerinalang/jvm/scheduling/Strand", "blockedOnExtern", "Z");
            if (callIns.lhsOp != null) {
                this.mv.visitVarInsn(25, localVarOffset);
                this.mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "returnValue", "Ljava/lang/Object;");
                BIROperand lhsOpVarDcl = callIns.lhsOp;
                JvmInstructionGen.addJUnboxInsn(this.mv, (JType)lhsOpVarDcl.variableDcl.type);
                this.storeToVar(lhsOpVarDcl.variableDcl);
            }
            this.mv.visitJumpInsn(167, notBlockedOnExternLabel);
            this.mv.visitLabel(blockedOnExternLabel);
            boolean isInterface = callIns.invocationType == 185;
            int argIndex = 0;
            if (callIns.invocationType == 182 || isInterface) {
                BIRNode.BIRVariableDcl selfArg = JvmMethodGen.getVariableDcl(callIns.args.get((int)0).variableDcl);
                this.loadVar(selfArg);
                this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
                this.mv.visitTypeInsn(192, callIns.jClassName);
                Label ifNonNullLabel = this.labelGen.getLabel("receiver_null_check");
                this.mv.visitLabel(ifNonNullLabel);
                this.mv.visitInsn(89);
                Label elseBlockLabel = this.labelGen.getLabel("receiver_null_check_else");
                this.mv.visitJumpInsn(199, elseBlockLabel);
                Label thenBlockLabel = this.labelGen.getLabel("receiver_null_check_then");
                this.mv.visitLabel(thenBlockLabel);
                this.mv.visitFieldInsn(178, "org/ballerinalang/jvm/util/exceptions/BallerinaErrorReasons", "JAVA_NULL_REFERENCE_ERROR", "Ljava/lang/String;");
                this.mv.visitFieldInsn(178, "org/ballerinalang/jvm/util/exceptions/RuntimeErrors", "JAVA_NULL_REFERENCE", "Lorg/ballerinalang/jvm/util/exceptions/RuntimeErrors;");
                this.mv.visitInsn(3);
                this.mv.visitTypeInsn(189, "java/lang/Object");
                this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/util/exceptions/BLangExceptionHelper", "getRuntimeException", "(Ljava/lang/String;Lorg/ballerinalang/jvm/util/exceptions/RuntimeErrors;[Ljava/lang/Object;)Lorg/ballerinalang/jvm/values/ErrorValue;", false);
                this.mv.visitInsn(191);
                this.mv.visitLabel(elseBlockLabel);
                ++argIndex;
            }
            int n = argsCount = callIns.varArgExist ? callIns.args.size() - 1 : callIns.args.size();
            while (argIndex < argsCount) {
                arg = callIns.args.get(argIndex);
                this.visitArg(arg);
                ++argIndex;
            }
            if (callIns.varArgExist) {
                arg = callIns.args.get(argIndex);
                int localVarIndex = this.indexMap.getIndex(arg.variableDcl);
                InteropMethodGen.genVarArg(this.mv, this.indexMap, arg.variableDcl.type, callIns.varArgType, localVarIndex);
            }
            String jClassName = callIns.jClassName;
            String jMethodName = callIns.name;
            String jMethodVMSig = callIns.jMethodVMSig;
            this.mv.visitMethodInsn(callIns.invocationType, jClassName, jMethodName, jMethodVMSig, isInterface);
            if (callIns.lhsOp != null && callIns.lhsOp.variableDcl != null) {
                this.storeToVar(callIns.lhsOp.variableDcl);
            }
            this.mv.visitLabel(notBlockedOnExternLabel);
        }

        void genJIConstructorTerm(InteropMethodGen.JIConstructorCall callIns, String funcName, @Nilable BType attachedType, int localVarOffset) {
            Label blockedOnExternLabel = new Label();
            Label notBlockedOnExternLabel = new Label();
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Strand", "isBlockedOnExtern", "()Z", false);
            this.mv.visitJumpInsn(153, blockedOnExternLabel);
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitInsn(3);
            this.mv.visitFieldInsn(181, "org/ballerinalang/jvm/scheduling/Strand", "blockedOnExtern", "Z");
            if (callIns.lhsOp.variableDcl != null) {
                this.mv.visitVarInsn(25, localVarOffset);
                this.mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "returnValue", "Ljava/lang/Object;");
                JvmInstructionGen.addUnboxInsn(this.mv, callIns.lhsOp.variableDcl.type);
                BIRNode.BIRVariableDcl lhsOpVarDcl = callIns.lhsOp.variableDcl;
                this.storeToVar(lhsOpVarDcl);
            }
            this.mv.visitJumpInsn(167, notBlockedOnExternLabel);
            this.mv.visitLabel(blockedOnExternLabel);
            this.mv.visitTypeInsn(187, callIns.jClassName);
            this.mv.visitInsn(89);
            int argsCount = callIns.args.size();
            for (int argIndex = 0; argIndex < argsCount; ++argIndex) {
                BIROperand arg = callIns.args.get(argIndex);
                this.visitArg(arg);
            }
            String jClassName = callIns.jClassName;
            String jMethodName = callIns.name;
            String jMethodVMSig = callIns.jMethodVMSig;
            this.mv.visitMethodInsn(183, jClassName, jMethodName, jMethodVMSig, false);
            BIRNode.BIRVariableDcl lhsOpVarDcl = callIns.lhsOp.variableDcl;
            if (lhsOpVarDcl != null) {
                this.storeToVar(lhsOpVarDcl);
            }
            this.mv.visitLabel(notBlockedOnExternLabel);
        }

        private void storeReturnFromCallIns(@Nilable BIRNode.BIRVariableDcl lhsOpVarDcl) {
            if (lhsOpVarDcl != null) {
                this.storeToVar(lhsOpVarDcl);
            } else {
                this.mv.visitInsn(87);
            }
        }

        private void genCall(BIRTerminator.Call callIns, String orgName, String moduleName, int localVarOffset) {
            if (!callIns.isVirtual) {
                this.genFuncCall(callIns, orgName, moduleName, localVarOffset);
                return;
            }
            BIRNode.BIRVariableDcl selfArg = JvmMethodGen.getVariableDcl(callIns.args.get((int)0).variableDcl);
            if (selfArg.type.tag == 32) {
                this.genVirtualCall(callIns, orgName, moduleName, localVarOffset);
            } else {
                this.genBuiltinTypeAttachedFuncCall(callIns, orgName, moduleName, localVarOffset);
            }
        }

        private void genFuncCall(BIRTerminator.Call callIns, String orgName, String moduleName, int localVarOffset) {
            String methodName = callIns.name.value;
            this.genStaticCall(callIns, orgName, moduleName, localVarOffset, methodName, methodName);
        }

        private void genBuiltinTypeAttachedFuncCall(BIRTerminator.Call callIns, String orgName, String moduleName, int localVarOffset) {
            String methodLookupName = callIns.name.value;
            int optionalIndex = methodLookupName.indexOf(".");
            int index = optionalIndex != -1 ? optionalIndex + 1 : 0;
            String methodName = methodLookupName.substring(index);
            this.genStaticCall(callIns, orgName, moduleName, localVarOffset, methodName, methodLookupName);
        }

        private void genStaticCall(BIRTerminator.Call callIns, String orgName, String moduleName, int localVarOffset, String methodName, String methodLookupName) {
            String methodDesc;
            String jvmClass;
            this.mv.visitVarInsn(25, localVarOffset);
            String lookupKey = JvmPackageGen.getPackageName(orgName, moduleName) + methodLookupName;
            int argsCount = callIns.args.size();
            for (int i = 0; i < argsCount; ++i) {
                BIROperand arg = callIns.args.get(i);
                boolean userProvidedArg = this.visitArg(arg);
                this.loadBooleanArgToIndicateUserProvidedArg(orgName, moduleName, userProvidedArg);
            }
            String cleanMethodName = JvmMethodGen.cleanupFunctionName(methodName);
            JvmPackageGen.BIRFunctionWrapper functionWrapper = JvmPackageGen.birFunctionMap.get(lookupKey);
            if (functionWrapper != null) {
                jvmClass = functionWrapper.fullQualifiedClassName;
                methodDesc = JvmInstructionGen.isBString ? functionWrapper.jvmMethodDescriptionBString : functionWrapper.jvmMethodDescription;
            } else {
                BPackageSymbol symbol = CodeGenerator.packageCache.getSymbol(orgName + "/" + moduleName);
                BInvokableSymbol funcSymbol = (BInvokableSymbol)symbol.scope.lookup((Name)new Name((String)methodName)).symbol;
                BInvokableType type = (BInvokableType)funcSymbol.type;
                ArrayList<BType> params = new ArrayList<BType>(type.paramTypes);
                if (type.restType != null) {
                    params.add(type.restType);
                }
                for (int j = params.size() - 1; j >= 0; --j) {
                    params.add(j + 1, JvmPackageGen.symbolTable.booleanType);
                }
                String balFileName = funcSymbol.source;
                if (balFileName == null || !balFileName.endsWith(".bal")) {
                    balFileName = "___init";
                }
                jvmClass = JvmPackageGen.getModuleLevelClassName(orgName, moduleName, JvmMethodGen.cleanupPathSeperators(JvmMethodGen.cleanupBalExt(balFileName)));
                methodDesc = JvmMethodGen.getMethodDesc(params, type.retType, null, false);
            }
            this.mv.visitMethodInsn(184, jvmClass, cleanMethodName, methodDesc, false);
        }

        private void genVirtualCall(BIRTerminator.Call callIns, String orgName, String moduleName, int localVarOffset) {
            BIRNode.BIRVariableDcl selfArg = JvmMethodGen.getVariableDcl(callIns.args.get((int)0).variableDcl);
            this.loadVar(selfArg);
            this.mv.visitTypeInsn(192, "org/ballerinalang/jvm/values/ObjectValue");
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitLdcInsn((Object)JvmTerminatorGen.cleanupObjectTypeName(callIns.name.value));
            int argsCount = callIns.args.size() - 1;
            this.mv.visitLdcInsn((Object)(argsCount * 2));
            this.mv.visitInsn(136);
            this.mv.visitTypeInsn(189, "java/lang/Object");
            int j = 0;
            for (int i = 0; i < argsCount; ++i) {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn((Object)j);
                this.mv.visitInsn(136);
                ++j;
                BIROperand arg = callIns.args.get(i + 1);
                boolean userProvidedArg = this.visitArg(arg);
                JvmInstructionGen.addBoxInsn(this.mv, arg.variableDcl.type);
                this.mv.visitInsn(83);
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn((Object)j);
                this.mv.visitInsn(136);
                ++j;
                this.loadBooleanArgToIndicateUserProvidedArg(orgName, moduleName, userProvidedArg);
                JvmInstructionGen.addBoxInsn(this.mv, JvmPackageGen.symbolTable.booleanType);
                this.mv.visitInsn(83);
            }
            String methodDesc = String.format("(L%s;L%s;[L%s;)L%s;", "org/ballerinalang/jvm/scheduling/Strand", "java/lang/String", "java/lang/Object", "java/lang/Object");
            this.mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ObjectValue", "call", methodDesc, true);
            BType returnType = callIns.lhsOp.variableDcl.type;
            JvmInstructionGen.addUnboxInsn(this.mv, returnType);
        }

        void loadBooleanArgToIndicateUserProvidedArg(String orgName, String moduleName, boolean userProvided) {
            if (ExternalMethodGen.isBallerinaBuiltinModule(orgName, moduleName)) {
                return;
            }
            if (userProvided) {
                this.mv.visitInsn(4);
            } else {
                this.mv.visitInsn(3);
            }
        }

        boolean visitArg(BIROperand arg) {
            BIRNode.BIRVariableDcl varDcl = JvmMethodGen.getVariableDcl(arg.variableDcl);
            if (varDcl.name.value.startsWith("_")) {
                JvmMethodGen.loadDefaultValue(this.mv, varDcl.type);
                return false;
            }
            this.loadVar(varDcl);
            return true;
        }

        void genAsyncCallTerm(BIRTerminator.AsyncCall callIns, int localVarOffset) {
            PackageID calleePkgId = callIns.calleePkg;
            String orgName = calleePkgId.orgName.value;
            String moduleName = calleePkgId.name.value;
            String lockStore = "Lorg/ballerinalang/jvm/BLockStore;";
            String initClassName = JvmPackageGen.lookupGlobalVarClassName(this.currentPackageName, "LOCK_STORE");
            this.mv.visitFieldInsn(178, initClassName, "LOCK_STORE", lockStore);
            this.mv.visitLdcInsn((Object)"global");
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/BLockStore", "panicIfInLock", String.format("(L%s;L%s;)V", "java/lang/String", "org/ballerinalang/jvm/scheduling/Strand"), false);
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "scheduler", String.format("L%s;", "org/ballerinalang/jvm/scheduling/Scheduler"));
            int argsCount = callIns.args.size();
            this.mv.visitLdcInsn((Object)(argsCount * 2 + 1));
            this.mv.visitInsn(136);
            this.mv.visitTypeInsn(189, "java/lang/Object");
            int paramIndex = 1;
            for (BIROperand arg : callIns.args) {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn((Object)paramIndex);
                this.mv.visitInsn(136);
                boolean userProvidedArg = this.visitArg(arg);
                JvmInstructionGen.addBoxInsn(this.mv, arg.variableDcl.type);
                this.mv.visitInsn(83);
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn((Object)(++paramIndex));
                this.mv.visitInsn(136);
                this.loadBooleanArgToIndicateUserProvidedArg(orgName, moduleName, userProvidedArg);
                JvmInstructionGen.addBoxInsn(this.mv, JvmPackageGen.symbolTable.booleanType);
                this.mv.visitInsn(83);
                ++paramIndex;
            }
            String funcName = callIns.name.value;
            String lambdaName = "$" + funcName + "$lambda$" + JvmPackageGen.lambdaIndex + "$";
            JvmMethodGen.createFunctionPointer(this.mv, JvmPackageGen.currentClass, lambdaName, 0);
            JvmPackageGen.lambdas.put(lambdaName, callIns);
            ++JvmPackageGen.lambdaIndex;
            boolean concurrent = false;
            if (callIns.annotAttachments.size() > 0) {
                for (BIRNode.BIRAnnotationAttachment annotationAttachment : callIns.annotAttachments) {
                    BIRNode.BIRAnnotationValue mapVal;
                    BIRNode.BIRAnnotationValue strandAnnot;
                    if (annotationAttachment == null || !"strand".equals(annotationAttachment.annotTagRef.value) || !"ballerina".equals(annotationAttachment.packageID.orgName.value) || !"lang.annotations".equals(annotationAttachment.packageID.name.value)) continue;
                    if (annotationAttachment.annotValues.size() == 0 || !((strandAnnot = annotationAttachment.annotValues.get(0)) instanceof BIRNode.BIRAnnotationRecordValue)) break;
                    BIRNode.BIRAnnotationRecordValue recordValue = (BIRNode.BIRAnnotationRecordValue)strandAnnot;
                    if (recordValue.annotValueEntryMap.containsKey("thread") && (mapVal = recordValue.annotValueEntryMap.get("thread")) instanceof BIRNode.BIRAnnotationLiteralValue && "any".equals(((BIRNode.BIRAnnotationLiteralValue)mapVal).value)) {
                        concurrent = true;
                    }
                    if (!recordValue.annotValueEntryMap.containsKey("name") || !((mapVal = recordValue.annotValueEntryMap.get("name")) instanceof BIRNode.BIRAnnotationLiteralValue) || "DEFAULT".equals(((BIRNode.BIRAnnotationLiteralValue)mapVal).value)) break;
                    throw new BLangCompilerException("Unsupported policy. Only 'DEFAULT' policy is supported by jBallerina runtime.");
                }
            }
            this.submitToScheduler(callIns.lhsOp, localVarOffset, concurrent);
        }

        void generateWaitIns(BIRTerminator.Wait waitInst, String funcName, int localVarOffset) {
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitTypeInsn(187, "java/util/ArrayList");
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V", false);
            for (int i = 0; i < waitInst.exprList.size(); ++i) {
                this.mv.visitInsn(89);
                BIROperand futureVal = waitInst.exprList.get(i);
                if (futureVal != null) {
                    this.loadVar(futureVal.variableDcl);
                }
                this.mv.visitMethodInsn(185, "java/util/List", "add", String.format("(L%s;)Z", "java/lang/Object"), true);
                this.mv.visitInsn(87);
            }
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Strand", "handleWaitAny", String.format("(L%s;)L%s$WaitResult;", "java/util/List", "org/ballerinalang/jvm/scheduling/Strand"), false);
            BIRNode.BIRVariableDcl tempVar = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("waitResult"), VarScope.FUNCTION, VarKind.ARG);
            int resultIndex = this.getJVMIndexOfVarRef(tempVar);
            this.mv.visitVarInsn(58, resultIndex);
            Label afterIf = new Label();
            this.mv.visitVarInsn(25, resultIndex);
            this.mv.visitFieldInsn(180, String.format("%s$WaitResult", "org/ballerinalang/jvm/scheduling/Strand"), "done", "Z");
            this.mv.visitJumpInsn(153, afterIf);
            Label withinIf = new Label();
            this.mv.visitLabel(withinIf);
            this.mv.visitVarInsn(25, resultIndex);
            this.mv.visitFieldInsn(180, String.format("%s$WaitResult", "org/ballerinalang/jvm/scheduling/Strand"), "result", String.format("L%s;", "java/lang/Object"));
            JvmInstructionGen.addUnboxInsn(this.mv, waitInst.lhsOp.variableDcl.type);
            this.storeToVar(waitInst.lhsOp.variableDcl);
            this.mv.visitLabel(afterIf);
        }

        void genWaitAllIns(BIRTerminator.WaitAll waitAll, String funcName, int localVarOffset) {
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitTypeInsn(187, "java/util/HashMap");
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
            for (int i = 0; i < waitAll.keys.size(); ++i) {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn((Object)waitAll.keys.get(i));
                BIROperand futureRef = waitAll.valueExprs.get(i);
                if (futureRef != null) {
                    this.loadVar(futureRef.variableDcl);
                }
                this.mv.visitMethodInsn(185, "java/util/Map", "put", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "java/lang/Object", "java/lang/Object"), true);
                this.mv.visitInsn(87);
            }
            this.loadVar(waitAll.lhsOp.variableDcl);
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Strand", "handleWaitMultiple", String.format("(L%s;L%s;)V", "java/util/Map", "org/ballerinalang/jvm/values/MapValue"), false);
        }

        void genFPCallIns(BIRTerminator.FPCall fpCall, String funcName, int localVarOffset) {
            if (fpCall.isAsync) {
                String lockStore = "Lorg/ballerinalang/jvm/BLockStore;";
                String initClassName = JvmPackageGen.lookupGlobalVarClassName(this.currentPackageName, "LOCK_STORE");
                this.mv.visitFieldInsn(178, initClassName, "LOCK_STORE", lockStore);
                this.mv.visitLdcInsn((Object)"global");
                this.mv.visitVarInsn(25, localVarOffset);
                this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/BLockStore", "panicIfInLock", String.format("(L%s;L%s;)V", "java/lang/String", "org/ballerinalang/jvm/scheduling/Strand"), false);
                this.mv.visitVarInsn(25, localVarOffset);
                this.mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "scheduler", String.format("L%s;", "org/ballerinalang/jvm/scheduling/Scheduler"));
            } else {
                this.loadVar(fpCall.fp.variableDcl);
            }
            this.mv.visitIntInsn(16, fpCall.args.size() * 2 + 1);
            this.mv.visitTypeInsn(189, "java/lang/Object");
            this.mv.visitInsn(89);
            this.mv.visitIntInsn(16, 0);
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitInsn(83);
            int paramIndex = 1;
            for (BIROperand arg : fpCall.args) {
                this.mv.visitInsn(89);
                this.mv.visitIntInsn(16, paramIndex);
                this.loadVar(JvmMethodGen.getVariableDcl(arg.variableDcl));
                BType bType = arg.variableDcl.type;
                JvmInstructionGen.addBoxInsn(this.mv, bType);
                this.mv.visitInsn(83);
                this.loadTrueValueAsArg(++paramIndex);
                ++paramIndex;
            }
            if (fpCall.isAsync) {
                this.loadVar(fpCall.fp.variableDcl);
                this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/AnnotationUtils", "isConcurrent", String.format("(L%s;)Z", "org/ballerinalang/jvm/values/FPValue"), false);
                Label notConcurrent = new Label();
                this.mv.visitJumpInsn(153, notConcurrent);
                Label concurrent = new Label();
                this.mv.visitLabel(concurrent);
                this.loadVar(fpCall.fp.variableDcl);
                this.submitToScheduler(fpCall.lhsOp, localVarOffset, true);
                Label afterSubmit = new Label();
                this.mv.visitJumpInsn(167, afterSubmit);
                this.mv.visitLabel(notConcurrent);
                this.loadVar(fpCall.fp.variableDcl);
                this.submitToScheduler(fpCall.lhsOp, localVarOffset, false);
                this.mv.visitLabel(afterSubmit);
            } else {
                BIRNode.BIRVariableDcl lhsVar;
                this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/FPValue", "call", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), false);
                BType lhsType = fpCall.lhsOp.variableDcl.type;
                if (lhsType != null) {
                    JvmInstructionGen.addUnboxInsn(this.mv, lhsType);
                }
                if ((lhsVar = fpCall.lhsOp.variableDcl) != null) {
                    this.storeToVar(lhsVar);
                } else {
                    this.mv.visitInsn(87);
                }
            }
        }

        void loadTrueValueAsArg(int paramIndex) {
            this.mv.visitInsn(89);
            this.mv.visitIntInsn(16, paramIndex);
            this.mv.visitInsn(4);
            JvmInstructionGen.addBoxInsn(this.mv, JvmPackageGen.symbolTable.booleanType);
            this.mv.visitInsn(83);
        }

        void genWorkerSendIns(BIRTerminator.WorkerSend ins, String funcName, int localVarOffset) {
            this.mv.visitVarInsn(25, localVarOffset);
            if (!ins.isSameStrand) {
                this.mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "parent", String.format("L%s;", "org/ballerinalang/jvm/scheduling/Strand"));
            }
            this.mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "wdChannels", String.format("L%s;", "org/ballerinalang/jvm/scheduling/WDChannels"));
            this.mv.visitLdcInsn((Object)ins.channel.value);
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/WDChannels", "getWorkerDataChannel", String.format("(L%s;)L%s;", "java/lang/String", "org/ballerinalang/jvm/scheduling/WorkerDataChannel"), false);
            this.loadVar(ins.data.variableDcl);
            JvmInstructionGen.addBoxInsn(this.mv, ins.data.variableDcl.type);
            this.mv.visitVarInsn(25, localVarOffset);
            if (!ins.isSync) {
                this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/WorkerDataChannel", "sendData", String.format("(L%s;L%s;)V", "java/lang/Object", "org/ballerinalang/jvm/scheduling/Strand"), false);
            } else {
                this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/WorkerDataChannel", "syncSendData", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "org/ballerinalang/jvm/scheduling/Strand", "java/lang/Object"), false);
                BIROperand lhsOp = ins.lhsOp;
                if (lhsOp != null) {
                    this.storeToVar(lhsOp.variableDcl);
                }
            }
        }

        void genWorkerReceiveIns(BIRTerminator.WorkerReceive ins, String funcName, int localVarOffset) {
            this.mv.visitVarInsn(25, localVarOffset);
            if (!ins.isSameStrand) {
                this.mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "parent", String.format("L%s;", "org/ballerinalang/jvm/scheduling/Strand"));
            }
            this.mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "wdChannels", String.format("L%s;", "org/ballerinalang/jvm/scheduling/WDChannels"));
            this.mv.visitLdcInsn((Object)ins.workerName.value);
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/WDChannels", "getWorkerDataChannel", String.format("(L%s;)L%s;", "java/lang/String", "org/ballerinalang/jvm/scheduling/WorkerDataChannel"), false);
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/WorkerDataChannel", "tryTakeData", String.format("(L%s;)L%s;", "org/ballerinalang/jvm/scheduling/Strand", "java/lang/Object"), false);
            BIRNode.BIRVariableDcl tempVar = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("wrkMsg"), VarScope.FUNCTION, VarKind.ARG);
            int wrkResultIndex = this.getJVMIndexOfVarRef(tempVar);
            this.mv.visitVarInsn(58, wrkResultIndex);
            Label jumpAfterReceive = new Label();
            this.mv.visitVarInsn(25, wrkResultIndex);
            this.mv.visitJumpInsn(198, jumpAfterReceive);
            Label withinReceiveSuccess = new Label();
            this.mv.visitLabel(withinReceiveSuccess);
            this.mv.visitVarInsn(25, wrkResultIndex);
            JvmInstructionGen.addUnboxInsn(this.mv, ins.lhsOp.variableDcl.type);
            this.storeToVar(ins.lhsOp.variableDcl);
            this.mv.visitLabel(jumpAfterReceive);
        }

        void genFlushIns(BIRTerminator.Flush ins, String funcName, int localVarOffset) {
            this.mv.visitVarInsn(25, localVarOffset);
            JvmTerminatorGen.loadChannelDetails(this.mv, Arrays.asList(ins.channels));
            this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Strand", "handleFlush", String.format("([L%s;)L%s;", "org/ballerinalang/jvm/values/ChannelDetails", "org/ballerinalang/jvm/values/ErrorValue"), false);
            this.storeToVar(ins.lhsOp.variableDcl);
        }

        void submitToScheduler(@Nilable BIROperand lhsOp, int localVarOffset, boolean concurrent) {
            BType futureType = lhsOp.variableDcl.type;
            BType returnType = JvmPackageGen.symbolTable.anyType;
            if (futureType.tag == 30) {
                returnType = ((BFutureType)futureType).constraint;
            }
            this.mv.visitVarInsn(25, localVarOffset);
            JvmTypeGen.loadType(this.mv, returnType);
            if (concurrent) {
                this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Scheduler", "scheduleFunction", String.format("([L%s;L%s;L%s;L%s;)L%s;", "java/lang/Object", "org/ballerinalang/jvm/values/FPValue", "org/ballerinalang/jvm/scheduling/Strand", "org/ballerinalang/jvm/types/BType", "org/ballerinalang/jvm/values/FutureValue"), false);
            } else {
                this.mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Scheduler", "scheduleLocal", String.format("([L%s;L%s;L%s;L%s;)L%s;", "java/lang/Object", "org/ballerinalang/jvm/values/FPValue", "org/ballerinalang/jvm/scheduling/Strand", "org/ballerinalang/jvm/types/BType", "org/ballerinalang/jvm/values/FutureValue"), false);
            }
            if (lhsOp.variableDcl != null) {
                BIRNode.BIRVariableDcl lhsOpVarDcl = lhsOp.variableDcl;
                this.storeToVar(JvmMethodGen.getVariableDcl(lhsOpVarDcl));
            }
        }

        int getJVMIndexOfVarRef(BIRNode.BIRVariableDcl varDcl) {
            return this.indexMap.getIndex(varDcl);
        }

        private void loadVar(BIRNode.BIRVariableDcl varDcl) {
            JvmInstructionGen.generateVarLoad(this.mv, varDcl, this.currentPackageName, this.getJVMIndexOfVarRef(varDcl));
        }

        private void storeToVar(BIRNode.BIRVariableDcl varDcl) {
            JvmInstructionGen.generateVarStore(this.mv, varDcl, this.currentPackageName, this.getJVMIndexOfVarRef(varDcl));
        }

        public void genReturnTerm(BIRTerminator.Return returnIns, int returnVarRefIndex, BIRNode.BIRFunction func, boolean isObserved, int localVarOffset) {
            if (isObserved) {
                JvmObservabilityGen.emitStopObservationInvocation(this.mv, localVarOffset);
            }
            BType bType = func.type.retType;
            if (bType.tag == 10) {
                this.mv.visitVarInsn(25, returnVarRefIndex);
                this.mv.visitInsn(176);
            } else if (TypeTags.isIntegerTypeTag(bType.tag)) {
                this.mv.visitVarInsn(22, returnVarRefIndex);
                this.mv.visitInsn(173);
            } else if (bType.tag == 2) {
                this.mv.visitVarInsn(21, returnVarRefIndex);
                this.mv.visitInsn(172);
            } else if (bType.tag == 3) {
                this.mv.visitVarInsn(24, returnVarRefIndex);
                this.mv.visitInsn(175);
            } else if (TypeTags.isStringTypeTag(bType.tag)) {
                this.mv.visitVarInsn(25, returnVarRefIndex);
                this.mv.visitInsn(176);
            } else if (bType.tag == 6) {
                this.mv.visitVarInsn(21, returnVarRefIndex);
                this.mv.visitInsn(172);
            } else if (bType.tag == 15 || bType.tag == 19 || bType.tag == 17 || bType.tag == 9 || bType.tag == 14 || bType.tag == 11 || bType.tag == 32 || bType.tag == 4 || bType.tag == 12 || bType.tag == 29 || bType.tag == 7 || bType.tag == 30 || TypeTags.isXMLTypeTag(bType.tag) || bType.tag == 16 || bType.tag == 35 || bType.tag == 31 || bType.tag == 13) {
                this.mv.visitVarInsn(25, returnVarRefIndex);
                this.mv.visitInsn(176);
            } else if (bType.tag == 20) {
                this.handleErrorRetInUnion(returnVarRefIndex, Arrays.asList(func.workerChannels), (BUnionType)bType);
                this.mv.visitVarInsn(25, returnVarRefIndex);
                this.mv.visitInsn(176);
            } else if (bType.tag == 27) {
                this.notifyChannels(Arrays.asList(func.workerChannels), returnVarRefIndex);
                this.mv.visitVarInsn(25, returnVarRefIndex);
                this.mv.visitInsn(176);
            } else {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", func.type.retType));
            }
        }
    }
}

