/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.repo;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.converters.ZipConverter;
import org.wso2.ballerinalang.compiler.packaging.repo.Repo;

public class BinaryRepo
implements Repo<Path> {
    private final ZipConverter converter;

    public BinaryRepo(Path pathToHiddenDir, CompilerPhase compilerPhase) {
        this(pathToHiddenDir, Paths.get("repo", new String[0]), compilerPhase);
    }

    public BinaryRepo(ZipConverter converter, CompilerPhase compilerPhase) {
        this.converter = converter;
    }

    public BinaryRepo(Path pathToHiddenDir, Path subDir, CompilerPhase compilerPhase) {
        this(new ZipConverter(pathToHiddenDir.resolve(subDir)), compilerPhase);
    }

    @Override
    public Patten calculate(PackageID pkg) {
        String orgName = pkg.getOrgName().getValue();
        String pkgName = pkg.getName().getValue();
        String versionStr = pkg.getPackageVersion().getValue();
        Patten.Part version = versionStr.isEmpty() ? Patten.LATEST_VERSION_DIR : Patten.path(versionStr);
        String artifactName = pkgName + ".zip";
        String binaryFileName = pkgName + ".bir";
        String folderName = "bir";
        return new Patten(Patten.path(orgName, pkgName), version, Patten.path(artifactName, folderName, binaryFileName));
    }

    @Override
    public Converter<Path> getConverterInstance() {
        return this.converter;
    }

    public String toString() {
        return "{t:'BinaryRepo', c:'" + this.converter + "'}";
    }
}

