/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BLangAnonymousModelHelper {
    private Map<PackageID, Integer> anonTypeCount;
    private Map<PackageID, Integer> anonServiceCount;
    private Map<PackageID, Integer> anonFunctionCount;
    private Map<PackageID, Integer> anonForkCount;
    private static final String ANON_TYPE = "$anonType$";
    private static final String LAMBDA = "$lambda$";
    private static final String SERVICE = "$$service$";
    private static final String ANON_SERVICE = "$anonService$";
    private static final String BUILTIN_ANON_TYPE = "$anonType$builtin$";
    private static final String BUILTIN_LAMBDA = "$lambda$builtin$";
    private static final String FORK = "$fork$";
    private static final CompilerContext.Key<BLangAnonymousModelHelper> ANONYMOUS_MODEL_HELPER_KEY = new CompilerContext.Key();

    private BLangAnonymousModelHelper(CompilerContext context) {
        context.put(ANONYMOUS_MODEL_HELPER_KEY, this);
        this.anonTypeCount = new HashMap<PackageID, Integer>();
        this.anonServiceCount = new HashMap<PackageID, Integer>();
        this.anonFunctionCount = new HashMap<PackageID, Integer>();
        this.anonForkCount = new HashMap<PackageID, Integer>();
    }

    public static BLangAnonymousModelHelper getInstance(CompilerContext context) {
        BLangAnonymousModelHelper helper = context.get(ANONYMOUS_MODEL_HELPER_KEY);
        if (helper == null) {
            helper = new BLangAnonymousModelHelper(context);
        }
        return helper;
    }

    public String getNextAnonymousTypeKey(PackageID packageID) {
        Integer nextValue = Optional.ofNullable(this.anonTypeCount.get(packageID)).orElse(0);
        this.anonTypeCount.put(packageID, nextValue + 1);
        if (PackageID.ANNOTATIONS.equals(packageID)) {
            return BUILTIN_ANON_TYPE + nextValue;
        }
        return ANON_TYPE + nextValue;
    }

    String getNextAnonymousServiceTypeKey(PackageID packageID, String serviceName) {
        Integer nextValue = Optional.ofNullable(this.anonServiceCount.get(packageID)).orElse(0);
        this.anonServiceCount.put(packageID, nextValue + 1);
        return serviceName + SERVICE + nextValue;
    }

    String getNextAnonymousServiceVarKey(PackageID packageID) {
        Integer nextValue = Optional.ofNullable(this.anonServiceCount.get(packageID)).orElse(0);
        this.anonServiceCount.put(packageID, nextValue + 1);
        return ANON_SERVICE + nextValue;
    }

    public String getNextAnonymousFunctionKey(PackageID packageID) {
        Integer nextValue = Optional.ofNullable(this.anonFunctionCount.get(packageID)).orElse(0);
        this.anonFunctionCount.put(packageID, nextValue + 1);
        return LAMBDA + nextValue;
    }

    public String getNextAnonymousForkKey(PackageID packageID) {
        Integer nextValue = Optional.ofNullable(this.anonFunctionCount.get(packageID)).orElse(0);
        this.anonFunctionCount.put(packageID, nextValue + 1);
        return FORK + nextValue;
    }

    public boolean isAnonymousType(BSymbol symbol) {
        return symbol.name.value.startsWith(ANON_TYPE);
    }
}

