/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.clauses.FromClauseNode;
import org.ballerinalang.model.clauses.WhereClauseNode;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.tree.expressions.XMLNavigationAccess;
import org.ballerinalang.util.diagnostic.DiagnosticCode;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeChecker;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangEndpoint;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResource;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangWorker;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIntRangeExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttributeAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAbort;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangThrow;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTryCatchFinally;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWorkerSend;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class CodeAnalyzer
extends BLangNodeVisitor {
    private static final CompilerContext.Key<CodeAnalyzer> CODE_ANALYZER_KEY = new CompilerContext.Key();
    private static final String NULL_LITERAL = "null";
    private final SymbolResolver symResolver;
    private int loopCount;
    private int transactionCount;
    private boolean statementReturns;
    private boolean lastStatement;
    private boolean withinRetryBlock;
    private boolean withinLockBlock;
    private int workerCount;
    private SymbolTable symTable;
    private Types types;
    private BLangDiagnosticLogHelper dlog;
    private TypeChecker typeChecker;
    private Stack<WorkerActionSystem> workerActionSystemStack = new Stack();
    private Stack<Boolean> loopWithintransactionCheckStack = new Stack();
    private Stack<Boolean> returnWithintransactionCheckStack = new Stack();
    private Stack<Boolean> doneWithintransactionCheckStack = new Stack();
    private BLangNode parent;
    private Names names;
    private SymbolEnv env;
    private final Stack<LinkedHashSet<BType>> returnTypes = new Stack();
    private boolean withinAbortedBlock;
    private boolean withinCommittedBlock;
    private boolean isJSONContext;
    private boolean enableExperimentalFeatures;

    public static CodeAnalyzer getInstance(CompilerContext context) {
        CodeAnalyzer codeGenerator = context.get(CODE_ANALYZER_KEY);
        if (codeGenerator == null) {
            codeGenerator = new CodeAnalyzer(context);
        }
        return codeGenerator;
    }

    public CodeAnalyzer(CompilerContext context) {
        context.put(CODE_ANALYZER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.types = Types.getInstance(context);
        this.dlog = BLangDiagnosticLogHelper.getInstance(context);
        this.typeChecker = TypeChecker.getInstance(context);
        this.names = Names.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.enableExperimentalFeatures = Boolean.parseBoolean(CompilerOptions.getInstance(context).get(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED));
    }

    private void resetFunction() {
        this.resetStatementReturns();
    }

    private void resetStatementReturns() {
        this.statementReturns = false;
    }

    private void resetLastStatement() {
        this.lastStatement = false;
    }

    public BLangPackage analyze(BLangPackage pkgNode) {
        pkgNode.accept(this);
        return pkgNode;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.CODE_ANALYZE)) {
            return;
        }
        this.parent = pkgNode;
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        this.analyzeTopLevelNodes(pkgNode, pkgEnv);
        pkgNode.getTestablePkgs().forEach(testablePackage -> this.visit((BLangPackage)testablePackage));
    }

    private void analyzeTopLevelNodes(BLangPackage pkgNode, SymbolEnv pkgEnv) {
        pkgNode.topLevelNodes.forEach(topLevelNode -> this.analyzeNode((BLangNode)((Object)topLevelNode), pkgEnv));
        pkgNode.completedPhases.add(CompilerPhase.CODE_ANALYZE);
        this.parent = null;
    }

    private void analyzeNode(BLangNode node, SymbolEnv env) {
        SymbolEnv prevEnv = this.env;
        this.env = env;
        BLangNode myParent = this.parent;
        node.parent = this.parent;
        this.parent = node;
        node.accept(this);
        this.parent = myParent;
        this.env = prevEnv;
    }

    private void analyzeTypeNode(BLangType node, SymbolEnv env) {
        if (node == null) {
            return;
        }
        this.analyzeNode(node, env);
    }

    @Override
    public void visit(BLangCompilationUnit compUnitNode) {
        compUnitNode.topLevelNodes.forEach(e -> this.analyzeNode((BLangNode)((Object)e), this.env));
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        this.analyzeTypeNode(typeDefinition.typeNode, this.env);
        typeDefinition.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, this.env));
    }

    @Override
    public void visit(BLangTupleVariableDef bLangTupleVariableDef) {
        this.analyzeNode(bLangTupleVariableDef.var, this.env);
    }

    @Override
    public void visit(BLangRecordVariableDef bLangRecordVariableDef) {
        this.analyzeNode(bLangRecordVariableDef.var, this.env);
    }

    @Override
    public void visit(BLangErrorVariableDef bLangErrorVariableDef) {
        this.analyzeNode(bLangErrorVariableDef.errorVariable, this.env);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        boolean isLambda = funcNode.flagSet.contains((Object)Flag.LAMBDA);
        if (isLambda) {
            return;
        }
        this.validateParams(funcNode);
        if (Symbols.isPublic(funcNode.symbol)) {
            funcNode.symbol.params.forEach(symbol -> this.analyzeExportableTypeRef(funcNode.symbol, symbol.type.tsymbol, true, funcNode.pos));
            if (funcNode.symbol.restParam != null) {
                this.analyzeExportableTypeRef(funcNode.symbol, funcNode.symbol.restParam.type.tsymbol, true, funcNode.restParam.pos);
            }
            this.analyzeExportableTypeRef(funcNode.symbol, funcNode.symbol.retType.tsymbol, true, funcNode.returnTypeNode.pos);
        }
        this.validateMainFunction(funcNode);
        this.validateModuleInitFunction(funcNode);
        try {
            this.initNewWorkerActionSystem();
            this.workerActionSystemStack.peek().startWorkerActionStateMachine("default", funcNode.pos, funcNode);
            this.visitFunction(funcNode);
            this.workerActionSystemStack.peek().endWorkerActionStateMachine();
        }
        finally {
            this.finalizeCurrentWorkerActionSystem();
        }
        funcNode.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, this.env));
    }

    private void validateParams(BLangFunction funcNode) {
        for (BLangSimpleVariable parameter : funcNode.requiredParams) {
            this.analyzeNode(parameter, this.env);
        }
        if (funcNode.restParam != null) {
            this.analyzeNode(funcNode.restParam, this.env);
        }
    }

    private void visitFunction(BLangFunction funcNode) {
        SymbolEnv invokableEnv = SymbolEnv.createFunctionEnv(funcNode, funcNode.symbol.scope, this.env);
        this.returnWithintransactionCheckStack.push(true);
        this.doneWithintransactionCheckStack.push(true);
        this.returnTypes.push(new LinkedHashSet());
        this.resetFunction();
        if (Symbols.isNative(funcNode.symbol)) {
            return;
        }
        if (this.isPublicInvokableNode(funcNode)) {
            this.analyzeNode(funcNode.returnTypeNode, invokableEnv);
        }
        if (funcNode.body != null) {
            this.analyzeNode(funcNode.body, invokableEnv);
            boolean isNilableReturn = funcNode.symbol.type.getReturnType().isNullable();
            if (!isNilableReturn && !this.statementReturns) {
                this.dlog.error(funcNode.pos, DiagnosticCode.INVOKABLE_MUST_RETURN, funcNode.getKind().toString().toLowerCase());
            }
        }
        this.returnTypes.pop();
        this.returnWithintransactionCheckStack.pop();
        this.doneWithintransactionCheckStack.pop();
    }

    private boolean isPublicInvokableNode(BLangInvokableNode invNode) {
        return Symbols.isPublic(invNode.symbol) && (SymbolKind.PACKAGE.equals((Object)invNode.symbol.owner.getKind()) || Symbols.isPublic(invNode.symbol.owner));
    }

    @Override
    public void visit(BLangBlockFunctionBody body) {
        SymbolEnv blockEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        for (BLangStatement e : body.stmts) {
            this.analyzeNode(e, blockEnv);
        }
        this.resetLastStatement();
    }

    @Override
    public void visit(BLangExprFunctionBody body) {
        this.analyzeExpr(body.expr);
        this.statementReturns = true;
        this.resetLastStatement();
    }

    @Override
    public void visit(BLangExternalFunctionBody body) {
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        if (forkJoin.workers.isEmpty()) {
            this.dlog.error(forkJoin.pos, DiagnosticCode.INVALID_FOR_JOIN_SYNTAX_EMPTY_FORK, new Object[0]);
        }
    }

    @Override
    public void visit(BLangWorker worker) {
    }

    @Override
    public void visit(BLangEndpoint endpointNode) {
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        this.checkExperimentalFeatureValidity(ExperimentalFeatures.TRANSACTIONS, transactionNode.pos);
        this.checkStatementExecutionValidity(transactionNode);
        if (!this.isValidTransactionBlock()) {
            this.dlog.error(transactionNode.pos, DiagnosticCode.TRANSACTION_CANNOT_BE_USED_WITHIN_HANDLER, new Object[0]);
            return;
        }
        this.loopWithintransactionCheckStack.push(false);
        this.returnWithintransactionCheckStack.push(false);
        this.doneWithintransactionCheckStack.push(false);
        ++this.transactionCount;
        if (this.transactionCount > 1) {
            this.dlog.error(transactionNode.pos, DiagnosticCode.NESTED_TRANSACTIONS_ARE_INVALID, new Object[0]);
        }
        this.analyzeNode(transactionNode.transactionBody, this.env);
        --this.transactionCount;
        this.resetLastStatement();
        if (transactionNode.onRetryBody != null) {
            this.withinRetryBlock = true;
            this.analyzeNode(transactionNode.onRetryBody, this.env);
            this.resetStatementReturns();
            this.resetLastStatement();
            this.withinRetryBlock = false;
        }
        if (transactionNode.abortedBody != null) {
            this.withinAbortedBlock = true;
            this.analyzeNode(transactionNode.abortedBody, this.env);
            this.resetStatementReturns();
            this.resetLastStatement();
            this.withinAbortedBlock = false;
        }
        if (transactionNode.committedBody != null) {
            this.withinCommittedBlock = true;
            this.analyzeNode(transactionNode.committedBody, this.env);
            this.resetStatementReturns();
            this.resetLastStatement();
            this.withinCommittedBlock = false;
        }
        this.returnWithintransactionCheckStack.pop();
        this.loopWithintransactionCheckStack.pop();
        this.doneWithintransactionCheckStack.pop();
        this.analyzeExpr(transactionNode.retryCount);
    }

    @Override
    public void visit(BLangAbort abortNode) {
        if (this.transactionCount == 0) {
            this.dlog.error(abortNode.pos, DiagnosticCode.ABORT_CANNOT_BE_OUTSIDE_TRANSACTION_BLOCK, new Object[0]);
            return;
        }
        this.lastStatement = true;
    }

    @Override
    public void visit(BLangRetry retryNode) {
        if (this.transactionCount == 0) {
            this.dlog.error(retryNode.pos, DiagnosticCode.RETRY_CANNOT_BE_OUTSIDE_TRANSACTION_BLOCK, new Object[0]);
            return;
        }
        this.lastStatement = true;
    }

    private void checkUnreachableCode(BLangStatement stmt) {
        if (this.statementReturns) {
            this.dlog.error(stmt.pos, DiagnosticCode.UNREACHABLE_CODE, new Object[0]);
            this.resetStatementReturns();
        }
        if (this.lastStatement) {
            this.dlog.error(stmt.pos, DiagnosticCode.UNREACHABLE_CODE, new Object[0]);
            this.resetLastStatement();
        }
    }

    private void checkStatementExecutionValidity(BLangStatement stmt) {
        this.checkUnreachableCode(stmt);
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(blockNode, this.env);
        blockNode.stmts.forEach(e -> this.analyzeNode((BLangNode)e, blockEnv));
        this.resetLastStatement();
    }

    @Override
    public void visit(BLangReturn returnStmt) {
        this.checkStatementExecutionValidity(returnStmt);
        if (this.checkReturnValidityInTransaction()) {
            this.dlog.error(returnStmt.pos, DiagnosticCode.RETURN_CANNOT_BE_USED_TO_EXIT_TRANSACTION, new Object[0]);
            return;
        }
        this.statementReturns = true;
        this.analyzeExpr(returnStmt.expr);
        this.returnTypes.peek().add(returnStmt.expr.type);
    }

    @Override
    public void visit(BLangIf ifStmt) {
        this.checkStatementExecutionValidity(ifStmt);
        this.analyzeNode(ifStmt.body, this.env);
        boolean ifStmtReturns = this.statementReturns;
        this.resetStatementReturns();
        if (ifStmt.elseStmt != null) {
            this.analyzeNode(ifStmt.elseStmt, this.env);
            this.statementReturns = ifStmtReturns && this.statementReturns;
        }
        this.analyzeExpr(ifStmt.expr);
    }

    @Override
    public void visit(BLangMatch matchStmt) {
        this.analyzeExpr(matchStmt.expr);
        boolean staticLastPattern = false;
        if (!matchStmt.getStaticPatternClauses().isEmpty()) {
            staticLastPattern = this.analyzeStaticMatchPatterns(matchStmt);
        }
        boolean structuredLastPattern = false;
        if (!matchStmt.getStructuredPatternClauses().isEmpty()) {
            structuredLastPattern = this.analyzeStructuredMatchPatterns(matchStmt);
        }
        if (!matchStmt.getPatternClauses().isEmpty()) {
            this.analyzeEmptyMatchPatterns(matchStmt);
            this.analyzeMatchedPatterns(matchStmt, staticLastPattern, structuredLastPattern);
        }
    }

    @Override
    public void visit(BLangMatch.BLangMatchStaticBindingPatternClause patternClause) {
        this.analyzeNode(patternClause.matchExpr, this.env);
        this.analyzeNode(patternClause.body, this.env);
        this.resetStatementReturns();
    }

    @Override
    public void visit(BLangMatch.BLangMatchStructuredBindingPatternClause patternClause) {
        this.analyzeNode(patternClause.matchExpr, this.env);
        this.analyzeNode(patternClause.body, this.env);
        this.resetStatementReturns();
    }

    private void analyzeMatchedPatterns(BLangMatch matchStmt, boolean staticLastPattern, boolean structuredLastPattern) {
        if (staticLastPattern && structuredLastPattern) {
            this.dlog.error(matchStmt.pos, DiagnosticCode.MATCH_STMT_CONTAINS_TWO_DEFAULT_PATTERNS, new Object[0]);
        }
        if (staticLastPattern && !this.hasErrorType(matchStmt.exprTypes) || structuredLastPattern) {
            if (matchStmt.getPatternClauses().size() == 1) {
                this.dlog.error(matchStmt.getPatternClauses().get((int)0).pos, DiagnosticCode.MATCH_STMT_PATTERN_ALWAYS_MATCHES, new Object[0]);
            }
            this.checkStatementExecutionValidity(matchStmt);
            boolean matchStmtReturns = true;
            for (BLangMatch.BLangMatchBindingPatternClause patternClause : matchStmt.getPatternClauses()) {
                this.analyzeNode(patternClause.body, this.env);
                matchStmtReturns = matchStmtReturns && this.statementReturns;
                this.resetStatementReturns();
            }
            this.statementReturns = matchStmtReturns;
        }
    }

    private boolean hasErrorType(List<BType> typeList) {
        return typeList.stream().anyMatch(t -> this.types.isAssignable((BType)t, this.symTable.errorType));
    }

    private boolean analyzeStructuredMatchPatterns(BLangMatch matchStmt) {
        if (matchStmt.exprTypes.isEmpty()) {
            return false;
        }
        for (BLangMatch.BLangMatchStructuredBindingPatternClause patternClause : matchStmt.getStructuredPatternClauses()) {
            this.analyzeNode(patternClause, this.env);
        }
        return this.analyseStructuredBindingPatterns(matchStmt.getStructuredPatternClauses(), this.hasErrorType(matchStmt.exprTypes));
    }

    private void analyzeEmptyMatchPatterns(BLangMatch matchStmt) {
        ArrayList<BLangMatch.BLangMatchBindingPatternClause> emptyLists = new ArrayList<BLangMatch.BLangMatchBindingPatternClause>();
        ArrayList<BLangMatch.BLangMatchBindingPatternClause> emptyRecords = new ArrayList<BLangMatch.BLangMatchBindingPatternClause>();
        for (BLangMatch.BLangMatchBindingPatternClause pattern : matchStmt.patternClauses) {
            if (pattern.getKind() == NodeKind.MATCH_STATIC_PATTERN_CLAUSE) {
                BLangMatch.BLangMatchStaticBindingPatternClause staticPattern = (BLangMatch.BLangMatchStaticBindingPatternClause)pattern;
                if (staticPattern.literal.getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR) {
                    BLangListConstructorExpr listLiteral = (BLangListConstructorExpr)staticPattern.literal;
                    if (!listLiteral.exprs.isEmpty()) continue;
                    emptyLists.add(pattern);
                    continue;
                }
                if (staticPattern.literal.getKind() != NodeKind.RECORD_LITERAL_EXPR) continue;
                BLangRecordLiteral recordLiteral = (BLangRecordLiteral)staticPattern.literal;
                if (!recordLiteral.fields.isEmpty()) continue;
                emptyRecords.add(pattern);
                continue;
            }
            if (pattern.getKind() != NodeKind.MATCH_STRUCTURED_PATTERN_CLAUSE) continue;
            BLangMatch.BLangMatchStructuredBindingPatternClause structuredPattern = (BLangMatch.BLangMatchStructuredBindingPatternClause)pattern;
            if (structuredPattern.bindingPatternVariable.getKind() == NodeKind.TUPLE_VARIABLE) {
                BLangTupleVariable tupleVariable = (BLangTupleVariable)structuredPattern.bindingPatternVariable;
                if (!tupleVariable.memberVariables.isEmpty() || tupleVariable.restVariable != null) continue;
                emptyLists.add(pattern);
                continue;
            }
            if (structuredPattern.bindingPatternVariable.getKind() != NodeKind.RECORD_VARIABLE) continue;
            BLangRecordVariable recordVariable = (BLangRecordVariable)structuredPattern.bindingPatternVariable;
            if (!recordVariable.variableList.isEmpty() || recordVariable.restParam != null) continue;
            emptyRecords.add(pattern);
        }
        if (emptyLists.size() > 1) {
            for (int i = 1; i < emptyLists.size(); ++i) {
                this.dlog.error(((BLangMatch.BLangMatchBindingPatternClause)emptyLists.get((int)i)).pos, DiagnosticCode.MATCH_STMT_UNREACHABLE_PATTERN, new Object[0]);
            }
        }
        if (emptyRecords.size() > 1) {
            for (int i = 1; i < emptyRecords.size(); ++i) {
                this.dlog.error(((BLangMatch.BLangMatchBindingPatternClause)emptyRecords.get((int)i)).pos, DiagnosticCode.MATCH_STMT_UNREACHABLE_PATTERN, new Object[0]);
            }
        }
    }

    private boolean analyzeStaticMatchPatterns(BLangMatch matchStmt) {
        if (matchStmt.exprTypes.isEmpty()) {
            return false;
        }
        ArrayList<BLangMatch.BLangMatchStaticBindingPatternClause> matchedPatterns = new ArrayList<BLangMatch.BLangMatchStaticBindingPatternClause>();
        for (BLangMatch.BLangMatchStaticBindingPatternClause pattern : matchStmt.getStaticPatternClauses()) {
            this.analyzeNode(pattern, this.env);
            List matchedExpTypes = matchStmt.exprTypes.stream().filter(exprType -> this.isValidStaticMatchPattern((BType)exprType, pattern.literal)).collect(Collectors.toList());
            if (matchedExpTypes.isEmpty()) {
                this.dlog.error(pattern.pos, DiagnosticCode.MATCH_STMT_UNMATCHED_PATTERN, new Object[0]);
                continue;
            }
            this.isJSONContext = this.types.isJSONContext(matchStmt.expr.type);
            this.analyzeNode(pattern.literal, this.env);
            matchedPatterns.add(pattern);
        }
        if (matchedPatterns.isEmpty()) {
            return false;
        }
        return this.analyzeStaticPatterns(matchedPatterns, this.hasErrorType(matchStmt.exprTypes));
    }

    private boolean analyzeStaticPatterns(List<BLangMatch.BLangMatchStaticBindingPatternClause> matchedPatterns, boolean errorTypeInMatchExpr) {
        BLangMatch.BLangMatchStaticBindingPatternClause finalPattern = matchedPatterns.get(matchedPatterns.size() - 1);
        if (finalPattern.literal.getKind() == NodeKind.SIMPLE_VARIABLE_REF && ((BLangSimpleVarRef)finalPattern.literal).variableName.value.equals(Names.IGNORE.value) && !errorTypeInMatchExpr) {
            finalPattern.isLastPattern = true;
        }
        for (int i = 0; i < matchedPatterns.size() - 1; ++i) {
            BLangExpression precedingPattern = matchedPatterns.get((int)i).literal;
            for (int j = i + 1; j < matchedPatterns.size(); ++j) {
                BLangExpression pattern = matchedPatterns.get((int)j).literal;
                if (!this.checkLiteralSimilarity(precedingPattern, pattern)) continue;
                this.dlog.error(pattern.pos, DiagnosticCode.MATCH_STMT_UNREACHABLE_PATTERN, new Object[0]);
                matchedPatterns.remove(j--);
            }
        }
        return finalPattern.isLastPattern;
    }

    private boolean analyseStructuredBindingPatterns(List<BLangMatch.BLangMatchStructuredBindingPatternClause> clauses, boolean errorTypeInMatchExpr) {
        BLangMatch.BLangMatchStructuredBindingPatternClause finalPattern = clauses.get(clauses.size() - 1);
        if (!(finalPattern.bindingPatternVariable.getKind() != NodeKind.VARIABLE || finalPattern.typeGuardExpr != null || errorTypeInMatchExpr && this.isWildcardMatchPattern(finalPattern))) {
            finalPattern.isLastPattern = true;
        }
        for (int i = 0; i < clauses.size(); ++i) {
            BLangMatch.BLangMatchStructuredBindingPatternClause precedingPattern = clauses.get(i);
            if (precedingPattern.typeGuardExpr != null) {
                this.analyzeExpr(precedingPattern.typeGuardExpr);
            }
            for (int j = i + 1; j < clauses.size(); ++j) {
                BLangMatch.BLangMatchStructuredBindingPatternClause currentPattern = clauses.get(j);
                BLangVariable precedingVar = precedingPattern.bindingPatternVariable;
                BLangVariable currentVar = currentPattern.bindingPatternVariable;
                if (!this.checkStructuredPatternSimilarity(precedingVar, currentVar, errorTypeInMatchExpr) || !this.checkTypeGuardSimilarity(precedingPattern.typeGuardExpr, currentPattern.typeGuardExpr)) continue;
                this.dlog.error(currentVar.pos, DiagnosticCode.MATCH_STMT_UNREACHABLE_PATTERN, new Object[0]);
                clauses.remove(j--);
            }
        }
        return finalPattern.isLastPattern;
    }

    private boolean isWildcardMatchPattern(BLangMatch.BLangMatchStructuredBindingPatternClause finalPattern) {
        return ((BLangSimpleVariable)finalPattern.bindingPatternVariable).name.value.equals(Names.IGNORE.value);
    }

    private boolean checkLiteralSimilarity(BLangExpression precedingPattern, BLangExpression pattern) {
        if (precedingPattern.getKind() == NodeKind.BINARY_EXPR) {
            BLangBinaryExpr precedingBinaryExpr = (BLangBinaryExpr)precedingPattern;
            BLangExpression precedingLhsExpr = precedingBinaryExpr.lhsExpr;
            BLangExpression precedingRhsExpr = precedingBinaryExpr.rhsExpr;
            return this.checkLiteralSimilarity(precedingLhsExpr, pattern) || this.checkLiteralSimilarity(precedingRhsExpr, pattern);
        }
        if (pattern.getKind() == NodeKind.BINARY_EXPR) {
            BLangBinaryExpr binaryExpr = (BLangBinaryExpr)pattern;
            BLangExpression lhsExpr = binaryExpr.lhsExpr;
            BLangExpression rhsExpr = binaryExpr.rhsExpr;
            return this.checkLiteralSimilarity(precedingPattern, lhsExpr) || this.checkLiteralSimilarity(precedingPattern, rhsExpr);
        }
        switch (precedingPattern.type.tag) {
            case 15: {
                if (pattern.type.tag == 15) {
                    BLangRecordLiteral precedingRecordLiteral = (BLangRecordLiteral)precedingPattern;
                    Map<String, BLangExpression> recordLiteral = ((BLangRecordLiteral)pattern).fields.stream().map(field -> (BLangRecordLiteral.BLangRecordKeyValueField)field).collect(Collectors.toMap(keyValuePair -> ((BLangSimpleVarRef)keyValuePair.key.expr).variableName.value, BLangRecordLiteral.BLangRecordKeyValueField::getValue));
                    for (int i2 = 0; i2 < precedingRecordLiteral.fields.size(); ++i2) {
                        BLangRecordLiteral.BLangRecordKeyValueField bLangRecordKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)precedingRecordLiteral.fields.get(i2);
                        String key = ((BLangSimpleVarRef)bLangRecordKeyValue.key.expr).variableName.value;
                        if (!recordLiteral.containsKey(key)) {
                            return false;
                        }
                        if (this.checkLiteralSimilarity(bLangRecordKeyValue.valueExpr, recordLiteral.get(key))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            case 29: {
                if (pattern.type.tag == 29) {
                    BLangListConstructorExpr precedingTupleLiteral = (BLangListConstructorExpr)precedingPattern;
                    BLangListConstructorExpr tupleLiteral = (BLangListConstructorExpr)pattern;
                    if (precedingTupleLiteral.exprs.size() != tupleLiteral.exprs.size()) {
                        return false;
                    }
                    return IntStream.range(0, precedingTupleLiteral.exprs.size()).allMatch(i -> this.checkLiteralSimilarity(precedingTupleLiteral.exprs.get(i), tupleLiteral.exprs.get(i)));
                }
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (precedingPattern.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                    BConstantSymbol precedingPatternSym = (BConstantSymbol)((BLangSimpleVarRef)precedingPattern).symbol;
                    if (pattern.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                        if (!((BLangSimpleVarRef)pattern).variableName.value.equals(Names.IGNORE.value)) {
                            BConstantSymbol patternSym = (BConstantSymbol)((BLangSimpleVarRef)pattern).symbol;
                            return precedingPatternSym.value.equals(patternSym.value);
                        }
                        return false;
                    }
                    BLangLiteral literal = pattern.getKind() == NodeKind.GROUP_EXPR ? (BLangLiteral)((BLangGroupExpr)pattern).expression : (BLangLiteral)pattern;
                    return precedingPatternSym.value.equals(literal.value);
                }
                if (this.types.isValueType(pattern.type)) {
                    BLangLiteral precedingLiteral;
                    BLangLiteral bLangLiteral = precedingLiteral = precedingPattern.getKind() == NodeKind.GROUP_EXPR ? (BLangLiteral)((BLangGroupExpr)precedingPattern).expression : (BLangLiteral)precedingPattern;
                    if (pattern.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                        if (pattern.type.tag != 22) {
                            BConstantSymbol patternSym = (BConstantSymbol)((BLangSimpleVarRef)pattern).symbol;
                            return patternSym.value.equals(precedingLiteral.value);
                        }
                        return false;
                    }
                    BLangLiteral literal = pattern.getKind() == NodeKind.GROUP_EXPR ? (BLangLiteral)((BLangGroupExpr)pattern).expression : (BLangLiteral)pattern;
                    return precedingLiteral.value.equals(literal.value);
                }
                return false;
            }
            case 17: {
                return pattern.type.tag != 27;
            }
        }
        return false;
    }

    private boolean checkTypeGuardSimilarity(BLangExpression precedingGuard, BLangExpression currentGuard) {
        if (precedingGuard != null && currentGuard != null) {
            if (precedingGuard.getKind() == NodeKind.TYPE_TEST_EXPR && currentGuard.getKind() == NodeKind.TYPE_TEST_EXPR && ((BLangTypeTestExpr)precedingGuard).expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF && ((BLangTypeTestExpr)currentGuard).expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BLangTypeTestExpr precedingTypeTest = (BLangTypeTestExpr)precedingGuard;
                BLangTypeTestExpr currentTypeTest = (BLangTypeTestExpr)currentGuard;
                return ((BLangSimpleVarRef)precedingTypeTest.expr).variableName.toString().equals(((BLangSimpleVarRef)currentTypeTest.expr).variableName.toString()) && precedingTypeTest.typeNode.type.tag == currentTypeTest.typeNode.type.tag;
            }
            return false;
        }
        return currentGuard != null || precedingGuard == null;
    }

    private boolean checkStructuredPatternSimilarity(BLangVariable precedingVar, BLangVariable var, boolean errorTypeInMatchExpr) {
        if (precedingVar.type.tag == 26 || var.type.tag == 26) {
            return false;
        }
        if (precedingVar.getKind() == NodeKind.RECORD_VARIABLE && var.getKind() == NodeKind.RECORD_VARIABLE) {
            BLangRecordVariable precedingRecVar = (BLangRecordVariable)precedingVar;
            BLangRecordVariable recVar = (BLangRecordVariable)var;
            Map<String, BLangVariable> recVarAsMap = recVar.variableList.stream().collect(Collectors.toMap(keyValue -> keyValue.key.value, keyValue -> keyValue.valueBindingPattern));
            if (precedingRecVar.variableList.size() > recVar.variableList.size()) {
                return false;
            }
            for (int i = 0; i < precedingRecVar.variableList.size(); ++i) {
                BLangRecordVariable.BLangRecordVariableKeyValue precedingKeyValue = precedingRecVar.variableList.get(i);
                if (!recVarAsMap.containsKey(precedingKeyValue.key.value)) {
                    return false;
                }
                if (this.checkStructuredPatternSimilarity(precedingKeyValue.valueBindingPattern, recVarAsMap.get(precedingKeyValue.key.value), errorTypeInMatchExpr)) continue;
                return false;
            }
            if (precedingRecVar.hasRestParam() && recVar.hasRestParam()) {
                return true;
            }
            return precedingRecVar.hasRestParam() || !recVar.hasRestParam();
        }
        if (precedingVar.getKind() == NodeKind.TUPLE_VARIABLE && var.getKind() == NodeKind.TUPLE_VARIABLE) {
            List<BLangVariable> precedingMemberVars = ((BLangTupleVariable)precedingVar).memberVariables;
            BLangVariable precedingRestVar = ((BLangTupleVariable)precedingVar).restVariable;
            List<BLangVariable> memberVars = ((BLangTupleVariable)var).memberVariables;
            BLangVariable memberRestVar = ((BLangTupleVariable)var).restVariable;
            if (precedingRestVar != null && memberRestVar != null) {
                return true;
            }
            if (precedingRestVar == null && memberRestVar == null && precedingMemberVars.size() != memberVars.size()) {
                return false;
            }
            if (precedingRestVar != null && precedingMemberVars.size() > memberVars.size()) {
                return false;
            }
            if (memberRestVar != null) {
                return false;
            }
            for (int i = 0; i < memberVars.size(); ++i) {
                if (this.checkStructuredPatternSimilarity(precedingMemberVars.get(i), memberVars.get(i), errorTypeInMatchExpr)) continue;
                return false;
            }
            return true;
        }
        if (precedingVar.getKind() == NodeKind.ERROR_VARIABLE && var.getKind() == NodeKind.ERROR_VARIABLE) {
            BLangErrorVariable precedingErrVar = (BLangErrorVariable)precedingVar;
            BLangErrorVariable errVar = (BLangErrorVariable)var;
            if (precedingErrVar.restDetail != null && this.isDirectErrorBindingPattern(precedingErrVar)) {
                return true;
            }
            if (errVar.restDetail != null) {
                return false;
            }
            if (precedingErrVar.detail != null && errVar.detail != null) {
                Map<String, BLangVariable> preDetails = precedingErrVar.detail.stream().collect(Collectors.toMap(entry -> entry.key.value, entry -> entry.valueBindingPattern));
                for (BLangErrorVariable.BLangErrorDetailEntry detailEntry : errVar.detail) {
                    BLangVariable correspondingCurDetail = preDetails.get(detailEntry.key.value);
                    if (correspondingCurDetail == null) {
                        return false;
                    }
                    boolean similar = this.checkStructuredPatternSimilarity(detailEntry.valueBindingPattern, correspondingCurDetail, errorTypeInMatchExpr);
                    if (similar) continue;
                    return false;
                }
            }
            return true;
        }
        if (precedingVar.getKind() == NodeKind.VARIABLE && ((BLangSimpleVariable)precedingVar).name.value.equals(Names.IGNORE.value) && var.getKind() == NodeKind.ERROR_VARIABLE) {
            return false;
        }
        return precedingVar.getKind() == NodeKind.VARIABLE;
    }

    private boolean isDirectErrorBindingPattern(BLangErrorVariable precedingErrVar) {
        return precedingErrVar.typeNode == null;
    }

    private boolean isValidStaticMatchPattern(BType matchType, BLangExpression literal) {
        if (literal.type.tag == 22) {
            return true;
        }
        if (this.types.isSameType(literal.type, matchType)) {
            return true;
        }
        if (17 == literal.type.tag) {
            return true;
        }
        switch (matchType.tag) {
            case 7: 
            case 11: 
            case 17: {
                return true;
            }
            case 20: {
                BUnionType unionMatchType = (BUnionType)matchType;
                return unionMatchType.getMemberTypes().stream().anyMatch(memberMatchType -> this.isValidStaticMatchPattern((BType)memberMatchType, literal));
            }
            case 29: {
                if (literal.type.tag != 29) break;
                BLangListConstructorExpr tupleLiteral = (BLangListConstructorExpr)literal;
                BTupleType literalTupleType = (BTupleType)literal.type;
                BTupleType matchTupleType = (BTupleType)matchType;
                if (literalTupleType.tupleTypes.size() != matchTupleType.tupleTypes.size()) {
                    return false;
                }
                return IntStream.range(0, literalTupleType.tupleTypes.size()).allMatch(i -> this.isValidStaticMatchPattern(matchTupleType.tupleTypes.get(i), tupleLiteral.exprs.get(i)));
            }
            case 15: {
                if (literal.type.tag != 15) break;
                BLangRecordLiteral mapLiteral = (BLangRecordLiteral)literal;
                return IntStream.range(0, mapLiteral.fields.size()).allMatch(i -> this.isValidStaticMatchPattern(((BMapType)matchType).constraint, ((BLangRecordLiteral.BLangRecordKeyValueField)mapLiteral.fields.get((int)i)).valueExpr));
            }
            case 12: {
                if (literal.type.tag != 15) break;
                BLangRecordLiteral mapLiteral = (BLangRecordLiteral)literal;
                BRecordType recordMatchType = (BRecordType)matchType;
                Map<String, BType> recordFields = recordMatchType.fields.stream().collect(Collectors.toMap(field -> field.getName().getValue(), BField::getType));
                for (RecordLiteralNode.RecordField field2 : mapLiteral.fields) {
                    String literalKeyName;
                    BLangRecordLiteral.BLangRecordKeyValueField literalKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field2;
                    NodeKind nodeKind = literalKeyValue.key.expr.getKind();
                    if (nodeKind == NodeKind.SIMPLE_VARIABLE_REF) {
                        literalKeyName = ((BLangSimpleVarRef)literalKeyValue.key.expr).variableName.value;
                    } else if (nodeKind == NodeKind.LITERAL || nodeKind == NodeKind.NUMERIC_LITERAL) {
                        literalKeyName = ((BLangLiteral)literalKeyValue.key.expr).value.toString();
                    } else {
                        return false;
                    }
                    if (!(recordFields.containsKey(literalKeyName) ? !this.isValidStaticMatchPattern(recordFields.get(literalKeyName), literalKeyValue.valueExpr) : recordMatchType.sealed || !this.isValidStaticMatchPattern(recordMatchType.restFieldType, literalKeyValue.valueExpr))) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                if (literal.type.tag != 1) break;
                return true;
            }
            case 31: {
                if (literal.getKind() == NodeKind.LITERAL || literal.getKind() == NodeKind.NUMERIC_LITERAL) {
                    return this.types.isAssignableToFiniteType(matchType, (BLangLiteral)literal);
                }
                if (literal.getKind() != NodeKind.SIMPLE_VARIABLE_REF || ((BLangSimpleVarRef)literal).symbol.getKind() != SymbolKind.CONSTANT) break;
                BConstantSymbol constSymbol = (BConstantSymbol)((BLangSimpleVarRef)literal).symbol;
                return this.types.isAssignableToFiniteType(matchType, (BLangLiteral)((BFiniteType)constSymbol.type).getValueSpace().iterator().next());
            }
        }
        return false;
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.loopWithintransactionCheckStack.push(true);
        boolean statementReturns = this.statementReturns;
        this.checkStatementExecutionValidity(foreach);
        ++this.loopCount;
        this.analyzeNode(foreach.body, this.env);
        --this.loopCount;
        this.statementReturns = statementReturns;
        this.resetLastStatement();
        this.loopWithintransactionCheckStack.pop();
        this.analyzeExpr(foreach.collection);
    }

    @Override
    public void visit(BLangWhile whileNode) {
        this.loopWithintransactionCheckStack.push(true);
        boolean statementReturns = this.statementReturns;
        this.checkStatementExecutionValidity(whileNode);
        ++this.loopCount;
        this.analyzeNode(whileNode.body, this.env);
        --this.loopCount;
        this.statementReturns = statementReturns;
        this.resetLastStatement();
        this.loopWithintransactionCheckStack.pop();
        this.analyzeExpr(whileNode.expr);
    }

    @Override
    public void visit(BLangLock lockNode) {
        this.checkStatementExecutionValidity(lockNode);
        boolean previousWithinLockBlock = this.withinLockBlock;
        this.withinLockBlock = true;
        lockNode.body.stmts.forEach(e -> this.analyzeNode((BLangNode)e, this.env));
        this.withinLockBlock = previousWithinLockBlock;
    }

    @Override
    public void visit(BLangContinue continueNode) {
        this.checkStatementExecutionValidity(continueNode);
        if (this.loopCount == 0) {
            this.dlog.error(continueNode.pos, DiagnosticCode.CONTINUE_CANNOT_BE_OUTSIDE_LOOP, new Object[0]);
            return;
        }
        if (this.checkNextBreakValidityInTransaction()) {
            this.dlog.error(continueNode.pos, DiagnosticCode.CONTINUE_CANNOT_BE_USED_TO_EXIT_TRANSACTION, new Object[0]);
            return;
        }
        this.lastStatement = true;
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
        BPackageSymbol pkgSymbol = importPkgNode.symbol;
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgSymbol);
        if (pkgEnv == null) {
            return;
        }
        this.analyzeNode(pkgEnv.node, this.env);
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
    }

    @Override
    public void visit(BLangService serviceNode) {
    }

    @Override
    public void visit(BLangResource resourceNode) {
        throw new RuntimeException("Deprecated lang feature");
    }

    private void analyzeExportableTypeRef(BSymbol owner, BTypeSymbol symbol, boolean inFuncSignature, DiagnosticPos pos) {
        if (!inFuncSignature && Symbols.isFlagOn(owner.flags, 2048)) {
            return;
        }
        if (Symbols.isPublic(owner)) {
            this.checkForExportableType(symbol, pos);
        }
    }

    private void checkForExportableType(BTypeSymbol symbol, DiagnosticPos pos) {
        if (symbol == null || symbol.type == null || Symbols.isFlagOn(symbol.flags, 0x400000)) {
            return;
        }
        switch (symbol.type.tag) {
            case 19: {
                this.checkForExportableType(((BArrayType)symbol.type).eType.tsymbol, pos);
                return;
            }
            case 29: {
                BTupleType tupleType = (BTupleType)symbol.type;
                tupleType.tupleTypes.forEach(t -> this.checkForExportableType(t.tsymbol, pos));
                if (tupleType.restType != null) {
                    this.checkForExportableType(tupleType.restType.tsymbol, pos);
                }
                return;
            }
            case 15: {
                this.checkForExportableType(((BMapType)symbol.type).constraint.tsymbol, pos);
                return;
            }
            case 12: {
                if (!Symbols.isFlagOn(symbol.flags, 2048)) break;
                BRecordType recordType = (BRecordType)symbol.type;
                recordType.fields.forEach(f -> this.checkForExportableType(f.type.tsymbol, pos));
                if (recordType.restFieldType != null) {
                    this.checkForExportableType(recordType.restFieldType.tsymbol, pos);
                }
                return;
            }
            case 9: {
                BTableType tableType = (BTableType)symbol.type;
                if (tableType.constraint != null) {
                    this.checkForExportableType(tableType.constraint.tsymbol, pos);
                }
                return;
            }
            case 14: {
                BStreamType streamType = (BStreamType)symbol.type;
                if (streamType.constraint != null) {
                    this.checkForExportableType(streamType.constraint.tsymbol, pos);
                }
                return;
            }
            case 16: {
                BInvokableType invokableType = (BInvokableType)symbol.type;
                if (invokableType.paramTypes != null) {
                    for (BType paramType : invokableType.paramTypes) {
                        this.checkForExportableType(paramType.tsymbol, pos);
                    }
                }
                if (invokableType.restType != null) {
                    this.checkForExportableType(invokableType.restType.tsymbol, pos);
                }
                this.checkForExportableType(invokableType.retType.tsymbol, pos);
                return;
            }
        }
        if (!Symbols.isPublic(symbol)) {
            this.dlog.error(pos, DiagnosticCode.ATTEMPT_EXPOSE_NON_PUBLIC_SYMBOL, symbol.name);
        }
    }

    @Override
    public void visit(BLangLetExpression letExpression) {
        int ownerSymTag = this.env.scope.owner.tag;
        if ((ownerSymTag & 0x5005C) == 327772) {
            this.dlog.error(letExpression.pos, DiagnosticCode.LET_EXPRESSION_NOT_YET_SUPPORTED_RECORD_FIELD, new Object[0]);
        } else if ((ownerSymTag & 0x3005C) == 196700) {
            this.dlog.error(letExpression.pos, DiagnosticCode.LET_EXPRESSION_NOT_YET_SUPPORTED_OBJECT_FIELD, new Object[0]);
        }
        boolean returnStateBefore = this.statementReturns;
        this.statementReturns = false;
        for (BLangLetVariable letVariable : letExpression.letVarDeclarations) {
            this.analyzeNode((BLangNode)((Object)letVariable.definitionNode), letExpression.env);
        }
        this.statementReturns = returnStateBefore;
        this.analyzeExpr(letExpression.expr, letExpression.env);
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        this.analyzeTypeNode(varNode.typeNode, this.env);
        this.analyzeExpr(varNode.expr);
        if (Objects.isNull(varNode.symbol)) {
            return;
        }
        if (!Symbols.isPublic(varNode.symbol)) {
            return;
        }
        int ownerSymTag = this.env.scope.owner.tag;
        if ((ownerSymTag & 0x5005C) == 327772 || (ownerSymTag & 0x3005C) == 196700) {
            this.analyzeExportableTypeRef(this.env.scope.owner, varNode.type.tsymbol, false, varNode.pos);
        } else if ((ownerSymTag & 0x100) != 256) {
            this.analyzeExportableTypeRef(varNode.symbol, varNode.type.tsymbol, false, varNode.pos);
        }
        varNode.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, this.env));
    }

    private void checkWorkerPeerWorkerUsageInsideWorker(DiagnosticPos pos, BSymbol symbol, SymbolEnv env) {
        if ((symbol.flags & 0x1000000) == 0x1000000 && this.isCurrentPositionInWorker(env) && env.scope.lookup((Name)symbol.name).symbol == null) {
            if (this.referingForkedWorkerOutOfFork(symbol, env)) {
                return;
            }
            this.dlog.error(pos, DiagnosticCode.INVALID_WORKER_REFERRENCE, symbol.name);
        }
    }

    private boolean isCurrentPositionInWorker(SymbolEnv env) {
        if (env.enclInvokable != null && env.enclInvokable.flagSet.contains((Object)Flag.WORKER)) {
            return true;
        }
        if (env.enclEnv != null && env.enclEnv.node.getKind() != NodeKind.PACKAGE && env.enclEnv.node.getKind() != NodeKind.OBJECT_TYPE) {
            return this.isCurrentPositionInWorker(env.enclEnv);
        }
        return false;
    }

    private boolean referingForkedWorkerOutOfFork(BSymbol symbol, SymbolEnv env) {
        return (symbol.flags & 0x2000000) == 0x2000000 && env.enclInvokable.getKind() == NodeKind.FUNCTION && ((BLangFunction)env.enclInvokable).anonForkName == null;
    }

    @Override
    public void visit(BLangTupleVariable bLangTupleVariable) {
        if (bLangTupleVariable.typeNode != null) {
            this.analyzeNode(bLangTupleVariable.typeNode, this.env);
        }
        this.analyzeExpr(bLangTupleVariable.expr);
    }

    @Override
    public void visit(BLangRecordVariable bLangRecordVariable) {
        if (bLangRecordVariable.typeNode != null) {
            this.analyzeNode(bLangRecordVariable.typeNode, this.env);
        }
        this.analyzeExpr(bLangRecordVariable.expr);
    }

    @Override
    public void visit(BLangErrorVariable bLangErrorVariable) {
        if (bLangErrorVariable.typeNode != null) {
            this.analyzeNode(bLangErrorVariable.typeNode, this.env);
        }
        this.analyzeExpr(bLangErrorVariable.expr);
    }

    private BType getNilableType(BType type) {
        if (type.isNullable()) {
            return type;
        }
        BUnionType unionType = BUnionType.create(null, new BType[0]);
        if (type.tag == 20) {
            LinkedHashSet<BType> memTypes = new LinkedHashSet<BType>(((BUnionType)type).getMemberTypes());
            unionType.addAll(memTypes);
        }
        unionType.add(type);
        unionType.add(this.symTable.nilType);
        return unionType;
    }

    @Override
    public void visit(BLangIdentifier identifierNode) {
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
        annotationNode.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, this.env));
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
        BAnnotationSymbol annotationSymbol = annAttachmentNode.annotationSymbol;
        if (annotationSymbol != null && Symbols.isFlagOn(annotationSymbol.flags, 16)) {
            this.dlog.warning(annAttachmentNode.pos, DiagnosticCode.USAGE_OF_DEPRECATED_CONSTRUCT, annotationSymbol);
        }
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        this.checkStatementExecutionValidity(varDefNode);
        this.analyzeNode(varDefNode.var, this.env);
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignment) {
        this.checkStatementExecutionValidity(compoundAssignment);
        this.analyzeExpr(compoundAssignment.varRef);
        this.analyzeExpr(compoundAssignment.expr);
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        this.checkStatementExecutionValidity(assignNode);
        this.analyzeExpr(assignNode.varRef);
        this.analyzeExpr(assignNode.expr);
    }

    @Override
    public void visit(BLangRecordDestructure stmt) {
        this.checkDuplicateVarRefs(this.getVarRefs(stmt.varRef));
        this.checkStatementExecutionValidity(stmt);
        this.analyzeExpr(stmt.varRef);
        this.analyzeExpr(stmt.expr);
    }

    @Override
    public void visit(BLangErrorDestructure stmt) {
        this.checkDuplicateVarRefs(this.getVarRefs(stmt.varRef));
        this.checkStatementExecutionValidity(stmt);
        this.analyzeExpr(stmt.varRef);
        this.analyzeExpr(stmt.expr);
    }

    @Override
    public void visit(BLangTupleDestructure stmt) {
        this.checkDuplicateVarRefs(this.getVarRefs(stmt.varRef));
        this.checkStatementExecutionValidity(stmt);
        this.analyzeExpr(stmt.varRef);
        this.analyzeExpr(stmt.expr);
    }

    private void checkDuplicateVarRefs(List<BLangExpression> varRefs) {
        this.checkDuplicateVarRefs(varRefs, new HashSet<BSymbol>());
    }

    private void checkDuplicateVarRefs(List<BLangExpression> varRefs, Set<BSymbol> symbols) {
        for (BLangExpression varRef : varRefs) {
            if (varRef == null || varRef.getKind() != NodeKind.SIMPLE_VARIABLE_REF && varRef.getKind() != NodeKind.RECORD_VARIABLE_REF && varRef.getKind() != NodeKind.ERROR_VARIABLE_REF && varRef.getKind() != NodeKind.TUPLE_VARIABLE_REF || varRef.getKind() == NodeKind.SIMPLE_VARIABLE_REF && this.names.fromIdNode(((BLangSimpleVarRef)varRef).variableName) == Names.IGNORE) continue;
            if (varRef.getKind() == NodeKind.TUPLE_VARIABLE_REF) {
                this.checkDuplicateVarRefs(this.getVarRefs((BLangTupleVarRef)varRef), symbols);
            }
            if (varRef.getKind() == NodeKind.RECORD_VARIABLE_REF) {
                this.checkDuplicateVarRefs(this.getVarRefs((BLangRecordVarRef)varRef), symbols);
            }
            if (varRef.getKind() == NodeKind.ERROR_VARIABLE_REF) {
                this.checkDuplicateVarRefs(this.getVarRefs((BLangErrorVarRef)varRef), symbols);
            }
            BLangVariableReference varRefExpr = (BLangVariableReference)varRef;
            if (varRefExpr.symbol == null || symbols.add(varRefExpr.symbol)) continue;
            this.dlog.error(varRef.pos, DiagnosticCode.DUPLICATE_VARIABLE_IN_BINDING_PATTERN, varRefExpr.symbol);
        }
    }

    private List<BLangExpression> getVarRefs(BLangRecordVarRef varRef) {
        List<BLangExpression> varRefs = varRef.recordRefFields.stream().map(e -> e.variableReference).collect(Collectors.toList());
        varRefs.add((BLangExpression)varRef.restParam);
        return varRefs;
    }

    private List<BLangExpression> getVarRefs(BLangErrorVarRef varRef) {
        ArrayList<BLangExpression> varRefs = new ArrayList<BLangExpression>();
        varRefs.add(varRef.reason);
        varRefs.addAll(varRef.detail.stream().map(e -> e.expr).collect(Collectors.toList()));
        varRefs.add(varRef.restVar);
        return varRefs;
    }

    private List<BLangExpression> getVarRefs(BLangTupleVarRef varRef) {
        ArrayList<BLangExpression> varRefs = new ArrayList<BLangExpression>(varRef.expressions);
        varRefs.add((BLangExpression)varRef.restParam);
        return varRefs;
    }

    @Override
    public void visit(BLangBreak breakNode) {
        this.checkStatementExecutionValidity(breakNode);
        if (this.loopCount == 0) {
            this.dlog.error(breakNode.pos, DiagnosticCode.BREAK_CANNOT_BE_OUTSIDE_LOOP, new Object[0]);
            return;
        }
        if (this.checkNextBreakValidityInTransaction()) {
            this.dlog.error(breakNode.pos, DiagnosticCode.BREAK_CANNOT_BE_USED_TO_EXIT_TRANSACTION, new Object[0]);
            return;
        }
        this.lastStatement = true;
    }

    @Override
    public void visit(BLangThrow throwNode) {
    }

    @Override
    public void visit(BLangPanic panicNode) {
        this.checkStatementExecutionValidity(panicNode);
        this.statementReturns = true;
        this.analyzeExpr(panicNode.expr);
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        this.checkStatementExecutionValidity(xmlnsStmtNode);
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        this.checkStatementExecutionValidity(exprStmtNode);
        this.analyzeExpr(exprStmtNode.expr);
        this.validateExprStatementExpression(exprStmtNode);
    }

    private void validateExprStatementExpression(BLangExpressionStmt exprStmtNode) {
        BLangExpression expr = exprStmtNode.expr;
        if (expr.getKind() == NodeKind.WORKER_SYNC_SEND) {
            return;
        }
        while (expr.getKind() == NodeKind.MATCH_EXPRESSION || expr.getKind() == NodeKind.CHECK_EXPR || expr.getKind() == NodeKind.CHECK_PANIC_EXPR) {
            if (expr.getKind() == NodeKind.MATCH_EXPRESSION) {
                expr = ((BLangMatchExpression)expr).expr;
                continue;
            }
            if (expr.getKind() == NodeKind.CHECK_EXPR) {
                expr = ((BLangCheckedExpr)expr).expr;
                continue;
            }
            if (expr.getKind() != NodeKind.CHECK_PANIC_EXPR) continue;
            expr = ((BLangCheckPanickedExpr)expr).expr;
        }
        if (expr.getKind() == NodeKind.INVOCATION || expr.getKind() == NodeKind.WAIT_EXPR) {
            return;
        }
        if (expr.type == this.symTable.nilType) {
            this.dlog.error(exprStmtNode.pos, DiagnosticCode.INVALID_EXPR_STATEMENT, new Object[0]);
        }
    }

    @Override
    public void visit(BLangTryCatchFinally tryNode) {
    }

    @Override
    public void visit(BLangCatch catchNode) {
    }

    private boolean isTopLevel() {
        SymbolEnv env = this.env;
        return env.enclInvokable.body == env.node;
    }

    private boolean isInWorker() {
        return this.env.enclInvokable.flagSet.contains((Object)Flag.WORKER);
    }

    private boolean isCommunicationAllowedLocation(String workerIdentifier) {
        return this.isDefaultWorkerCommunication(workerIdentifier) && this.isInWorker() || this.isTopLevel();
    }

    private boolean isDefaultWorkerCommunication(String workerIdentifier) {
        return workerIdentifier.equals("default");
    }

    private boolean workerExists(BType type, String workerName) {
        if (this.isDefaultWorkerCommunication(workerName) && this.isInWorker()) {
            return true;
        }
        if (type == this.symTable.semanticError) {
            return false;
        }
        return type.tag == 30 && ((BFutureType)type).workerDerivative;
    }

    @Override
    public void visit(BLangWorkerSend workerSendNode) {
        BSymbol receiver = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromIdNode(workerSendNode.workerIdentifier));
        if ((receiver.tag & 0x34) != 52) {
            receiver = this.symTable.notFoundSymbol;
        }
        this.verifyPeerCommunication(workerSendNode.pos, receiver, workerSendNode.workerIdentifier.value);
        this.checkStatementExecutionValidity(workerSendNode);
        if (workerSendNode.isChannel) {
            this.analyzeExpr(workerSendNode.expr);
            if (workerSendNode.keyExpr != null) {
                this.analyzeExpr(workerSendNode.keyExpr);
            }
            return;
        }
        WorkerActionSystem was = this.workerActionSystemStack.peek();
        BType type = workerSendNode.expr.type;
        if (type == this.symTable.semanticError) {
            was.hasErrors = true;
        } else if (!type.isAnydata()) {
            this.dlog.error(workerSendNode.pos, DiagnosticCode.INVALID_TYPE_FOR_SEND, type);
        }
        String workerName = workerSendNode.workerIdentifier.getValue();
        boolean allowedLocation = this.isCommunicationAllowedLocation(workerName);
        if (!allowedLocation) {
            this.dlog.error(workerSendNode.pos, DiagnosticCode.INVALID_WORKER_SEND_POSITION, new Object[0]);
            was.hasErrors = true;
        }
        if (!this.workerExists(workerSendNode.type, workerName)) {
            this.dlog.error(workerSendNode.pos, DiagnosticCode.UNDEFINED_WORKER, workerName);
            was.hasErrors = true;
        }
        workerSendNode.type = this.createAccumulatedErrorTypeForMatchingRecive(workerSendNode.pos, workerSendNode.expr.type);
        was.addWorkerAction(workerSendNode);
        this.analyzeExpr(workerSendNode.expr);
        this.validateActionParentNode(workerSendNode.pos, workerSendNode.expr);
    }

    private BType createAccumulatedErrorTypeForMatchingRecive(DiagnosticPos pos, BType exprType) {
        Set returnTypesUpToNow = this.returnTypes.peek();
        LinkedHashSet<BType> returnTypeAndSendType = new LinkedHashSet<BType>(){
            {
                Comparator.comparing(BType::toString);
            }
        };
        for (BType returnType : returnTypesUpToNow) {
            if (returnType.tag == 27) {
                returnTypeAndSendType.add(returnType);
                continue;
            }
            this.dlog.error(pos, DiagnosticCode.WORKER_SEND_AFTER_RETURN, new Object[0]);
        }
        returnTypeAndSendType.add(exprType);
        if (returnTypeAndSendType.size() > 1) {
            return BUnionType.create(null, returnTypeAndSendType);
        }
        return exprType;
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        BSymbol receiver = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromIdNode(syncSendExpr.workerIdentifier));
        if ((receiver.tag & 0x34) != 52) {
            receiver = this.symTable.notFoundSymbol;
        }
        this.verifyPeerCommunication(syncSendExpr.pos, receiver, syncSendExpr.workerIdentifier.value);
        this.validateActionParentNode(syncSendExpr.pos, syncSendExpr);
        String workerName = syncSendExpr.workerIdentifier.getValue();
        WorkerActionSystem was = this.workerActionSystemStack.peek();
        boolean allowedLocation = this.isCommunicationAllowedLocation(workerName);
        if (!allowedLocation) {
            this.dlog.error(syncSendExpr.pos, DiagnosticCode.INVALID_WORKER_SEND_POSITION, new Object[0]);
            was.hasErrors = true;
        }
        if (!this.workerExists(syncSendExpr.workerType, workerName)) {
            this.dlog.error(syncSendExpr.pos, DiagnosticCode.UNDEFINED_WORKER, workerName);
            was.hasErrors = true;
        }
        syncSendExpr.type = this.createAccumulatedErrorTypeForMatchingRecive(syncSendExpr.pos, syncSendExpr.expr.type);
        was.addWorkerAction(syncSendExpr);
        this.analyzeExpr(syncSendExpr.expr);
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
        this.validateActionParentNode(workerReceiveNode.pos, workerReceiveNode);
        BSymbol sender = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromIdNode(workerReceiveNode.workerIdentifier));
        if ((sender.tag & 0x34) != 52) {
            sender = this.symTable.notFoundSymbol;
        }
        this.verifyPeerCommunication(workerReceiveNode.pos, sender, workerReceiveNode.workerIdentifier.value);
        if (workerReceiveNode.isChannel) {
            if (workerReceiveNode.keyExpr != null) {
                this.analyzeExpr(workerReceiveNode.keyExpr);
            }
            return;
        }
        WorkerActionSystem was = this.workerActionSystemStack.peek();
        String workerName = workerReceiveNode.workerIdentifier.getValue();
        boolean allowedLocation = this.isCommunicationAllowedLocation(workerName);
        if (!allowedLocation) {
            this.dlog.error(workerReceiveNode.pos, DiagnosticCode.INVALID_WORKER_RECEIVE_POSITION, new Object[0]);
            was.hasErrors = true;
        }
        if (!this.workerExists(workerReceiveNode.workerType, workerName)) {
            this.dlog.error(workerReceiveNode.pos, DiagnosticCode.UNDEFINED_WORKER, workerName);
            was.hasErrors = true;
        }
        workerReceiveNode.matchingSendsError = this.createAccumulatedErrorTypeForMatchingSyncSend(workerReceiveNode);
        was.addWorkerAction(workerReceiveNode);
    }

    private void verifyPeerCommunication(DiagnosticPos pos, BSymbol otherWorker, String otherWorkerName) {
        if (this.env.enclEnv.node.getKind() != NodeKind.FUNCTION) {
            return;
        }
        BLangFunction funcNode = (BLangFunction)this.env.enclEnv.node;
        Set flagSet = funcNode.flagSet;
        Name workerDerivedName = this.names.fromString("0" + otherWorker.name.value);
        if (flagSet.contains((Object)Flag.WORKER)) {
            if (otherWorkerName.equals("default")) {
                if (flagSet.contains((Object)Flag.FORKED)) {
                    this.dlog.error(pos, DiagnosticCode.WORKER_INTERACTIONS_ONLY_ALLOWED_BETWEEN_PEERS, new Object[0]);
                }
                return;
            }
            Scope enclFunctionScope = this.env.enclEnv.enclEnv.scope;
            BInvokableSymbol wLambda = (BInvokableSymbol)enclFunctionScope.lookup((Name)workerDerivedName).symbol;
            if (wLambda != null && funcNode.anonForkName != null && !funcNode.anonForkName.equals(wLambda.enclForkName)) {
                this.dlog.error(pos, DiagnosticCode.WORKER_INTERACTIONS_ONLY_ALLOWED_BETWEEN_PEERS, new Object[0]);
            }
        } else {
            BInvokableSymbol wLambda = (BInvokableSymbol)this.env.scope.lookup((Name)workerDerivedName).symbol;
            if (wLambda != null && wLambda.enclForkName != null) {
                this.dlog.error(pos, DiagnosticCode.WORKER_INTERACTIONS_ONLY_ALLOWED_BETWEEN_PEERS, new Object[0]);
            }
        }
    }

    public BType createAccumulatedErrorTypeForMatchingSyncSend(BLangWorkerReceive workerReceiveNode) {
        Set returnTypesUpToNow = this.returnTypes.peek();
        LinkedHashSet<BType> returnTypeAndSendType = new LinkedHashSet<BType>();
        for (BType returnType : returnTypesUpToNow) {
            if (returnType.tag == 27) {
                returnTypeAndSendType.add(returnType);
                continue;
            }
            this.dlog.error(workerReceiveNode.pos, DiagnosticCode.WORKER_RECEIVE_AFTER_RETURN, new Object[0]);
        }
        returnTypeAndSendType.add(this.symTable.nilType);
        if (returnTypeAndSendType.size() > 1) {
            return BUnionType.create(null, returnTypeAndSendType);
        }
        return this.symTable.nilType;
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
        if (literalExpr.type.tag == 10 && NULL_LITERAL.equals(literalExpr.originalValue) && !literalExpr.isJSONContext && !this.isJSONContext) {
            this.dlog.error(literalExpr.pos, DiagnosticCode.INVALID_USE_OF_NULL_LITERAL, new Object[0]);
        }
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        this.analyzeExprs(listConstructorExpr.exprs);
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        List<RecordLiteralNode.RecordField> fields = recordLiteral.fields;
        for (RecordLiteralNode.RecordField field : fields) {
            if (field.isKeyValueField()) {
                this.analyzeExpr(((BLangRecordLiteral.BLangRecordKeyValueField)field).valueExpr);
                continue;
            }
            if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                this.analyzeExpr((BLangRecordLiteral.BLangRecordVarNameField)field);
                continue;
            }
            this.analyzeExpr(((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr);
        }
        HashSet<Object> names = new HashSet<Object>();
        BType type = recordLiteral.type;
        boolean isOpenRecord = type != null && type.tag == 12 && !((BRecordType)type).sealed;
        for (RecordLiteralNode.RecordField field : fields) {
            Object name;
            BLangExpression keyExpr;
            if (field.getKind() == NodeKind.RECORD_LITERAL_SPREAD_OP) {
                BLangRecordLiteral.BLangRecordSpreadOperatorField spreadOpField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
                BLangExpression spreadOpExpr = spreadOpField.expr;
                this.analyzeExpr(spreadOpExpr);
                if (spreadOpExpr.type.tag != 12) continue;
                for (BField bField : ((BRecordType)spreadOpExpr.type).fields) {
                    if (Symbols.isOptional(bField.symbol)) continue;
                    String name2 = bField.name.value;
                    if (names.contains(name2)) {
                        this.dlog.error(spreadOpExpr.pos, DiagnosticCode.DUPLICATE_KEY_IN_RECORD_LITERAL_SPREAD_OP, recordLiteral.expectedType.getKind().typeName(), name2, spreadOpField);
                    }
                    names.add(name2);
                }
                continue;
            }
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKey key = ((BLangRecordLiteral.BLangRecordKeyValueField)field).key;
                keyExpr = key.expr;
                if (key.computedKey) {
                    this.analyzeExpr(keyExpr);
                    continue;
                }
            } else {
                keyExpr = (BLangRecordLiteral.BLangRecordVarNameField)field;
            }
            if (keyExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                name = ((BLangSimpleVarRef)keyExpr).variableName.value;
                if (names.contains(name)) {
                    this.dlog.error(keyExpr.pos, DiagnosticCode.DUPLICATE_KEY_IN_RECORD_LITERAL, recordLiteral.expectedType.getKind().typeName(), name);
                }
                if (isOpenRecord && ((BRecordType)type).fields.stream().noneMatch(arg_0 -> CodeAnalyzer.lambda$visit$27((String)name, arg_0))) {
                    this.dlog.error(keyExpr.pos, DiagnosticCode.INVALID_RECORD_LITERAL_IDENTIFIER_KEY, name);
                }
                names.add(name);
                continue;
            }
            if (keyExpr.getKind() != NodeKind.LITERAL && keyExpr.getKind() != NodeKind.NUMERIC_LITERAL) continue;
            name = ((BLangLiteral)keyExpr).value;
            if (names.contains(name)) {
                this.dlog.error(keyExpr.pos, DiagnosticCode.DUPLICATE_KEY_IN_RECORD_LITERAL, recordLiteral.parent.type.getKind().typeName(), name);
            }
            names.add(name);
        }
    }

    @Override
    public void visit(BLangTableLiteral tableLiteral) {
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        switch (varRefExpr.parent.getKind()) {
            case WORKER_RECEIVE: 
            case WORKER_SEND: 
            case WORKER_SYNC_SEND: {
                return;
            }
        }
        if (varRefExpr.type != null && varRefExpr.type.tag == 30) {
            this.checkWorkerPeerWorkerUsageInsideWorker(varRefExpr.pos, varRefExpr.symbol, this.env);
        }
        if (varRefExpr.symbol != null && Symbols.isFlagOn(varRefExpr.symbol.flags, 16)) {
            this.dlog.warning(varRefExpr.pos, DiagnosticCode.USAGE_OF_DEPRECATED_CONSTRUCT, varRefExpr);
        }
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        this.analyzeExpr(fieldAccessExpr.expr);
        BSymbol symbol = fieldAccessExpr.symbol;
        if (symbol != null && Symbols.isFlagOn(fieldAccessExpr.symbol.flags, 16)) {
            this.dlog.warning(fieldAccessExpr.pos, DiagnosticCode.USAGE_OF_DEPRECATED_CONSTRUCT, fieldAccessExpr);
        }
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        this.analyzeExpr(indexAccessExpr.indexExpr);
        this.analyzeExpr(indexAccessExpr.expr);
    }

    @Override
    public void visit(BLangInvocation invocationExpr) {
        this.analyzeExpr(invocationExpr.expr);
        this.analyzeExprs(invocationExpr.requiredArgs);
        this.analyzeExprs(invocationExpr.restArgs);
        if (invocationExpr.symbol != null && invocationExpr.symbol.kind == SymbolKind.FUNCTION) {
            BSymbol funcSymbol = invocationExpr.symbol;
            if (Symbols.isFlagOn(funcSymbol.flags, 16)) {
                this.dlog.warning(invocationExpr.pos, DiagnosticCode.USAGE_OF_DEPRECATED_CONSTRUCT, invocationExpr);
            }
        }
        if (invocationExpr.actionInvocation || invocationExpr.async) {
            if (invocationExpr.actionInvocation || !this.withinLockBlock) {
                this.validateActionInvocation(invocationExpr.pos, invocationExpr);
                return;
            }
            this.dlog.error(invocationExpr.pos, invocationExpr.functionPointerInvocation ? DiagnosticCode.USAGE_OF_WORKER_WITHIN_LOCK_IS_PROHIBITED : DiagnosticCode.USAGE_OF_START_WITHIN_LOCK_IS_PROHIBITED, new Object[0]);
        }
    }

    private void validateActionInvocation(DiagnosticPos pos, BLangInvocation iExpr) {
        if (iExpr.expr != null) {
            NodeKind clientNodeKind = iExpr.expr.getKind();
            if (clientNodeKind != NodeKind.SIMPLE_VARIABLE_REF && clientNodeKind != NodeKind.FIELD_BASED_ACCESS_EXPR) {
                this.dlog.error(pos, DiagnosticCode.INVALID_ACTION_INVOCATION_AS_EXPR, new Object[0]);
            } else if (clientNodeKind == NodeKind.FIELD_BASED_ACCESS_EXPR) {
                BLangFieldBasedAccess fieldBasedAccess = (BLangFieldBasedAccess)iExpr.expr;
                if (fieldBasedAccess.expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
                    this.dlog.error(pos, DiagnosticCode.INVALID_ACTION_INVOCATION_AS_EXPR, new Object[0]);
                } else {
                    BLangSimpleVarRef selfName = (BLangSimpleVarRef)fieldBasedAccess.expr;
                    if (!Names.SELF.equals(selfName.symbol.name)) {
                        this.dlog.error(pos, DiagnosticCode.INVALID_ACTION_INVOCATION_AS_EXPR, new Object[0]);
                    }
                }
            }
        }
        this.validateActionParentNode(pos, iExpr);
    }

    private void validateActionParentNode(DiagnosticPos pos, BLangNode node) {
        BLangNode parent = node.parent;
        if (parent.getKind() == NodeKind.BLOCK) {
            return;
        }
        while (parent != null) {
            NodeKind kind = parent.getKind();
            if (kind == NodeKind.ASSIGNMENT || kind == NodeKind.EXPRESSION_STATEMENT || kind == NodeKind.RETURN || kind == NodeKind.RECORD_DESTRUCTURE || kind == NodeKind.ERROR_DESTRUCTURE || kind == NodeKind.TUPLE_DESTRUCTURE || kind == NodeKind.VARIABLE || kind == NodeKind.RECORD_VARIABLE || kind == NodeKind.TUPLE_VARIABLE || kind == NodeKind.ERROR_VARIABLE || kind == NodeKind.MATCH || kind == NodeKind.FOREACH) {
                return;
            }
            if (kind == NodeKind.CHECK_PANIC_EXPR || kind == NodeKind.CHECK_EXPR || kind == NodeKind.WORKER_RECEIVE || kind == NodeKind.WORKER_FLUSH || kind == NodeKind.WORKER_SEND || kind == NodeKind.WAIT_EXPR || kind == NodeKind.GROUP_EXPR || kind == NodeKind.TRAP_EXPR) {
                parent = parent.parent;
                if (parent.getKind() != NodeKind.BLOCK && parent.getKind() != NodeKind.BLOCK_FUNCTION_BODY) continue;
                return;
            }
            if (kind != NodeKind.ELVIS_EXPR || ((BLangElvisExpr)parent).lhsExpr.getKind() != NodeKind.INVOCATION || !((BLangInvocation)((BLangElvisExpr)parent).lhsExpr).actionInvocation) break;
            parent = parent.parent;
        }
        this.dlog.error(pos, DiagnosticCode.INVALID_ACTION_INVOCATION_AS_EXPR, new Object[0]);
    }

    @Override
    public void visit(BLangTypeInit cIExpr) {
        this.analyzeExprs(cIExpr.argsExpr);
        this.analyzeExpr(cIExpr.initInvocation);
        BType type = cIExpr.type;
        if (cIExpr.userDefinedType != null && Symbols.isFlagOn(type.tsymbol.flags, 16)) {
            this.dlog.warning(cIExpr.pos, DiagnosticCode.USAGE_OF_DEPRECATED_CONSTRUCT, type);
        }
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        boolean isJSONCtx;
        this.analyzeExpr(ternaryExpr.expr);
        this.isJSONContext = isJSONCtx = this.getIsJSONContext(ternaryExpr.type);
        this.analyzeExpr(ternaryExpr.thenExpr);
        this.isJSONContext = isJSONCtx;
        this.analyzeExpr(ternaryExpr.elseExpr);
    }

    @Override
    public void visit(BLangWaitExpr awaitExpr) {
        this.analyzeExpr(awaitExpr.getExpression());
        this.validateActionParentNode(awaitExpr.pos, awaitExpr);
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr) {
        waitForAllExpr.keyValuePairs.forEach(keyValue -> {
            BLangExpression expr = keyValue.valueExpr != null ? keyValue.valueExpr : keyValue.keyExpr;
            this.analyzeExpr(expr);
        });
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        this.analyzeExpr(xmlElementAccess.expr);
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        this.analyzeExpr(xmlNavigation.expr);
        if (xmlNavigation.childIndex != null) {
            if (xmlNavigation.navAccessType == XMLNavigationAccess.NavAccessType.DESCENDANTS || xmlNavigation.navAccessType == XMLNavigationAccess.NavAccessType.CHILDREN) {
                this.dlog.error(xmlNavigation.pos, DiagnosticCode.UNSUPPORTED_INDEX_IN_XML_NAVIGATION, new Object[0]);
            }
            this.analyzeExpr(xmlNavigation.childIndex);
        }
        this.validateMethodInvocationsInXMLNavigationExpression(xmlNavigation);
    }

    private void validateMethodInvocationsInXMLNavigationExpression(BLangXMLNavigationAccess expression) {
        if (!expression.methodInvocationAnalyzed && expression.parent.getKind() == NodeKind.INVOCATION) {
            BLangInvocation invocation = (BLangInvocation)expression.parent;
            if (invocation.argExprs.contains(expression) && (invocation.symbol.flags & 0x800000) != 0x800000) {
                return;
            }
            this.dlog.error(invocation.pos, DiagnosticCode.UNSUPPORTED_METHOD_INVOCATION_XML_NAV, new Object[0]);
        }
        expression.methodInvocationAnalyzed = true;
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        BLangIdentifier flushWrkIdentifier = workerFlushExpr.workerIdentifier;
        Stack<WorkerActionSystem> workerActionSystems = this.workerActionSystemStack;
        WorkerActionSystem currentWrkerAction = workerActionSystems.peek();
        List<BLangWorkerSend> sendStmts = this.getAsyncSendStmtsOfWorker(currentWrkerAction);
        if (flushWrkIdentifier != null) {
            List sendsToGivenWrkr = sendStmts.stream().filter(bLangNode -> bLangNode.workerIdentifier.equals(flushWrkIdentifier)).collect(Collectors.toList());
            if (sendsToGivenWrkr.size() == 0) {
                this.dlog.error(workerFlushExpr.pos, DiagnosticCode.INVALID_WORKER_FLUSH_FOR_WORKER, flushWrkIdentifier, currentWrkerAction.currentWorkerId());
                return;
            }
            sendStmts = sendsToGivenWrkr;
        } else if (sendStmts.size() == 0) {
            this.dlog.error(workerFlushExpr.pos, DiagnosticCode.INVALID_WORKER_FLUSH, currentWrkerAction.currentWorkerId());
            return;
        }
        workerFlushExpr.cachedWorkerSendStmts = sendStmts;
        this.validateActionParentNode(workerFlushExpr.pos, workerFlushExpr);
    }

    private List<BLangWorkerSend> getAsyncSendStmtsOfWorker(WorkerActionSystem currentWorkerAction) {
        List<BLangNode> actions = ((WorkerActionStateMachine)((WorkerActionSystem)currentWorkerAction).workerActionStateMachines.peek()).actions;
        return actions.stream().filter(CodeAnalyzer::isWorkerSend).map(bLangNode -> (BLangWorkerSend)bLangNode).collect(Collectors.toList());
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        this.analyzeExpr(trapExpr.expr);
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        if (this.validateBinaryExpr(binaryExpr)) {
            boolean isJSONCtx;
            this.isJSONContext = isJSONCtx = this.getIsJSONContext(binaryExpr.lhsExpr.type, binaryExpr.rhsExpr.type);
            this.analyzeExpr(binaryExpr.lhsExpr);
            this.isJSONContext = isJSONCtx;
            this.analyzeExpr(binaryExpr.rhsExpr);
        }
    }

    private boolean validateBinaryExpr(BLangBinaryExpr binaryExpr) {
        if (binaryExpr.lhsExpr.type.tag != 30 && binaryExpr.rhsExpr.type.tag != 30) {
            return true;
        }
        BLangNode parentNode = binaryExpr.parent;
        if (binaryExpr.lhsExpr.type.tag == 30 || binaryExpr.rhsExpr.type.tag == 30) {
            if (parentNode == null) {
                return false;
            }
            if (parentNode.getKind() == NodeKind.WAIT_EXPR) {
                return true;
            }
        }
        if (parentNode.getKind() != NodeKind.BINARY_EXPR && binaryExpr.opKind == OperatorKind.BITWISE_OR) {
            this.dlog.error(binaryExpr.pos, DiagnosticCode.OPERATOR_NOT_SUPPORTED, new Object[]{OperatorKind.BITWISE_OR, this.symTable.futureType});
            return false;
        }
        if (parentNode.getKind() == NodeKind.BINARY_EXPR) {
            return this.validateBinaryExpr((BLangBinaryExpr)parentNode);
        }
        return true;
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        this.analyzeExpr(elvisExpr.lhsExpr);
        this.analyzeExpr(elvisExpr.rhsExpr);
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        this.analyzeExpr(groupExpr.expression);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        this.analyzeExpr(unaryExpr.expr);
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        this.analyzeExpr(conversionExpr.expr);
        conversionExpr.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, this.env));
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        this.analyzeExpr(xmlAttribute.name);
        this.analyzeExpr(xmlAttribute.value);
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        this.analyzeExpr(xmlElementLiteral.startTagName);
        this.analyzeExpr(xmlElementLiteral.endTagName);
        this.analyzeExprs(xmlElementLiteral.attributes);
        this.analyzeExprs(xmlElementLiteral.children);
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        this.analyzeExprs(xmlTextLiteral.textFragments);
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        this.analyzeExprs(xmlCommentLiteral.textFragments);
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        this.analyzeExprs(xmlProcInsLiteral.dataFragments);
        this.analyzeExpr(xmlProcInsLiteral.target);
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        this.analyzeExprs(xmlQuotedString.textFragments);
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        this.analyzeExprs(stringTemplateLiteral.exprs);
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        String workerVarName;
        boolean isWorker = false;
        if (bLangLambdaFunction.parent.getKind() == NodeKind.VARIABLE && (workerVarName = ((BLangSimpleVariable)bLangLambdaFunction.parent).name.value).startsWith("0")) {
            String workerName = workerVarName.substring(1);
            isWorker = true;
            this.workerActionSystemStack.peek().startWorkerActionStateMachine(workerName, bLangLambdaFunction.function.pos, bLangLambdaFunction.function);
        }
        boolean statementReturn = this.statementReturns;
        this.visitFunction(bLangLambdaFunction.function);
        this.statementReturns = statementReturn;
        if (isWorker) {
            this.workerActionSystemStack.peek().endWorkerActionStateMachine();
        }
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        this.analyzeExpr(bLangArrowFunction.body.expr);
    }

    @Override
    public void visit(BLangXMLAttributeAccess xmlAttributeAccessExpr) {
        this.analyzeExpr(xmlAttributeAccessExpr.expr);
        this.analyzeExpr(xmlAttributeAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangIntRangeExpression intRangeExpression) {
        this.analyzeExpr(intRangeExpression.startExpr);
        this.analyzeExpr(intRangeExpression.endExpr);
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        SymbolEnv recordEnv = SymbolEnv.createTypeEnv(recordTypeNode, recordTypeNode.symbol.scope, this.env);
        if (recordTypeNode.isFieldAnalyseRequired) {
            recordTypeNode.fields.forEach(field -> this.analyzeNode((BLangNode)field, recordEnv));
        }
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        SymbolEnv objectEnv = SymbolEnv.createTypeEnv(objectTypeNode, objectTypeNode.symbol.scope, this.env);
        if (objectTypeNode.isFieldAnalyseRequired) {
            objectTypeNode.fields.forEach(field -> this.analyzeNode((BLangNode)field, objectEnv));
        }
        Stream.concat(objectTypeNode.functions.stream(), Optional.ofNullable(objectTypeNode.initFunction).map(Stream::of).orElseGet(Stream::empty)).sorted(Comparator.comparingInt(fn -> fn.pos.sLine)).forEachOrdered(fn -> this.analyzeNode((BLangNode)fn, objectEnv));
    }

    @Override
    public void visit(BLangValueType valueType) {
    }

    @Override
    public void visit(BLangArrayType arrayType) {
        this.analyzeTypeNode(arrayType.elemtype, this.env);
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode builtInRefType) {
    }

    @Override
    public void visit(BLangConstrainedType constrainedType) {
        this.analyzeTypeNode(constrainedType.constraint, this.env);
    }

    @Override
    public void visit(BLangStreamType streamType) {
        this.analyzeTypeNode(streamType.constraint, this.env);
        this.analyzeTypeNode(streamType.error, this.env);
    }

    @Override
    public void visit(BLangErrorType errorType) {
        this.analyzeTypeNode(errorType.reasonType, this.env);
        this.analyzeTypeNode(errorType.detailType, this.env);
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType) {
        BTypeSymbol typeSymbol = userDefinedType.type.tsymbol;
        if (typeSymbol != null && Symbols.isFlagOn(typeSymbol.flags, 16)) {
            this.dlog.warning(userDefinedType.pos, DiagnosticCode.USAGE_OF_DEPRECATED_CONSTRUCT, userDefinedType);
        }
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        tupleTypeNode.memberTypeNodes.forEach(memberType -> this.analyzeTypeNode((BLangType)memberType, this.env));
        this.analyzeTypeNode(tupleTypeNode.restParamType, this.env);
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        unionTypeNode.memberTypeNodes.forEach(memberType -> this.analyzeTypeNode((BLangType)memberType, this.env));
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        functionTypeNode.params.forEach(node -> this.analyzeNode((BLangNode)node, this.env));
        this.analyzeTypeNode(functionTypeNode.returnTypeNode, this.env);
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        this.analyzeExpr(bLangVarArgsExpression.expr);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        this.analyzeExpr(bLangNamedArgsExpression.expr);
    }

    @Override
    public void visit(BLangMatchExpression bLangMatchExpression) {
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.analyzeExpr(checkedExpr.expr);
        if (this.env.scope.owner.getKind() == SymbolKind.PACKAGE) {
            return;
        }
        BType exprType = this.env.enclInvokable.getReturnTypeNode().type;
        if (!this.types.isAssignable(this.getErrorTypes(checkedExpr.expr.type), exprType)) {
            this.dlog.error(checkedExpr.pos, DiagnosticCode.CHECKED_EXPR_NO_MATCHING_ERROR_RETURN_IN_ENCL_INVOKABLE, new Object[0]);
        }
        if (this.checkReturnValidityInTransaction()) {
            this.dlog.error(checkedExpr.pos, DiagnosticCode.CHECK_EXPRESSION_INVALID_USAGE_WITHIN_TRANSACTION_BLOCK, new Object[0]);
            return;
        }
        this.returnTypes.peek().add(exprType);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkPanicExpr) {
        this.analyzeExpr(checkPanicExpr.expr);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        int fromCount = 0;
        for (FromClauseNode fromClauseNode : queryExpr.fromClauseList) {
            BLangExpression collection = (BLangExpression)fromClauseNode.getCollection();
            if (++fromCount > 1 && 14 == collection.type.tag) {
                this.dlog.error(collection.pos, DiagnosticCode.NOT_ALLOWED_STREAM_USAGE_WITH_FROM, new Object[0]);
            }
            this.analyzeNode((BLangFromClause)fromClauseNode, this.env);
        }
        for (WhereClauseNode whereClauseNode : queryExpr.whereClauseList) {
            this.analyzeNode((BLangWhereClause)whereClauseNode, this.env);
        }
        this.analyzeNode(queryExpr.selectClause, this.env);
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        int fromCount = 0;
        for (FromClauseNode fromClauseNode : queryAction.fromClauseList) {
            BLangExpression collection = (BLangExpression)fromClauseNode.getCollection();
            if (++fromCount > 1 && 14 == collection.type.tag) {
                this.dlog.error(collection.pos, DiagnosticCode.NOT_ALLOWED_STREAM_USAGE_WITH_FROM, new Object[0]);
            }
            this.analyzeNode((BLangFromClause)fromClauseNode, this.env);
        }
        for (WhereClauseNode whereClauseNode : queryAction.whereClauseList) {
            this.analyzeNode((BLangWhereClause)whereClauseNode, this.env);
        }
        this.analyzeNode(queryAction.doClause, this.env);
        this.validateActionParentNode(queryAction.pos, queryAction);
    }

    @Override
    public void visit(BLangFromClause fromClause) {
        this.analyzeExpr(fromClause.collection);
    }

    @Override
    public void visit(BLangWhereClause whereClause) {
        this.analyzeExpr(whereClause.expression);
    }

    @Override
    public void visit(BLangSelectClause selectClause) {
        this.analyzeExpr(selectClause.expression);
    }

    @Override
    public void visit(BLangDoClause doClause) {
        this.analyzeNode(doClause.body, this.env);
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        this.analyzeNode(typeTestExpr.expr, this.env);
        if (typeTestExpr.typeNode.type == this.symTable.semanticError || typeTestExpr.expr.type == this.symTable.semanticError) {
            return;
        }
        if (this.types.isAssignable(typeTestExpr.expr.type, typeTestExpr.typeNode.type)) {
            this.dlog.error(typeTestExpr.pos, DiagnosticCode.UNNECESSARY_CONDITION, new Object[0]);
            return;
        }
        if (!this.types.isAssignable(typeTestExpr.typeNode.type, typeTestExpr.expr.type) && !this.indirectIntersectionExists(typeTestExpr.expr, typeTestExpr.typeNode.type)) {
            this.dlog.error(typeTestExpr.pos, DiagnosticCode.INCOMPATIBLE_TYPE_CHECK, typeTestExpr.expr.type, typeTestExpr.typeNode.type);
        }
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        this.analyzeExpr(annotAccessExpr.expr);
        BAnnotationSymbol annotationSymbol = annotAccessExpr.annotationSymbol;
        if (annotationSymbol != null && Symbols.isFlagOn(annotationSymbol.flags, 16)) {
            this.dlog.warning(annotAccessExpr.pos, DiagnosticCode.USAGE_OF_DEPRECATED_CONSTRUCT, annotationSymbol);
        }
    }

    private boolean indirectIntersectionExists(BLangExpression expression, BType testType) {
        BType expressionType = expression.type;
        switch (expressionType.tag) {
            case 20: {
                if (this.types.getTypeForUnionTypeMembersAssignableToType((BUnionType)expressionType, testType) == this.symTable.semanticError) break;
                return true;
            }
            case 31: {
                if (this.types.getTypeForFiniteTypeValuesAssignableToType((BFiniteType)expressionType, testType) == this.symTable.semanticError) break;
                return true;
            }
        }
        switch (testType.tag) {
            case 20: {
                return this.types.getTypeForUnionTypeMembersAssignableToType((BUnionType)testType, expressionType) != this.symTable.semanticError;
            }
            case 31: {
                return this.types.getTypeForFiniteTypeValuesAssignableToType((BFiniteType)testType, expressionType) != this.symTable.semanticError;
            }
        }
        return false;
    }

    private <E extends BLangExpression> void analyzeExpr(E node) {
        if (node == null) {
            return;
        }
        BLangNode myParent = this.parent;
        node.parent = this.parent;
        this.parent = node;
        node.accept(this);
        this.isJSONContext = false;
        this.parent = myParent;
        this.checkAccess(node);
    }

    private <E extends BLangExpression> void analyzeExpr(E node, SymbolEnv env) {
        if (node == null) {
            return;
        }
        SymbolEnv prevEnv = this.env;
        this.env = env;
        BLangNode myParent = this.parent;
        node.parent = this.parent;
        this.parent = node;
        node.accept(this);
        this.isJSONContext = false;
        this.parent = myParent;
        this.checkAccess(node);
        this.env = prevEnv;
    }

    @Override
    public void visit(BLangConstant constant) {
        this.analyzeTypeNode(constant.typeNode, this.env);
        this.analyzeNode(constant.expr, this.env);
        this.analyzeExportableTypeRef(constant.symbol, constant.symbol.type.tsymbol, false, constant.pos);
        constant.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, this.env));
    }

    private <E extends BLangExpression> void checkAccess(E node) {
        if (node.type != null) {
            this.checkAccessSymbol(node.type.tsymbol, node.pos);
        }
        if (node.getKind() == NodeKind.INVOCATION) {
            BLangInvocation bLangInvocation = (BLangInvocation)node;
            this.checkAccessSymbol(bLangInvocation.symbol, bLangInvocation.pos);
        }
    }

    private void checkAccessSymbol(BSymbol symbol, DiagnosticPos position) {
        if (symbol == null) {
            return;
        }
        if (this.env.enclPkg.symbol.pkgID != symbol.pkgID && !Symbols.isPublic(symbol)) {
            this.dlog.error(position, DiagnosticCode.ATTEMPT_REFER_NON_ACCESSIBLE_SYMBOL, symbol.name);
        }
    }

    private <E extends BLangExpression> void analyzeExprs(List<E> nodeList) {
        for (int i = 0; i < nodeList.size(); ++i) {
            this.analyzeExpr((BLangExpression)nodeList.get(i));
        }
    }

    private void initNewWorkerActionSystem() {
        this.workerActionSystemStack.push(new WorkerActionSystem());
    }

    private void finalizeCurrentWorkerActionSystem() {
        WorkerActionSystem was = this.workerActionSystemStack.pop();
        if (!was.hasErrors) {
            this.validateWorkerInteractions(was);
        }
    }

    private static boolean isWorkerSend(BLangNode action) {
        return action.getKind() == NodeKind.WORKER_SEND;
    }

    private static boolean isWorkerSyncSend(BLangNode action) {
        return action.getKind() == NodeKind.WORKER_SYNC_SEND;
    }

    private String extractWorkerId(BLangNode action) {
        if (CodeAnalyzer.isWorkerSend(action)) {
            return ((BLangWorkerSend)action).workerIdentifier.value;
        }
        if (CodeAnalyzer.isWorkerSyncSend(action)) {
            return ((BLangWorkerSyncSendExpr)action).workerIdentifier.value;
        }
        return ((BLangWorkerReceive)action).workerIdentifier.value;
    }

    private void validateWorkerInteractions(WorkerActionSystem workerActionSystem) {
        boolean systemRunning;
        do {
            systemRunning = false;
            for (WorkerActionStateMachine worker : workerActionSystem.finshedWorkers) {
                WorkerActionStateMachine otherSM;
                BLangNode currentAction;
                if (worker.done() || !CodeAnalyzer.isWorkerSend(currentAction = worker.currentAction()) && !CodeAnalyzer.isWorkerSyncSend(currentAction) || (otherSM = workerActionSystem.find(this.extractWorkerId(currentAction))) == null || !otherSM.currentIsReceive(worker.workerId)) continue;
                BLangWorkerReceive receive = (BLangWorkerReceive)otherSM.currentAction();
                if (CodeAnalyzer.isWorkerSyncSend(currentAction)) {
                    this.validateWorkerActionParameters((BLangWorkerSyncSendExpr)currentAction, receive);
                } else {
                    this.validateWorkerActionParameters((BLangWorkerSend)currentAction, receive);
                }
                otherSM.next();
                worker.next();
                systemRunning = true;
                String channelName = CodeAnalyzer.generateChannelName(worker.workerId, otherSM.workerId);
                otherSM.node.sendsToThis.add(channelName);
                worker.node.sendsToThis.add(channelName);
            }
        } while (systemRunning);
        if (!workerActionSystem.everyoneDone()) {
            this.reportInvalidWorkerInteractionDiagnostics(workerActionSystem);
        }
    }

    private void reportInvalidWorkerInteractionDiagnostics(WorkerActionSystem workerActionSystem) {
        this.dlog.error(workerActionSystem.getRootPosition(), DiagnosticCode.INVALID_WORKER_INTERACTION, workerActionSystem.toString());
    }

    private void validateWorkerActionParameters(BLangWorkerSend send, BLangWorkerReceive receive) {
        this.types.checkType(receive, send.type, receive.type);
        this.addImplicitCast(send.type, receive);
        NodeKind kind = receive.parent.getKind();
        if (kind == NodeKind.TRAP_EXPR || kind == NodeKind.CHECK_EXPR || kind == NodeKind.CHECK_PANIC_EXPR) {
            this.typeChecker.checkExpr((BLangExpression)receive.parent, receive.env);
        }
        receive.sendExpression = send.expr;
    }

    private void validateWorkerActionParameters(BLangWorkerSyncSendExpr send, BLangWorkerReceive receive) {
        send.receive = receive;
        NodeKind parentNodeKind = send.parent.getKind();
        if (parentNodeKind == NodeKind.VARIABLE) {
            BLangSimpleVariable variable = (BLangSimpleVariable)send.parent;
            if (variable.isDeclaredWithVar) {
                variable.symbol.type = send.expectedType = receive.matchingSendsError;
                variable.type = send.expectedType;
            }
        } else if (parentNodeKind == NodeKind.ASSIGNMENT) {
            BSymbol varSymbol;
            BLangAssignment assignment = (BLangAssignment)send.parent;
            if (assignment.varRef.getKind() == NodeKind.SIMPLE_VARIABLE_REF && (varSymbol = ((BLangSimpleVarRef)assignment.varRef).symbol) != null) {
                send.expectedType = varSymbol.type;
            }
        }
        if (receive.matchingSendsError != this.symTable.nilType && parentNodeKind == NodeKind.EXPRESSION_STATEMENT) {
            this.dlog.error(send.pos, DiagnosticCode.ASSIGNMENT_REQUIRED, new Object[0]);
        } else {
            this.types.checkType(send.pos, receive.matchingSendsError, send.expectedType, DiagnosticCode.INCOMPATIBLE_TYPES);
        }
        this.types.checkType(receive, send.type, receive.type);
        this.addImplicitCast(send.type, receive);
        NodeKind kind = receive.parent.getKind();
        if (kind == NodeKind.TRAP_EXPR || kind == NodeKind.CHECK_EXPR || kind == NodeKind.CHECK_PANIC_EXPR) {
            this.typeChecker.checkExpr((BLangExpression)receive.parent, receive.env);
        }
        receive.sendExpression = send;
    }

    private void addImplicitCast(BType actualType, BLangWorkerReceive receive) {
        if (receive.type != null && receive.type != this.symTable.semanticError) {
            this.types.setImplicitCastExpr(receive, actualType, receive.type);
            receive.type = actualType;
        }
    }

    private boolean checkNextBreakValidityInTransaction() {
        return this.loopWithintransactionCheckStack.peek() == false && this.transactionCount > 0;
    }

    private boolean checkReturnValidityInTransaction() {
        return (this.returnWithintransactionCheckStack.empty() || this.returnWithintransactionCheckStack.peek() == false) && this.transactionCount > 0;
    }

    private boolean isValidTransactionBlock() {
        return !this.withinRetryBlock && !this.withinAbortedBlock && !this.withinCommittedBlock;
    }

    private void validateMainFunction(BLangFunction funcNode) {
        if (!"main".equals(funcNode.name.value)) {
            return;
        }
        if (!Symbols.isPublic(funcNode.symbol)) {
            this.dlog.error(funcNode.pos, DiagnosticCode.MAIN_SHOULD_BE_PUBLIC, new Object[0]);
        }
        funcNode.requiredParams.forEach(param -> {
            if (!param.type.isAnydata()) {
                this.dlog.error(param.pos, DiagnosticCode.MAIN_PARAMS_SHOULD_BE_ANYDATA, param.type);
            }
        });
        if (funcNode.restParam != null && !funcNode.restParam.type.isAnydata()) {
            this.dlog.error(funcNode.restParam.pos, DiagnosticCode.MAIN_PARAMS_SHOULD_BE_ANYDATA, funcNode.restParam.type);
        }
        this.types.validateErrorOrNilReturn(funcNode, DiagnosticCode.MAIN_RETURN_SHOULD_BE_ERROR_OR_NIL);
    }

    private void validateModuleInitFunction(BLangFunction funcNode) {
        if (funcNode.attachedFunction || !Names.USER_DEFINED_INIT_SUFFIX.value.equals(funcNode.name.value)) {
            return;
        }
        if (Symbols.isPublic(funcNode.symbol)) {
            this.dlog.error(funcNode.pos, DiagnosticCode.MODULE_INIT_CANNOT_BE_PUBLIC, new Object[0]);
        }
        if (!funcNode.requiredParams.isEmpty() || funcNode.restParam != null) {
            this.dlog.error(funcNode.pos, DiagnosticCode.MODULE_INIT_CANNOT_HAVE_PARAMS, new Object[0]);
        }
        this.types.validateErrorOrNilReturn(funcNode, DiagnosticCode.MODULE_INIT_RETURN_SHOULD_BE_ERROR_OR_NIL);
    }

    private boolean getIsJSONContext(BType ... arg) {
        if (this.isJSONContext) {
            return true;
        }
        for (BType type : arg) {
            if (!this.types.isJSONContext(type)) continue;
            return true;
        }
        return false;
    }

    private BType getErrorTypes(BType bType) {
        BType errorType = this.symTable.semanticError;
        int tag = bType.tag;
        if (tag == 27) {
            errorType = bType;
        } else if (tag == 20) {
            LinkedHashSet<BType> errTypes = new LinkedHashSet<BType>();
            Set<BType> memTypes = ((BUnionType)bType).getMemberTypes();
            for (BType memType : memTypes) {
                if (memType.tag != 27) continue;
                errTypes.add(memType);
            }
            errorType = errTypes.size() == 1 ? (BType)errTypes.iterator().next() : BUnionType.create(null, errTypes);
        }
        return errorType;
    }

    private void checkExperimentalFeatureValidity(ExperimentalFeatures constructName, DiagnosticPos pos) {
        if (this.enableExperimentalFeatures) {
            return;
        }
        this.dlog.error(pos, DiagnosticCode.INVALID_USE_OF_EXPERIMENTAL_FEATURE, constructName.value);
    }

    public static String generateChannelName(String source, String target) {
        return source + "->" + target;
    }

    private static /* synthetic */ boolean lambda$visit$27(String name, BField recField) {
        return name.equals(recField.name.value);
    }

    private static enum ExperimentalFeatures {
        TRANSACTIONS("transaction"),
        LOCK("lock"),
        XML_ACCESS("xml access expression"),
        XML_ATTRIBUTES_ACCESS("xml attribute expression");

        private String value;

        private ExperimentalFeatures(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    private static class WorkerActionStateMachine {
        private static final String WORKER_SM_FINISHED = "FINISHED";
        public int currentState;
        public List<BLangNode> actions = new ArrayList<BLangNode>();
        public DiagnosticPos pos;
        public String workerId;
        public BLangFunction node;

        public WorkerActionStateMachine(DiagnosticPos pos, String workerId, BLangFunction node) {
            this.pos = pos;
            this.workerId = workerId;
            this.node = node;
        }

        public boolean done() {
            return this.actions.size() == this.currentState;
        }

        public BLangNode currentAction() {
            return this.actions.get(this.currentState);
        }

        public boolean currentIsReceive(String sourceWorkerId) {
            if (this.done()) {
                return false;
            }
            BLangNode action = this.currentAction();
            return !CodeAnalyzer.isWorkerSend(action) && !CodeAnalyzer.isWorkerSyncSend(action) && ((BLangWorkerReceive)action).workerIdentifier.value.equals(sourceWorkerId);
        }

        public void next() {
            ++this.currentState;
        }

        public String toString() {
            if (this.done()) {
                return WORKER_SM_FINISHED;
            }
            BLangNode action = this.currentAction();
            if (CodeAnalyzer.isWorkerSend(action)) {
                return ((BLangWorkerSend)action).toActionString();
            }
            if (CodeAnalyzer.isWorkerSyncSend(action)) {
                return ((BLangWorkerSyncSendExpr)action).toActionString();
            }
            return ((BLangWorkerReceive)action).toActionString();
        }
    }

    private static class WorkerActionSystem {
        public List<WorkerActionStateMachine> finshedWorkers = new ArrayList<WorkerActionStateMachine>();
        private Stack<WorkerActionStateMachine> workerActionStateMachines = new Stack();
        private boolean hasErrors = false;

        private WorkerActionSystem() {
        }

        public void startWorkerActionStateMachine(String workerId, DiagnosticPos pos, BLangFunction node) {
            this.workerActionStateMachines.push(new WorkerActionStateMachine(pos, workerId, node));
        }

        public void endWorkerActionStateMachine() {
            this.finshedWorkers.add(this.workerActionStateMachines.pop());
        }

        public void addWorkerAction(BLangNode action) {
            this.workerActionStateMachines.peek().actions.add(action);
        }

        public WorkerActionStateMachine find(String workerId) {
            for (WorkerActionStateMachine worker : this.finshedWorkers) {
                if (!worker.workerId.equals(workerId)) continue;
                return worker;
            }
            throw new AssertionError((Object)("Reference to non existing worker " + workerId));
        }

        public boolean everyoneDone() {
            return this.finshedWorkers.stream().allMatch(WorkerActionStateMachine::done);
        }

        public DiagnosticPos getRootPosition() {
            return this.finshedWorkers.iterator().next().pos;
        }

        public String toString() {
            return this.finshedWorkers.toString();
        }

        public String currentWorkerId() {
            return this.workerActionStateMachines.peek().workerId;
        }
    }
}

