/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.clauses.FromClauseNode;
import org.ballerinalang.model.clauses.LetClauseNode;
import org.ballerinalang.model.clauses.WhereClauseNode;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.elements.TableColumnFlag;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.expressions.NamedArgNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticCode;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.parser.NodeCloner;
import org.wso2.ballerinalang.compiler.semantics.analyzer.ConstantAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemanticAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolEnter;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeNarrower;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeParamAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BLetSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIntRangeExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttributeAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementFilter;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.ClosureVarSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.FieldKind;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.NumericLiteralSupport;
import org.wso2.ballerinalang.compiler.util.TypeDefBuilderHelper;
import org.wso2.ballerinalang.compiler.util.TypeTags;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;
import org.wso2.ballerinalang.util.Flags;
import org.wso2.ballerinalang.util.Lists;

public class TypeChecker
extends BLangNodeVisitor {
    private static final CompilerContext.Key<TypeChecker> TYPE_CHECKER_KEY = new CompilerContext.Key();
    private static final String TABLE_TNAME = "table";
    private Names names;
    private SymbolTable symTable;
    private SymbolEnter symbolEnter;
    private SymbolResolver symResolver;
    private NodeCloner nodeCloner;
    private Types types;
    private BLangDiagnosticLogHelper dlog;
    private SymbolEnv env;
    private boolean isTypeChecked;
    private TypeNarrower typeNarrower;
    private TypeParamAnalyzer typeParamAnalyzer;
    private BLangAnonymousModelHelper anonymousModelHelper;
    private SemanticAnalyzer semanticAnalyzer;
    private boolean nonErrorLoggingCheck = false;
    private int letCount = 0;
    private BType expType;
    private BType resultType;
    private DiagnosticCode diagCode;

    public static TypeChecker getInstance(CompilerContext context) {
        TypeChecker typeChecker = context.get(TYPE_CHECKER_KEY);
        if (typeChecker == null) {
            typeChecker = new TypeChecker(context);
        }
        return typeChecker;
    }

    public TypeChecker(CompilerContext context) {
        context.put(TYPE_CHECKER_KEY, this);
        this.names = Names.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.symbolEnter = SymbolEnter.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.nodeCloner = NodeCloner.getInstance(context);
        this.types = Types.getInstance(context);
        this.dlog = BLangDiagnosticLogHelper.getInstance(context);
        this.typeNarrower = TypeNarrower.getInstance(context);
        this.typeParamAnalyzer = TypeParamAnalyzer.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
        this.semanticAnalyzer = SemanticAnalyzer.getInstance(context);
    }

    public BType checkExpr(BLangExpression expr, SymbolEnv env) {
        return this.checkExpr(expr, env, this.symTable.noType);
    }

    public BType checkExpr(BLangExpression expr, SymbolEnv env, BType expType) {
        return this.checkExpr(expr, env, expType, DiagnosticCode.INCOMPATIBLE_TYPES);
    }

    public List<BType> checkExprs(List<BLangExpression> exprs, SymbolEnv env, BType expType) {
        ArrayList<BType> resTypes = new ArrayList<BType>(exprs.size());
        for (BLangExpression expr : exprs) {
            resTypes.add(this.checkExpr(expr, env, expType));
        }
        return resTypes;
    }

    public BType checkExpr(BLangExpression expr, SymbolEnv env, BType expType, DiagnosticCode diagCode) {
        if (expr.typeChecked) {
            return expr.type;
        }
        SymbolEnv prevEnv = this.env;
        BType preExpType = this.expType;
        DiagnosticCode preDiagCode = this.diagCode;
        this.env = env;
        this.diagCode = diagCode;
        this.expType = expType;
        this.isTypeChecked = true;
        expr.expectedType = expType;
        expr.accept(this);
        expr.type = this.resultType;
        expr.typeChecked = this.isTypeChecked;
        this.env = prevEnv;
        this.expType = preExpType;
        this.diagCode = preDiagCode;
        if (this.resultType.tag != 26) {
            expr.expectedType = this.resultType;
        }
        return this.resultType;
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
        BType literalType = this.setLiteralValueAndGetType(literalExpr, this.expType);
        if (literalType == this.symTable.semanticError || literalExpr.isFiniteContext) {
            return;
        }
        this.resultType = this.types.checkType(literalExpr, literalType, this.expType);
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        this.checkXMLNamespacePrefixes(xmlElementAccess.filters);
        this.resultType = this.checkExpr(xmlElementAccess.expr, this.env, this.symTable.xmlType);
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        if (xmlNavigation.lhsVar) {
            this.dlog.error(xmlNavigation.pos, DiagnosticCode.CANNOT_UPDATE_XML_SEQUENCE, new Object[0]);
        }
        this.checkXMLNamespacePrefixes(xmlNavigation.filters);
        if (xmlNavigation.childIndex != null) {
            this.checkExpr(xmlNavigation.childIndex, this.env, this.symTable.intType);
        }
        this.resultType = this.checkExpr(xmlNavigation.expr, this.env, this.symTable.xmlType);
    }

    private void checkXMLNamespacePrefixes(List<BLangXMLElementFilter> filters) {
        for (BLangXMLElementFilter filter : filters) {
            BSymbol nsSymbol;
            if (filter.namespace.isEmpty()) continue;
            Name nsName = this.names.fromString(filter.namespace);
            filter.namespaceSymbol = nsSymbol = this.symResolver.lookupSymbolInPrefixSpace(this.env, nsName);
            if (nsSymbol != this.symTable.notFoundSymbol) continue;
            this.dlog.error(filter.nsPos, DiagnosticCode.CANNOT_FIND_XML_NAMESPACE, nsName);
        }
    }

    private BType setLiteralValueAndGetType(BLangLiteral literalExpr, BType expType) {
        BType literalType = this.symTable.getTypeFromTag(literalExpr.type.tag);
        Object literalValue = literalExpr.value;
        literalExpr.isJSONContext = this.types.isJSONContext(expType);
        if (literalType.tag == 1) {
            if (expType.tag == 3) {
                literalType = this.symTable.floatType;
                literalExpr.value = ((Long)literalValue).doubleValue();
            } else if (expType.tag == 4) {
                literalType = this.symTable.decimalType;
                literalExpr.value = String.valueOf(literalValue);
            } else if (TypeTags.isIntegerTypeTag(expType.tag) || expType.tag == 2) {
                if ((literalType = this.getIntLiteralType(literalExpr.pos, expType, literalType, literalValue)) == this.symTable.semanticError) {
                    return this.symTable.semanticError;
                }
            } else if (expType.tag == 31 && this.types.isAssignableToFiniteType(expType, literalExpr)) {
                BFiniteType finiteType = (BFiniteType)expType;
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 1)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.intType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 2)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.byteType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 3)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.floatType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 4)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.decimalType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 36)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.signed32IntType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 37)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.signed16IntType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 38)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.signed8IntType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 39)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.unsigned32IntType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 40)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.unsigned16IntType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 41)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.unsigned8IntType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
            } else if (expType.tag == 20) {
                BType setType;
                Set<BType> memberTypes = ((BUnionType)expType).getMemberTypes();
                if (memberTypes.stream().anyMatch(memType -> memType.tag == 1 || memType.tag == 7 || memType.tag == 11 || memType.tag == 17)) {
                    return this.setLiteralValueAndGetType(literalExpr, this.symTable.intType);
                }
                BType finiteType = this.getFiniteTypeWithValuesOfSingleType((BUnionType)expType, this.symTable.intType);
                if (finiteType != this.symTable.semanticError) {
                    setType = this.setLiteralValueAndGetType(literalExpr, finiteType);
                    if (literalExpr.isFiniteContext) {
                        return setType;
                    }
                }
                if (memberTypes.stream().anyMatch(memType -> memType.tag == 2)) {
                    return this.setLiteralValueAndGetType(literalExpr, this.symTable.byteType);
                }
                finiteType = this.getFiniteTypeWithValuesOfSingleType((BUnionType)expType, this.symTable.byteType);
                if (finiteType != this.symTable.semanticError) {
                    setType = this.setLiteralValueAndGetType(literalExpr, finiteType);
                    if (literalExpr.isFiniteContext) {
                        return setType;
                    }
                }
                if (memberTypes.stream().anyMatch(memType -> memType.tag == 3)) {
                    return this.setLiteralValueAndGetType(literalExpr, this.symTable.floatType);
                }
                finiteType = this.getFiniteTypeWithValuesOfSingleType((BUnionType)expType, this.symTable.floatType);
                if (finiteType != this.symTable.semanticError) {
                    setType = this.setLiteralValueAndGetType(literalExpr, finiteType);
                    if (literalExpr.isFiniteContext) {
                        return setType;
                    }
                }
                if (memberTypes.stream().anyMatch(memType -> memType.tag == 4)) {
                    return this.setLiteralValueAndGetType(literalExpr, this.symTable.decimalType);
                }
                finiteType = this.getFiniteTypeWithValuesOfSingleType((BUnionType)expType, this.symTable.decimalType);
                if (finiteType != this.symTable.semanticError) {
                    setType = this.setLiteralValueAndGetType(literalExpr, finiteType);
                    if (literalExpr.isFiniteContext) {
                        return setType;
                    }
                }
            }
        } else if (literalType.tag == 3) {
            BUnionType unionType;
            BType unionMember;
            String literal = String.valueOf(literalValue);
            String numericLiteral = NumericLiteralSupport.stripDiscriminator(literal);
            boolean isDiscriminatedFloat = NumericLiteralSupport.isFloatDiscriminated(literal);
            if (expType.tag == 4) {
                if (isDiscriminatedFloat || NumericLiteralSupport.isHexLiteral(numericLiteral)) {
                    this.dlog.error(literalExpr.pos, DiagnosticCode.INCOMPATIBLE_TYPES, expType, this.symTable.floatType);
                    this.resultType = this.symTable.semanticError;
                    return this.resultType;
                }
                literalType = this.symTable.decimalType;
                literalExpr.value = numericLiteral;
            } else if (expType.tag == 3) {
                literalExpr.value = Double.parseDouble(String.valueOf(numericLiteral));
            } else if (expType.tag == 31 && this.types.isAssignableToFiniteType(expType, literalExpr)) {
                BFiniteType finiteType = (BFiniteType)expType;
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 3)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.floatType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (!isDiscriminatedFloat && this.literalAssignableToFiniteType(literalExpr, finiteType, 4)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.decimalType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
            } else if (expType.tag == 20 && (unionMember = this.getAndSetAssignableUnionMember(literalExpr, unionType = (BUnionType)expType, this.symTable.floatType)) != this.symTable.noType) {
                return unionMember;
            }
        } else {
            BUnionType unionType;
            boolean foundMember;
            if (literalType.tag == 4) {
                return this.decimalLiteral(literalValue, literalExpr, expType);
            }
            if (literalType.tag == 5 && this.expType.tag == 42 && this.types.isCharLiteralValue((String)literalValue)) {
                return this.symTable.charStringType;
            }
            if (this.expType.tag == 31) {
                boolean foundMember2 = this.types.isAssignableToFiniteType(this.expType, literalExpr);
                if (foundMember2) {
                    this.setLiteralValueForFiniteType(literalExpr, literalType);
                    return literalType;
                }
            } else if (this.expType.tag == 20 && (foundMember = (unionType = (BUnionType)this.expType).getMemberTypes().stream().anyMatch(memberType -> this.types.isAssignableToFiniteType((BType)memberType, literalExpr)))) {
                this.setLiteralValueForFiniteType(literalExpr, literalType);
                return literalType;
            }
        }
        if (literalExpr.type.tag == 33) {
            literalType = new BArrayType(this.symTable.byteType);
        }
        return literalType;
    }

    private BType getAndSetAssignableUnionMember(BLangLiteral literalExpr, BUnionType expType, BType desiredType) {
        BType setType;
        Set<BType> memberTypes = expType.getMemberTypes();
        if (memberTypes.stream().anyMatch(memType -> memType.tag == desiredType.tag || memType.tag == 7 || memType.tag == 11 || memType.tag == 17)) {
            return this.setLiteralValueAndGetType(literalExpr, desiredType);
        }
        BType finiteType = this.getFiniteTypeWithValuesOfSingleType(expType, this.symTable.floatType);
        if (finiteType != this.symTable.semanticError) {
            setType = this.setLiteralValueAndGetType(literalExpr, finiteType);
            if (literalExpr.isFiniteContext) {
                return setType;
            }
        }
        if (memberTypes.stream().anyMatch(memType -> memType.tag == 4)) {
            return this.setLiteralValueAndGetType(literalExpr, this.symTable.decimalType);
        }
        finiteType = this.getFiniteTypeWithValuesOfSingleType(expType, this.symTable.decimalType);
        if (finiteType != this.symTable.semanticError) {
            setType = this.setLiteralValueAndGetType(literalExpr, finiteType);
            if (literalExpr.isFiniteContext) {
                return setType;
            }
        }
        return this.symTable.noType;
    }

    private boolean literalAssignableToFiniteType(BLangLiteral literalExpr, BFiniteType finiteType, int targetMemberTypeTag) {
        for (BLangExpression valueExpr : finiteType.getValueSpace()) {
            if (valueExpr.type.tag != targetMemberTypeTag || !this.types.checkLiteralAssignabilityBasedOnType((BLangLiteral)valueExpr, literalExpr)) continue;
            return true;
        }
        return false;
    }

    private BType decimalLiteral(Object literalValue, BLangLiteral literalExpr, BType expType) {
        BUnionType unionType;
        BType unionMember;
        String literal = String.valueOf(literalValue);
        if (expType.tag == 3 && NumericLiteralSupport.isDecimalDiscriminated(literal)) {
            this.dlog.error(literalExpr.pos, DiagnosticCode.INCOMPATIBLE_TYPES, expType, this.symTable.decimalType);
            this.resultType = this.symTable.semanticError;
            return this.resultType;
        }
        if (expType.tag == 31 && this.types.isAssignableToFiniteType(expType, literalExpr)) {
            BFiniteType finiteType = (BFiniteType)expType;
            if (this.literalAssignableToFiniteType(literalExpr, finiteType, 4)) {
                BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.decimalType);
                this.setLiteralValueForFiniteType(literalExpr, valueType);
                return valueType;
            }
        } else if (expType.tag == 20 && (unionMember = this.getAndSetAssignableUnionMember(literalExpr, unionType = (BUnionType)expType, this.symTable.decimalType)) != this.symTable.noType) {
            return unionMember;
        }
        literalExpr.value = NumericLiteralSupport.stripDiscriminator(literal);
        this.resultType = this.symTable.decimalType;
        return this.symTable.decimalType;
    }

    private void setLiteralValueForFiniteType(BLangLiteral literalExpr, BType type) {
        this.types.setImplicitCastExpr(literalExpr, type, this.expType);
        this.resultType = type;
        literalExpr.isFiniteContext = true;
    }

    private BType getFiniteTypeWithValuesOfSingleType(BUnionType unionType, BType matchType) {
        List finiteTypeMembers = unionType.getMemberTypes().stream().filter(memType -> memType.tag == 31).map(memFiniteType -> (BFiniteType)memFiniteType).collect(Collectors.toList());
        if (finiteTypeMembers.isEmpty()) {
            return this.symTable.semanticError;
        }
        int tag = matchType.tag;
        LinkedHashSet<BLangExpression> matchedValueSpace = new LinkedHashSet<BLangExpression>();
        for (BFiniteType finiteType : finiteTypeMembers) {
            HashSet<BLangExpression> set = new HashSet<BLangExpression>();
            for (BLangExpression expression : finiteType.getValueSpace()) {
                if (expression.type.tag != tag) continue;
                set.add(expression);
            }
            matchedValueSpace.addAll(set);
        }
        if (matchedValueSpace.isEmpty()) {
            return this.symTable.semanticError;
        }
        return new BFiniteType(null, matchedValueSpace);
    }

    private BType getIntLiteralType(DiagnosticPos pos, BType expType, BType literalType, Object literalValue) {
        switch (expType.tag) {
            case 1: {
                return this.symTable.intType;
            }
            case 2: {
                if (!this.types.isByteLiteralValue((Long)literalValue)) break;
                return this.symTable.byteType;
            }
            case 36: {
                if (!this.types.isSigned32LiteralValue((Long)literalValue)) break;
                return this.symTable.signed32IntType;
            }
            case 37: {
                if (!this.types.isSigned16LiteralValue((Long)literalValue)) break;
                return this.symTable.signed16IntType;
            }
            case 38: {
                if (!this.types.isSigned8LiteralValue((Long)literalValue)) break;
                return this.symTable.signed8IntType;
            }
            case 39: {
                if (!this.types.isUnsigned32LiteralValue((Long)literalValue)) break;
                return this.symTable.unsigned32IntType;
            }
            case 40: {
                if (!this.types.isUnsigned16LiteralValue((Long)literalValue)) break;
                return this.symTable.unsigned16IntType;
            }
            case 41: {
                if (!this.types.isUnsigned8LiteralValue((Long)literalValue)) break;
                return this.symTable.unsigned8IntType;
            }
        }
        this.dlog.error(pos, DiagnosticCode.INCOMPATIBLE_TYPES, expType, literalType);
        this.resultType = this.symTable.semanticError;
        return this.resultType;
    }

    @Override
    public void visit(BLangTableLiteral tableLiteral) {
        if (this.expType.tag == this.symTable.semanticError.tag) {
            return;
        }
        if (this.expType.getKind() != TypeKind.TABLE) {
            this.dlog.error(tableLiteral.pos, DiagnosticCode.CANNOT_INFER_TABLE_TYPE, new Object[0]);
            this.resultType = this.symTable.semanticError;
            return;
        }
        BType tableConstraint = ((BTableType)this.expType).getConstraint();
        if (tableConstraint.tag == 22) {
            this.dlog.error(tableLiteral.pos, DiagnosticCode.TABLE_CANNOT_BE_CREATED_WITHOUT_CONSTRAINT, new Object[0]);
            return;
        }
        if (tableConstraint.tag != 12) {
            this.dlog.error(tableLiteral.pos, DiagnosticCode.TABLE_CONSTRAINT_MUST_BE_A_RECORD_TYPE, new Object[0]);
            return;
        }
        this.validateTableColumns(tableConstraint, tableLiteral);
        this.checkExprs(tableLiteral.tableDataRows, this.env, tableConstraint);
        this.resultType = this.types.checkType(tableLiteral, this.expType, this.symTable.noType);
    }

    private void validateTableColumns(BType tableConstraint, BLangTableLiteral tableLiteral) {
        if (tableConstraint.tag != 26) {
            ArrayList<String> columnNames = new ArrayList<String>();
            for (BField field : ((BRecordType)tableConstraint).fields) {
                columnNames.add(field.getName().getValue());
                if (field.type.tag != 1 && field.type.tag != 5 && field.type.tag != 3 && field.type.tag != 4 && field.type.tag != 8 && field.type.tag != 7 && field.type.tag != 6 && field.type.tag != 19) {
                    this.dlog.error(tableLiteral.pos, DiagnosticCode.FIELD_NOT_ALLOWED_WITH_TABLE_COLUMN, field.name.value, field.type);
                }
                if (field.type.tag != 19) continue;
                BType arrayType = ((BArrayType)field.type).eType;
                if (arrayType.tag == 1 || arrayType.tag == 3 || arrayType.tag == 4 || arrayType.tag == 5 || arrayType.tag == 6 || arrayType.tag == 2) continue;
                this.dlog.error(tableLiteral.pos, DiagnosticCode.FIELD_NOT_ALLOWED_WITH_TABLE_COLUMN, field.name.value, field.type);
            }
            block1: for (BLangTableLiteral.BLangTableColumn column : tableLiteral.columns) {
                boolean contains = columnNames.contains(column.columnName);
                if (!contains) {
                    this.dlog.error(column.pos, DiagnosticCode.UNDEFINED_TABLE_COLUMN, column.columnName, tableConstraint);
                }
                if (!column.flagSet.contains((Object)TableColumnFlag.PRIMARYKEY)) continue;
                for (BField field : ((BRecordType)tableConstraint).fields) {
                    if (!field.name.value.equals(column.columnName)) continue;
                    if (field.type.tag == 1 || field.type.tag == 5) continue block1;
                    this.dlog.error(column.pos, DiagnosticCode.TYPE_NOT_ALLOWED_WITH_PRIMARYKEY, column.columnName, field.type);
                    continue block1;
                }
            }
        }
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructor) {
        if (this.expType.tag == 22) {
            BType inferredType = this.getInferredTupleType(listConstructor);
            if (inferredType != this.symTable.semanticError) {
                this.resultType = this.types.checkType(listConstructor, inferredType, this.expType);
            }
            return;
        }
        this.resultType = this.checkListConstructorCompatibility(this.expType, listConstructor);
    }

    private BType checkListConstructorCompatibility(BType bType, BLangListConstructorExpr listConstructor) {
        if (bType.tag == 20) {
            boolean prevNonErrorLoggingCheck = this.nonErrorLoggingCheck;
            this.nonErrorLoggingCheck = true;
            BLangDiagnosticLog prevDLog = this.dlog.getCurrentLog();
            this.dlog.setNonConsoleDLog();
            ArrayList<BType> compatibleTypes = new ArrayList<BType>();
            for (BType memberType : ((BUnionType)bType).getMemberTypes()) {
                BType listCompatibleMemType = this.getListConstructorCompatibleNonUnionType(memberType);
                if (listCompatibleMemType == this.symTable.semanticError) continue;
                BType memCompatibiltyType = this.checkListConstructorCompatibility(listCompatibleMemType, listConstructor);
                if (memCompatibiltyType != this.symTable.semanticError && this.dlog.getErrorCount() == 0 && this.isUniqueType(compatibleTypes, memCompatibiltyType)) {
                    compatibleTypes.add(memCompatibiltyType);
                }
                this.dlog.resetErrorCount();
            }
            this.dlog.setCurrentLog(prevDLog);
            this.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
            if (compatibleTypes.isEmpty()) {
                BLangListConstructorExpr exprToLog = listConstructor;
                if (this.nonErrorLoggingCheck) {
                    ++listConstructor.cloneAttempt;
                    exprToLog = this.nodeCloner.clone(listConstructor);
                }
                this.dlog.error(listConstructor.pos, DiagnosticCode.INCOMPATIBLE_TYPES, this.expType, this.getInferredTupleType(exprToLog));
                return this.symTable.semanticError;
            }
            if (compatibleTypes.size() != 1) {
                this.dlog.error(listConstructor.pos, DiagnosticCode.AMBIGUOUS_TYPES, this.expType);
                return this.symTable.semanticError;
            }
            return this.checkListConstructorCompatibility((BType)compatibleTypes.get(0), listConstructor);
        }
        BType possibleType = this.getListConstructorCompatibleNonUnionType(bType);
        switch (possibleType.tag) {
            case 19: {
                return this.checkArrayType(listConstructor, (BArrayType)possibleType);
            }
            case 29: {
                return this.checkTupleType(listConstructor, (BTupleType)possibleType);
            }
            case 13: {
                ArrayList<BType> results = new ArrayList<BType>();
                listConstructor.isTypedescExpr = true;
                for (int i = 0; i < listConstructor.exprs.size(); ++i) {
                    results.add(this.checkExpr(listConstructor.exprs.get(i), this.env, this.symTable.noType));
                }
                ArrayList<BType> actualTypes = new ArrayList<BType>();
                for (int i = 0; i < listConstructor.exprs.size(); ++i) {
                    BLangExpression expr = listConstructor.exprs.get(i);
                    if (expr.getKind() == NodeKind.TYPEDESC_EXPRESSION) {
                        actualTypes.add(((BLangTypedescExpr)expr).resolvedType);
                        continue;
                    }
                    if (expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                        actualTypes.add(((BLangSimpleVarRef)expr).symbol.type);
                        continue;
                    }
                    actualTypes.add((BType)results.get(i));
                }
                listConstructor.typedescType = actualTypes.size() == 1 ? (BType)actualTypes.get(0) : new BTupleType(actualTypes);
                return new BTypedescType(listConstructor.typedescType, null);
            }
        }
        BLangListConstructorExpr exprToLog = listConstructor;
        if (this.nonErrorLoggingCheck) {
            ++listConstructor.cloneAttempt;
            exprToLog = this.nodeCloner.clone(listConstructor);
        }
        this.dlog.error(listConstructor.pos, DiagnosticCode.INCOMPATIBLE_TYPES, bType, this.getInferredTupleType(exprToLog));
        return this.symTable.semanticError;
    }

    private BType getListConstructorCompatibleNonUnionType(BType type) {
        switch (type.tag) {
            case 13: 
            case 19: 
            case 29: {
                return type;
            }
            case 7: {
                return this.symTable.arrayJsonType;
            }
            case 11: {
                return this.symTable.arrayAnydataType;
            }
            case 17: {
                return this.symTable.arrayType;
            }
        }
        return this.symTable.semanticError;
    }

    private BType checkArrayType(BLangListConstructorExpr listConstructor, BArrayType arrayType) {
        BType eType = arrayType.eType;
        if (arrayType.state == BArrayState.OPEN_SEALED) {
            arrayType.size = listConstructor.exprs.size();
            arrayType.state = BArrayState.CLOSED_SEALED;
        } else if (arrayType.state != BArrayState.UNSEALED && arrayType.size != listConstructor.exprs.size()) {
            if (arrayType.size < listConstructor.exprs.size()) {
                this.dlog.error(listConstructor.pos, DiagnosticCode.MISMATCHING_ARRAY_LITERAL_VALUES, arrayType.size, listConstructor.exprs.size());
                return this.symTable.semanticError;
            }
            if (!this.types.hasFillerValue(eType)) {
                this.dlog.error(listConstructor.pos, DiagnosticCode.INVALID_LIST_CONSTRUCTOR_ELEMENT_TYPE, this.expType);
                return this.symTable.semanticError;
            }
        }
        boolean errored = false;
        for (BLangExpression expr : listConstructor.exprs) {
            if (!this.exprIncompatible(eType, expr) || errored) continue;
            errored = true;
        }
        return errored ? this.symTable.semanticError : arrayType;
    }

    private BType checkTupleType(BLangListConstructorExpr listConstructor, BTupleType tupleType) {
        int i;
        int memberTypeSize;
        List<BLangExpression> exprs = listConstructor.exprs;
        List<BType> memberTypes = tupleType.tupleTypes;
        BType restType = tupleType.restType;
        int listExprSize = exprs.size();
        if (listExprSize < (memberTypeSize = memberTypes.size())) {
            for (int i2 = listExprSize; i2 < memberTypeSize; ++i2) {
                if (this.types.hasFillerValue(memberTypes.get(i2))) continue;
                this.dlog.error(listConstructor.pos, DiagnosticCode.SYNTAX_ERROR, "tuple and expression size does not match");
                return this.symTable.semanticError;
            }
        } else if (listExprSize > memberTypeSize && restType == null) {
            this.dlog.error(listConstructor.pos, DiagnosticCode.SYNTAX_ERROR, "tuple and expression size does not match");
            return this.symTable.semanticError;
        }
        boolean errored = false;
        int nonRestCountToCheck = listExprSize < memberTypeSize ? listExprSize : memberTypeSize;
        for (i = 0; i < nonRestCountToCheck; ++i) {
            if (!this.exprIncompatible(memberTypes.get(i), exprs.get(i)) || errored) continue;
            errored = true;
        }
        for (i = nonRestCountToCheck; i < exprs.size(); ++i) {
            if (!this.exprIncompatible(restType, exprs.get(i)) || errored) continue;
            errored = true;
        }
        return errored ? this.symTable.semanticError : tupleType;
    }

    private boolean exprIncompatible(BType eType, BLangExpression expr) {
        if (expr.typeChecked) {
            return expr.type == this.symTable.semanticError;
        }
        BLangExpression exprToCheck = expr;
        if (this.nonErrorLoggingCheck) {
            ++expr.cloneAttempt;
            exprToCheck = this.nodeCloner.clone(expr);
        }
        return this.checkExpr(exprToCheck, this.env, eType) == this.symTable.semanticError;
    }

    private BType[] getExprListUniqueTypes(List<BLangExpression> exprs, SymbolEnv env) {
        LinkedHashSet<BType> typesSet = new LinkedHashSet<BType>(this.checkExprList(exprs, env));
        return typesSet.toArray(new BType[0]);
    }

    private List<BType> checkExprList(List<BLangExpression> exprs, SymbolEnv env) {
        ArrayList<BType> types = new ArrayList<BType>();
        SymbolEnv prevEnv = this.env;
        BType preExpType = this.expType;
        this.env = env;
        this.expType = this.symTable.noType;
        for (BLangExpression e : exprs) {
            this.checkExpr(e, this.env);
            types.add(this.resultType);
        }
        this.env = prevEnv;
        this.expType = preExpType;
        return types;
    }

    private BType getInferredTupleType(BLangListConstructorExpr listConstructor) {
        List<BType> memTypes = this.checkExprList(listConstructor.exprs, this.env);
        for (BType memType : memTypes) {
            if (memType != this.symTable.semanticError) continue;
            return this.symTable.semanticError;
        }
        return new BTupleType(memTypes);
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        int expTypeTag = this.expType.tag;
        if (expTypeTag == 22) {
            this.expType = this.defineInferredRecordType(recordLiteral);
        } else if (expTypeTag == 32) {
            this.dlog.error(recordLiteral.pos, DiagnosticCode.INVALID_RECORD_LITERAL, this.expType);
            this.resultType = this.symTable.semanticError;
            return;
        }
        this.resultType = this.checkMappingConstructorCompatibility(this.expType, recordLiteral);
    }

    private BType checkMappingConstructorCompatibility(BType bType, BLangRecordLiteral mappingConstructor) {
        if (bType.tag == 20) {
            boolean prevNonErrorLoggingCheck = this.nonErrorLoggingCheck;
            this.nonErrorLoggingCheck = true;
            BLangDiagnosticLog prevDLog = this.dlog.getCurrentLog();
            this.dlog.setNonConsoleDLog();
            ArrayList<BType> compatibleTypes = new ArrayList<BType>();
            for (BType memberType : ((BUnionType)bType).getMemberTypes()) {
                BType listCompatibleMemType = this.getMappingConstructorCompatibleNonUnionType(memberType);
                if (listCompatibleMemType == this.symTable.semanticError) continue;
                BType memCompatibiltyType = this.checkMappingConstructorCompatibility(listCompatibleMemType, mappingConstructor);
                if (memCompatibiltyType != this.symTable.semanticError && this.dlog.getErrorCount() == 0 && this.isUniqueType(compatibleTypes, memCompatibiltyType)) {
                    compatibleTypes.add(memCompatibiltyType);
                }
                this.dlog.resetErrorCount();
            }
            this.dlog.setCurrentLog(prevDLog);
            this.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
            if (compatibleTypes.isEmpty()) {
                this.reportIncompatibleMappingConstructorError(mappingConstructor, bType);
                this.validateSpecifiedFields(mappingConstructor, this.symTable.semanticError);
                return this.symTable.semanticError;
            }
            if (compatibleTypes.size() != 1) {
                this.dlog.error(mappingConstructor.pos, DiagnosticCode.AMBIGUOUS_TYPES, bType);
                this.validateSpecifiedFields(mappingConstructor, this.symTable.semanticError);
                return this.symTable.semanticError;
            }
            return this.checkMappingConstructorCompatibility((BType)compatibleTypes.get(0), mappingConstructor);
        }
        BType possibleType = this.getMappingConstructorCompatibleNonUnionType(bType);
        switch (possibleType.tag) {
            case 15: {
                return this.validateSpecifiedFields(mappingConstructor, possibleType) ? possibleType : this.symTable.semanticError;
            }
            case 12: {
                boolean isSpecifiedFieldsValid = this.validateSpecifiedFields(mappingConstructor, possibleType);
                boolean hasAllRequiredFields = this.validateRequiredFields((BRecordType)possibleType, mappingConstructor.fields, mappingConstructor.pos);
                return isSpecifiedFieldsValid && hasAllRequiredFields ? possibleType : this.symTable.semanticError;
            }
        }
        this.reportIncompatibleMappingConstructorError(mappingConstructor, bType);
        this.validateSpecifiedFields(mappingConstructor, this.symTable.semanticError);
        return this.symTable.semanticError;
    }

    private BType getMappingConstructorCompatibleNonUnionType(BType type) {
        switch (type.tag) {
            case 12: 
            case 15: {
                return type;
            }
            case 7: {
                return this.symTable.mapJsonType;
            }
            case 11: {
                return this.symTable.mapAnydataType;
            }
            case 17: {
                return this.symTable.mapType;
            }
        }
        return this.symTable.semanticError;
    }

    private boolean isMappingConstructorCompatibleType(BType type) {
        return type.tag == 12 || type.tag == 15;
    }

    private void reportIncompatibleMappingConstructorError(BLangRecordLiteral mappingConstructorExpr, BType expType) {
        if (expType.tag != 20) {
            this.dlog.error(mappingConstructorExpr.pos, DiagnosticCode.MAPPING_CONSTRUCTOR_COMPATIBLE_TYPE_NOT_FOUND, expType);
            return;
        }
        BUnionType unionType = (BUnionType)expType;
        BType[] memberTypes = unionType.getMemberTypes().toArray(new BType[0]);
        if (memberTypes.length == 2) {
            BRecordType recType = null;
            if (memberTypes[0].tag == 12 && memberTypes[1].tag == 10) {
                recType = (BRecordType)memberTypes[0];
            } else if (memberTypes[1].tag == 12 && memberTypes[0].tag == 10) {
                recType = (BRecordType)memberTypes[1];
            }
            if (recType != null) {
                this.validateSpecifiedFields(mappingConstructorExpr, recType);
                this.validateRequiredFields(recType, mappingConstructorExpr.fields, mappingConstructorExpr.pos);
                return;
            }
        }
        for (BType bType : memberTypes) {
            if (!this.isMappingConstructorCompatibleType(bType)) continue;
            this.dlog.error(mappingConstructorExpr.pos, DiagnosticCode.INCOMPATIBLE_MAPPING_CONSTRUCTOR, unionType);
            return;
        }
        this.dlog.error(mappingConstructorExpr.pos, DiagnosticCode.MAPPING_CONSTRUCTOR_COMPATIBLE_TYPE_NOT_FOUND, unionType);
    }

    private boolean validateSpecifiedFields(BLangRecordLiteral mappingConstructor, BType possibleType) {
        boolean isFieldsValid = true;
        for (RecordLiteralNode.RecordField field : mappingConstructor.fields) {
            BType checkedType = this.checkMappingField(field, possibleType);
            if (!isFieldsValid || checkedType != this.symTable.semanticError) continue;
            isFieldsValid = false;
        }
        return isFieldsValid;
    }

    private boolean validateRequiredFields(BRecordType type, List<RecordLiteralNode.RecordField> specifiedFields, DiagnosticPos pos) {
        HashSet<String> specFieldNames = this.getFieldNames(specifiedFields);
        boolean hasAllRequiredFields = true;
        for (BField field : type.fields) {
            if (specFieldNames.contains(field.name.value) || !Symbols.isFlagOn(field.symbol.flags, 256)) continue;
            this.dlog.error(pos, DiagnosticCode.MISSING_REQUIRED_RECORD_FIELD, field.name);
            if (!hasAllRequiredFields) continue;
            hasAllRequiredFields = false;
        }
        return hasAllRequiredFields;
    }

    private HashSet<String> getFieldNames(List<RecordLiteralNode.RecordField> specifiedFields) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (RecordLiteralNode.RecordField specifiedField : specifiedFields) {
            if (specifiedField.isKeyValueField()) {
                String name = this.getKeyValueFieldName((BLangRecordLiteral.BLangRecordKeyValueField)specifiedField);
                if (name == null) continue;
                fieldNames.add(name);
                continue;
            }
            if (specifiedField.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                fieldNames.add(this.getVarNameFieldName((BLangRecordLiteral.BLangRecordVarNameField)specifiedField));
                continue;
            }
            fieldNames.addAll(this.getSpreadOpFieldRequiredFieldNames((BLangRecordLiteral.BLangRecordSpreadOperatorField)specifiedField));
        }
        return fieldNames;
    }

    private String getKeyValueFieldName(BLangRecordLiteral.BLangRecordKeyValueField field) {
        BLangRecordLiteral.BLangRecordKey key = field.key;
        if (key.computedKey) {
            return null;
        }
        BLangExpression keyExpr = key.expr;
        if (keyExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            return ((BLangSimpleVarRef)keyExpr).variableName.value;
        }
        if (keyExpr.getKind() == NodeKind.LITERAL) {
            return (String)((BLangLiteral)keyExpr).value;
        }
        return null;
    }

    private String getVarNameFieldName(BLangRecordLiteral.BLangRecordVarNameField field) {
        return field.variableName.value;
    }

    private List<String> getSpreadOpFieldRequiredFieldNames(BLangRecordLiteral.BLangRecordSpreadOperatorField field) {
        BType spreadType = this.checkExpr(field.expr, this.env);
        if (spreadType.tag != 12) {
            return Collections.emptyList();
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (BField bField : ((BRecordType)spreadType).getFields()) {
            if (Symbols.isOptional(bField.symbol)) continue;
            fieldNames.add(bField.name.value);
        }
        return fieldNames;
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        String workerName;
        if (workerFlushExpr.workerIdentifier != null && !this.workerExists(this.env, workerName = workerFlushExpr.workerIdentifier.getValue())) {
            this.dlog.error(workerFlushExpr.pos, DiagnosticCode.UNDEFINED_WORKER, workerName);
        }
        BUnionType actualType = BUnionType.create(null, this.symTable.errorType, this.symTable.nilType);
        this.resultType = this.types.checkType(workerFlushExpr, actualType, this.expType);
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        String workerName;
        BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromIdNode(syncSendExpr.workerIdentifier));
        syncSendExpr.workerType = this.symTable.notFoundSymbol.equals(symbol) ? this.symTable.semanticError : symbol.type;
        syncSendExpr.env = this.env;
        this.checkExpr(syncSendExpr.expr, this.env);
        if (!syncSendExpr.expr.type.isAnydata()) {
            this.dlog.error(syncSendExpr.pos, DiagnosticCode.INVALID_TYPE_FOR_SEND, syncSendExpr.expr.type);
        }
        if (!this.workerExists(this.env, workerName = syncSendExpr.workerIdentifier.getValue())) {
            this.dlog.error(syncSendExpr.pos, DiagnosticCode.UNDEFINED_WORKER, workerName);
        }
        syncSendExpr.expectedType = this.expType;
        this.resultType = this.expType == this.symTable.noType ? this.symTable.nilType : this.expType;
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveExpr) {
        BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromIdNode(workerReceiveExpr.workerIdentifier));
        if (workerReceiveExpr.isChannel) {
            this.dlog.error(workerReceiveExpr.pos, DiagnosticCode.UNDEFINED_ACTION, new Object[0]);
            return;
        }
        workerReceiveExpr.env = this.env;
        workerReceiveExpr.workerType = this.symTable.notFoundSymbol.equals(symbol) ? this.symTable.semanticError : symbol.type;
        if (this.symTable.noType == this.expType) {
            this.dlog.error(workerReceiveExpr.pos, DiagnosticCode.INVALID_USAGE_OF_RECEIVE_EXPRESSION, new Object[0]);
        }
        workerReceiveExpr.type = this.expType;
        this.resultType = this.expType;
    }

    private boolean workerExists(SymbolEnv env, String workerName) {
        if (workerName.equals("default")) {
            return true;
        }
        BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(env, new Name(workerName));
        return symbol != this.symTable.notFoundSymbol && symbol.type.tag == 30 && ((BFutureType)symbol.type).workerDerivative;
    }

    @Override
    public void visit(BLangConstRef constRef) {
        constRef.symbol = this.symResolver.lookupMainSpaceSymbolInPackage(constRef.pos, this.env, this.names.fromIdNode(constRef.pkgAlias), this.names.fromIdNode(constRef.variableName));
        this.types.setImplicitCastExpr(constRef, constRef.type, this.expType);
        this.resultType = constRef.type;
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        BType actualType = this.symTable.semanticError;
        Name varName = this.names.fromIdNode(varRefExpr.variableName);
        if (varName == Names.IGNORE) {
            if (varRefExpr.lhsVar) {
                varRefExpr.type = this.symTable.anyType;
            } else {
                varRefExpr.type = this.symTable.semanticError;
                this.dlog.error(varRefExpr.pos, DiagnosticCode.UNDERSCORE_NOT_ALLOWED, new Object[0]);
            }
            varRefExpr.symbol = new BVarSymbol(0, varName, this.env.enclPkg.symbol.pkgID, varRefExpr.type, this.env.scope.owner);
            this.resultType = varRefExpr.type;
            return;
        }
        Name compUnitName = this.getCurrentCompUnit(varRefExpr);
        varRefExpr.pkgSymbol = this.symResolver.resolvePrefixSymbol(this.env, this.names.fromIdNode(varRefExpr.pkgAlias), compUnitName);
        if (varRefExpr.pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(varRefExpr.pos, DiagnosticCode.UNDEFINED_MODULE, varRefExpr.pkgAlias);
        }
        if (varRefExpr.pkgSymbol.tag == 8193) {
            actualType = this.symTable.stringType;
        } else if (varRefExpr.pkgSymbol != this.symTable.notFoundSymbol) {
            BSymbol symbol = this.symResolver.lookupMainSpaceSymbolInPackage(varRefExpr.pos, this.env, this.names.fromIdNode(varRefExpr.pkgAlias), varName);
            if (symbol == this.symTable.notFoundSymbol && this.env.enclType != null) {
                Name objFuncName = this.names.fromString(Symbols.getAttachedFuncSymbolName(this.env.enclType.type.tsymbol.name.value, varName.value));
                symbol = this.symResolver.resolveStructField(varRefExpr.pos, this.env, objFuncName, this.env.enclType.type.tsymbol);
            }
            if ((symbol.tag & 0x34) == 52 && !this.isInLocallyDefinedRecord(symbol, this.env)) {
                BVarSymbol varSym = (BVarSymbol)symbol;
                this.checkSefReferences(varRefExpr.pos, this.env, varSym);
                varRefExpr.symbol = varSym;
                actualType = varSym.type;
                this.markAndRegisterClosureVariable(symbol, varRefExpr.pos);
            } else if ((symbol.tag & 0x1001C) == 65564) {
                actualType = new BTypedescType(symbol.type, null);
                varRefExpr.symbol = symbol;
            } else if ((symbol.tag & 0x100001C) == 0x100001C) {
                BConstantSymbol constSymbol = (BConstantSymbol)symbol;
                varRefExpr.symbol = constSymbol;
                BType symbolType = symbol.type;
                actualType = symbolType != this.symTable.noType && this.expType.tag == 31 || this.expType.tag == 20 && ((BUnionType)this.expType).getMemberTypes().stream().anyMatch(memType -> memType.tag == 31 && this.types.isAssignable(symbolType, (BType)memType)) ? symbolType : constSymbol.literalType;
                if (varRefExpr.lhsVar || varRefExpr.compoundAssignmentLhsVar) {
                    actualType = this.symTable.semanticError;
                    this.dlog.error(varRefExpr.pos, DiagnosticCode.CANNOT_UPDATE_CONSTANT_VALUE, new Object[0]);
                }
            } else {
                this.dlog.error(varRefExpr.pos, DiagnosticCode.UNDEFINED_SYMBOL, varName.toString());
            }
        }
        if (this.expType.tag == 19 && this.isArrayOpenSealedType((BArrayType)this.expType)) {
            this.dlog.error(varRefExpr.pos, DiagnosticCode.SEALED_ARRAY_TYPE_CAN_NOT_INFER_SIZE, new Object[0]);
            return;
        }
        this.resultType = this.types.checkType(varRefExpr, actualType, this.expType);
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
        ArrayList<BField> fields = new ArrayList<BField>();
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(0, this.names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(this.env.enclPkg.symbol.pkgID)), this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner);
        boolean unresolvedReference = false;
        for (BLangRecordVarRef.BLangRecordVarRefKeyValue recordRefField : varRefExpr.recordRefFields) {
            ((BLangVariableReference)recordRefField.variableReference).lhsVar = true;
            this.checkExpr(recordRefField.variableReference, this.env);
            if (((BLangVariableReference)recordRefField.variableReference).symbol == null || !this.isValidVariableReference(recordRefField.variableReference)) {
                unresolvedReference = true;
                continue;
            }
            BVarSymbol bVarSymbol = (BVarSymbol)((BLangVariableReference)recordRefField.variableReference).symbol;
            fields.add(new BField(this.names.fromIdNode(recordRefField.variableName), varRefExpr.pos, new BVarSymbol(0, this.names.fromIdNode(recordRefField.variableName), this.env.enclPkg.symbol.pkgID, bVarSymbol.type, recordSymbol)));
        }
        if (varRefExpr.restParam != null) {
            BLangExpression restParam = (BLangExpression)varRefExpr.restParam;
            this.checkExpr(restParam, this.env);
            boolean bl = unresolvedReference = !this.isValidVariableReference(restParam);
        }
        if (unresolvedReference) {
            this.resultType = this.symTable.semanticError;
            return;
        }
        BRecordType bRecordType = new BRecordType(recordSymbol);
        bRecordType.fields = fields;
        recordSymbol.type = bRecordType;
        varRefExpr.symbol = new BVarSymbol(0, recordSymbol.name, this.env.enclPkg.symbol.pkgID, bRecordType, this.env.scope.owner);
        if (varRefExpr.restParam == null) {
            bRecordType.sealed = true;
            bRecordType.restFieldType = this.symTable.noType;
        } else {
            bRecordType.restFieldType = this.symTable.mapType;
        }
        this.resultType = bRecordType;
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        BType errorRefRestFieldType;
        if (varRefExpr.typeNode != null) {
            BType bType;
            varRefExpr.type = bType = this.symResolver.resolveTypeNode(varRefExpr.typeNode, this.env);
            this.checkIndirectErrorVarRef(varRefExpr);
            this.resultType = bType;
            return;
        }
        if (varRefExpr.reason != null) {
            varRefExpr.reason.lhsVar = true;
            this.checkExpr(varRefExpr.reason, this.env);
        }
        boolean unresolvedReference = false;
        for (BLangNamedArgsExpression detailItem : varRefExpr.detail) {
            BLangVariableReference refItem = (BLangVariableReference)detailItem.expr;
            refItem.lhsVar = true;
            this.checkExpr(refItem, this.env);
            if (!this.isValidVariableReference(refItem)) {
                unresolvedReference = true;
                continue;
            }
            if (refItem.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR || refItem.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR) {
                this.dlog.error(refItem.pos, DiagnosticCode.INVALID_VARIABLE_REFERENCE_IN_BINDING_PATTERN, refItem);
                unresolvedReference = true;
                continue;
            }
            if (refItem.symbol != null) continue;
            unresolvedReference = true;
        }
        if (varRefExpr.restVar != null) {
            varRefExpr.restVar.lhsVar = true;
            if (varRefExpr.restVar.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                this.checkExpr(varRefExpr.restVar, this.env);
                unresolvedReference = unresolvedReference || varRefExpr.restVar.symbol == null || !this.isValidVariableReference(varRefExpr.restVar);
            } else if (varRefExpr.restVar.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR || varRefExpr.restVar.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR) {
                unresolvedReference = this.checkErrorRestParamVarRef(varRefExpr, unresolvedReference);
            }
        }
        if (unresolvedReference) {
            this.resultType = this.symTable.semanticError;
            return;
        }
        if (varRefExpr.restVar == null) {
            errorRefRestFieldType = this.symTable.pureType;
        } else if (varRefExpr.restVar.getKind() == NodeKind.SIMPLE_VARIABLE_REF && ((BLangSimpleVarRef)varRefExpr.restVar).variableName.value.equals(Names.IGNORE.value)) {
            errorRefRestFieldType = this.symTable.pureType;
        } else if (varRefExpr.restVar.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR || varRefExpr.restVar.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR) {
            errorRefRestFieldType = varRefExpr.restVar.type;
        } else if (varRefExpr.restVar.type.tag == 15) {
            errorRefRestFieldType = ((BMapType)varRefExpr.restVar.type).constraint;
        } else {
            this.dlog.error(varRefExpr.restVar.pos, DiagnosticCode.INCOMPATIBLE_TYPES, varRefExpr.restVar.type, this.symTable.detailType);
            this.resultType = this.symTable.semanticError;
            return;
        }
        BRecordType errorDetailType = this.getCompatibleDetailType(errorRefRestFieldType);
        this.resultType = new BErrorType(this.symTable.errorType.tsymbol, varRefExpr.reason.type, errorDetailType);
    }

    private void checkIndirectErrorVarRef(BLangErrorVarRef varRefExpr) {
        for (BLangNamedArgsExpression detailItem : varRefExpr.detail) {
            this.checkExpr(detailItem.expr, this.env);
            this.checkExpr(detailItem, this.env, detailItem.expr.type);
        }
        if (varRefExpr.restVar != null) {
            this.checkExpr(varRefExpr.restVar, this.env);
        }
        varRefExpr.reason.type = this.symTable.noType;
    }

    private BRecordType getCompatibleDetailType(BType errorRefRestFieldType) {
        PackageID packageID = this.env.enclPkg.packageID;
        BRecordTypeSymbol detailSymbol = new BRecordTypeSymbol(327772, 1, Names.EMPTY, packageID, null, this.env.scope.owner);
        detailSymbol.scope = new Scope(this.env.scope.owner);
        BRecordType detailType = new BRecordType(detailSymbol);
        int flags = Flags.asMask(new HashSet<Flag>(Lists.of(Flag.OPTIONAL, Flag.PUBLIC)));
        BField messageField = new BField(Names.DETAIL_MESSAGE, null, new BVarSymbol(flags, Names.DETAIL_MESSAGE, packageID, this.symTable.stringType, detailSymbol));
        detailType.fields.add(messageField);
        detailSymbol.scope.define(Names.DETAIL_MESSAGE, messageField.symbol);
        BField causeField = new BField(Names.DETAIL_CAUSE, null, new BVarSymbol(flags, Names.DETAIL_CAUSE, packageID, this.symTable.errorType, detailSymbol));
        detailType.fields.add(causeField);
        detailSymbol.scope.define(Names.DETAIL_CAUSE, causeField.symbol);
        detailType.restFieldType = errorRefRestFieldType;
        BInvokableType invokableType = new BInvokableType(new ArrayList<BType>(), this.symTable.nilType, null);
        BInvokableSymbol initSymbol = Symbols.createFunctionSymbol(0, Names.INIT_FUNCTION_SUFFIX, packageID, invokableType, detailSymbol, false);
        detailSymbol.initializerFunc = new BAttachedFunction(Names.INIT_FUNCTION_SUFFIX, initSymbol, invokableType);
        detailSymbol.scope.define(initSymbol.name, initSymbol);
        return detailType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkErrorRestParamVarRef(BLangErrorVarRef varRefExpr, boolean unresolvedReference) {
        BLangAccessExpression accessExpression = (BLangAccessExpression)varRefExpr.restVar;
        Name exprName = this.names.fromIdNode(((BLangSimpleVarRef)accessExpression.expr).variableName);
        BSymbol fSym = this.symResolver.lookupSymbolInMainSpace(this.env, exprName);
        if (fSym == null) return true;
        if (fSym.type.getKind() != TypeKind.MAP) throw new UnsupportedOperationException("rec field base access");
        BType constraint = ((BMapType)fSym.type).constraint;
        varRefExpr.restVar.type = this.types.isAssignable(constraint, this.symTable.pureType) ? constraint : this.symTable.pureType;
        return unresolvedReference;
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
        ArrayList<BType> results = new ArrayList<BType>();
        for (int i = 0; i < varRefExpr.expressions.size(); ++i) {
            ((BLangVariableReference)varRefExpr.expressions.get((int)i)).lhsVar = true;
            results.add(this.checkExpr(varRefExpr.expressions.get(i), this.env, this.symTable.noType));
        }
        BTupleType actualType = new BTupleType(results);
        if (varRefExpr.restParam != null) {
            BLangExpression restExpr = (BLangExpression)varRefExpr.restParam;
            ((BLangVariableReference)restExpr).lhsVar = true;
            BType checkedType = this.checkExpr(restExpr, this.env, this.symTable.noType);
            if (checkedType.tag != 19) {
                this.dlog.error(varRefExpr.pos, DiagnosticCode.INVALID_TYPE_FOR_REST_DESCRIPTOR, checkedType);
                this.resultType = this.symTable.semanticError;
                return;
            }
            actualType.restType = ((BArrayType)checkedType).eType;
        }
        this.resultType = this.types.checkType(varRefExpr, actualType, this.expType);
    }

    public boolean isArrayOpenSealedType(BArrayType arrayType) {
        if (arrayType.state == BArrayState.OPEN_SEALED) {
            return true;
        }
        if (arrayType.eType.tag == 19) {
            return this.isArrayOpenSealedType((BArrayType)arrayType.eType);
        }
        return false;
    }

    private SymbolEnv findEnclosingInvokableEnv(SymbolEnv env, BLangInvokableNode encInvokable) {
        if (env.enclEnv.node != null && env.enclEnv.node.getKind() == NodeKind.ARROW_EXPR) {
            return env.enclEnv;
        }
        if (env.enclEnv.node != null && env.enclEnv.node.getKind() == NodeKind.TRANSACTION) {
            return env.enclEnv;
        }
        if (env.enclInvokable != null && env.enclInvokable == encInvokable) {
            return this.findEnclosingInvokableEnv(env.enclEnv, encInvokable);
        }
        return env;
    }

    private boolean isFunctionArgument(BSymbol symbol, List<BLangSimpleVariable> params) {
        return params.stream().anyMatch(param -> param.symbol.name.equals(symbol.name) && param.type.tag == symbol.type.tag);
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        BType actualType;
        ((BLangVariableReference)fieldAccessExpr.expr).lhsVar = fieldAccessExpr.lhsVar;
        ((BLangVariableReference)fieldAccessExpr.expr).compoundAssignmentLhsVar = fieldAccessExpr.compoundAssignmentLhsVar;
        BType varRefType = this.getTypeOfExprInFieldAccess(fieldAccessExpr.expr);
        if (fieldAccessExpr instanceof BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess && !this.isXmlAccess(fieldAccessExpr)) {
            this.dlog.error(fieldAccessExpr.pos, DiagnosticCode.INVALID_FIELD_ACCESS_EXPRESSION, new Object[0]);
            this.resultType = this.symTable.semanticError;
            return;
        }
        if (fieldAccessExpr.fieldKind == FieldKind.ALL && varRefType.tag != 8) {
            this.dlog.error(fieldAccessExpr.pos, DiagnosticCode.CANNOT_GET_ALL_FIELDS, varRefType);
            actualType = this.symTable.semanticError;
        } else if (fieldAccessExpr.optionalFieldAccess) {
            if (fieldAccessExpr.lhsVar || fieldAccessExpr.compoundAssignmentLhsVar) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticCode.OPTIONAL_FIELD_ACCESS_NOT_REQUIRED_ON_LHS, new Object[0]);
                this.resultType = this.symTable.semanticError;
                return;
            }
            actualType = this.checkOptionalFieldAccessExpr(fieldAccessExpr, varRefType, this.names.fromIdNode(fieldAccessExpr.field));
        } else {
            actualType = this.checkFieldAccessExpr(fieldAccessExpr, varRefType, this.names.fromIdNode(fieldAccessExpr.field));
        }
        this.resultType = this.types.checkType(fieldAccessExpr, actualType, this.expType);
    }

    private boolean isXmlAccess(BLangFieldBasedAccess fieldAccessExpr) {
        BLangExpression expr = fieldAccessExpr.expr;
        BType exprType = expr.type;
        if (exprType.tag == 8 || exprType.tag == 43) {
            return true;
        }
        if (expr.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR && this.hasLaxOriginalType((BLangFieldBasedAccess)expr) && exprType.tag == 20) {
            Set<BType> memberTypes = ((BUnionType)exprType).getMemberTypes();
            return memberTypes.contains(this.symTable.xmlType) || memberTypes.contains(this.symTable.xmlElementType);
        }
        return false;
    }

    @Override
    public void visit(BLangIndexBasedAccess indexBasedAccessExpr) {
        ((BLangVariableReference)indexBasedAccessExpr.expr).lhsVar = indexBasedAccessExpr.lhsVar;
        ((BLangVariableReference)indexBasedAccessExpr.expr).compoundAssignmentLhsVar = indexBasedAccessExpr.compoundAssignmentLhsVar;
        this.checkExpr(indexBasedAccessExpr.expr, this.env, this.symTable.noType);
        BType actualType = this.checkIndexAccessExpr(indexBasedAccessExpr);
        if (indexBasedAccessExpr.lhsVar) {
            indexBasedAccessExpr.originalType = actualType;
            indexBasedAccessExpr.type = actualType;
            this.resultType = actualType;
            return;
        }
        this.resultType = this.types.checkType(indexBasedAccessExpr, actualType, this.expType);
    }

    @Override
    public void visit(BLangInvocation iExpr) {
        if (iExpr.expr == null) {
            this.checkFunctionInvocationExpr(iExpr);
            return;
        }
        Name pkgAlias = this.names.fromIdNode(iExpr.pkgAlias);
        if (pkgAlias != Names.EMPTY) {
            this.dlog.error(iExpr.pos, DiagnosticCode.PKG_ALIAS_NOT_ALLOWED_HERE, new Object[0]);
            return;
        }
        BType exprType = this.checkExpr(iExpr.expr, this.env, this.symTable.noType);
        if (iExpr.actionInvocation) {
            this.checkActionInvocationExpr(iExpr, exprType);
            return;
        }
        BType varRefType = iExpr.expr.type;
        switch (varRefType.tag) {
            case 32: {
                this.checkObjectFunctionInvocationExpr(iExpr, (BObjectType)varRefType);
                break;
            }
            case 12: {
                boolean methodFound = this.checkFieldFunctionPointer(iExpr);
                if (methodFound) break;
                this.checkInLangLib(iExpr, varRefType);
                break;
            }
            case 22: {
                this.dlog.error(iExpr.pos, DiagnosticCode.UNDEFINED_FUNCTION, iExpr.name);
                break;
            }
            case 26: {
                break;
            }
            default: {
                this.checkInLangLib(iExpr, varRefType);
            }
        }
    }

    @Override
    public void visit(BLangLetExpression letExpression) {
        BLetSymbol letSymbol = new BLetSymbol(0x8000000, Flags.asMask(new HashSet<Flag>(Lists.of(new Flag[0]))), new Name(String.format("$let_symbol_%d$", this.letCount++)), this.env.enclPkg.symbol.pkgID, letExpression.type, this.env.scope.owner);
        letExpression.env = SymbolEnv.createExprEnv(letExpression, this.env, letSymbol);
        for (BLangLetVariable letVariable : letExpression.letVarDeclarations) {
            this.semanticAnalyzer.analyzeDef((BLangNode)((Object)letVariable.definitionNode), letExpression.env);
        }
        BType exprType = this.checkExpr(letExpression.expr, letExpression.env);
        this.types.checkType(letExpression, exprType, this.expType);
    }

    private void checkInLangLib(BLangInvocation iExpr, BType varRefType) {
        boolean langLibMethodExists = this.checkLangLibMethodInvocationExpr(iExpr, varRefType);
        if (!langLibMethodExists) {
            this.dlog.error(iExpr.name.pos, DiagnosticCode.UNDEFINED_FUNCTION, iExpr.name.value);
            this.resultType = this.symTable.semanticError;
        }
    }

    private boolean checkFieldFunctionPointer(BLangInvocation iExpr) {
        BType type = this.checkExpr(iExpr.expr, this.env);
        if (type == this.symTable.semanticError) {
            return false;
        }
        BSymbol funcSymbol = this.symResolver.resolveStructField(iExpr.pos, this.env, this.names.fromIdNode(iExpr.name), type.tsymbol);
        if (funcSymbol == this.symTable.notFoundSymbol) {
            return false;
        }
        iExpr.symbol = funcSymbol;
        iExpr.type = ((BInvokableSymbol)funcSymbol).retType;
        this.checkInvocationParamAndReturnType(iExpr);
        iExpr.functionPointerInvocation = true;
        return true;
    }

    @Override
    public void visit(BLangTypeInit cIExpr) {
        if (this.expType.tag == 17 && cIExpr.userDefinedType == null || this.expType.tag == 12) {
            this.dlog.error(cIExpr.pos, DiagnosticCode.INVALID_TYPE_NEW_LITERAL, this.expType);
            this.resultType = this.symTable.semanticError;
            return;
        }
        BType actualType = cIExpr.userDefinedType != null ? this.symResolver.resolveTypeNode(cIExpr.userDefinedType, this.env) : this.expType;
        if (actualType == this.symTable.semanticError) {
            this.resultType = this.symTable.semanticError;
            return;
        }
        switch (actualType.tag) {
            case 32: {
                if ((actualType.tsymbol.flags & 0x1000) == 4096) {
                    this.dlog.error(cIExpr.pos, DiagnosticCode.CANNOT_INITIALIZE_ABSTRACT_OBJECT, actualType.tsymbol);
                    cIExpr.initInvocation.argExprs.forEach(expr -> this.checkExpr((BLangExpression)expr, this.env, this.symTable.noType));
                    this.resultType = this.symTable.semanticError;
                    return;
                }
                if (((BObjectTypeSymbol)actualType.tsymbol).initializerFunc != null) {
                    cIExpr.initInvocation.symbol = ((BObjectTypeSymbol)actualType.tsymbol).initializerFunc.symbol;
                    this.checkInvocationParam(cIExpr.initInvocation);
                    cIExpr.initInvocation.type = ((BInvokableSymbol)cIExpr.initInvocation.symbol).retType;
                    break;
                }
                if (this.isValidInitInvocation(cIExpr, (BObjectType)actualType)) break;
                return;
            }
            case 14: {
                BType error;
                if (cIExpr.initInvocation.argExprs.size() != 1) {
                    this.dlog.error(cIExpr.pos, DiagnosticCode.INVALID_STREAM_CONSTRUCTOR, cIExpr.initInvocation.name);
                    this.resultType = this.symTable.semanticError;
                    return;
                }
                BStreamType actualStreamType = (BStreamType)actualType;
                if (actualStreamType.error != null && !this.types.containsErrorType(error = actualStreamType.error)) {
                    this.dlog.error(cIExpr.pos, DiagnosticCode.ERROR_TYPE_EXPECTED, error.toString());
                    this.resultType = this.symTable.semanticError;
                    return;
                }
                BLangExpression iteratorExpr = cIExpr.initInvocation.argExprs.get(0);
                BType constructType = this.checkExpr(iteratorExpr, this.env, this.symTable.noType);
                BUnionType nextReturnType = this.types.getVarTypeFromIteratorFuncReturnType(constructType);
                BUnionType expectedReturnType = this.createNextReturnType(cIExpr.pos, (BStreamType)actualType);
                if (nextReturnType == null) {
                    this.dlog.error(iteratorExpr.pos, DiagnosticCode.MISSING_REQUIRED_METHOD_NEXT, constructType, expectedReturnType);
                    this.resultType = this.symTable.semanticError;
                    return;
                }
                this.types.checkType(iteratorExpr.pos, (BType)nextReturnType, (BType)expectedReturnType, DiagnosticCode.INCOMPATIBLE_TYPES);
                this.resultType = actualType;
                return;
            }
            case 20: {
                List<BType> matchingMembers = this.findMembersWithMatchingInitFunc(cIExpr, (BUnionType)actualType);
                BType matchedType = this.getMatchingType(matchingMembers, cIExpr, actualType);
                cIExpr.initInvocation.type = this.symTable.nilType;
                if (matchedType.tag == 32) {
                    if (((BObjectTypeSymbol)matchedType.tsymbol).initializerFunc != null) {
                        cIExpr.initInvocation.symbol = ((BObjectTypeSymbol)matchedType.tsymbol).initializerFunc.symbol;
                        this.checkInvocationParam(cIExpr.initInvocation);
                        cIExpr.initInvocation.type = ((BInvokableSymbol)cIExpr.initInvocation.symbol).retType;
                        actualType = matchedType;
                        break;
                    }
                    if (!this.isValidInitInvocation(cIExpr, (BObjectType)matchedType)) {
                        return;
                    }
                }
                this.types.checkType(cIExpr, matchedType, this.expType);
                cIExpr.type = matchedType;
                this.resultType = matchedType;
                return;
            }
            default: {
                this.dlog.error(cIExpr.pos, DiagnosticCode.CANNOT_INFER_OBJECT_TYPE_FROM_LHS, actualType);
                this.resultType = this.symTable.semanticError;
                return;
            }
        }
        if (cIExpr.initInvocation.type == null) {
            cIExpr.initInvocation.type = this.symTable.nilType;
        }
        BType actualTypeInitType = this.getObjectConstructorReturnType(actualType, cIExpr.initInvocation.type);
        this.resultType = this.types.checkType(cIExpr, actualTypeInitType, this.expType);
    }

    private BUnionType createNextReturnType(DiagnosticPos pos, BStreamType streamType) {
        BRecordType recordType = new BRecordType(null);
        recordType.restFieldType = this.symTable.noType;
        recordType.sealed = true;
        Name fieldName = Names.VALUE;
        BField field = new BField(fieldName, pos, new BVarSymbol(1, fieldName, this.env.enclPkg.packageID, streamType.constraint, this.env.scope.owner));
        field.type = streamType.constraint;
        recordType.fields.add(field);
        recordType.tsymbol = Symbols.createRecordSymbol(0, Names.EMPTY, this.env.enclPkg.packageID, recordType, this.env.scope.owner);
        recordType.tsymbol.scope = new Scope(this.env.scope.owner);
        recordType.tsymbol.scope.define(fieldName, field.symbol);
        LinkedHashSet<BType> retTypeMembers = new LinkedHashSet<BType>();
        retTypeMembers.add(recordType);
        if (streamType.error != null) {
            retTypeMembers.add(streamType.error);
        }
        retTypeMembers.add(this.symTable.nilType);
        BUnionType unionType = BUnionType.create(null, retTypeMembers);
        unionType.tsymbol = Symbols.createTypeSymbol(2097180, 0, Names.EMPTY, this.env.enclPkg.symbol.pkgID, unionType, this.env.scope.owner);
        return unionType;
    }

    private boolean isValidInitInvocation(BLangTypeInit cIExpr, BObjectType objType) {
        if (!cIExpr.initInvocation.argExprs.isEmpty() && ((BObjectTypeSymbol)objType.tsymbol).initializerFunc == null) {
            this.dlog.error(cIExpr.pos, DiagnosticCode.TOO_MANY_ARGS_FUNC_CALL, cIExpr.initInvocation.exprSymbol);
            cIExpr.initInvocation.argExprs.forEach(expr -> this.checkExpr((BLangExpression)expr, this.env, this.symTable.noType));
            this.resultType = this.symTable.semanticError;
            return false;
        }
        return true;
    }

    private BType getObjectConstructorReturnType(BType objType, BType initRetType) {
        if (initRetType.tag == 20) {
            LinkedHashSet<BType> retTypeMembers = new LinkedHashSet<BType>();
            retTypeMembers.add(objType);
            retTypeMembers.addAll(((BUnionType)initRetType).getMemberTypes());
            retTypeMembers.remove(this.symTable.nilType);
            BUnionType unionType = BUnionType.create(null, retTypeMembers);
            unionType.tsymbol = Symbols.createTypeSymbol(2097180, 0, Names.EMPTY, this.env.enclPkg.symbol.pkgID, unionType, this.env.scope.owner);
            return unionType;
        }
        if (initRetType.tag == 10) {
            return objType;
        }
        return this.symTable.semanticError;
    }

    private List<BType> findMembersWithMatchingInitFunc(BLangTypeInit cIExpr, BUnionType lhsUnionType) {
        boolean containsSingleObject = lhsUnionType.getMemberTypes().stream().filter(x -> x.tag == 32).count() == 1L;
        ArrayList<BType> matchingLhsMemberTypes = new ArrayList<BType>();
        for (BType memberType : lhsUnionType.getMemberTypes()) {
            if (memberType.tag != 32) continue;
            if ((memberType.tsymbol.flags & 0x1000) == 4096) {
                this.dlog.error(cIExpr.pos, DiagnosticCode.CANNOT_INITIALIZE_ABSTRACT_OBJECT, lhsUnionType.tsymbol);
            }
            if (containsSingleObject) {
                return Collections.singletonList(memberType);
            }
            BAttachedFunction initializerFunc = ((BObjectTypeSymbol)memberType.tsymbol).initializerFunc;
            if (!this.isArgsMatchesFunction(cIExpr.argsExpr, initializerFunc)) continue;
            matchingLhsMemberTypes.add(memberType);
        }
        return matchingLhsMemberTypes;
    }

    private BType getMatchingType(List<BType> matchingLhsMembers, BLangTypeInit cIExpr, BType lhsUnion) {
        if (matchingLhsMembers.isEmpty()) {
            this.dlog.error(cIExpr.pos, DiagnosticCode.CANNOT_INFER_OBJECT_TYPE_FROM_LHS, lhsUnion);
            this.resultType = this.symTable.semanticError;
            return this.symTable.semanticError;
        }
        if (matchingLhsMembers.size() == 1) {
            return matchingLhsMembers.get((int)0).tsymbol.type;
        }
        this.dlog.error(cIExpr.pos, DiagnosticCode.AMBIGUOUS_TYPES, lhsUnion);
        this.resultType = this.symTable.semanticError;
        return this.symTable.semanticError;
    }

    private boolean isArgsMatchesFunction(List<BLangExpression> invocationArguments, BAttachedFunction function) {
        invocationArguments.forEach(expr -> this.checkExpr((BLangExpression)expr, this.env, this.symTable.noType));
        if (function == null) {
            return invocationArguments.isEmpty();
        }
        if (function.symbol.params.isEmpty() && invocationArguments.isEmpty()) {
            return true;
        }
        ArrayList<BLangNamedArgsExpression> namedArgs = new ArrayList<BLangNamedArgsExpression>();
        ArrayList<BLangExpression> positionalArgs = new ArrayList<BLangExpression>();
        for (BLangExpression argument : invocationArguments) {
            if (argument.getKind() == NodeKind.NAMED_ARGS_EXPR) {
                namedArgs.add((BLangNamedArgsExpression)argument);
                continue;
            }
            positionalArgs.add(argument);
        }
        List requiredParams = function.symbol.params.stream().filter(param -> !param.defaultableParam).collect(Collectors.toList());
        if (requiredParams.size() > invocationArguments.size()) {
            return false;
        }
        List defaultableParams = function.symbol.params.stream().filter(param -> param.defaultableParam).collect(Collectors.toList());
        int givenRequiredParamCount = 0;
        for (int i = 0; i < positionalArgs.size(); ++i) {
            if (function.symbol.params.size() > i) {
                ++givenRequiredParamCount;
                BVarSymbol functionParam = function.symbol.params.get(i);
                if (!this.types.isAssignable(((BLangExpression)positionalArgs.get((int)i)).type, functionParam.type)) {
                    return false;
                }
                requiredParams.remove(functionParam);
                defaultableParams.remove(functionParam);
                continue;
            }
            if (function.symbol.restParam != null) {
                BType restParamType = ((BArrayType)function.symbol.restParam.type).eType;
                if (this.types.isAssignable(((BLangExpression)positionalArgs.get((int)i)).type, restParamType)) continue;
                return false;
            }
            return false;
        }
        for (BLangNamedArgsExpression namedArg : namedArgs) {
            boolean foundNamedArg = false;
            List<BVarSymbol> params = function.symbol.params;
            for (int i = givenRequiredParamCount; i < params.size(); ++i) {
                BVarSymbol functionParam = params.get(i);
                if (!namedArg.name.value.equals(functionParam.name.value)) continue;
                foundNamedArg = true;
                BType namedArgExprType = this.checkExpr(namedArg.expr, this.env);
                if (!this.types.isAssignable(functionParam.type, namedArgExprType)) {
                    return false;
                }
                requiredParams.remove(functionParam);
                defaultableParams.remove(functionParam);
            }
            if (foundNamedArg) continue;
            return false;
        }
        return requiredParams.size() <= 0;
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr) {
        switch (this.expType.tag) {
            case 12: {
                this.checkTypesForRecords(waitForAllExpr);
                break;
            }
            case 15: {
                this.checkTypesForMap(waitForAllExpr.keyValuePairs, ((BMapType)this.expType).constraint);
                LinkedHashSet<BType> memberTypesForMap = this.collectWaitExprTypes(waitForAllExpr.keyValuePairs);
                if (memberTypesForMap.size() == 1) {
                    this.resultType = new BMapType(15, (BType)memberTypesForMap.iterator().next(), this.symTable.mapType.tsymbol);
                    break;
                }
                BUnionType constraintTypeForMap = BUnionType.create(null, memberTypesForMap);
                this.resultType = new BMapType(15, constraintTypeForMap, this.symTable.mapType.tsymbol);
                break;
            }
            case 17: 
            case 22: {
                this.checkTypesForMap(waitForAllExpr.keyValuePairs, this.expType);
                LinkedHashSet<BType> memberTypes = this.collectWaitExprTypes(waitForAllExpr.keyValuePairs);
                if (memberTypes.size() == 1) {
                    this.resultType = new BMapType(15, (BType)memberTypes.iterator().next(), this.symTable.mapType.tsymbol);
                    break;
                }
                BUnionType constraintType = BUnionType.create(null, memberTypes);
                this.resultType = new BMapType(15, constraintType, this.symTable.mapType.tsymbol);
                break;
            }
            default: {
                this.dlog.error(waitForAllExpr.pos, DiagnosticCode.INCOMPATIBLE_TYPES, this.expType, this.getWaitForAllExprReturnType(waitForAllExpr.keyValuePairs));
                this.resultType = this.symTable.semanticError;
            }
        }
        waitForAllExpr.type = this.resultType;
        if (this.resultType != null && this.resultType != this.symTable.semanticError) {
            this.types.setImplicitCastExpr(waitForAllExpr, waitForAllExpr.type, this.expType);
        }
    }

    private BRecordType getWaitForAllExprReturnType(List<BLangWaitForAllExpr.BLangWaitKeyValue> keyVals) {
        BRecordType retType = new BRecordType(null);
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyVal : keyVals) {
            BLangIdentifier fieldName = keyVal.valueExpr == null || keyVal.valueExpr.getKind() != NodeKind.SIMPLE_VARIABLE_REF ? keyVal.key : ((BLangSimpleVarRef)keyVal.valueExpr).variableName;
            BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromIdNode(fieldName));
            BType fieldType = symbol.type.tag == 30 ? ((BFutureType)symbol.type).constraint : symbol.type;
            BField field = new BField(this.names.fromIdNode(keyVal.key), null, new BVarSymbol(0, this.names.fromIdNode(keyVal.key), this.env.enclPkg.packageID, fieldType, null));
            retType.fields.add(field);
        }
        retType.restFieldType = this.symTable.noType;
        retType.sealed = true;
        retType.tsymbol = Symbols.createRecordSymbol(0, Names.EMPTY, this.env.enclPkg.packageID, retType, null);
        return retType;
    }

    private LinkedHashSet<BType> collectWaitExprTypes(List<BLangWaitForAllExpr.BLangWaitKeyValue> keyVals) {
        LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyVal : keyVals) {
            BType bType;
            BType bType2 = bType = keyVal.keyExpr != null ? keyVal.keyExpr.type : keyVal.valueExpr.type;
            if (bType.tag == 30) {
                memberTypes.add(((BFutureType)bType).constraint);
                continue;
            }
            memberTypes.add(bType);
        }
        return memberTypes;
    }

    private void checkTypesForMap(List<BLangWaitForAllExpr.BLangWaitKeyValue> keyValuePairs, BType expType) {
        keyValuePairs.forEach(keyVal -> this.checkWaitKeyValExpr((BLangWaitForAllExpr.BLangWaitKeyValue)keyVal, expType));
    }

    private void checkTypesForRecords(BLangWaitForAllExpr waitExpr) {
        List<BLangWaitForAllExpr.BLangWaitKeyValue> rhsFields = waitExpr.getKeyValuePairs();
        HashMap lhsFields = new HashMap();
        ((BRecordType)this.expType).getFields().forEach(field -> lhsFields.put(field.name.value, field.type));
        if (((BRecordType)this.expType).sealed && rhsFields.size() > lhsFields.size()) {
            this.dlog.error(waitExpr.pos, DiagnosticCode.INCOMPATIBLE_TYPES, this.expType, this.getWaitForAllExprReturnType(waitExpr.keyValuePairs));
            this.resultType = this.symTable.semanticError;
            return;
        }
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyVal : rhsFields) {
            String key = keyVal.key.value;
            if (!lhsFields.containsKey(key)) {
                if (((BRecordType)this.expType).sealed) {
                    this.dlog.error(waitExpr.pos, DiagnosticCode.INVALID_FIELD_NAME_RECORD_LITERAL, key, this.expType);
                    this.resultType = this.symTable.semanticError;
                    continue;
                }
                BType restFieldType = ((BRecordType)this.expType).restFieldType;
                this.checkWaitKeyValExpr(keyVal, restFieldType);
                continue;
            }
            this.checkWaitKeyValExpr(keyVal, (BType)lhsFields.get(key));
        }
        this.checkMissingReqFieldsForWait((BRecordType)this.expType, rhsFields, waitExpr.pos);
        if (this.symTable.semanticError != this.resultType) {
            this.resultType = this.expType;
        }
    }

    private void checkMissingReqFieldsForWait(BRecordType type, List<BLangWaitForAllExpr.BLangWaitKeyValue> keyValPairs, DiagnosticPos pos) {
        type.fields.forEach(field -> {
            boolean hasField = keyValPairs.stream().anyMatch(keyVal -> field.name.value.equals(keyVal.key.value));
            if (!hasField && Symbols.isFlagOn(field.symbol.flags, 256)) {
                this.dlog.error(pos, DiagnosticCode.MISSING_REQUIRED_RECORD_FIELD, field.name);
            }
        });
    }

    private void checkWaitKeyValExpr(BLangWaitForAllExpr.BLangWaitKeyValue keyVal, BType type) {
        BLangExpression expr;
        if (keyVal.keyExpr != null) {
            BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromIdNode(((BLangSimpleVarRef)keyVal.keyExpr).variableName));
            keyVal.keyExpr.type = symbol.type;
            expr = keyVal.keyExpr;
        } else {
            expr = keyVal.valueExpr;
        }
        BFutureType futureType = new BFutureType(30, type, null);
        this.checkExpr(expr, this.env, futureType);
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        BType condExprType = this.checkExpr(ternaryExpr.expr, this.env, this.symTable.booleanType);
        SymbolEnv thenEnv = this.typeNarrower.evaluateTruth(ternaryExpr.expr, ternaryExpr.thenExpr, this.env);
        BType thenType = this.checkExpr(ternaryExpr.thenExpr, thenEnv, this.expType);
        SymbolEnv elseEnv = this.typeNarrower.evaluateFalsity(ternaryExpr.expr, ternaryExpr.elseExpr, this.env);
        BType elseType = this.checkExpr(ternaryExpr.elseExpr, elseEnv, this.expType);
        if (condExprType == this.symTable.semanticError || thenType == this.symTable.semanticError || elseType == this.symTable.semanticError) {
            this.resultType = this.symTable.semanticError;
        } else if (this.expType == this.symTable.noType) {
            if (this.types.isAssignable(elseType, thenType)) {
                this.resultType = thenType;
            } else if (this.types.isAssignable(thenType, elseType)) {
                this.resultType = elseType;
            } else {
                this.dlog.error(ternaryExpr.pos, DiagnosticCode.INCOMPATIBLE_TYPES, thenType, elseType);
                this.resultType = this.symTable.semanticError;
            }
        } else {
            this.resultType = this.expType;
        }
    }

    @Override
    public void visit(BLangWaitExpr waitExpr) {
        this.expType = new BFutureType(30, this.expType, null);
        this.checkExpr(waitExpr.getExpression(), this.env, this.expType);
        if (this.resultType.tag == 20) {
            LinkedHashSet<BType> memberTypes = this.collectMemberTypes((BUnionType)this.resultType, new LinkedHashSet<BType>());
            this.resultType = memberTypes.size() == 1 ? memberTypes.toArray(new BType[0])[0] : BUnionType.create(null, memberTypes);
        } else if (this.resultType != this.symTable.semanticError) {
            this.resultType = ((BFutureType)this.resultType).constraint;
        }
        waitExpr.type = this.resultType;
        if (this.resultType != null && this.resultType != this.symTable.semanticError) {
            this.types.setImplicitCastExpr(waitExpr, waitExpr.type, ((BFutureType)this.expType).constraint);
        }
    }

    private LinkedHashSet<BType> collectMemberTypes(BUnionType unionType, LinkedHashSet<BType> memberTypes) {
        for (BType memberType : unionType.getMemberTypes()) {
            if (memberType.tag == 30) {
                memberTypes.add(((BFutureType)memberType).constraint);
                continue;
            }
            memberTypes.add(memberType);
        }
        return memberTypes;
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        BType actualType;
        boolean definedWithVar;
        boolean firstVisit = trapExpr.expr.type == null;
        BType exprType = this.checkExpr(trapExpr.expr, this.env, this.expType);
        boolean bl = definedWithVar = this.expType == this.symTable.noType;
        if (trapExpr.expr.getKind() == NodeKind.WORKER_RECEIVE) {
            if (firstVisit) {
                this.isTypeChecked = false;
                this.resultType = this.expType;
                return;
            }
            this.expType = trapExpr.type;
            exprType = trapExpr.expr.type;
        }
        if (this.expType == this.symTable.semanticError || exprType == this.symTable.semanticError) {
            actualType = this.symTable.semanticError;
        } else {
            LinkedHashSet<BType> resultTypes = new LinkedHashSet<BType>();
            if (exprType.tag == 20) {
                resultTypes.addAll(((BUnionType)exprType).getMemberTypes());
            } else {
                resultTypes.add(exprType);
            }
            resultTypes.add(this.symTable.errorType);
            actualType = BUnionType.create(null, resultTypes);
        }
        this.resultType = this.types.checkType(trapExpr, actualType, this.expType);
        if (definedWithVar && this.resultType != null && this.resultType != this.symTable.semanticError) {
            this.types.setImplicitCastExpr(trapExpr.expr, trapExpr.expr.type, this.resultType);
        }
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        if (this.expType.tag == 30 && binaryExpr.opKind == OperatorKind.BITWISE_OR) {
            BType lhsResultType = this.checkExpr(binaryExpr.lhsExpr, this.env, this.expType);
            BType rhsResultType = this.checkExpr(binaryExpr.rhsExpr, this.env, this.expType);
            if (lhsResultType == this.symTable.semanticError || rhsResultType == this.symTable.semanticError) {
                this.resultType = this.symTable.semanticError;
                return;
            }
            this.resultType = BUnionType.create(null, lhsResultType, rhsResultType);
            return;
        }
        this.checkDecimalCompatibilityForBinaryArithmeticOverLiteralValues(binaryExpr);
        BType lhsType = this.checkExpr(binaryExpr.lhsExpr, this.env);
        SymbolEnv rhsExprEnv = binaryExpr.opKind == OperatorKind.AND ? this.typeNarrower.evaluateTruth(binaryExpr.lhsExpr, binaryExpr.rhsExpr, this.env) : (binaryExpr.opKind == OperatorKind.OR ? this.typeNarrower.evaluateFalsity(binaryExpr.lhsExpr, binaryExpr.rhsExpr, this.env) : this.env);
        BType rhsType = this.checkExpr(binaryExpr.rhsExpr, rhsExprEnv);
        BType actualType = this.symTable.semanticError;
        if (lhsType != this.symTable.semanticError && rhsType != this.symTable.semanticError) {
            BSymbol opSymbol = this.symResolver.resolveBinaryOperator(binaryExpr.opKind, lhsType, rhsType);
            if (opSymbol == this.symTable.notFoundSymbol) {
                opSymbol = this.symResolver.getBinaryEqualityForTypeSets(binaryExpr.opKind, lhsType, rhsType, binaryExpr);
            }
            if (opSymbol == this.symTable.notFoundSymbol) {
                this.dlog.error(binaryExpr.pos, DiagnosticCode.BINARY_OP_INCOMPATIBLE_TYPES, new Object[]{binaryExpr.opKind, lhsType, rhsType});
            } else {
                if ((binaryExpr.opKind == OperatorKind.EQUAL || binaryExpr.opKind == OperatorKind.NOT_EQUAL) && this.couldHoldTableValues(lhsType, new ArrayList<BType>()) && this.couldHoldTableValues(rhsType, new ArrayList<BType>())) {
                    this.dlog.error(binaryExpr.pos, DiagnosticCode.EQUALITY_NOT_YET_SUPPORTED, TABLE_TNAME);
                }
                binaryExpr.opSymbol = (BOperatorSymbol)opSymbol;
                actualType = opSymbol.type.getReturnType();
            }
        }
        this.resultType = this.types.checkType(binaryExpr, actualType, this.expType);
    }

    private void checkDecimalCompatibilityForBinaryArithmeticOverLiteralValues(BLangBinaryExpr binaryExpr) {
        if (this.expType.tag != 4) {
            return;
        }
        switch (binaryExpr.opKind) {
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: {
                this.checkExpr(binaryExpr.lhsExpr, this.env, this.expType);
                this.checkExpr(binaryExpr.rhsExpr, this.env, this.expType);
                break;
            }
        }
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        BType lhsType = this.checkExpr(elvisExpr.lhsExpr, this.env);
        BType actualType = this.symTable.semanticError;
        if (lhsType != this.symTable.semanticError) {
            if (lhsType.tag == 20 && lhsType.isNullable()) {
                BUnionType unionType = (BUnionType)lhsType;
                LinkedHashSet memberTypes = unionType.getMemberTypes().stream().filter(type -> type.tag != 10).collect(Collectors.toCollection(LinkedHashSet::new));
                actualType = memberTypes.size() == 1 ? memberTypes.toArray(new BType[0])[0] : BUnionType.create(null, memberTypes);
            } else {
                this.dlog.error(elvisExpr.pos, DiagnosticCode.OPERATOR_NOT_SUPPORTED, new Object[]{OperatorKind.ELVIS, lhsType});
            }
        }
        BType rhsReturnType = this.checkExpr(elvisExpr.rhsExpr, this.env, this.expType);
        BType lhsReturnType = this.types.checkType(elvisExpr.lhsExpr.pos, actualType, this.expType, DiagnosticCode.INCOMPATIBLE_TYPES);
        if (rhsReturnType == this.symTable.semanticError || lhsReturnType == this.symTable.semanticError) {
            this.resultType = this.symTable.semanticError;
        } else if (this.expType == this.symTable.noType) {
            if (this.types.isSameType(rhsReturnType, lhsReturnType)) {
                this.resultType = lhsReturnType;
            } else {
                this.dlog.error(elvisExpr.rhsExpr.pos, DiagnosticCode.INCOMPATIBLE_TYPES, lhsReturnType, rhsReturnType);
                this.resultType = this.symTable.semanticError;
            }
        } else {
            this.resultType = this.expType;
        }
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        this.resultType = this.checkExpr(groupExpr.expression, this.env, this.expType);
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
        accessExpr.resolvedType = this.symResolver.resolveTypeNode(accessExpr.typeNode, this.env);
        int resolveTypeTag = accessExpr.resolvedType.tag;
        BType actualType = resolveTypeTag != 13 && resolveTypeTag != 22 ? new BTypedescType(accessExpr.resolvedType, null) : accessExpr.resolvedType;
        this.resultType = this.types.checkType(accessExpr, actualType, this.expType);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        BType actualType = this.symTable.semanticError;
        if (OperatorKind.UNTAINT.equals((Object)unaryExpr.operator)) {
            BType exprType = this.checkExpr(unaryExpr.expr, this.env);
            if (exprType != this.symTable.semanticError) {
                actualType = exprType;
            }
        } else if (OperatorKind.TYPEOF.equals((Object)unaryExpr.operator)) {
            BType exprType = this.checkExpr(unaryExpr.expr, this.env);
            if (exprType != this.symTable.semanticError) {
                actualType = new BTypedescType(exprType, null);
            }
        } else {
            BType exprType;
            BType bType = exprType = OperatorKind.ADD.equals((Object)unaryExpr.operator) ? this.checkExpr(unaryExpr.expr, this.env, this.expType) : this.checkExpr(unaryExpr.expr, this.env);
            if (exprType != this.symTable.semanticError) {
                BSymbol symbol = this.symResolver.resolveUnaryOperator(unaryExpr.pos, unaryExpr.operator, exprType);
                if (symbol == this.symTable.notFoundSymbol) {
                    this.dlog.error(unaryExpr.pos, DiagnosticCode.UNARY_OP_INCOMPATIBLE_TYPES, new Object[]{unaryExpr.operator, exprType});
                } else {
                    unaryExpr.opSymbol = (BOperatorSymbol)symbol;
                    actualType = symbol.type.getReturnType();
                }
            }
        }
        this.resultType = this.types.checkType(unaryExpr, actualType, this.expType);
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        BType targetType;
        BType actualType = this.symTable.semanticError;
        BLangExpression expr = conversionExpr.expr;
        if (conversionExpr.typeNode == null && !conversionExpr.annAttachments.isEmpty()) {
            BType expType;
            this.resultType = expType = this.checkExpr(expr, this.env, this.expType);
            return;
        }
        conversionExpr.targetType = targetType = this.symResolver.resolveTypeNode(conversionExpr.typeNode, this.env);
        BType expType = this.requireTypeInference(expr, false) ? targetType : this.symTable.noType;
        BType sourceType = this.checkExpr(expr, this.env, expType);
        if (this.types.isTypeCastable(expr, sourceType, targetType)) {
            actualType = targetType;
        } else {
            this.dlog.error(conversionExpr.pos, DiagnosticCode.INCOMPATIBLE_TYPES_CAST, sourceType, targetType);
        }
        this.resultType = this.types.checkType(conversionExpr, actualType, this.expType);
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        bLangLambdaFunction.type = bLangLambdaFunction.function.symbol.type;
        bLangLambdaFunction.capturedClosureEnv = this.env.createClone();
        this.env.enclPkg.lambdaFunctions.add(bLangLambdaFunction);
        this.resultType = this.types.checkType(bLangLambdaFunction, bLangLambdaFunction.type, this.expType);
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        BUnionType unionType;
        BType invokableType;
        BType expectedType = this.expType;
        if (expectedType.tag == 20 && (invokableType = (unionType = (BUnionType)expectedType).getMemberTypes().stream().filter(type -> type.tag == 16).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.size() != 1) {
                return null;
            }
            return (BType)list.get(0);
        }))) != null) {
            expectedType = invokableType;
        }
        if (expectedType.tag != 16) {
            this.dlog.error(bLangArrowFunction.pos, DiagnosticCode.ARROW_EXPRESSION_CANNOT_INFER_TYPE_FROM_LHS, new Object[0]);
            this.resultType = this.symTable.semanticError;
            return;
        }
        BInvokableType expectedInvocation = (BInvokableType)expectedType;
        this.populateArrowExprParamTypes(bLangArrowFunction, expectedInvocation.paramTypes);
        bLangArrowFunction.body.expr.type = this.populateArrowExprReturn(bLangArrowFunction, expectedInvocation.retType);
        if (expectedInvocation.retType.tag == 22) {
            expectedInvocation.retType = bLangArrowFunction.body.expr.type;
        }
        this.resultType = bLangArrowFunction.funcType = expectedInvocation;
    }

    @Override
    public void visit(BLangXMLQName bLangXMLQName) {
        String prefix = bLangXMLQName.prefix.value;
        this.resultType = this.types.checkType(bLangXMLQName, this.symTable.stringType, this.expType);
        if (this.env.node.getKind() == NodeKind.XML_ATTRIBUTE && prefix.isEmpty() && bLangXMLQName.localname.value.equals("xmlns")) {
            ((BLangXMLAttribute)this.env.node).isNamespaceDeclr = true;
            return;
        }
        if (this.env.node.getKind() == NodeKind.XML_ATTRIBUTE && prefix.equals("xmlns")) {
            ((BLangXMLAttribute)this.env.node).isNamespaceDeclr = true;
            return;
        }
        if (prefix.equals("xmlns")) {
            this.dlog.error(bLangXMLQName.pos, DiagnosticCode.INVALID_NAMESPACE_PREFIX, prefix);
            bLangXMLQName.type = this.symTable.semanticError;
            return;
        }
        BSymbol xmlnsSymbol = this.symResolver.lookupSymbolInPrefixSpace(this.env, this.names.fromIdNode(bLangXMLQName.prefix));
        if (prefix.isEmpty() && xmlnsSymbol == this.symTable.notFoundSymbol) {
            return;
        }
        if (!prefix.isEmpty() && xmlnsSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(bLangXMLQName.pos, DiagnosticCode.UNDEFINED_SYMBOL, prefix);
            bLangXMLQName.type = this.symTable.semanticError;
            return;
        }
        if (xmlnsSymbol.getKind() == SymbolKind.PACKAGE) {
            xmlnsSymbol = this.findXMLNamespaceFromPackageConst(bLangXMLQName.localname.value, bLangXMLQName.prefix.value, (BPackageSymbol)xmlnsSymbol, bLangXMLQName.pos);
        }
        if (xmlnsSymbol == null || xmlnsSymbol.getKind() != SymbolKind.XMLNS) {
            this.resultType = this.symTable.semanticError;
            return;
        }
        bLangXMLQName.nsSymbol = (BXMLNSSymbol)xmlnsSymbol;
        bLangXMLQName.namespaceURI = bLangXMLQName.nsSymbol.namespaceURI;
    }

    private BSymbol findXMLNamespaceFromPackageConst(String localname, String prefix, BPackageSymbol pkgSymbol, DiagnosticPos pos) {
        BSymbol constSymbol = this.symResolver.lookupMemberSymbol(pos, pkgSymbol.scope, this.env, this.names.fromString(localname), 0x100001C);
        if (constSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticCode.UNDEFINED_SYMBOL, prefix + ":" + localname);
            return null;
        }
        BConstantSymbol constantSymbol = (BConstantSymbol)constSymbol;
        if (constantSymbol.literalType.tag != 5) {
            this.dlog.error(pos, DiagnosticCode.INCOMPATIBLE_TYPES, this.symTable.stringType, constantSymbol.literalType);
            return null;
        }
        String constVal = (String)constantSymbol.value.value;
        int s = constVal.indexOf(123);
        int e = constVal.lastIndexOf(125);
        if (e > s + 1) {
            pkgSymbol.isUsed = true;
            String nsURI = constVal.substring(s + 1, e);
            String local = constVal.substring(e);
            return new BXMLNSSymbol(this.names.fromString(local), nsURI, constantSymbol.pkgID, constantSymbol.owner);
        }
        this.dlog.error(pos, DiagnosticCode.INVALID_ATTRIBUTE_REFERENCE, prefix + ":" + localname);
        return null;
    }

    @Override
    public void visit(BLangXMLAttribute bLangXMLAttribute) {
        SymbolEnv xmlAttributeEnv = SymbolEnv.getXMLAttributeEnv(bLangXMLAttribute, this.env);
        this.checkExpr(bLangXMLAttribute.name, xmlAttributeEnv, this.symTable.stringType);
        this.checkExpr(bLangXMLAttribute.value, xmlAttributeEnv, this.symTable.stringType);
        this.symbolEnter.defineNode(bLangXMLAttribute, this.env);
    }

    @Override
    public void visit(BLangXMLElementLiteral bLangXMLElementLiteral) {
        SymbolEnv xmlElementEnv = SymbolEnv.getXMLElementEnv(bLangXMLElementLiteral, this.env);
        HashSet<String> usedPrefixes = new HashSet<String>();
        BLangIdentifier elemNamePrefix = ((BLangXMLQName)bLangXMLElementLiteral.startTagName).prefix;
        if (elemNamePrefix != null && !elemNamePrefix.value.isEmpty()) {
            usedPrefixes.add(elemNamePrefix.value);
        }
        for (BLangXMLAttribute attribute2 : bLangXMLElementLiteral.attributes) {
            BLangIdentifier prefix;
            if (attribute2.name.getKind() == NodeKind.XML_QNAME && this.isXmlNamespaceAttribute(attribute2)) {
                BLangXMLQuotedString value = attribute2.value;
                if (value.getKind() == NodeKind.XML_QUOTED_STRING && value.textFragments.size() > 1) {
                    this.dlog.error(value.pos, DiagnosticCode.INVALID_XML_NS_INTERPOLATION, new Object[0]);
                }
                this.checkExpr(attribute2, xmlElementEnv, this.symTable.noType);
            }
            if ((prefix = ((BLangXMLQName)attribute2.name).prefix) == null || prefix.value.isEmpty()) continue;
            usedPrefixes.add(prefix.value);
        }
        bLangXMLElementLiteral.attributes.forEach(attribute -> {
            if (attribute.name.getKind() != NodeKind.XML_QNAME || !this.isXmlNamespaceAttribute((BLangXMLAttribute)attribute)) {
                this.checkExpr((BLangExpression)attribute, xmlElementEnv, this.symTable.noType);
            }
        });
        Map<Name, BXMLNSSymbol> namespaces = this.symResolver.resolveAllNamespaces(xmlElementEnv);
        Name defaultNs = this.names.fromString("");
        if (namespaces.containsKey(defaultNs)) {
            bLangXMLElementLiteral.defaultNsSymbol = namespaces.remove(defaultNs);
        }
        for (Map.Entry<Name, BXMLNSSymbol> nsEntry : namespaces.entrySet()) {
            if (!usedPrefixes.contains(nsEntry.getKey().value)) continue;
            bLangXMLElementLiteral.namespacesInScope.put(nsEntry.getKey(), nsEntry.getValue());
        }
        this.validateTags(bLangXMLElementLiteral, xmlElementEnv);
        bLangXMLElementLiteral.modifiedChildren = this.concatSimilarKindXMLNodes(bLangXMLElementLiteral.children, xmlElementEnv);
        this.resultType = this.types.checkType(bLangXMLElementLiteral, this.symTable.xmlType, this.expType);
    }

    private boolean isXmlNamespaceAttribute(BLangXMLAttribute attribute) {
        BLangXMLQName attrName = (BLangXMLQName)attribute.name;
        return attrName.prefix.value.isEmpty() && attrName.localname.value.equals("xmlns") || attrName.prefix.value.equals("xmlns");
    }

    @Override
    public void visit(BLangXMLTextLiteral bLangXMLTextLiteral) {
        this.checkStringTemplateExprs(bLangXMLTextLiteral.textFragments, false);
        this.resultType = this.types.checkType(bLangXMLTextLiteral, this.symTable.xmlType, this.expType);
    }

    @Override
    public void visit(BLangXMLCommentLiteral bLangXMLCommentLiteral) {
        this.checkStringTemplateExprs(bLangXMLCommentLiteral.textFragments, false);
        this.resultType = this.types.checkType(bLangXMLCommentLiteral, this.symTable.xmlType, this.expType);
    }

    @Override
    public void visit(BLangXMLProcInsLiteral bLangXMLProcInsLiteral) {
        this.checkExpr(bLangXMLProcInsLiteral.target, this.env, this.symTable.stringType);
        this.checkStringTemplateExprs(bLangXMLProcInsLiteral.dataFragments, false);
        this.resultType = this.types.checkType(bLangXMLProcInsLiteral, this.symTable.xmlType, this.expType);
    }

    @Override
    public void visit(BLangXMLQuotedString bLangXMLQuotedString) {
        this.checkStringTemplateExprs(bLangXMLQuotedString.textFragments, false);
        this.resultType = this.types.checkType(bLangXMLQuotedString, this.symTable.stringType, this.expType);
    }

    @Override
    public void visit(BLangXMLAttributeAccess xmlAttributeAccessExpr) {
        this.dlog.error(xmlAttributeAccessExpr.pos, DiagnosticCode.DEPRECATED_XML_ATTRIBUTE_ACCESS, new Object[0]);
        this.resultType = this.symTable.semanticError;
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        this.checkStringTemplateExprs(stringTemplateLiteral.exprs, false);
        this.resultType = this.types.checkType(stringTemplateLiteral, this.symTable.stringType, this.expType);
    }

    @Override
    public void visit(BLangIntRangeExpression intRangeExpression) {
        this.checkExpr(intRangeExpression.startExpr, this.env, this.symTable.intType);
        this.checkExpr(intRangeExpression.endExpr, this.env, this.symTable.intType);
        this.resultType = new BArrayType(this.symTable.intType);
    }

    @Override
    public void visit(BLangRestArgsExpression bLangRestArgExpression) {
        this.resultType = this.checkExpr(bLangRestArgExpression.expr, this.env, this.expType);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        this.resultType = this.checkExpr(bLangNamedArgsExpression.expr, this.env, this.expType);
        bLangNamedArgsExpression.type = bLangNamedArgsExpression.expr.type;
    }

    @Override
    public void visit(BLangMatchExpression bLangMatchExpression) {
        SymbolEnv matchExprEnv = SymbolEnv.createBlockEnv((BLangBlockStmt)TreeBuilder.createBlockNode(), this.env);
        this.checkExpr(bLangMatchExpression.expr, matchExprEnv);
        bLangMatchExpression.patternClauses.forEach(pattern -> {
            if (!pattern.variable.name.value.endsWith(Names.IGNORE.value)) {
                this.symbolEnter.defineNode(pattern.variable, matchExprEnv);
            }
            this.checkExpr(pattern.expr, matchExprEnv, this.expType);
            pattern.variable.type = this.symResolver.resolveTypeNode(pattern.variable.typeNode, matchExprEnv);
        });
        LinkedHashSet<BType> matchExprTypes = this.getMatchExpressionTypes(bLangMatchExpression);
        BType actualType = matchExprTypes.contains(this.symTable.semanticError) ? this.symTable.semanticError : (matchExprTypes.size() == 1 ? matchExprTypes.toArray(new BType[0])[0] : BUnionType.create(null, matchExprTypes));
        this.resultType = this.types.checkType(bLangMatchExpression, actualType, this.expType);
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.visitCheckAndCheckPanicExpr(checkedExpr);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkedExpr) {
        this.visitCheckAndCheckPanicExpr(checkedExpr);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(BLangQueryExpr queryExpr) {
        void var8_12;
        List<BLangFromClause> fromClauseList = queryExpr.fromClauseList;
        List<BLangWhereClause> whereClauseList = queryExpr.whereClauseList;
        List<BLangLetClause> letClauseList = queryExpr.letClausesList;
        BLangExpression collectionNode = (BLangExpression)((FromClauseNode)fromClauseList.get(0)).getCollection();
        SymbolEnv parentEnv = this.env;
        for (FromClauseNode fromClauseNode : fromClauseList) {
            parentEnv = this.typeCheckFromClause((BLangFromClause)fromClauseNode, parentEnv);
        }
        for (LetClauseNode letClauseNode : letClauseList) {
            parentEnv = this.typeCheckLetClause((BLangLetClause)letClauseNode, parentEnv);
        }
        BLangSelectClause selectClause = queryExpr.selectClause;
        SymbolEnv symbolEnv = parentEnv;
        for (WhereClauseNode whereClauseNode : whereClauseList) {
            SymbolEnv symbolEnv2 = this.typeCheckWhereClause((BLangWhereClause)whereClauseNode, selectClause, parentEnv);
        }
        BType actualType = this.findAssignableType((SymbolEnv)var8_12, selectClause.expression, collectionNode.type, this.expType);
        this.resultType = actualType != this.symTable.semanticError ? this.types.checkType(queryExpr.pos, actualType, this.expType, DiagnosticCode.INCOMPATIBLE_TYPES) : actualType;
    }

    private BType findAssignableType(SymbolEnv env, BLangExpression selectExp, BType collectionType, BType targetType) {
        Map<Boolean, List<BType>> collectionTypeMap;
        ArrayList<BType> assignableSelectTypes = new ArrayList<BType>();
        int enclosedTypeTag = targetType.tag == 22 ? collectionType.tag : this.expType.tag;
        BType actualType = this.symTable.semanticError;
        Map<Boolean, List<BType>> resultTypeMap = this.types.getAllTypes(targetType).stream().collect(Collectors.groupingBy(memberType -> this.types.isAssignable((BType)memberType, this.symTable.errorType) || this.types.isAssignable((BType)memberType, this.symTable.nilType)));
        for (BType type : resultTypeMap.get(false)) {
            BType selectType;
            switch (type.tag) {
                case 19: {
                    selectType = this.checkExpr(selectExp, env, ((BArrayType)type).eType);
                    enclosedTypeTag = 19;
                    break;
                }
                case 14: {
                    selectType = this.checkExpr(selectExp, env, ((BStreamType)type).constraint);
                    break;
                }
                default: {
                    selectType = this.checkExpr(selectExp, env, type);
                    enclosedTypeTag = 19;
                }
            }
            if (selectType == this.symTable.semanticError) continue;
            assignableSelectTypes.add(selectType);
        }
        if (assignableSelectTypes.size() == 1) {
            actualType = (BType)assignableSelectTypes.get(0);
            if (enclosedTypeTag == 19) {
                actualType = new BArrayType((BType)assignableSelectTypes.get(0));
            }
        } else {
            if (assignableSelectTypes.size() > 1) {
                this.dlog.error(selectExp.pos, DiagnosticCode.AMBIGUOUS_TYPES, assignableSelectTypes);
                return actualType;
            }
            return actualType;
        }
        BUnionType nextMethodReturnType = null;
        switch (collectionType.tag) {
            case 14: {
                BErrorType errorType = (BErrorType)((BStreamType)collectionType).error;
                if (errorType == null) break;
                return BUnionType.create(null, actualType, errorType);
            }
            case 32: {
                nextMethodReturnType = this.types.getVarTypeFromIterableObject((BObjectType)collectionType);
                break;
            }
            default: {
                BInvokableSymbol iteratorSymbol = (BInvokableSymbol)this.symResolver.lookupLangLibMethod(collectionType, this.names.fromString("iterator"));
                nextMethodReturnType = (BUnionType)this.types.getResultTypeOfNextInvocation((BObjectType)iteratorSymbol.retType);
            }
        }
        if (nextMethodReturnType != null && (collectionTypeMap = this.types.getAllTypes(nextMethodReturnType).stream().collect(Collectors.groupingBy(memberType -> this.types.isAssignable((BType)memberType, this.symTable.errorType)))).get(true) != null && !collectionTypeMap.get(true).isEmpty()) {
            List<BType> collectionTypes = Lists.of(actualType);
            collectionTypes.addAll((Collection<BType>)collectionTypeMap.get(true));
            return BUnionType.create(null, collectionTypes.toArray(new BType[collectionTypes.size()]));
        }
        return actualType;
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        List<BLangFromClause> fromClauseList = queryAction.fromClauseList;
        List<BLangWhereClause> whereClauseList = queryAction.whereClauseList;
        List<BLangLetClause> letClauseList = queryAction.letClauseList;
        BLangDoClause doClauseNode = queryAction.doClause;
        SymbolEnv parentEnv = this.env;
        for (FromClauseNode fromClauseNode : fromClauseList) {
            parentEnv = this.typeCheckFromClause((BLangFromClause)fromClauseNode, parentEnv);
        }
        for (LetClauseNode letClauseNode : letClauseList) {
            parentEnv = this.typeCheckLetClause((BLangLetClause)letClauseNode, parentEnv);
        }
        SymbolEnv whereEnv = parentEnv;
        for (WhereClauseNode whereClauseNode : whereClauseList) {
            BLangWhereClause whereClause = (BLangWhereClause)whereClauseNode;
            this.checkExpr(whereClause.expression, parentEnv);
            whereEnv = this.typeNarrower.evaluateTruth(whereClause.expression, doClauseNode, parentEnv);
        }
        SymbolEnv symbolEnv = SymbolEnv.createBlockEnv(doClauseNode.body, whereEnv);
        this.semanticAnalyzer.analyzeStmt(doClauseNode.body, symbolEnv);
        BUnionType bUnionType = BUnionType.create(null, this.symTable.errorType, this.symTable.nilType);
        this.resultType = this.types.checkType(doClauseNode.pos, (BType)bUnionType, this.expType, DiagnosticCode.INCOMPATIBLE_TYPES);
    }

    private SymbolEnv typeCheckFromClause(BLangFromClause fromClause, SymbolEnv parentEnv) {
        this.checkExpr(fromClause.collection, parentEnv);
        this.types.setFromClauseTypedBindingPatternType(fromClause);
        SymbolEnv fromClauseEnv = SymbolEnv.createTypeNarrowedEnv(fromClause, parentEnv);
        this.handleFromClauseVariables(fromClause, fromClauseEnv);
        return fromClauseEnv;
    }

    private SymbolEnv typeCheckLetClause(BLangLetClause letClause, SymbolEnv parentEnv) {
        SymbolEnv letClauseEnv = SymbolEnv.createTypeNarrowedEnv(letClause, parentEnv);
        for (BLangLetVariable letVariable : letClause.letVarDeclarations) {
            this.semanticAnalyzer.analyzeDef((BLangNode)((Object)letVariable.definitionNode), letClauseEnv);
        }
        return letClauseEnv;
    }

    private SymbolEnv typeCheckWhereClause(BLangWhereClause whereClause, BLangSelectClause selectClause, SymbolEnv parentEnv) {
        this.checkExpr(whereClause.expression, parentEnv, this.symTable.booleanType);
        BType actualType = whereClause.expression.type;
        if (29 == actualType.tag) {
            this.dlog.error(whereClause.expression.pos, DiagnosticCode.INCOMPATIBLE_TYPES, this.symTable.booleanType, actualType);
        }
        return this.typeNarrower.evaluateTruth(whereClause.expression, selectClause, parentEnv);
    }

    private void handleFromClauseVariables(BLangFromClause fromClause, SymbolEnv blockEnv) {
        if (fromClause.variableDefinitionNode == null) {
            return;
        }
        BLangVariable variableNode = (BLangVariable)fromClause.variableDefinitionNode.getVariable();
        if (fromClause.isDeclaredWithVar) {
            this.semanticAnalyzer.handleDeclaredVarInForeach(variableNode, fromClause.varType, blockEnv);
            return;
        }
        BType typeNodeType = this.symResolver.resolveTypeNode(variableNode.typeNode, blockEnv);
        if (this.types.isAssignable(fromClause.varType, typeNodeType)) {
            this.semanticAnalyzer.handleDeclaredVarInForeach(variableNode, fromClause.varType, blockEnv);
            return;
        }
        if (typeNodeType != this.symTable.semanticError) {
            this.dlog.error(variableNode.typeNode.pos, DiagnosticCode.INCOMPATIBLE_TYPES, fromClause.varType, typeNodeType);
        }
        this.semanticAnalyzer.handleDeclaredVarInForeach(variableNode, typeNodeType, blockEnv);
    }

    private void visitCheckAndCheckPanicExpr(BLangCheckedExpr checkedExpr) {
        String operatorType = checkedExpr.getKind() == NodeKind.CHECK_EXPR ? "check" : "checkpanic";
        boolean firstVisit = checkedExpr.expr.type == null;
        BType exprExpType = this.expType == this.symTable.noType ? this.symTable.noType : BUnionType.create(null, this.expType, this.symTable.errorType);
        BType exprType = this.checkExpr(checkedExpr.expr, this.env, exprExpType);
        if (checkedExpr.expr.getKind() == NodeKind.WORKER_RECEIVE) {
            if (firstVisit) {
                this.isTypeChecked = false;
                this.resultType = this.expType;
                return;
            }
            this.expType = checkedExpr.type;
            exprType = checkedExpr.expr.type;
        }
        if (exprType.tag != 20) {
            if (this.types.isAssignable(exprType, this.symTable.errorType)) {
                this.dlog.error(checkedExpr.expr.pos, DiagnosticCode.CHECKED_EXPR_INVALID_USAGE_ALL_ERROR_TYPES_IN_RHS, operatorType);
            } else if (exprType != this.symTable.semanticError) {
                this.dlog.error(checkedExpr.expr.pos, DiagnosticCode.CHECKED_EXPR_INVALID_USAGE_NO_ERROR_TYPE_IN_RHS, operatorType);
            }
            checkedExpr.type = this.symTable.semanticError;
            return;
        }
        BUnionType unionType = (BUnionType)exprType;
        Map<Boolean, List<BType>> resultTypeMap = unionType.getMemberTypes().stream().collect(Collectors.groupingBy(memberType -> this.types.isAssignable((BType)memberType, this.symTable.errorType)));
        checkedExpr.equivalentErrorTypeList = resultTypeMap.get(true);
        if (checkedExpr.equivalentErrorTypeList == null || checkedExpr.equivalentErrorTypeList.size() == 0) {
            this.dlog.error(checkedExpr.expr.pos, DiagnosticCode.CHECKED_EXPR_INVALID_USAGE_NO_ERROR_TYPE_IN_RHS, operatorType);
            checkedExpr.type = this.symTable.semanticError;
            return;
        }
        List<BType> nonErrorTypeList = resultTypeMap.get(false);
        if (nonErrorTypeList == null || nonErrorTypeList.size() == 0) {
            this.dlog.error(checkedExpr.expr.pos, DiagnosticCode.CHECKED_EXPR_INVALID_USAGE_ALL_ERROR_TYPES_IN_RHS, operatorType);
            checkedExpr.type = this.symTable.semanticError;
            return;
        }
        BType actualType = nonErrorTypeList.size() == 1 ? nonErrorTypeList.get(0) : BUnionType.create(null, new LinkedHashSet<BType>(nonErrorTypeList));
        this.resultType = this.types.checkType(checkedExpr, actualType, this.expType);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        this.resultType = serviceConstructorExpr.serviceNode.symbol.type;
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        typeTestExpr.typeNode.type = this.symResolver.resolveTypeNode(typeTestExpr.typeNode, this.env);
        this.checkExpr(typeTestExpr.expr, this.env);
        this.resultType = this.types.checkType(typeTestExpr, this.symTable.booleanType, this.expType);
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        this.checkExpr(annotAccessExpr.expr, this.env, this.symTable.typeDesc);
        BType actualType = this.symTable.semanticError;
        BSymbol symbol = this.symResolver.resolveAnnotation(annotAccessExpr.pos, this.env, this.names.fromString(annotAccessExpr.pkgAlias.getValue()), this.names.fromString(annotAccessExpr.annotationName.getValue()));
        if (symbol == this.symTable.notFoundSymbol) {
            this.dlog.error(annotAccessExpr.pos, DiagnosticCode.UNDEFINED_ANNOTATION, annotAccessExpr.annotationName.getValue());
        } else {
            annotAccessExpr.annotationSymbol = (BAnnotationSymbol)symbol;
            BType annotType = ((BAnnotationSymbol)symbol).attachedType == null ? this.symTable.trueType : ((BAnnotationSymbol)symbol).attachedType.type;
            actualType = BUnionType.create(null, annotType, this.symTable.nilType);
        }
        this.resultType = this.types.checkType(annotAccessExpr, actualType, this.expType);
    }

    private boolean isValidVariableReference(BLangExpression varRef) {
        switch (varRef.getKind()) {
            case SIMPLE_VARIABLE_REF: 
            case RECORD_VARIABLE_REF: 
            case TUPLE_VARIABLE_REF: 
            case ERROR_VARIABLE_REF: 
            case FIELD_BASED_ACCESS_EXPR: 
            case INDEX_BASED_ACCESS_EXPR: 
            case XML_ATTRIBUTE_ACCESS_EXPR: {
                return true;
            }
        }
        this.dlog.error(varRef.pos, DiagnosticCode.INVALID_RECORD_BINDING_PATTERN, varRef.type);
        return false;
    }

    private BType populateArrowExprReturn(BLangArrowFunction bLangArrowFunction, BType expectedRetType) {
        SymbolEnv arrowFunctionEnv = SymbolEnv.createArrowFunctionSymbolEnv(bLangArrowFunction, this.env);
        bLangArrowFunction.params.forEach(param -> this.symbolEnter.defineNode((BLangNode)param, arrowFunctionEnv));
        return this.checkExpr(bLangArrowFunction.body.expr, arrowFunctionEnv, expectedRetType);
    }

    private void populateArrowExprParamTypes(BLangArrowFunction bLangArrowFunction, List<BType> paramTypes) {
        if (paramTypes.size() != bLangArrowFunction.params.size()) {
            this.dlog.error(bLangArrowFunction.pos, DiagnosticCode.ARROW_EXPRESSION_MISMATCHED_PARAMETER_LENGTH, paramTypes.size(), bLangArrowFunction.params.size());
            this.resultType = this.symTable.semanticError;
            bLangArrowFunction.params.forEach(param -> {
                param.type = this.symTable.semanticError;
            });
            return;
        }
        for (int i = 0; i < bLangArrowFunction.params.size(); ++i) {
            BLangSimpleVariable paramIdentifier = bLangArrowFunction.params.get(i);
            BType bType = paramTypes.get(i);
            BLangValueType valueTypeNode = (BLangValueType)TreeBuilder.createValueTypeNode();
            valueTypeNode.setTypeKind(bType.getKind());
            paramIdentifier.setTypeNode(valueTypeNode);
            paramIdentifier.type = bType;
        }
    }

    private void checkSefReferences(DiagnosticPos pos, SymbolEnv env, BVarSymbol varSymbol) {
        if (env.enclVarSym == varSymbol) {
            this.dlog.error(pos, DiagnosticCode.SELF_REFERENCE_VAR, varSymbol.name);
        }
    }

    private boolean isInLocallyDefinedRecord(BSymbol symbol, SymbolEnv env) {
        boolean isLocalSym = (symbol.owner.tag & 0x1001) != 4097;
        boolean isInLetExpr = (symbol.owner.tag & 0x8000000) == 0x8000000;
        return isLocalSym && !isInLetExpr && env.enclType != null && env.enclType.getKind() == NodeKind.RECORD_TYPE;
    }

    public List<BType> getListWithErrorTypes(int count) {
        ArrayList<BType> list = new ArrayList<BType>(count);
        for (int i = 0; i < count; ++i) {
            list.add(this.symTable.semanticError);
        }
        return list;
    }

    private void checkFunctionInvocationExpr(BLangInvocation iExpr) {
        Name funcName = this.names.fromIdNode(iExpr.name);
        Name pkgAlias = this.names.fromIdNode(iExpr.pkgAlias);
        BSymbol funcSymbol = this.symTable.notFoundSymbol;
        BSymbol pkgSymbol = this.symResolver.resolvePrefixSymbol(this.env, pkgAlias, this.getCurrentCompUnit(iExpr));
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(iExpr.pos, DiagnosticCode.UNDEFINED_MODULE, pkgAlias);
        } else {
            if (funcSymbol == this.symTable.notFoundSymbol) {
                BSymbol symbol = this.symResolver.lookupMainSpaceSymbolInPackage(iExpr.pos, this.env, pkgAlias, funcName);
                if ((symbol.tag & 0x34) == 52) {
                    funcSymbol = symbol;
                }
                if (this.symTable.rootPkgSymbol.pkgID.equals(symbol.pkgID) && (symbol.tag & 0x14) == 20) {
                    funcSymbol = symbol;
                }
            }
            if (funcSymbol == this.symTable.notFoundSymbol) {
                funcSymbol = this.symResolver.lookupConstructorSpaceSymbolInPackage(iExpr.pos, this.env, pkgAlias, funcName);
            }
        }
        if ((funcSymbol.tag & 0x9001C) == 589852 || (funcSymbol.tag & 0x4000100) == 0x4000100 && funcSymbol.type.tag == 27) {
            iExpr.symbol = funcSymbol;
            iExpr.type = funcSymbol.type;
            this.checkErrorConstructorInvocation(iExpr);
            return;
        }
        if (funcSymbol == this.symTable.notFoundSymbol || this.isNotFunction(funcSymbol)) {
            this.dlog.error(iExpr.pos, DiagnosticCode.UNDEFINED_FUNCTION, funcName);
            iExpr.argExprs.forEach(arg -> this.checkExpr((BLangExpression)arg, this.env));
            this.resultType = this.symTable.semanticError;
            return;
        }
        if (this.isFunctionPointer(funcSymbol)) {
            iExpr.functionPointerInvocation = true;
            this.markAndRegisterClosureVariable(funcSymbol, iExpr.pos);
        }
        if (Symbols.isFlagOn(funcSymbol.flags, 65536)) {
            this.dlog.error(iExpr.pos, DiagnosticCode.INVALID_ACTION_INVOCATION_SYNTAX, new Object[0]);
        }
        if (Symbols.isFlagOn(funcSymbol.flags, 262144)) {
            this.dlog.error(iExpr.pos, DiagnosticCode.INVALID_RESOURCE_FUNCTION_INVOCATION, new Object[0]);
        }
        if (PackageID.isLangLibPackageID(pkgSymbol.pkgID)) {
            this.env = SymbolEnv.createInvocationEnv(iExpr, this.env);
        }
        iExpr.symbol = funcSymbol;
        this.checkInvocationParamAndReturnType(iExpr);
    }

    private void markAndRegisterClosureVariable(BSymbol symbol, DiagnosticPos pos) {
        SymbolEnv encInvokableEnv;
        BSymbol resolvedSymbol;
        BLangInvokableNode encInvokable = this.env.enclInvokable;
        if (symbol.owner instanceof BPackageSymbol) {
            return;
        }
        if (encInvokable != null && encInvokable.flagSet.contains((Object)Flag.LAMBDA) && !this.isFunctionArgument(symbol, encInvokable.requiredParams) && (resolvedSymbol = this.symResolver.lookupClosureVarSymbol(encInvokableEnv = this.findEnclosingInvokableEnv(this.env, encInvokable), symbol.name, 52)) != this.symTable.notFoundSymbol && !encInvokable.flagSet.contains((Object)Flag.ATTACHED)) {
            resolvedSymbol.closure = true;
            ((BLangFunction)encInvokable).closureVarSymbols.add(new ClosureVarSymbol(resolvedSymbol, pos));
        }
        if (this.env.node.getKind() == NodeKind.ARROW_EXPR && !this.isFunctionArgument(symbol, ((BLangArrowFunction)this.env.node).params) && (resolvedSymbol = this.symResolver.lookupClosureVarSymbol(encInvokableEnv = this.findEnclosingInvokableEnv(this.env, encInvokable), symbol.name, 52)) != this.symTable.notFoundSymbol) {
            resolvedSymbol.closure = true;
            ((BLangArrowFunction)this.env.node).closureVarSymbols.add(new ClosureVarSymbol(resolvedSymbol, pos));
        }
        BLangNode node = this.env.node;
        SymbolEnv cEnv = this.env;
        while (node != null && node.getKind() != NodeKind.FUNCTION) {
            if (node.getKind() == NodeKind.TRANSACTION) {
                SymbolEnv encInvokableEnv2 = this.findEnclosingInvokableEnv(this.env, encInvokable);
                BSymbol resolvedSymbol2 = this.symResolver.lookupClosureVarSymbol(encInvokableEnv2, symbol.name, 52);
                if (resolvedSymbol2 == this.symTable.notFoundSymbol) break;
                resolvedSymbol2.closure = true;
                break;
            }
            SymbolEnv enclEnv = cEnv.enclEnv;
            if (enclEnv == null) break;
            cEnv = enclEnv;
            node = cEnv.node;
        }
    }

    private boolean isNotFunction(BSymbol funcSymbol) {
        if ((funcSymbol.tag & 0x334) == 820) {
            return false;
        }
        return !this.isFunctionPointer(funcSymbol);
    }

    private boolean isFunctionPointer(BSymbol funcSymbol) {
        if ((funcSymbol.tag & 0x334) == 820) {
            return false;
        }
        return (funcSymbol.tag & 0x334) == 52 && funcSymbol.kind == SymbolKind.FUNCTION && (funcSymbol.flags & 2) != 2;
    }

    private void checkErrorConstructorInvocation(BLangInvocation iExpr) {
        BErrorType expectedError;
        BType[] errorMembers;
        BType expectedType = this.expType;
        if (this.expType.getKind() == TypeKind.UNION && (errorMembers = (BType[])((BUnionType)expectedType).getMemberTypes().stream().filter(memberType -> this.types.isAssignable((BType)memberType, this.symTable.errorType)).toArray(BType[]::new)).length > 0) {
            expectedType = BUnionType.create(null, errorMembers);
        }
        if (this.expType.getKind() == TypeKind.UNION && iExpr.symbol.type == this.symTable.errorType) {
            BUnionType unionType = (BUnionType)this.expType;
            long count = unionType.getMemberTypes().stream().filter(member -> this.types.isAssignable(iExpr.symbol.type, (BType)member)).count();
            if (count > 1L) {
                this.dlog.error(iExpr.pos, DiagnosticCode.CANNOT_INFER_ERROR_TYPE, this.expType);
                return;
            }
        } else if (!this.types.isAssignable(expectedType, this.symTable.errorType)) {
            if ((iExpr.symbol.tag & 0x4000100) == 0x4000100) {
                expectedType = iExpr.type;
            } else {
                if (expectedType != this.symTable.noType) {
                    this.dlog.error(iExpr.pos, DiagnosticCode.CANNOT_INFER_ERROR_TYPE, this.expType);
                    this.resultType = this.symTable.semanticError;
                    return;
                }
                expectedType = this.symTable.errorType;
            }
        }
        if ((expectedError = this.getExpectedErrorType(iExpr.pos, expectedType, iExpr.symbol)) == null) {
            return;
        }
        if (iExpr.argExprs.isEmpty() && iExpr.requiredArgs.isEmpty() && this.checkNoArgErrorCtorInvocation(expectedError, iExpr.name, iExpr.pos)) {
            return;
        }
        if (this.nonNamedArgsGiven(iExpr) && (iExpr.symbol.tag & 0x4000100) == 0x4000100) {
            this.dlog.error(iExpr.argExprs.get((int)0).pos, DiagnosticCode.INDIRECT_ERROR_CTOR_REASON_NOT_ALLOWED, new Object[0]);
            this.resultType = this.symTable.semanticError;
            return;
        }
        boolean reasonArgGiven = this.checkErrorReasonArg(iExpr, expectedError);
        if (expectedError.detailType.tag == 12) {
            BRecordType targetErrorDetailRec = (BRecordType)expectedError.detailType;
            BRecordType recordType = this.createErrorDetailRecordType(iExpr, reasonArgGiven, targetErrorDetailRec);
            if (this.resultType == this.symTable.semanticError) {
                return;
            }
            if (!this.types.isAssignable(recordType, targetErrorDetailRec)) {
                this.dlog.error(iExpr.pos, DiagnosticCode.INVALID_ERROR_CONSTRUCTOR_DETAIL, iExpr);
                this.resultType = this.symTable.semanticError;
                return;
            }
        } else {
            return;
        }
        this.setErrorReasonParam(iExpr, reasonArgGiven, expectedError);
        this.setErrorDetailArgsToNamedArgsList(iExpr);
        this.resultType = expectedError;
        if (iExpr.symbol == this.symTable.errorType.tsymbol) {
            iExpr.symbol = ((BErrorTypeSymbol)expectedError.tsymbol).ctorSymbol;
        }
    }

    private BErrorType getExpectedErrorType(DiagnosticPos pos, BType expType, BSymbol iExprSymbol) {
        if (iExprSymbol == this.symTable.errorType.tsymbol) {
            if (expType.tag == 20) {
                List matchedErrors = ((BUnionType)expType).getMemberTypes().stream().filter(m -> this.types.isAssignable((BType)m, iExprSymbol.type)).collect(Collectors.toList());
                if (matchedErrors.size() == 1) {
                    return (BErrorType)matchedErrors.get(0);
                }
                this.dlog.error(pos, DiagnosticCode.CANNOT_INFER_ERROR_TYPE, expType);
                this.resultType = this.symTable.semanticError;
                return null;
            }
            return (BErrorType)expType;
        }
        return (BErrorType)iExprSymbol.type;
    }

    private boolean nonNamedArgsGiven(BLangInvocation iExpr) {
        return iExpr.argExprs.stream().anyMatch(arg -> arg.getKind() != NodeKind.NAMED_ARGS_EXPR);
    }

    private boolean checkErrorReasonArg(BLangInvocation iExpr, BErrorType ctorType) {
        if (iExpr.type != this.symTable.errorType) {
            if (ctorType.reasonType.getKind() != TypeKind.FINITE) {
                this.dlog.error(iExpr.pos, DiagnosticCode.INDIRECT_ERROR_CTOR_NOT_ALLOWED_ON_NON_CONST_REASON, iExpr.type);
                return false;
            }
            BFiniteType reasonType = (BFiniteType)ctorType.reasonType;
            if (reasonType.getValueSpace().size() > 1) {
                this.dlog.error(iExpr.pos, DiagnosticCode.INDIRECT_ERROR_CTOR_NOT_ALLOWED_ON_NON_CONST_REASON, iExpr.type);
                return false;
            }
        }
        if (iExpr.argExprs.isEmpty()) {
            return false;
        }
        BLangExpression firstErrorArg = iExpr.argExprs.get(0);
        if (firstErrorArg.getKind() != NodeKind.NAMED_ARGS_EXPR) {
            this.checkExpr(firstErrorArg, this.env, ctorType.reasonType, DiagnosticCode.INVALID_ERROR_REASON_TYPE);
            return true;
        }
        if (iExpr.type == this.symTable.errorType) {
            this.dlog.error(iExpr.pos, DiagnosticCode.DIRECT_ERROR_CTOR_REASON_NOT_PROVIDED, new Object[0]);
        }
        return false;
    }

    private boolean checkNoArgErrorCtorInvocation(BErrorType errorType, BLangIdentifier name, DiagnosticPos pos) {
        if (errorType.reasonType.tag != 31) {
            this.dlog.error(pos, DiagnosticCode.INDIRECT_ERROR_CTOR_NOT_ALLOWED_ON_NON_CONST_REASON, name);
            this.resultType = this.symTable.semanticError;
            return true;
        }
        BFiniteType finiteType = (BFiniteType)errorType.reasonType;
        if (finiteType.getValueSpace().size() != 1) {
            if (errorType == this.symTable.errorType) {
                this.dlog.error(pos, DiagnosticCode.CANNOT_INFER_ERROR_TYPE, this.expType.tsymbol.name);
            } else {
                this.dlog.error(pos, DiagnosticCode.INDIRECT_ERROR_CTOR_NOT_ALLOWED_ON_NON_CONST_REASON, this.expType.tsymbol.name);
            }
            this.resultType = this.symTable.semanticError;
            return true;
        }
        return false;
    }

    private void setErrorDetailArgsToNamedArgsList(BLangInvocation iExpr) {
        ArrayList<BLangExpression> namedArgPositions = new ArrayList<BLangExpression>(iExpr.argExprs.size());
        for (int i = 0; i < iExpr.argExprs.size(); ++i) {
            BLangExpression argExpr = iExpr.argExprs.get(i);
            this.checkExpr(argExpr, this.env, this.symTable.pureType);
            if (argExpr.getKind() == NodeKind.NAMED_ARGS_EXPR) {
                iExpr.requiredArgs.add(argExpr);
                namedArgPositions.add(argExpr);
                continue;
            }
            this.dlog.error(argExpr.pos, DiagnosticCode.ERROR_DETAIL_ARG_IS_NOT_NAMED_ARG, new Object[0]);
            this.resultType = this.symTable.semanticError;
        }
        for (BLangExpression expr : namedArgPositions) {
            iExpr.argExprs.remove(expr);
        }
    }

    private void setErrorReasonParam(BLangInvocation iExpr, boolean reasonArgGiven, BErrorType ctorType) {
        if (!reasonArgGiven && ctorType.reasonType.getKind() == TypeKind.FINITE) {
            BFiniteType finiteType = (BFiniteType)ctorType.reasonType;
            BLangExpression reasonExpr = (BLangExpression)finiteType.getValueSpace().toArray()[0];
            iExpr.requiredArgs.add(reasonExpr);
            return;
        }
        if (!iExpr.argExprs.isEmpty()) {
            iExpr.requiredArgs.add(iExpr.argExprs.get(0));
            iExpr.argExprs.remove(0);
        }
    }

    private BRecordType createErrorDetailRecordType(BLangInvocation iExpr, boolean reasonArgGiven, BRecordType targetErrorDetailsType) {
        List<BLangNamedArgsExpression> namedArgs = this.getProvidedErrorDetails(iExpr, reasonArgGiven);
        if (namedArgs == null) {
            return null;
        }
        BRecordTypeSymbol recordTypeSymbol = new BRecordTypeSymbol(327772, targetErrorDetailsType.tsymbol.flags, Names.EMPTY, targetErrorDetailsType.tsymbol.pkgID, this.symTable.recordType, null);
        BRecordType recordType = new BRecordType(recordTypeSymbol);
        recordType.sealed = targetErrorDetailsType.sealed;
        recordType.restFieldType = targetErrorDetailsType.restFieldType;
        HashSet<Name> availableErrorDetailFields = new HashSet<Name>();
        for (BLangNamedArgsExpression arg : namedArgs) {
            Name fieldName = this.names.fromIdNode(arg.name);
            BField field = new BField(fieldName, arg.pos, new BVarSymbol(0, fieldName, null, arg.type, null));
            recordType.fields.add(field);
            availableErrorDetailFields.add(fieldName);
        }
        for (BField field : targetErrorDetailsType.fields) {
            boolean notRequired = (field.symbol.flags & 0x100) != 256;
            if (!notRequired || availableErrorDetailFields.contains(field.name)) continue;
            BField defaultableField = new BField(field.name, iExpr.pos, new BVarSymbol(field.symbol.flags, field.name, null, field.type, null));
            recordType.fields.add(defaultableField);
        }
        return recordType;
    }

    private List<BLangNamedArgsExpression> getProvidedErrorDetails(BLangInvocation iExpr, boolean reasonArgGiven) {
        int i;
        ArrayList<BLangNamedArgsExpression> namedArgs = new ArrayList<BLangNamedArgsExpression>();
        int n = i = reasonArgGiven ? 1 : 0;
        while (i < iExpr.argExprs.size()) {
            BLangExpression argExpr = iExpr.argExprs.get(i);
            this.checkExpr(argExpr, this.env);
            if (argExpr.getKind() != NodeKind.NAMED_ARGS_EXPR) {
                this.dlog.error(argExpr.pos, DiagnosticCode.ERROR_DETAIL_ARG_IS_NOT_NAMED_ARG, new Object[0]);
                this.resultType = this.symTable.semanticError;
                return null;
            }
            namedArgs.add((BLangNamedArgsExpression)argExpr);
            ++i;
        }
        return namedArgs;
    }

    private void checkObjectFunctionInvocationExpr(BLangInvocation iExpr, BObjectType objectType) {
        if (!(objectType.getKind() != TypeKind.SERVICE || iExpr.expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF && Names.SELF.equals(((BLangSimpleVarRef)iExpr.expr).symbol.name))) {
            this.dlog.error(iExpr.pos, DiagnosticCode.SERVICE_FUNCTION_INVALID_INVOCATION, new Object[0]);
            return;
        }
        Name funcName = this.names.fromString(Symbols.getAttachedFuncSymbolName(objectType.tsymbol.name.value, iExpr.name.value));
        BSymbol funcSymbol = this.symResolver.resolveObjectMethod(iExpr.pos, this.env, funcName, (BObjectTypeSymbol)objectType.tsymbol);
        if (funcSymbol == this.symTable.notFoundSymbol || funcSymbol.type.tag != 16) {
            if (!this.checkLangLibMethodInvocationExpr(iExpr, objectType)) {
                this.dlog.error(iExpr.name.pos, DiagnosticCode.UNDEFINED_FUNCTION_IN_OBJECT, iExpr.name.value, objectType);
                this.resultType = this.symTable.semanticError;
                return;
            }
        } else {
            iExpr.symbol = funcSymbol;
        }
        if (iExpr.name.value.equals(Names.USER_DEFINED_INIT_SUFFIX.value) && (iExpr.expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF || !Names.SELF.equals(((BLangSimpleVarRef)iExpr.expr).symbol.name))) {
            this.dlog.error(iExpr.pos, DiagnosticCode.INVALID_INIT_INVOCATION, new Object[0]);
        }
        if (Symbols.isFlagOn(funcSymbol.flags, 65536)) {
            this.dlog.error(iExpr.pos, DiagnosticCode.INVALID_ACTION_INVOCATION_SYNTAX, new Object[0]);
        }
        if (Symbols.isFlagOn(funcSymbol.flags, 262144)) {
            this.dlog.error(iExpr.pos, DiagnosticCode.INVALID_RESOURCE_FUNCTION_INVOCATION, new Object[0]);
        }
        this.checkInvocationParamAndReturnType(iExpr);
    }

    private void checkActionInvocationExpr(BLangInvocation iExpr, BType epType) {
        BType actualType = this.symTable.semanticError;
        if (epType == this.symTable.semanticError || epType.tag != 32 || ((BLangVariableReference)iExpr.expr).symbol.tag != 32820) {
            this.dlog.error(iExpr.pos, DiagnosticCode.INVALID_ACTION_INVOCATION, new Object[0]);
            this.resultType = actualType;
            return;
        }
        BVarSymbol epSymbol = (BVarSymbol)((BLangVariableReference)iExpr.expr).symbol;
        Name remoteFuncQName = this.names.fromString(Symbols.getAttachedFuncSymbolName(epType.tsymbol.name.value, iExpr.name.value));
        Name actionName = this.names.fromIdNode(iExpr.name);
        BSymbol remoteFuncSymbol = this.symResolver.lookupMemberSymbol(iExpr.pos, ((BObjectTypeSymbol)epSymbol.type.tsymbol).methodScope, this.env, remoteFuncQName, 820);
        if (remoteFuncSymbol == this.symTable.notFoundSymbol || !Symbols.isFlagOn(remoteFuncSymbol.flags, 65536)) {
            this.dlog.error(iExpr.pos, DiagnosticCode.UNDEFINED_ACTION, actionName, epSymbol.type.tsymbol.name);
            this.resultType = actualType;
            return;
        }
        iExpr.symbol = remoteFuncSymbol;
        this.checkInvocationParamAndReturnType(iExpr);
    }

    private boolean checkLangLibMethodInvocationExpr(BLangInvocation iExpr, BType bType) {
        Name funcName = this.names.fromString(iExpr.name.value);
        BSymbol funcSymbol = this.symResolver.lookupLangLibMethod(bType, funcName);
        if (funcSymbol == this.symTable.notFoundSymbol) {
            return false;
        }
        iExpr.symbol = funcSymbol;
        iExpr.langLibInvocation = true;
        SymbolEnv enclEnv = this.env;
        this.env = SymbolEnv.createInvocationEnv(iExpr, this.env);
        if (iExpr.argExprs.isEmpty() || !iExpr.argExprs.get(0).equals(iExpr.expr)) {
            iExpr.argExprs.add(0, iExpr.expr);
        }
        this.checkInvocationParamAndReturnType(iExpr);
        this.env = enclEnv;
        return true;
    }

    private void checkInvocationParamAndReturnType(BLangInvocation iExpr) {
        BType actualType = this.checkInvocationParam(iExpr);
        this.resultType = this.types.checkType(iExpr, actualType, this.expType);
    }

    private BType checkInvocationParam(BLangInvocation iExpr) {
        if (iExpr.symbol.type.tag != 16) {
            this.dlog.error(iExpr.pos, DiagnosticCode.INVALID_FUNCTION_INVOCATION, iExpr.symbol.type);
            return this.symTable.noType;
        }
        List<BType> paramTypes = ((BInvokableType)iExpr.symbol.type).getParameterTypes();
        HashMap<String, BVarSymbol> params = new HashMap<String, BVarSymbol>();
        for (BVarSymbol a : ((BInvokableSymbol)iExpr.symbol).params) {
            if (a.name.equals(Names.EMPTY)) continue;
            params.put(a.name.getValue(), a);
        }
        int parameterCount = paramTypes.size();
        iExpr.requiredArgs = new ArrayList<BLangExpression>();
        int i = 0;
        BLangExpression vararg = null;
        boolean foundNamedArg = false;
        block5: for (BLangExpression expr : iExpr.argExprs) {
            switch (expr.getKind()) {
                case NAMED_ARGS_EXPR: {
                    BVarSymbol varSymbol = (BVarSymbol)params.get(((BLangNamedArgsExpression)expr).name.value);
                    if (!this.env.enclPkg.packageID.equals(iExpr.symbol.pkgID) && varSymbol != null && !Symbols.isFlagOn(varSymbol.flags, 1)) {
                        this.dlog.error(expr.pos, DiagnosticCode.NON_PUBLIC_ARG_ACCESSED_WITH_NAMED_ARG, ((BLangNamedArgsExpression)expr).name.value, iExpr.toString());
                    }
                    foundNamedArg = true;
                    if (i < parameterCount) {
                        iExpr.requiredArgs.add(expr);
                    } else {
                        this.dlog.error(expr.pos, DiagnosticCode.TOO_MANY_ARGS_FUNC_CALL, iExpr.name.value);
                    }
                    ++i;
                    continue block5;
                }
                case REST_ARGS_EXPR: {
                    if (foundNamedArg) {
                        this.dlog.error(expr.pos, DiagnosticCode.REST_ARG_DEFINED_AFTER_NAMED_ARG, new Object[0]);
                        continue block5;
                    }
                    vararg = expr;
                    continue block5;
                }
            }
            if (foundNamedArg) {
                this.dlog.error(expr.pos, DiagnosticCode.POSITIONAL_ARG_DEFINED_AFTER_NAMED_ARG, new Object[0]);
            }
            if (i < parameterCount) {
                iExpr.requiredArgs.add(expr);
            } else {
                iExpr.restArgs.add(expr);
            }
            ++i;
        }
        return this.checkInvocationArgs(iExpr, paramTypes, vararg);
    }

    private BType checkInvocationArgs(BLangInvocation iExpr, List<BType> paramTypes, BLangExpression vararg) {
        BType actualType = this.symTable.semanticError;
        BInvokableSymbol invokableSymbol = (BInvokableSymbol)iExpr.symbol;
        BInvokableType bInvokableType = (BInvokableType)invokableSymbol.type;
        BInvokableTypeSymbol invokableTypeSymbol = (BInvokableTypeSymbol)bInvokableType.tsymbol;
        ArrayList<BVarSymbol> nonRestParams = new ArrayList<BVarSymbol>(invokableTypeSymbol.params);
        this.checkNonRestArgs(nonRestParams, iExpr, paramTypes);
        if (!(invokableTypeSymbol.restParam != null || vararg == null && iExpr.restArgs.isEmpty())) {
            this.dlog.error(iExpr.pos, DiagnosticCode.TOO_MANY_ARGS_FUNC_CALL, iExpr.name.value);
            return actualType;
        }
        this.checkRestArgs(iExpr.restArgs, vararg, invokableTypeSymbol.restParam, iExpr.langLibInvocation);
        BType retType = this.typeParamAnalyzer.getReturnTypeParams(this.env, bInvokableType.getReturnType());
        if (iExpr.async) {
            return this.generateFutureType(invokableSymbol, retType);
        }
        return retType;
    }

    private BFutureType generateFutureType(BInvokableSymbol invocableSymbol, BType retType) {
        boolean isWorkerStart = invocableSymbol.name.value.startsWith("0");
        return new BFutureType(30, retType, null, isWorkerStart);
    }

    private void checkNonRestArgs(List<BVarSymbol> nonRestParams, BLangInvocation iExpr, List<BType> paramTypes) {
        List<BLangExpression> nonRestArgs = iExpr.requiredArgs;
        List requiredParams = nonRestParams.stream().filter(param -> !param.defaultableParam).collect(Collectors.toList());
        ArrayList<BVarSymbol> valueProvidedParams = new ArrayList<BVarSymbol>();
        for (int i = 0; i < nonRestArgs.size(); ++i) {
            BLangExpression arg = nonRestArgs.get(i);
            BType expectedType = paramTypes.get(i);
            if (i == 0 && arg.typeChecked && iExpr.expr != null && iExpr.expr == arg) {
                this.types.checkType(arg.pos, arg.type, expectedType, DiagnosticCode.INCOMPATIBLE_TYPES);
                this.types.setImplicitCastExpr(arg, arg.type, expectedType);
            }
            if (arg.getKind() != NodeKind.NAMED_ARGS_EXPR) {
                if (i < nonRestParams.size()) {
                    BVarSymbol param2 = nonRestParams.get(i);
                    this.checkTypeParamExpr(arg, this.env, param2.type, iExpr.langLibInvocation);
                    valueProvidedParams.add(param2);
                    requiredParams.remove(param2);
                    continue;
                }
                this.dlog.error(arg.pos, DiagnosticCode.TOO_MANY_ARGS_FUNC_CALL, iExpr.name.value);
                return;
            }
            if (arg.getKind() != NodeKind.NAMED_ARGS_EXPR) continue;
            BLangIdentifier argName = ((NamedArgNode)((Object)arg)).getName();
            BVarSymbol varSym = nonRestParams.stream().filter(param -> param.getName().value.equals(argName.value)).findAny().orElse(null);
            if (varSym == null) {
                this.dlog.error(arg.pos, DiagnosticCode.UNDEFINED_PARAMETER, argName);
                break;
            }
            requiredParams.remove(varSym);
            if (valueProvidedParams.contains(varSym)) {
                this.dlog.error(arg.pos, DiagnosticCode.DUPLICATE_NAMED_ARGS, varSym.name.value);
                continue;
            }
            this.checkTypeParamExpr(arg, this.env, varSym.type, iExpr.langLibInvocation);
            valueProvidedParams.add(varSym);
        }
        for (BVarSymbol reqParam : requiredParams) {
            this.dlog.error(iExpr.pos, DiagnosticCode.MISSING_REQUIRED_PARAMETER, reqParam.name, iExpr.name.value);
        }
    }

    private void checkRestArgs(List<BLangExpression> restArgExprs, BLangExpression vararg, BVarSymbol restParam, boolean langlibInvocation) {
        if (vararg != null && !restArgExprs.isEmpty()) {
            this.dlog.error(vararg.pos, DiagnosticCode.INVALID_REST_ARGS, new Object[0]);
            return;
        }
        if (vararg != null) {
            this.checkTypeParamExpr(vararg.getKind() == NodeKind.REST_ARGS_EXPR ? ((BLangRestArgsExpression)vararg).expr.pos : vararg.pos, vararg, this.env, restParam.type, langlibInvocation);
            restArgExprs.add(vararg);
            return;
        }
        if (restArgExprs.isEmpty()) {
            return;
        }
        BType restType = ((BArrayType)restParam.type).eType;
        for (BLangExpression arg : restArgExprs) {
            this.checkTypeParamExpr(arg, this.env, restType, true);
        }
    }

    private void checkTypeParamExpr(BLangExpression arg, SymbolEnv env, BType expectedType, boolean inferTypeForNumericLiteral) {
        this.checkTypeParamExpr(arg.pos, arg, env, expectedType, inferTypeForNumericLiteral);
    }

    private void checkTypeParamExpr(DiagnosticPos pos, BLangExpression arg, SymbolEnv env, BType expectedType, boolean inferTypeForNumericLiteral) {
        if (this.typeParamAnalyzer.notRequireTypeParams(env)) {
            this.checkExpr(arg, env, expectedType);
            return;
        }
        if (this.requireTypeInference(arg, inferTypeForNumericLiteral)) {
            BType expType = this.typeParamAnalyzer.getMatchingBoundType(expectedType, env);
            BType inferredType = this.checkExpr(arg, env, expType);
            this.typeParamAnalyzer.checkForTypeParamsInArg(pos, inferredType, this.env, expectedType);
            return;
        }
        this.checkExpr(arg, env, expectedType);
        this.typeParamAnalyzer.checkForTypeParamsInArg(pos, arg.type, this.env, expectedType);
    }

    private boolean requireTypeInference(BLangExpression expr, boolean inferTypeForNumericLiteral) {
        switch (expr.getKind()) {
            case GROUP_EXPR: {
                return this.requireTypeInference(((BLangGroupExpr)expr).expression, inferTypeForNumericLiteral);
            }
            case ARROW_EXPR: 
            case LIST_CONSTRUCTOR_EXPR: 
            case RECORD_LITERAL_EXPR: {
                return true;
            }
            case NUMERIC_LITERAL: {
                return inferTypeForNumericLiteral;
            }
        }
        return false;
    }

    private BType checkMappingField(RecordLiteralNode.RecordField field, BType mappingType) {
        BType fieldType = this.symTable.semanticError;
        boolean keyValueField = field.isKeyValueField();
        boolean spreadOpField = field.getKind() == NodeKind.RECORD_LITERAL_SPREAD_OP;
        BLangExpression valueExpr = null;
        if (keyValueField) {
            valueExpr = ((BLangRecordLiteral.BLangRecordKeyValueField)field).valueExpr;
        } else if (!spreadOpField) {
            valueExpr = (BLangRecordLiteral.BLangRecordVarNameField)field;
        }
        switch (mappingType.tag) {
            case 12: {
                if (keyValueField) {
                    BLangRecordLiteral.BLangRecordKey key = ((BLangRecordLiteral.BLangRecordKeyValueField)field).key;
                    fieldType = this.checkRecordLiteralKeyExpr(key.expr, key.computedKey, (BRecordType)mappingType);
                    break;
                }
                if (spreadOpField) {
                    BLangExpression spreadExpr = ((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr;
                    this.checkExpr(spreadExpr, this.env);
                    BType spreadExprType = spreadExpr.type;
                    if (spreadExprType.tag == 15) {
                        return this.symTable.noType;
                    }
                    if (spreadExprType.tag != 12) {
                        this.dlog.error(spreadExpr.pos, DiagnosticCode.INCOMPATIBLE_TYPES_SPREAD_OP, spreadExprType);
                        return this.symTable.semanticError;
                    }
                    boolean errored = false;
                    for (BField bField : ((BRecordType)spreadExprType).getFields()) {
                        BType specFieldType = bField.type;
                        BType expectedFieldType = this.checkRecordLiteralKeyByName(spreadExpr.pos, this.env, bField.name, (BRecordType)mappingType);
                        if (expectedFieldType == this.symTable.semanticError || this.types.isAssignable(specFieldType, expectedFieldType)) continue;
                        this.dlog.error(spreadExpr.pos, DiagnosticCode.INCOMPATIBLE_TYPES_FIELD, expectedFieldType, bField.name, specFieldType);
                        if (errored) continue;
                        errored = true;
                    }
                    return errored ? this.symTable.semanticError : this.symTable.noType;
                }
                fieldType = this.checkRecordLiteralKeyExpr((BLangRecordLiteral.BLangRecordVarNameField)field, false, (BRecordType)mappingType);
                break;
            }
            case 15: {
                boolean validMapKey;
                if (spreadOpField) {
                    BType spreadOpMemberType;
                    BLangExpression spreadExp = ((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr;
                    BType spreadOpType = this.checkExpr(spreadExp, this.env);
                    switch (spreadOpType.tag) {
                        case 12: {
                            ArrayList<BType> types = new ArrayList<BType>();
                            BRecordType recordType = (BRecordType)spreadOpType;
                            for (BField recField : recordType.fields) {
                                types.add(recField.type);
                            }
                            if (!recordType.sealed) {
                                types.add(recordType.restFieldType);
                            }
                            spreadOpMemberType = this.getRepresentativeBroadType(types);
                            break;
                        }
                        case 15: {
                            spreadOpMemberType = ((BMapType)spreadOpType).constraint;
                            break;
                        }
                        default: {
                            this.dlog.error(spreadExp.pos, DiagnosticCode.INCOMPATIBLE_TYPES_SPREAD_OP, spreadOpType);
                            return this.symTable.semanticError;
                        }
                    }
                    return this.types.checkType(spreadExp.pos, spreadOpMemberType, ((BMapType)mappingType).constraint, DiagnosticCode.INCOMPATIBLE_TYPES);
                }
                if (keyValueField) {
                    BLangRecordLiteral.BLangRecordKey key = ((BLangRecordLiteral.BLangRecordKeyValueField)field).key;
                    validMapKey = this.checkValidJsonOrMapLiteralKeyExpr(key.expr, key.computedKey);
                } else {
                    validMapKey = this.checkValidJsonOrMapLiteralKeyExpr((BLangRecordLiteral.BLangRecordVarNameField)field, false);
                }
                BType bType = fieldType = validMapKey ? ((BMapType)mappingType).constraint : this.symTable.semanticError;
            }
        }
        if (spreadOpField) {
            valueExpr = ((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr;
        }
        BLangExpression exprToCheck = valueExpr;
        if (this.nonErrorLoggingCheck) {
            ++valueExpr.cloneAttempt;
            exprToCheck = this.nodeCloner.clone(valueExpr);
        }
        return this.checkExpr(exprToCheck, this.env, fieldType);
    }

    private BType checkRecordLiteralKeyExpr(BLangExpression keyExpr, boolean computedKey, BRecordType recordType) {
        Name fieldName;
        if (computedKey) {
            this.checkExpr(keyExpr, this.env, this.symTable.stringType);
            if (keyExpr.type == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            LinkedHashSet fieldTypes = recordType.fields.stream().map(field -> field.type).collect(Collectors.toCollection(LinkedHashSet::new));
            if (recordType.restFieldType.tag != 22) {
                fieldTypes.add(recordType.restFieldType);
            }
            return BUnionType.create(null, fieldTypes);
        }
        if (keyExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BLangSimpleVarRef varRef = (BLangSimpleVarRef)keyExpr;
            fieldName = this.names.fromIdNode(varRef.variableName);
        } else if (keyExpr.getKind() == NodeKind.LITERAL && ((BLangLiteral)keyExpr).type.tag == 5) {
            fieldName = this.names.fromString((String)((BLangLiteral)keyExpr).value);
        } else {
            this.dlog.error(keyExpr.pos, DiagnosticCode.INVALID_RECORD_LITERAL_KEY, new Object[0]);
            return this.symTable.semanticError;
        }
        return this.checkRecordLiteralKeyByName(keyExpr.pos, this.env, fieldName, recordType);
    }

    private BType checkRecordLiteralKeyByName(DiagnosticPos pos, SymbolEnv env, Name key, BRecordType recordType) {
        BSymbol fieldSymbol = this.symResolver.resolveStructField(pos, env, key, recordType.tsymbol);
        if (fieldSymbol != this.symTable.notFoundSymbol) {
            return fieldSymbol.type;
        }
        if (recordType.sealed) {
            this.dlog.error(pos, DiagnosticCode.UNDEFINED_STRUCTURE_FIELD_WITH_TYPE, key, recordType.tsymbol.type.getKind().typeName(), recordType);
            return this.symTable.semanticError;
        }
        return recordType.restFieldType;
    }

    private boolean checkValidJsonOrMapLiteralKeyExpr(BLangExpression keyExpr, boolean computedKey) {
        if (computedKey) {
            this.checkExpr(keyExpr, this.env, this.symTable.stringType);
            return keyExpr.type != this.symTable.semanticError;
        }
        if (keyExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF || keyExpr.getKind() == NodeKind.LITERAL && ((BLangLiteral)keyExpr).type.tag == 5) {
            return true;
        }
        this.dlog.error(keyExpr.pos, DiagnosticCode.INVALID_RECORD_LITERAL_KEY, new Object[0]);
        return false;
    }

    private BType addNilForNillableIndexBasedAccess(BType actualType) {
        if (actualType.isNullable()) {
            return actualType;
        }
        return BUnionType.create(null, actualType, this.symTable.nilType);
    }

    private BType checkRecordRequiredFieldAccess(BLangVariableReference varReferExpr, Name fieldName, BRecordType recordType) {
        BSymbol fieldSymbol = this.symResolver.resolveStructField(varReferExpr.pos, this.env, fieldName, recordType.tsymbol);
        if (fieldSymbol == this.symTable.notFoundSymbol || Symbols.isOptional(fieldSymbol)) {
            return this.symTable.semanticError;
        }
        varReferExpr.symbol = fieldSymbol;
        return fieldSymbol.type;
    }

    private BType checkRecordOptionalFieldAccess(BLangVariableReference varReferExpr, Name fieldName, BRecordType recordType) {
        BSymbol fieldSymbol = this.symResolver.resolveStructField(varReferExpr.pos, this.env, fieldName, recordType.tsymbol);
        if (fieldSymbol == this.symTable.notFoundSymbol || !Symbols.isOptional(fieldSymbol)) {
            return this.symTable.semanticError;
        }
        varReferExpr.symbol = fieldSymbol;
        return fieldSymbol.type;
    }

    private BType checkRecordRestFieldAccess(BLangVariableReference varReferExpr, Name fieldName, BRecordType recordType) {
        BSymbol fieldSymbol = this.symResolver.resolveStructField(varReferExpr.pos, this.env, fieldName, recordType.tsymbol);
        if (fieldSymbol != this.symTable.notFoundSymbol) {
            return this.symTable.semanticError;
        }
        if (recordType.sealed) {
            return this.symTable.semanticError;
        }
        return recordType.restFieldType;
    }

    private BType checkObjectFieldAccess(BLangFieldBasedAccess bLangFieldBasedAccess, Name fieldName, BObjectType objectType) {
        BSymbol fieldSymbol = this.symResolver.resolveStructField(bLangFieldBasedAccess.pos, this.env, fieldName, objectType.tsymbol);
        if (fieldSymbol != this.symTable.notFoundSymbol) {
            bLangFieldBasedAccess.symbol = fieldSymbol;
            return fieldSymbol.type;
        }
        Name objFuncName = this.names.fromString(Symbols.getAttachedFuncSymbolName(objectType.tsymbol.name.value, fieldName.value));
        fieldSymbol = this.symResolver.resolveObjectField(bLangFieldBasedAccess.pos, this.env, objFuncName, objectType.tsymbol);
        if (fieldSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(bLangFieldBasedAccess.field.pos, DiagnosticCode.UNDEFINED_STRUCTURE_FIELD_WITH_TYPE, fieldName, objectType.tsymbol.type.getKind().typeName(), objectType.tsymbol);
            return this.symTable.semanticError;
        }
        bLangFieldBasedAccess.symbol = fieldSymbol;
        return fieldSymbol.type;
    }

    private BType checkTupleFieldType(BType tupleType, int indexValue) {
        BTupleType bTupleType = (BTupleType)tupleType;
        if (bTupleType.tupleTypes.size() <= indexValue && bTupleType.restType != null) {
            return bTupleType.restType;
        }
        if (indexValue < 0 || bTupleType.tupleTypes.size() <= indexValue) {
            return this.symTable.semanticError;
        }
        return bTupleType.tupleTypes.get(indexValue);
    }

    private void validateTags(BLangXMLElementLiteral bLangXMLElementLiteral, SymbolEnv xmlElementEnv) {
        BLangExpression startTagName = bLangXMLElementLiteral.startTagName;
        this.checkExpr(startTagName, xmlElementEnv, this.symTable.stringType);
        BLangExpression endTagName = bLangXMLElementLiteral.endTagName;
        if (endTagName == null) {
            return;
        }
        this.checkExpr(endTagName, xmlElementEnv, this.symTable.stringType);
        if (startTagName.getKind() == NodeKind.XML_QNAME && endTagName.getKind() == NodeKind.XML_QNAME && startTagName.equals(endTagName)) {
            return;
        }
        if (startTagName.getKind() != NodeKind.XML_QNAME && endTagName.getKind() != NodeKind.XML_QNAME) {
            return;
        }
        this.dlog.error(bLangXMLElementLiteral.pos, DiagnosticCode.XML_TAGS_MISMATCH, new Object[0]);
    }

    private void checkStringTemplateExprs(List<BLangExpression> exprs, boolean allowXml) {
        for (BLangExpression expr : exprs) {
            this.checkExpr(expr, this.env);
            BType type = expr.type;
            if (type == this.symTable.semanticError || type.tag < 7) continue;
            if (allowXml) {
                if (type.tag == 8) continue;
                this.dlog.error(expr.pos, DiagnosticCode.INCOMPATIBLE_TYPES, BUnionType.create(null, this.symTable.intType, this.symTable.floatType, this.symTable.decimalType, this.symTable.stringType, this.symTable.booleanType, this.symTable.xmlType), type);
                continue;
            }
            this.dlog.error(expr.pos, DiagnosticCode.INCOMPATIBLE_TYPES, BUnionType.create(null, this.symTable.intType, this.symTable.floatType, this.symTable.decimalType, this.symTable.stringType, this.symTable.booleanType), type);
        }
    }

    private List<BLangExpression> concatSimilarKindXMLNodes(List<BLangExpression> exprs, SymbolEnv xmlElementEnv) {
        ArrayList<BLangExpression> newChildren = new ArrayList<BLangExpression>();
        ArrayList<BLangExpression> tempConcatExpressions = new ArrayList<BLangExpression>();
        for (BLangExpression expr : exprs) {
            BType exprType = this.checkExpr(expr, xmlElementEnv);
            if (exprType == this.symTable.xmlType) {
                if (!tempConcatExpressions.isEmpty()) {
                    newChildren.add(this.getXMLTextLiteral(tempConcatExpressions));
                    tempConcatExpressions = new ArrayList();
                }
                newChildren.add(expr);
                continue;
            }
            BType type = expr.type;
            if (type.tag >= 7) {
                if (type == this.symTable.semanticError || TypeTags.isXMLTypeTag(type.tag)) continue;
                this.dlog.error(expr.pos, DiagnosticCode.INCOMPATIBLE_TYPES, BUnionType.create(null, this.symTable.intType, this.symTable.floatType, this.symTable.decimalType, this.symTable.stringType, this.symTable.booleanType, this.symTable.xmlType), type);
                continue;
            }
            tempConcatExpressions.add(expr);
        }
        if (!tempConcatExpressions.isEmpty()) {
            newChildren.add(this.getXMLTextLiteral(tempConcatExpressions));
        }
        return newChildren;
    }

    private BLangExpression getXMLTextLiteral(List<BLangExpression> exprs) {
        BLangXMLTextLiteral xmlTextLiteral = (BLangXMLTextLiteral)TreeBuilder.createXMLTextLiteralNode();
        xmlTextLiteral.textFragments = exprs;
        xmlTextLiteral.pos = exprs.get((int)0).pos;
        xmlTextLiteral.type = this.symTable.xmlType;
        return xmlTextLiteral;
    }

    private BType getTypeOfExprInFieldAccess(BLangExpression expr) {
        this.checkExpr(expr, this.env, this.symTable.noType);
        return expr.type;
    }

    private BType getAccessExprFinalType(BLangAccessExpression accessExpr, BType actualType) {
        accessExpr.originalType = actualType;
        BUnionType unionType = BUnionType.create(null, actualType);
        if (this.returnsNull(accessExpr)) {
            unionType.add(this.symTable.nilType);
        }
        BType parentType = accessExpr.expr.type;
        if (accessExpr.errorSafeNavigation && (parentType.tag == 26 || parentType.tag == 20 && ((BUnionType)parentType).getMemberTypes().contains(this.symTable.errorType))) {
            unionType.add(this.symTable.errorType);
        }
        if (unionType.getMemberTypes().size() == 1) {
            return unionType.getMemberTypes().toArray(new BType[0])[0];
        }
        return unionType;
    }

    private boolean returnsNull(BLangAccessExpression accessExpr) {
        BType parentType = accessExpr.expr.type;
        if (parentType.isNullable() && parentType.tag != 7) {
            return true;
        }
        if (parentType.tag != 15) {
            return false;
        }
        if (accessExpr.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR && accessExpr.expr.type.tag == 15) {
            BType constraintType = ((BMapType)accessExpr.expr.type).constraint;
            return constraintType != null && constraintType.tag != 17 && constraintType.tag != 7;
        }
        return false;
    }

    private BType checkObjectFieldAccessExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName) {
        if (varRefType.tag == 32) {
            return this.checkObjectFieldAccess(fieldAccessExpr, fieldName, (BObjectType)varRefType);
        }
        Set<BType> memberTypes = ((BUnionType)varRefType).getMemberTypes();
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : memberTypes) {
            BType individualFieldType = this.checkObjectFieldAccess(fieldAccessExpr, fieldName, (BObjectType)memType);
            if (individualFieldType == this.symTable.semanticError) {
                return individualFieldType;
            }
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.size() == 1) {
            return (BType)fieldTypeMembers.iterator().next();
        }
        return BUnionType.create(null, fieldTypeMembers);
    }

    private BType checkRecordFieldAccessExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName) {
        if (varRefType.tag == 12) {
            return this.checkRecordRequiredFieldAccess(fieldAccessExpr, fieldName, (BRecordType)varRefType);
        }
        Set<BType> memberTypes = ((BUnionType)varRefType).getMemberTypes();
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : memberTypes) {
            BType individualFieldType = this.checkRecordFieldAccessExpr(fieldAccessExpr, memType, fieldName);
            if (individualFieldType == this.symTable.semanticError) {
                return individualFieldType;
            }
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.size() == 1) {
            return (BType)fieldTypeMembers.iterator().next();
        }
        return BUnionType.create(null, fieldTypeMembers);
    }

    private BType checkRecordFieldAccessLhsExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName) {
        if (varRefType.tag == 12) {
            BType fieldType = this.checkRecordRequiredFieldAccess(fieldAccessExpr, fieldName, (BRecordType)varRefType);
            if (fieldType != this.symTable.semanticError) {
                return fieldType;
            }
            return this.checkRecordOptionalFieldAccess(fieldAccessExpr, fieldName, (BRecordType)varRefType);
        }
        Set<BType> memberTypes = ((BUnionType)varRefType).getMemberTypes();
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : memberTypes) {
            BType individualFieldType = this.checkRecordFieldAccessLhsExpr(fieldAccessExpr, memType, fieldName);
            if (individualFieldType == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.size() == 1) {
            return (BType)fieldTypeMembers.iterator().next();
        }
        return BUnionType.create(null, fieldTypeMembers);
    }

    private BType checkOptionalRecordFieldAccessExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName) {
        if (varRefType.tag == 12) {
            BType fieldType = this.checkRecordRequiredFieldAccess(fieldAccessExpr, fieldName, (BRecordType)varRefType);
            if (fieldType != this.symTable.semanticError) {
                return fieldType;
            }
            fieldType = this.checkRecordOptionalFieldAccess(fieldAccessExpr, fieldName, (BRecordType)varRefType);
            if (fieldType == this.symTable.semanticError) {
                return fieldType;
            }
            return BUnionType.create(null, fieldType, this.symTable.nilType);
        }
        Set<BType> memberTypes = ((BUnionType)varRefType).getMemberTypes();
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : memberTypes) {
            BType individualFieldType = this.checkOptionalRecordFieldAccessExpr(fieldAccessExpr, memType, fieldName);
            if (individualFieldType == this.symTable.semanticError) continue;
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.isEmpty()) {
            return this.symTable.semanticError;
        }
        if (fieldTypeMembers.size() == 1) {
            return (BType)fieldTypeMembers.iterator().next();
        }
        return BUnionType.create(null, fieldTypeMembers);
    }

    private BType checkFieldAccessExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName) {
        BType actualType = this.symTable.semanticError;
        if (this.types.isSubTypeOfBaseType(varRefType, 32)) {
            fieldAccessExpr.originalType = actualType = this.checkObjectFieldAccessExpr(fieldAccessExpr, varRefType, fieldName);
        } else if (this.types.isSubTypeOfBaseType(varRefType, 12)) {
            actualType = this.checkRecordFieldAccessExpr(fieldAccessExpr, varRefType, fieldName);
            if (actualType != this.symTable.semanticError) {
                fieldAccessExpr.originalType = actualType;
                return actualType;
            }
            if (!fieldAccessExpr.lhsVar) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticCode.OPERATION_DOES_NOT_SUPPORT_FIELD_ACCESS_FOR_NON_REQUIRED_FIELD, varRefType, fieldName);
                return actualType;
            }
            fieldAccessExpr.originalType = actualType = this.checkRecordFieldAccessLhsExpr(fieldAccessExpr, varRefType, fieldName);
            if (actualType == this.symTable.semanticError) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticCode.UNDEFINED_STRUCTURE_FIELD_WITH_TYPE, fieldName, varRefType.tsymbol.type.getKind().typeName(), varRefType);
            }
        } else if (this.types.isLax(varRefType)) {
            if (fieldAccessExpr.lhsVar) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticCode.OPERATION_DOES_NOT_SUPPORT_FIELD_ACCESS_FOR_ASSIGNMENT, varRefType);
                return this.symTable.semanticError;
            }
            if (fieldAccessExpr.fieldKind == FieldKind.WITH_NS) {
                this.resolveXMLNamespace((BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess)fieldAccessExpr);
            }
            BType laxFieldAccessType = this.getLaxFieldAccessType(varRefType);
            actualType = BUnionType.create(null, laxFieldAccessType, this.symTable.errorType);
            fieldAccessExpr.originalType = laxFieldAccessType;
        } else if (fieldAccessExpr.expr.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR && this.hasLaxOriginalType((BLangFieldBasedAccess)fieldAccessExpr.expr)) {
            BType laxFieldAccessType = this.getLaxFieldAccessType(((BLangFieldBasedAccess)fieldAccessExpr.expr).originalType);
            if (fieldAccessExpr.fieldKind == FieldKind.WITH_NS) {
                this.resolveXMLNamespace((BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess)fieldAccessExpr);
            }
            actualType = BUnionType.create(null, laxFieldAccessType, this.symTable.errorType);
            fieldAccessExpr.errorSafeNavigation = true;
            fieldAccessExpr.originalType = laxFieldAccessType;
        } else if (TypeTags.isXMLTypeTag(varRefType.tag)) {
            if (fieldAccessExpr.lhsVar) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticCode.CANNOT_UPDATE_XML_SEQUENCE, new Object[0]);
            }
            fieldAccessExpr.originalType = actualType = this.symTable.xmlType;
        } else if (varRefType.tag != 26) {
            this.dlog.error(fieldAccessExpr.pos, DiagnosticCode.OPERATION_DOES_NOT_SUPPORT_FIELD_ACCESS, varRefType);
        }
        return actualType;
    }

    private void resolveXMLNamespace(BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess fieldAccessExpr) {
        BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess nsPrefixedFieldAccess = fieldAccessExpr;
        String nsPrefix = nsPrefixedFieldAccess.nsPrefix.value;
        BSymbol nsSymbol = this.symResolver.lookupSymbolInPrefixSpace(this.env, this.names.fromString(nsPrefix));
        if (nsSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(nsPrefixedFieldAccess.nsPrefix.pos, DiagnosticCode.CANNOT_FIND_XML_NAMESPACE, nsPrefixedFieldAccess.nsPrefix);
        } else {
            nsPrefixedFieldAccess.nsSymbol = nsSymbol.getKind() == SymbolKind.PACKAGE ? (BXMLNSSymbol)this.findXMLNamespaceFromPackageConst(nsPrefixedFieldAccess.field.value, nsPrefixedFieldAccess.nsPrefix.value, (BPackageSymbol)nsSymbol, fieldAccessExpr.pos) : (BXMLNSSymbol)nsSymbol;
        }
    }

    private boolean hasLaxOriginalType(BLangFieldBasedAccess fieldBasedAccess) {
        return fieldBasedAccess.originalType != null && this.types.isLax(fieldBasedAccess.originalType);
    }

    private BType getLaxFieldAccessType(BType exprType) {
        switch (exprType.tag) {
            case 7: {
                return this.symTable.jsonType;
            }
            case 8: 
            case 43: {
                return this.symTable.stringType;
            }
            case 15: {
                return ((BMapType)exprType).constraint;
            }
            case 20: {
                BUnionType unionType = (BUnionType)exprType;
                LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
                unionType.getMemberTypes().forEach(bType -> memberTypes.add(this.getLaxFieldAccessType((BType)bType)));
                return memberTypes.size() == 1 ? (BType)memberTypes.iterator().next() : BUnionType.create(null, memberTypes);
            }
        }
        return this.symTable.semanticError;
    }

    private BType checkOptionalFieldAccessExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName) {
        BType laxFieldAccessType;
        Set<BType> memTypes;
        BType actualType = this.symTable.semanticError;
        boolean nillableExprType = false;
        BType effectiveType = varRefType;
        if (varRefType.tag == 20 && (memTypes = ((BUnionType)varRefType).getMemberTypes()).contains(this.symTable.nilType)) {
            LinkedHashSet<BType> nilRemovedSet = new LinkedHashSet<BType>();
            for (BType bType : memTypes) {
                if (bType != this.symTable.nilType) {
                    nilRemovedSet.add(bType);
                    continue;
                }
                nillableExprType = true;
            }
            BType bType = effectiveType = nilRemovedSet.size() == 1 ? (BType)nilRemovedSet.iterator().next() : BUnionType.create(null, nilRemovedSet);
        }
        if (this.types.isSubTypeOfBaseType(effectiveType, 12)) {
            actualType = this.checkOptionalRecordFieldAccessExpr(fieldAccessExpr, effectiveType, fieldName);
            if (actualType == this.symTable.semanticError) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticCode.OPERATION_DOES_NOT_SUPPORT_OPTIONAL_FIELD_ACCESS_FOR_FIELD, varRefType, fieldName);
            }
            fieldAccessExpr.nilSafeNavigation = nillableExprType;
            fieldAccessExpr.originalType = this.getSafeType(actualType, fieldAccessExpr);
        } else if (this.types.isLax(effectiveType)) {
            laxFieldAccessType = this.getLaxFieldAccessType(effectiveType);
            BType bType = actualType = this.accessCouldResultInError(effectiveType) ? BUnionType.create(null, laxFieldAccessType, this.symTable.errorType) : laxFieldAccessType;
            if (fieldAccessExpr.fieldKind == FieldKind.WITH_NS) {
                this.resolveXMLNamespace((BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess)fieldAccessExpr);
            }
            fieldAccessExpr.originalType = laxFieldAccessType;
            fieldAccessExpr.nilSafeNavigation = true;
            nillableExprType = true;
        } else if (fieldAccessExpr.expr.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR && this.hasLaxOriginalType((BLangFieldBasedAccess)fieldAccessExpr.expr)) {
            laxFieldAccessType = this.getLaxFieldAccessType(((BLangFieldBasedAccess)fieldAccessExpr.expr).originalType);
            BType bType = actualType = this.accessCouldResultInError(effectiveType) ? BUnionType.create(null, laxFieldAccessType, this.symTable.errorType) : laxFieldAccessType;
            if (fieldAccessExpr.fieldKind == FieldKind.WITH_NS) {
                this.resolveXMLNamespace((BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess)fieldAccessExpr);
            }
            fieldAccessExpr.errorSafeNavigation = true;
            fieldAccessExpr.originalType = laxFieldAccessType;
            fieldAccessExpr.nilSafeNavigation = true;
            nillableExprType = true;
        } else if (varRefType.tag != 26) {
            this.dlog.error(fieldAccessExpr.pos, DiagnosticCode.OPERATION_DOES_NOT_SUPPORT_OPTIONAL_FIELD_ACCESS, varRefType);
        }
        if (nillableExprType && actualType != this.symTable.semanticError && !actualType.isNullable()) {
            actualType = BUnionType.create(null, actualType, this.symTable.nilType);
        }
        return actualType;
    }

    private boolean accessCouldResultInError(BType type) {
        if (type.tag == 7) {
            return true;
        }
        if (type.tag == 15) {
            return false;
        }
        if (type.tag == 8) {
            return true;
        }
        if (type.tag == 20) {
            return ((BUnionType)type).getMemberTypes().stream().anyMatch(this::accessCouldResultInError);
        }
        return false;
    }

    private BType checkIndexAccessExpr(BLangIndexBasedAccess indexBasedAccessExpr) {
        Set<BType> memTypes;
        BType varRefType = indexBasedAccessExpr.expr.type;
        boolean nillableExprType = false;
        if (varRefType.tag == 20 && (memTypes = ((BUnionType)varRefType).getMemberTypes()).contains(this.symTable.nilType)) {
            LinkedHashSet<BType> nilRemovedSet = new LinkedHashSet<BType>();
            for (BType bType : memTypes) {
                if (bType != this.symTable.nilType) {
                    nilRemovedSet.add(bType);
                    continue;
                }
                nillableExprType = true;
            }
            if (nillableExprType) {
                BType bType = varRefType = nilRemovedSet.size() == 1 ? (BType)nilRemovedSet.iterator().next() : BUnionType.create(null, nilRemovedSet);
                if (!this.types.isSubTypeOfMapping(varRefType)) {
                    this.dlog.error(indexBasedAccessExpr.pos, DiagnosticCode.OPERATION_DOES_NOT_SUPPORT_INDEXING, indexBasedAccessExpr.expr.type);
                    return this.symTable.semanticError;
                }
                if (indexBasedAccessExpr.lhsVar) {
                    this.dlog.error(indexBasedAccessExpr.pos, DiagnosticCode.OPERATION_DOES_NOT_SUPPORT_INDEX_ACCESS_FOR_ASSIGNMENT, indexBasedAccessExpr.expr.type);
                    return this.symTable.semanticError;
                }
            }
        }
        BLangExpression indexExpr = indexBasedAccessExpr.indexExpr;
        BType actualType = this.symTable.semanticError;
        if (this.types.isSubTypeOfMapping(varRefType)) {
            this.checkExpr(indexExpr, this.env, this.symTable.stringType);
            if (indexExpr.type == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            actualType = this.checkMappingIndexBasedAccess(indexBasedAccessExpr, varRefType);
            if (actualType == this.symTable.semanticError) {
                if (indexExpr.type.tag == 5 && this.isConst(indexExpr)) {
                    String fieldName = this.getConstFieldName(indexExpr);
                    this.dlog.error(indexBasedAccessExpr.pos, DiagnosticCode.UNDEFINED_STRUCTURE_FIELD, fieldName, indexBasedAccessExpr.expr.type);
                    return actualType;
                }
                this.dlog.error(indexExpr.pos, DiagnosticCode.INVALID_RECORD_INDEX_EXPR, indexExpr.type);
                return actualType;
            }
            indexBasedAccessExpr.nilSafeNavigation = nillableExprType;
            indexBasedAccessExpr.originalType = this.getSafeType(actualType, indexBasedAccessExpr);
        } else if (this.types.isSubTypeOfList(varRefType)) {
            this.checkExpr(indexExpr, this.env, this.symTable.intType);
            if (indexExpr.type == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            indexBasedAccessExpr.originalType = actualType = this.checkListIndexBasedAccess(indexBasedAccessExpr, varRefType);
            if (actualType == this.symTable.semanticError) {
                if (indexExpr.type.tag == 1 && this.isConst(indexExpr)) {
                    this.dlog.error(indexBasedAccessExpr.indexExpr.pos, DiagnosticCode.LIST_INDEX_OUT_OF_RANGE, this.getConstIndex(indexExpr));
                    return actualType;
                }
                this.dlog.error(indexExpr.pos, DiagnosticCode.INVALID_LIST_INDEX_EXPR, indexExpr.type);
                return actualType;
            }
        } else if (this.types.isAssignable(varRefType, this.symTable.stringType)) {
            if (indexBasedAccessExpr.lhsVar) {
                this.dlog.error(indexBasedAccessExpr.pos, DiagnosticCode.OPERATION_DOES_NOT_SUPPORT_INDEX_ACCESS_FOR_ASSIGNMENT, indexBasedAccessExpr.expr.type);
                return this.symTable.semanticError;
            }
            this.checkExpr(indexExpr, this.env, this.symTable.intType);
            if (indexExpr.type == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            indexBasedAccessExpr.originalType = this.symTable.stringType;
            actualType = this.symTable.stringType;
        } else if (varRefType.tag == 8) {
            if (indexBasedAccessExpr.lhsVar) {
                indexExpr.type = this.symTable.semanticError;
                this.dlog.error(indexBasedAccessExpr.pos, DiagnosticCode.CANNOT_UPDATE_XML_SEQUENCE, new Object[0]);
                return actualType;
            }
            BType indexExprType = this.checkExpr(indexExpr, this.env);
            if (this.types.isAssignable(indexExprType, this.symTable.stringType)) {
                this.dlog.warning(indexBasedAccessExpr.pos, DiagnosticCode.DEPRECATED_XML_CHILD_ACCESS, new Object[0]);
            } else if (!this.types.isAssignable(indexExprType, this.symTable.intType)) {
                this.dlog.error(indexBasedAccessExpr.pos, DiagnosticCode.INCOMPATIBLE_TYPES, this.symTable.intType, indexExprType);
                return this.symTable.semanticError;
            }
            indexBasedAccessExpr.originalType = actualType = this.symTable.xmlType;
        } else {
            if (varRefType == this.symTable.semanticError) {
                indexBasedAccessExpr.indexExpr.type = this.symTable.semanticError;
                return this.symTable.semanticError;
            }
            indexBasedAccessExpr.indexExpr.type = this.symTable.semanticError;
            this.dlog.error(indexBasedAccessExpr.pos, DiagnosticCode.OPERATION_DOES_NOT_SUPPORT_INDEXING, indexBasedAccessExpr.expr.type);
            return this.symTable.semanticError;
        }
        if (nillableExprType && !actualType.isNullable()) {
            actualType = BUnionType.create(null, actualType, this.symTable.nilType);
        }
        return actualType;
    }

    private Long getConstIndex(BLangExpression indexExpr) {
        return indexExpr.getKind() == NodeKind.NUMERIC_LITERAL ? (Long)((BLangLiteral)indexExpr).value : (Long)((BConstantSymbol)((BLangSimpleVarRef)indexExpr).symbol).value.value;
    }

    private String getConstFieldName(BLangExpression indexExpr) {
        return indexExpr.getKind() == NodeKind.LITERAL ? (String)((BLangLiteral)indexExpr).value : (String)((BConstantSymbol)((BLangSimpleVarRef)indexExpr).symbol).value.value;
    }

    private BType checkArrayIndexBasedAccess(BLangIndexBasedAccess indexBasedAccess, BType indexExprType, BArrayType arrayType) {
        BType actualType = this.symTable.semanticError;
        switch (indexExprType.tag) {
            case 1: {
                BLangExpression indexExpr = indexBasedAccess.indexExpr;
                if (!this.isConst(indexExpr) || arrayType.state == BArrayState.UNSEALED) {
                    actualType = arrayType.eType;
                    break;
                }
                actualType = this.getConstIndex(indexExpr) >= (long)arrayType.size ? this.symTable.semanticError : arrayType.eType;
                break;
            }
            case 31: {
                BFiniteType finiteIndexExpr = (BFiniteType)indexExprType;
                boolean validIndexExists = false;
                for (BLangExpression finiteMember : finiteIndexExpr.getValueSpace()) {
                    int indexValue = ((Long)((BLangLiteral)finiteMember).value).intValue();
                    if (indexValue < 0 || arrayType.state != BArrayState.UNSEALED && indexValue >= arrayType.size) continue;
                    validIndexExists = true;
                    break;
                }
                if (!validIndexExists) {
                    return this.symTable.semanticError;
                }
                actualType = arrayType.eType;
                break;
            }
            case 20: {
                BFiniteType finiteType;
                List<BFiniteType> finiteTypes = ((BUnionType)indexExprType).getMemberTypes().stream().filter(memType -> memType.tag == 31).map(matchedType -> (BFiniteType)matchedType).collect(Collectors.toList());
                if (finiteTypes.size() == 1) {
                    finiteType = (BFiniteType)finiteTypes.get(0);
                } else {
                    LinkedHashSet<BLangExpression> valueSpace = new LinkedHashSet<BLangExpression>();
                    finiteTypes.forEach(constituent -> valueSpace.addAll(constituent.getValueSpace()));
                    finiteType = new BFiniteType(null, valueSpace);
                }
                BType elementType = this.checkArrayIndexBasedAccess(indexBasedAccess, finiteType, arrayType);
                if (elementType == this.symTable.semanticError) {
                    return this.symTable.semanticError;
                }
                actualType = arrayType.eType;
            }
        }
        return actualType;
    }

    private BType checkListIndexBasedAccess(BLangIndexBasedAccess accessExpr, BType type) {
        if (type.tag == 19) {
            return this.checkArrayIndexBasedAccess(accessExpr, accessExpr.indexExpr.type, (BArrayType)type);
        }
        if (type.tag == 29) {
            return this.checkTupleIndexBasedAccess(accessExpr, (BTupleType)type, accessExpr.indexExpr.type);
        }
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : ((BUnionType)type).getMemberTypes()) {
            BType individualFieldType = this.checkListIndexBasedAccess(accessExpr, memType);
            if (individualFieldType == this.symTable.semanticError) continue;
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.size() == 0) {
            return this.symTable.semanticError;
        }
        if (fieldTypeMembers.size() == 1) {
            return (BType)fieldTypeMembers.iterator().next();
        }
        return BUnionType.create(null, fieldTypeMembers);
    }

    private BType checkTupleIndexBasedAccess(BLangIndexBasedAccess accessExpr, BTupleType tuple, BType currentType) {
        BType actualType = this.symTable.semanticError;
        BLangExpression indexExpr = accessExpr.indexExpr;
        switch (currentType.tag) {
            case 1: {
                if (this.isConst(indexExpr)) {
                    actualType = this.checkTupleFieldType(tuple, this.getConstIndex(indexExpr).intValue());
                    break;
                }
                BTupleType tupleExpr = (BTupleType)accessExpr.expr.type;
                LinkedHashSet<BType> tupleTypes = this.collectTupleFieldTypes(tupleExpr, new LinkedHashSet<BType>());
                actualType = tupleTypes.size() == 1 ? (BType)tupleTypes.iterator().next() : BUnionType.create(null, tupleTypes);
                break;
            }
            case 31: {
                BFiniteType finiteIndexExpr = (BFiniteType)currentType;
                LinkedHashSet<BType> possibleTypes = new LinkedHashSet<BType>();
                for (BLangExpression finiteMember : finiteIndexExpr.getValueSpace()) {
                    int indexValue = ((Long)((BLangLiteral)finiteMember).value).intValue();
                    BType fieldType = this.checkTupleFieldType(tuple, indexValue);
                    if (fieldType.tag == 26) continue;
                    possibleTypes.add(fieldType);
                }
                if (possibleTypes.size() == 0) {
                    return this.symTable.semanticError;
                }
                actualType = possibleTypes.size() == 1 ? (BType)possibleTypes.iterator().next() : BUnionType.create(null, possibleTypes);
                break;
            }
            case 20: {
                BFiniteType finiteType;
                LinkedHashSet<BType> possibleTypesByMember = new LinkedHashSet<BType>();
                ArrayList finiteTypes = new ArrayList();
                ((BUnionType)currentType).getMemberTypes().forEach(memType -> {
                    if (memType.tag == 31) {
                        finiteTypes.add((BFiniteType)memType);
                    } else {
                        BType possibleType = this.checkTupleIndexBasedAccess(accessExpr, tuple, (BType)memType);
                        if (possibleType.tag == 20) {
                            possibleTypesByMember.addAll(((BUnionType)possibleType).getMemberTypes());
                        } else {
                            possibleTypesByMember.add(possibleType);
                        }
                    }
                });
                if (finiteTypes.size() == 1) {
                    finiteType = (BFiniteType)finiteTypes.get(0);
                } else {
                    LinkedHashSet<BLangExpression> valueSpace = new LinkedHashSet<BLangExpression>();
                    finiteTypes.forEach(constituent -> valueSpace.addAll(constituent.getValueSpace()));
                    finiteType = new BFiniteType(null, valueSpace);
                }
                BType possibleType = this.checkTupleIndexBasedAccess(accessExpr, tuple, finiteType);
                if (possibleType.tag == 20) {
                    possibleTypesByMember.addAll(((BUnionType)possibleType).getMemberTypes());
                } else {
                    possibleTypesByMember.add(possibleType);
                }
                if (possibleTypesByMember.contains(this.symTable.semanticError)) {
                    return this.symTable.semanticError;
                }
                actualType = possibleTypesByMember.size() == 1 ? (BType)possibleTypesByMember.iterator().next() : BUnionType.create(null, possibleTypesByMember);
            }
        }
        return actualType;
    }

    private LinkedHashSet<BType> collectTupleFieldTypes(BTupleType tupleType, LinkedHashSet<BType> memberTypes) {
        tupleType.tupleTypes.forEach(memberType -> {
            if (memberType.tag == 20) {
                this.collectMemberTypes((BUnionType)memberType, memberTypes);
            } else {
                memberTypes.add((BType)memberType);
            }
        });
        return memberTypes;
    }

    private BType checkMappingIndexBasedAccess(BLangIndexBasedAccess accessExpr, BType type) {
        if (type.tag == 15) {
            BType constraint = ((BMapType)type).constraint;
            return accessExpr.lhsVar ? constraint : this.addNilForNillableIndexBasedAccess(constraint);
        }
        if (type.tag == 12) {
            return this.checkRecordIndexBasedAccess(accessExpr, (BRecordType)type, accessExpr.indexExpr.type);
        }
        boolean nonMatchedRecordExists = false;
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : ((BUnionType)type).getMemberTypes()) {
            BType individualFieldType = this.checkMappingIndexBasedAccess(accessExpr, memType);
            if (individualFieldType == this.symTable.semanticError) {
                nonMatchedRecordExists = true;
                continue;
            }
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.size() == 0) {
            return this.symTable.semanticError;
        }
        BType fieldType = fieldTypeMembers.size() == 1 ? (BType)fieldTypeMembers.iterator().next() : BUnionType.create(null, fieldTypeMembers);
        return nonMatchedRecordExists ? this.addNilForNillableIndexBasedAccess(fieldType) : fieldType;
    }

    private BType checkRecordIndexBasedAccess(BLangIndexBasedAccess accessExpr, BRecordType record, BType currentType) {
        BType actualType = this.symTable.semanticError;
        BLangExpression indexExpr = accessExpr.indexExpr;
        switch (currentType.tag) {
            case 5: {
                if (this.isConst(indexExpr)) {
                    String fieldName = this.getConstFieldName(indexExpr);
                    actualType = this.checkRecordRequiredFieldAccess(accessExpr, this.names.fromString(fieldName), record);
                    if (actualType != this.symTable.semanticError) {
                        return actualType;
                    }
                    actualType = this.checkRecordOptionalFieldAccess(accessExpr, this.names.fromString(fieldName), record);
                    if (actualType == this.symTable.semanticError) {
                        actualType = this.checkRecordRestFieldAccess(accessExpr, this.names.fromString(fieldName), record);
                        if (actualType == this.symTable.semanticError) {
                            return actualType;
                        }
                        return this.addNilForNillableIndexBasedAccess(actualType);
                    }
                    if (accessExpr.lhsVar) {
                        return actualType;
                    }
                    return this.addNilForNillableIndexBasedAccess(actualType);
                }
                LinkedHashSet fieldTypes = record.fields.stream().map(field -> field.type).collect(Collectors.toCollection(LinkedHashSet::new));
                if (record.restFieldType.tag != 22) {
                    fieldTypes.add(record.restFieldType);
                }
                if (fieldTypes.stream().noneMatch(BType::isNullable)) {
                    fieldTypes.add(this.symTable.nilType);
                }
                actualType = BUnionType.create(null, fieldTypes);
                break;
            }
            case 31: {
                BFiniteType finiteIndexExpr = (BFiniteType)currentType;
                LinkedHashSet<BType> possibleTypes = new LinkedHashSet<BType>();
                for (BLangExpression finiteMember : finiteIndexExpr.getValueSpace()) {
                    String fieldName = (String)((BLangLiteral)finiteMember).value;
                    BType fieldType = this.checkRecordRequiredFieldAccess(accessExpr, this.names.fromString(fieldName), record);
                    if (fieldType == this.symTable.semanticError) {
                        fieldType = this.checkRecordOptionalFieldAccess(accessExpr, this.names.fromString(fieldName), record);
                        if (fieldType == this.symTable.semanticError) {
                            fieldType = this.checkRecordRestFieldAccess(accessExpr, this.names.fromString(fieldName), record);
                        }
                        if (fieldType != this.symTable.semanticError) {
                            fieldType = this.addNilForNillableIndexBasedAccess(fieldType);
                        }
                    }
                    if (fieldType.tag == 26) continue;
                    possibleTypes.add(fieldType);
                }
                if (possibleTypes.isEmpty()) {
                    return this.symTable.semanticError;
                }
                if (possibleTypes.stream().noneMatch(BType::isNullable)) {
                    possibleTypes.add(this.symTable.nilType);
                }
                actualType = possibleTypes.size() == 1 ? (BType)possibleTypes.iterator().next() : BUnionType.create(null, possibleTypes);
                break;
            }
            case 20: {
                BFiniteType finiteType;
                LinkedHashSet<BType> possibleTypesByMember = new LinkedHashSet<BType>();
                ArrayList finiteTypes = new ArrayList();
                ((BUnionType)currentType).getMemberTypes().forEach(memType -> {
                    if (memType.tag == 31) {
                        finiteTypes.add((BFiniteType)memType);
                    } else {
                        BType possibleType = this.checkRecordIndexBasedAccess(accessExpr, record, (BType)memType);
                        if (possibleType.tag == 20) {
                            possibleTypesByMember.addAll(((BUnionType)possibleType).getMemberTypes());
                        } else {
                            possibleTypesByMember.add(possibleType);
                        }
                    }
                });
                if (finiteTypes.size() == 1) {
                    finiteType = (BFiniteType)finiteTypes.get(0);
                } else {
                    LinkedHashSet<BLangExpression> valueSpace = new LinkedHashSet<BLangExpression>();
                    finiteTypes.forEach(constituent -> valueSpace.addAll(constituent.getValueSpace()));
                    finiteType = new BFiniteType(null, valueSpace);
                }
                BType possibleType = this.checkRecordIndexBasedAccess(accessExpr, record, finiteType);
                if (possibleType.tag == 20) {
                    possibleTypesByMember.addAll(((BUnionType)possibleType).getMemberTypes());
                } else {
                    possibleTypesByMember.add(possibleType);
                }
                if (possibleTypesByMember.contains(this.symTable.semanticError)) {
                    return this.symTable.semanticError;
                }
                actualType = possibleTypesByMember.size() == 1 ? (BType)possibleTypesByMember.iterator().next() : BUnionType.create(null, possibleTypesByMember);
            }
        }
        return actualType;
    }

    private BType getSafeType(BType type, BLangAccessExpression accessExpr) {
        if (type.tag != 20) {
            return type;
        }
        List<BType> lhsTypes = new ArrayList<BType>(((BUnionType)type).getMemberTypes());
        if (accessExpr.errorSafeNavigation) {
            if (!lhsTypes.contains(this.symTable.errorType)) {
                this.dlog.error(accessExpr.pos, DiagnosticCode.SAFE_NAVIGATION_NOT_REQUIRED, type);
                return this.symTable.semanticError;
            }
            if ((lhsTypes = lhsTypes.stream().filter(memberType -> memberType != this.symTable.errorType).collect(Collectors.toList())).isEmpty()) {
                this.dlog.error(accessExpr.pos, DiagnosticCode.SAFE_NAVIGATION_NOT_REQUIRED, type);
                return this.symTable.semanticError;
            }
        }
        if (accessExpr.nilSafeNavigation) {
            lhsTypes = lhsTypes.stream().filter(memberType -> memberType != this.symTable.nilType).collect(Collectors.toList());
        }
        if (lhsTypes.size() == 1) {
            return (BType)lhsTypes.get(0);
        }
        return BUnionType.create(null, new LinkedHashSet<BType>(lhsTypes));
    }

    private List<BType> getTypesList(BType type) {
        if (type.tag == 20) {
            BUnionType unionType = (BUnionType)type;
            return new ArrayList<BType>(unionType.getMemberTypes());
        }
        return Lists.of(type);
    }

    private LinkedHashSet<BType> getMatchExpressionTypes(BLangMatchExpression bLangMatchExpression) {
        List<BType> exprTypes = this.getTypesList(bLangMatchExpression.expr.type);
        LinkedHashSet<BType> matchExprTypes = new LinkedHashSet<BType>();
        for (BType type : exprTypes) {
            boolean assignable = false;
            for (BLangMatchExpression.BLangMatchExprPatternClause pattern : bLangMatchExpression.patternClauses) {
                BType patternExprType = pattern.expr.type;
                matchExprTypes.addAll(this.getTypesList(patternExprType));
                if (type.tag == 26 || patternExprType.tag == 26) {
                    return new LinkedHashSet<BType>(){
                        {
                            this.add(((TypeChecker)TypeChecker.this).symTable.semanticError);
                        }
                    };
                }
                assignable = this.types.isAssignable(type, pattern.variable.type);
                if (!assignable) continue;
                break;
            }
            if (assignable) continue;
            matchExprTypes.add(type);
        }
        return matchExprTypes;
    }

    private BSymbol getFunctionPointerCallSymbol(BLangInvocation iExpr) {
        if (iExpr.expr == null) {
            return this.symTable.notFoundSymbol;
        }
        BSymbol varSymbol = ((BLangVariableReference)iExpr.expr).symbol;
        if (varSymbol == null) {
            return this.symTable.notFoundSymbol;
        }
        BType varType = varSymbol.type;
        if (varType.tag != 16) {
            return this.symTable.notFoundSymbol;
        }
        if (varSymbol.kind != SymbolKind.FUNCTION) {
            varSymbol = new BInvokableSymbol(52, 0, varSymbol.name, this.env.enclPkg.symbol.pkgID, varType, this.env.scope.owner);
            varSymbol.kind = SymbolKind.FUNCTION;
        }
        iExpr.symbol = varSymbol;
        return varSymbol;
    }

    private boolean couldHoldTableValues(BType type, List<BType> encounteredTypes) {
        if (encounteredTypes.contains(type)) {
            return false;
        }
        encounteredTypes.add(type);
        switch (type.tag) {
            case 9: {
                return true;
            }
            case 20: {
                return ((BUnionType)type).getMemberTypes().stream().anyMatch(bType -> this.couldHoldTableValues((BType)bType, encounteredTypes));
            }
            case 15: {
                return this.couldHoldTableValues(((BMapType)type).constraint, encounteredTypes);
            }
            case 12: {
                BRecordType recordType = (BRecordType)type;
                return recordType.fields.stream().anyMatch(field -> this.couldHoldTableValues(field.type, encounteredTypes)) || !recordType.sealed && this.couldHoldTableValues(recordType.restFieldType, encounteredTypes);
            }
            case 19: {
                return this.couldHoldTableValues(((BArrayType)type).eType, encounteredTypes);
            }
            case 29: {
                return ((BTupleType)type).getTupleTypes().stream().anyMatch(bType -> this.couldHoldTableValues((BType)bType, encounteredTypes));
            }
        }
        return false;
    }

    private boolean isConst(BLangExpression expression) {
        if (ConstantAnalyzer.isValidConstantExpressionNode(expression)) {
            return true;
        }
        if (expression.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
            return false;
        }
        return (((BLangSimpleVarRef)expression).symbol.tag & 0x100001C) == 0x100001C;
    }

    private Name getCurrentCompUnit(BLangNode node) {
        return this.names.fromString(node.pos.getSource().getCompilationUnitName());
    }

    private BType getRepresentativeBroadTypeForExprs(List<BLangExpression> exprs) {
        return this.getRepresentativeBroadType(new ArrayList<BType>(Arrays.asList(this.getExprListUniqueTypes(exprs, this.env))));
    }

    private BType getRepresentativeBroadType(List<BType> inferredTypeList) {
        block0: for (int i = 0; i < inferredTypeList.size(); ++i) {
            BType type = inferredTypeList.get(i);
            if (type.tag == 26) {
                return type;
            }
            for (int j = i + 1; j < inferredTypeList.size(); ++j) {
                BType otherType = inferredTypeList.get(j);
                if (otherType.tag == 26) {
                    return otherType;
                }
                if (this.types.isAssignable(otherType, type)) {
                    inferredTypeList.remove(j);
                    --j;
                    continue;
                }
                if (!this.types.isAssignable(type, otherType)) continue;
                inferredTypeList.remove(i);
                --i;
                continue block0;
            }
        }
        if (inferredTypeList.size() == 1) {
            return inferredTypeList.get(0);
        }
        return BUnionType.create(null, inferredTypeList.toArray(new BType[0]));
    }

    private BRecordType defineInferredRecordType(BLangRecordLiteral recordLiteral) {
        PackageID pkgID = this.env.enclPkg.symbol.pkgID;
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(0, this.names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(pkgID)), pkgID, null, this.env.scope.owner);
        BInvokableType bInvokableType = new BInvokableType(new ArrayList<BType>(), this.symTable.nilType, null);
        BInvokableSymbol initFuncSymbol = Symbols.createFunctionSymbol(1, Names.EMPTY, this.env.enclPkg.symbol.pkgID, bInvokableType, this.env.scope.owner, false);
        initFuncSymbol.retType = this.symTable.nilType;
        recordSymbol.initializerFunc = new BAttachedFunction(Names.INIT_FUNCTION_SUFFIX, initFuncSymbol, bInvokableType);
        recordSymbol.scope = new Scope(recordSymbol);
        recordSymbol.scope.define(this.names.fromString(recordSymbol.name.value + "." + recordSymbol.initializerFunc.funcName.value), recordSymbol.initializerFunc.symbol);
        LinkedHashMap<String, FieldInfo> nonRestFieldTypes = new LinkedHashMap<String, FieldInfo>();
        ArrayList<BType> restFieldTypes = new ArrayList<BType>();
        for (RecordLiteralNode.RecordField recordField : recordLiteral.fields) {
            if (recordField.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField bLangRecordKeyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)recordField;
                BLangRecordLiteral.BLangRecordKey key = bLangRecordKeyValueField.key;
                BLangExpression expression = bLangRecordKeyValueField.valueExpr;
                BLangExpression keyExpr = key.expr;
                if (key.computedKey) {
                    BType exprType = this.checkExpr(expression, this.env);
                    if (!this.isUniqueType(restFieldTypes, exprType)) continue;
                    restFieldTypes.add(exprType);
                    continue;
                }
                this.addToNonRestFieldTypes(nonRestFieldTypes, this.getKeyName(keyExpr), this.checkExpr(expression, this.env), true);
                continue;
            }
            if (recordField.getKind() == NodeKind.RECORD_LITERAL_SPREAD_OP) {
                BType restFieldType;
                BType constraintType;
                BType bType = this.checkExpr(((BLangRecordLiteral.BLangRecordSpreadOperatorField)recordField).expr, this.env);
                int typeTag = bType.tag;
                if (typeTag == 15 && this.isUniqueType(restFieldTypes, constraintType = ((BMapType)bType).constraint)) {
                    restFieldTypes.add(constraintType);
                }
                if (bType.tag != 12) continue;
                BRecordType recordType = (BRecordType)bType;
                for (BField recField : recordType.fields) {
                    this.addToNonRestFieldTypes(nonRestFieldTypes, recField.name.value, recField.type, !Symbols.isOptional(recField.symbol));
                }
                if (recordType.sealed || !this.isUniqueType(restFieldTypes, restFieldType = recordType.restFieldType)) continue;
                restFieldTypes.add(restFieldType);
                continue;
            }
            BLangSimpleVarRef bLangSimpleVarRef = (BLangSimpleVarRef)((Object)recordField);
            this.addToNonRestFieldTypes(nonRestFieldTypes, this.getKeyName(bLangSimpleVarRef), this.checkExpr(bLangSimpleVarRef, this.env), true);
        }
        ArrayList<BField> fields = new ArrayList<BField>();
        for (Map.Entry entry : nonRestFieldTypes.entrySet()) {
            FieldInfo fieldInfo = (FieldInfo)entry.getValue();
            List<BType> types = fieldInfo.types;
            String key = (String)entry.getKey();
            Name fieldName = this.names.fromString(key);
            BType type = types.size() == 1 ? types.get(0) : BUnionType.create(null, types.toArray(new BType[0]));
            BVarSymbol fieldSymbol = new BVarSymbol(fieldInfo.required ? 256 : 8192, fieldName, pkgID, type, recordSymbol);
            fields.add(new BField(fieldName, null, fieldSymbol));
            recordSymbol.scope.define(fieldName, fieldSymbol);
        }
        BRecordType bRecordType = new BRecordType(recordSymbol);
        bRecordType.fields = fields;
        if (restFieldTypes.isEmpty()) {
            bRecordType.sealed = true;
            bRecordType.restFieldType = this.symTable.noType;
        } else {
            bRecordType.restFieldType = restFieldTypes.size() == 1 ? (BType)restFieldTypes.get(0) : BUnionType.create(null, restFieldTypes.toArray(new BType[0]));
        }
        recordSymbol.type = bRecordType;
        bRecordType.tsymbol = recordSymbol;
        BLangRecordTypeNode bLangRecordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(bRecordType, pkgID, this.symTable, recordLiteral.pos);
        bLangRecordTypeNode.initFunction = TypeDefBuilderHelper.createInitFunctionForRecordType(bLangRecordTypeNode, this.env, this.names, this.symTable);
        TypeDefBuilderHelper.addTypeDefinition(bRecordType, recordSymbol, bLangRecordTypeNode, this.env);
        return bRecordType;
    }

    private String getKeyName(BLangExpression key) {
        return key.getKind() == NodeKind.SIMPLE_VARIABLE_REF ? ((BLangSimpleVarRef)key).variableName.value : (String)((BLangLiteral)key).value;
    }

    private void addToNonRestFieldTypes(Map<String, FieldInfo> nonRestFieldTypes, String keyString, final BType exprType, boolean required) {
        if (!nonRestFieldTypes.containsKey(keyString)) {
            nonRestFieldTypes.put(keyString, new FieldInfo(new ArrayList<BType>(){
                {
                    this.add(exprType);
                }
            }, required));
            return;
        }
        FieldInfo fieldInfo = nonRestFieldTypes.get(keyString);
        List<BType> typeList = fieldInfo.types;
        if (this.isUniqueType(typeList, exprType)) {
            typeList.add(exprType);
        }
        if (required && !fieldInfo.required) {
            fieldInfo.required = true;
        }
    }

    private boolean isUniqueType(List<BType> typeList, BType type) {
        boolean isRecord = type.tag == 12;
        for (BType bType : typeList) {
            if (!(isRecord ? type == bType : this.types.isSameType(type, bType))) continue;
            return false;
        }
        return true;
    }

    private static class FieldInfo {
        List<BType> types;
        boolean required;

        private FieldInfo(List<BType> types, boolean required) {
            this.types = types;
            this.required = required;
        }
    }
}

