/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.StringJoiner;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.ErrorVariableNode;
import org.ballerinalang.model.tree.NodeKind;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;

public class BLangErrorVariable
extends BLangVariable
implements ErrorVariableNode {
    public BLangSimpleVariable reason;
    public List<BLangErrorDetailEntry> detail;
    public BLangSimpleVariable restDetail;
    public BLangInvocation detailExpr;
    public boolean reasonVarPrefixAvailable;
    public BLangLiteral reasonMatchConst;
    public boolean isInMatchStmt;

    public BLangErrorVariable() {
        this.annAttachments = new ArrayList();
        this.detail = new ArrayList<BLangErrorDetailEntry>();
        this.flagSet = EnumSet.noneOf(Flag.class);
    }

    @Override
    public BLangSimpleVariable getReason() {
        return this.reason;
    }

    public List<BLangErrorDetailEntry> getDetail() {
        return this.detail;
    }

    @Override
    public BLangSimpleVariable getRestDetail() {
        return this.restDetail;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.ERROR_VARIABLE;
    }

    @Override
    public String toString() {
        StringJoiner details = new StringJoiner(", ");
        this.detail.forEach(d -> details.add(d.key.toString() + "=" + d.valueBindingPattern.toString()));
        return "error (" + this.reason + ", " + details.toString() + (this.restDetail != null ? ", ...var " + this.restDetail.name.toString() : "") + ")";
    }

    public static class BLangErrorDetailEntry
    implements ErrorVariableNode.ErrorDetailEntry {
        public BLangIdentifier key;
        public BLangVariable valueBindingPattern;

        public BLangErrorDetailEntry(BLangIdentifier key, BLangVariable valueBindingPattern) {
            this.key = key;
            this.valueBindingPattern = valueBindingPattern;
        }

        @Override
        public BLangIdentifier getKey() {
            return this.key;
        }

        @Override
        public BLangVariable getValue() {
            return this.valueBindingPattern;
        }

        public String toString() {
            return this.key + ": " + this.valueBindingPattern;
        }
    }
}

