/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class BLangRecordLiteral
extends BLangExpression
implements RecordLiteralNode {
    public List<RecordLiteralNode.RecordField> fields;

    public BLangRecordLiteral() {
        this.fields = new ArrayList<RecordLiteralNode.RecordField>();
    }

    public BLangRecordLiteral(DiagnosticPos pos) {
        this();
        this.pos = pos;
    }

    public BLangRecordLiteral(DiagnosticPos pos, BType type) {
        this.pos = pos;
        this.fields = new ArrayList<RecordLiteralNode.RecordField>();
        this.type = type;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.RECORD_LITERAL_EXPR;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    public List<RecordLiteralNode.RecordField> getFields() {
        return this.fields;
    }

    public String toString() {
        return " {" + this.fields.stream().map(Object::toString).collect(Collectors.joining(",")) + "}";
    }

    public static class BLangChannelLiteral
    extends BLangRecordLiteral {
        public String channelName;

        public BLangChannelLiteral(DiagnosticPos pos, BType channelType, String channelName) {
            super(pos);
            this.type = channelType;
            this.channelName = channelName;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangMapLiteral
    extends BLangRecordLiteral {
        public BLangMapLiteral(DiagnosticPos pos, BType mapType) {
            super(pos);
            this.type = mapType;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangStructLiteral
    extends BLangRecordLiteral {
        public BAttachedFunction initializer;

        public BLangStructLiteral(DiagnosticPos pos, BType structType) {
            super(pos);
            this.type = structType;
            this.initializer = ((BRecordTypeSymbol)structType.tsymbol).initializerFunc;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangRecordKey
    extends BLangNode {
        public boolean computedKey = false;
        public BLangExpression expr;
        public BVarSymbol fieldSymbol;

        public BLangRecordKey(BLangExpression expr) {
            this.expr = expr;
        }

        @Override
        public NodeKind getKind() {
            return null;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
        }

        public String toString() {
            return this.expr.toString();
        }
    }

    public static class BLangRecordSpreadOperatorField
    extends BLangNode
    implements RecordLiteralNode.RecordSpreadOperatorFieldNode {
        public BLangExpression expr;

        @Override
        public BLangExpression getExpression() {
            return this.expr;
        }

        @Override
        public void setExpression(ExpressionNode expr) {
            this.expr = (BLangExpression)expr;
        }

        @Override
        public NodeKind getKind() {
            return NodeKind.RECORD_LITERAL_SPREAD_OP;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }

        public String toString() {
            return "..." + this.expr;
        }

        @Override
        public boolean isKeyValueField() {
            return false;
        }
    }

    public static class BLangRecordVarNameField
    extends BLangSimpleVarRef
    implements RecordLiteralNode.RecordVarNameFieldNode {
        @Override
        public boolean isKeyValueField() {
            return false;
        }
    }

    public static class BLangRecordKeyValueField
    extends BLangNode
    implements RecordLiteralNode.RecordKeyValueFieldNode {
        public BLangRecordKey key;
        public BLangExpression valueExpr;

        public BLangRecordKeyValueField() {
        }

        public BLangRecordKeyValueField(BLangRecordKey key, BLangExpression valueExpr) {
            this.key = key;
            this.valueExpr = valueExpr;
        }

        @Override
        public BLangExpression getKey() {
            return this.key.expr;
        }

        @Override
        public BLangExpression getValue() {
            return this.valueExpr;
        }

        @Override
        public NodeKind getKind() {
            return NodeKind.RECORD_LITERAL_KEY_VALUE;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }

        public String toString() {
            return this.key + (this.valueExpr != null ? ": " + this.valueExpr : "");
        }

        @Override
        public boolean isKeyValueField() {
            return true;
        }
    }
}

