/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.statements;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.statements.TryCatchFinallyNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;

public class BLangTryCatchFinally
extends BLangStatement
implements TryCatchFinallyNode {
    public BLangBlockStmt tryBody;
    public List<BLangCatch> catchBlocks;
    public BLangBlockStmt finallyBody;

    public BLangTryCatchFinally() {
        this.catchBlocks = new ArrayList<BLangCatch>();
    }

    public BLangTryCatchFinally(BLangBlockStmt tryBody, List<BLangCatch> catchBlocks, BLangBlockStmt finallyBody) {
        this.tryBody = tryBody;
        this.catchBlocks = catchBlocks;
        this.finallyBody = finallyBody;
    }

    @Override
    public BLangBlockStmt getBody() {
        return this.tryBody;
    }

    public List<BLangCatch> getCatchBlocks() {
        return this.catchBlocks;
    }

    @Override
    public BLangBlockStmt getFinallyBody() {
        return this.finallyBody;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.TRY;
    }

    public String toString() {
        String catchString = "";
        for (BLangCatch catchNode : this.catchBlocks) {
            catchString = catchString + String.valueOf(catchNode);
        }
        return "try{" + String.valueOf(this.tryBody) + "}" + catchString + (this.finallyBody != null ? "finally{" + String.valueOf(this.finallyBody) + "}" : "");
    }
}

