/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util.diagnotic;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticCode;
import org.ballerinalang.util.diagnostic.DiagnosticListener;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.diagnotic.BDiagnostic;
import org.wso2.ballerinalang.compiler.util.diagnotic.DefaultDiagnosticListener;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class BLangDiagnosticLog
implements DiagnosticLog {
    private static final CompilerContext.Key<BLangDiagnosticLog> DIAGNOSTIC_LOG_KEY = new CompilerContext.Key();
    private static ResourceBundle messages = ResourceBundle.getBundle("compiler", Locale.getDefault());
    private static final String errMsgKeyPrefix = "error.";
    private static final String warningMsgKeyPrefix = "warning.";
    private static final String noteMsgKeyPrefix = "note.";
    public int errorCount = 0;
    protected DiagnosticListener listener;
    private PackageCache pkgCache;

    @Deprecated
    public static BLangDiagnosticLog getInstance(CompilerContext context) {
        BLangDiagnosticLog dLogger = context.get(DIAGNOSTIC_LOG_KEY);
        if (dLogger == null) {
            dLogger = new BLangDiagnosticLog(context);
        }
        return dLogger;
    }

    private BLangDiagnosticLog(CompilerContext context) {
        context.put(DIAGNOSTIC_LOG_KEY, this);
        this.pkgCache = PackageCache.getInstance(context);
        this.listener = context.get(DiagnosticListener.class);
        if (this.listener == null) {
            this.listener = new DefaultDiagnosticListener();
        }
    }

    protected BLangDiagnosticLog() {
    }

    public void error(DiagnosticPos pos, DiagnosticCode code, Object ... args) {
        String msg = this.formatMessage(errMsgKeyPrefix, code, args);
        this.reportDiagnostic(new BDiagnostic(Diagnostic.Kind.ERROR, pos, code, msg));
    }

    public void warning(DiagnosticPos pos, DiagnosticCode code, Object ... args) {
        String msg = this.formatMessage(warningMsgKeyPrefix, code, args);
        this.reportDiagnostic(new BDiagnostic(Diagnostic.Kind.WARNING, pos, code, msg));
    }

    public void note(DiagnosticPos pos, DiagnosticCode code, Object ... args) {
        String msg = this.formatMessage(noteMsgKeyPrefix, code, args);
        this.reportDiagnostic(new BDiagnostic(Diagnostic.Kind.NOTE, pos, code, msg));
    }

    @Override
    public void logDiagnostic(Diagnostic.Kind kind, Diagnostic.DiagnosticPosition pos, CharSequence message) {
        this.reportDiagnostic(new BDiagnostic(kind, (DiagnosticPos)pos, message.toString()));
    }

    private String formatMessage(String prefix, DiagnosticCode code, Object[] args) {
        String msgKey = messages.getString(prefix + code.getValue());
        return MessageFormat.format(msgKey, args);
    }

    protected void reportDiagnostic(BDiagnostic diagnostic) {
        if (diagnostic.kind == Diagnostic.Kind.ERROR) {
            ++this.errorCount;
        }
        this.storeDiagnosticInPackage(diagnostic.pos.src.pkgID, diagnostic);
        this.listener.received(diagnostic);
    }

    private void storeDiagnosticInPackage(PackageID pkgId, BDiagnostic diagnostic) {
        BLangPackage pkgNode = this.pkgCache.get(pkgId);
        pkgNode.diagCollector.addDiagnostic(diagnostic);
    }
}

