/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util.diagnotic;

import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.wso2.ballerinalang.compiler.util.diagnotic.BDiagnosticSource;

public class DiagnosticPos
implements Diagnostic.DiagnosticPosition {
    public BDiagnosticSource src;
    public int sLine;
    public int eLine;
    public int sCol;
    public int eCol;

    public DiagnosticPos(BDiagnosticSource source, int startLine, int endLine, int startCol, int endCol) {
        this.src = source;
        this.sLine = startLine;
        this.eLine = endLine;
        this.sCol = startCol;
        this.eCol = endCol;
    }

    @Override
    public BDiagnosticSource getSource() {
        return this.src;
    }

    @Override
    public int getStartLine() {
        return this.sLine;
    }

    @Override
    public int getEndLine() {
        return this.eLine;
    }

    @Override
    public int getStartColumn() {
        return this.sCol;
    }

    @Override
    public int getEndColumn() {
        return this.eCol;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DiagnosticPos)) {
            return false;
        }
        DiagnosticPos diagnosticPos = (DiagnosticPos)obj;
        return this.src.equals(diagnosticPos.src) && this.sLine == diagnosticPos.sLine && this.eLine == diagnosticPos.eLine && this.sCol == diagnosticPos.sCol && this.eCol == diagnosticPos.eCol;
    }

    public int hashCode() {
        return this.src.hashCode() + this.sLine + this.eLine + this.sCol + this.eCol;
    }

    @Override
    public int compareTo(Diagnostic.DiagnosticPosition diagnosticPosition) {
        int value = this.getSource().compareTo(diagnosticPosition.getSource());
        if (value != 0) {
            return value;
        }
        if (this.sLine < diagnosticPosition.getStartLine()) {
            return -1;
        }
        if (this.sLine > diagnosticPosition.getStartLine()) {
            return 1;
        }
        if (this.sCol < diagnosticPosition.getStartColumn()) {
            return -1;
        }
        if (this.sCol > diagnosticPosition.getStartColumn()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        boolean cUnitNameAvailable = this.src.cUnitName != null && !this.src.cUnitName.isEmpty();
        String strPos = "";
        strPos = this.src.pkgID != PackageID.DEFAULT && cUnitNameAvailable ? strPos + this.src.pkgID + "::" + this.src.cUnitName + ":" : (this.src.pkgID != PackageID.DEFAULT ? strPos + this.src.pkgID + ":" : strPos + this.src.cUnitName + ":");
        return strPos + this.sLine + ":" + this.sCol + ":";
    }
}

