/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageRegistry;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;

public class MessageParser {
    private final String messageName;
    private final BType bType;
    private final Map<Integer, Descriptors.FieldDescriptor> fieldDescriptors;

    public MessageParser(String messageName, BType bType) {
        this.messageName = messageName;
        this.bType = bType;
        Descriptors.Descriptor messageDescriptor = MessageRegistry.getInstance().getMessageDescriptor(messageName);
        this.fieldDescriptors = this.computeFieldTagValues(messageDescriptor);
    }

    MessageParser(Descriptors.Descriptor descriptor, BType bType) {
        this.messageName = descriptor.getName();
        this.bType = bType;
        this.fieldDescriptors = this.computeFieldTagValues(descriptor);
    }

    Message parseFrom(CodedInputStream input) throws IOException {
        return new Message(this.messageName, this.bType, input, this.fieldDescriptors);
    }

    Message getDefaultInstance() throws IOException {
        return new Message(this.messageName, this.bType, null, this.fieldDescriptors);
    }

    private Map<Integer, Descriptors.FieldDescriptor> computeFieldTagValues(Descriptors.Descriptor messageDescriptor) {
        if (messageDescriptor == null) {
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL).withDescription("Couldn't find message descriptor for the message name: " + this.messageName)));
        }
        HashMap<Integer, Descriptors.FieldDescriptor> fieldDescriptors = new HashMap<Integer, Descriptors.FieldDescriptor>();
        for (Descriptors.FieldDescriptor fieldDescriptor : messageDescriptor.getFields()) {
            Descriptors.FieldDescriptor.Type fieldType = fieldDescriptor.getType();
            int number = fieldDescriptor.getNumber();
            int byteCode = (number << 3) + MessageUtils.getFieldWireType(fieldType);
            fieldDescriptors.put(byteCode, fieldDescriptor);
        }
        return fieldDescriptors;
    }
}

