/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.validator;

class ErrorMessages {
    ErrorMessages() {
    }

    static String invalidFilePath(String path) {
        return String.format("OpenAPI contract doesn't exist in the given location:%n%s", path);
    }

    static String invalidFile() {
        return "Invalid file type. Provide either a .yaml or .json file.";
    }

    static String parserException(String path) {
        return String.format("Couldn't read the OpenAPI contract from the given file: %s", path);
    }

    static String undocumentedResourcePath(String path) {
        return String.format("Ballerina service contains a Resource that is not documented in the OpenAPI contract. Error Resource path '%s'", path);
    }

    static String undocumentedResourceParameter(String paramName, String method, String path) {
        return String.format("'%s' parameter for the method '%s' of the resource associated with the path '%s' is not documented in the OpenAPI contract", paramName, method, path);
    }

    static String undocumentedResourceMethods(String methods, String path) {
        return String.format("OpenAPI contract doesn't contain the documentation for http method(s) '%s' for the path '%s'", methods, path);
    }

    static String unimplementedOpenAPIPath(String path) {
        return String.format("Couldn't find a Ballerina service resource for the path '%s' which is documented in the OpenAPI contract", path);
    }

    static String unimplementedOpenAPIOperationsForPath(String methods, String path) {
        return String.format("Couldn't find Ballerina service resource(s) for http method(s) '%s' for the path '%s' which is documented in the OpenAPI contract", methods, path);
    }

    static String unimplementedParameterForOperation(String paramName, String method, String path) {
        return String.format("Couldn't find '%s' parameter in the Ballerina service resource for the method '%s' of the path '%s' which is documented in the OpenAPI contract", paramName, method, path);
    }

    static String undocumentedFieldInRecordParam(String fieldName, String paramName, String method, String path) {
        return String.format("The '%s' field in the record type of the parameter '%s' is not documented in the OpenAPI contract for the method '%s' of the path '%s'", fieldName, paramName, method, path);
    }

    static String unimplementedFieldInOperation(String fieldName, String paramName, String operation, String path) {
        return String.format("Couldn't find the '%s' field in the record type of the parameter '%s' for the method '%s' of the path '%s' which is documented in the OpenAPI contract", fieldName, paramName, operation, path);
    }

    static String tagFilterEnable() {
        return String.format("Both Tags and excludeTags fields include the same tag(s). Make sure to use one field of tag filtering when using the openapi annotation. ", new Object[0]);
    }

    static String operationFilterEnable() {
        return String.format("Both Operations and excludeOperations fields include the same operation(s). Make sure to use one field of operation filtering when using the openapi annotation.", new Object[0]);
    }
}

