/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.nativeimpl.consumer;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.messaging.kafka.observability.KafkaMetricsUtil;
import org.ballerinalang.messaging.kafka.observability.KafkaTracingUtil;
import org.ballerinalang.messaging.kafka.utils.KafkaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetOffsets {
    private static final Logger logger = LoggerFactory.getLogger(GetOffsets.class);

    public static Object getBeginningOffsets(ObjectValue consumerObject, BArray topicPartitions, long duration) {
        KafkaTracingUtil.traceResourceInvocation(Scheduler.getStrand(), consumerObject);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        Properties consumerProperties = (Properties)consumerObject.getNativeData("KafkaConsumerConfig");
        int defaultApiTimeout = KafkaUtils.getDefaultApiTimeout(consumerProperties);
        int apiTimeout = KafkaUtils.getIntFromLong(duration, logger, "duration");
        ArrayList<TopicPartition> partitionList = KafkaUtils.getTopicPartitionList(topicPartitions, logger);
        try {
            Map<TopicPartition, Long> offsetMap = apiTimeout > -1 ? GetOffsets.getBeginningOffsetsWithDuration(kafkaConsumer, partitionList, apiTimeout) : (defaultApiTimeout > -1 ? GetOffsets.getBeginningOffsetsWithDuration(kafkaConsumer, partitionList, defaultApiTimeout) : kafkaConsumer.beginningOffsets(partitionList));
            return KafkaUtils.getPartitionOffsetArrayFromOffsetMap(offsetMap);
        }
        catch (KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "get_beginning_offsets");
            return KafkaUtils.createKafkaError("Failed to retrieve offsets for the topic partitions: " + e.getMessage(), "{ballerina/kafka}ConsumerError");
        }
    }

    public static Object getCommittedOffset(ObjectValue consumerObject, MapValue<String, Object> topicPartition, long duration) {
        KafkaTracingUtil.traceResourceInvocation(Scheduler.getStrand(), consumerObject);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        Properties consumerProperties = (Properties)consumerObject.getNativeData("KafkaConsumerConfig");
        int defaultApiTimeout = KafkaUtils.getDefaultApiTimeout(consumerProperties);
        int apiTimeout = KafkaUtils.getIntFromLong(duration, logger, "duration");
        String topic = topicPartition.getStringValue("topic");
        Long partition = topicPartition.getIntValue("partition");
        TopicPartition tp = new TopicPartition(topic, KafkaUtils.getIntFromLong(partition, logger, "partition"));
        try {
            MapValue<String, Object> offset = new MapValue<String, Object>(KafkaUtils.getPartitionOffsetRecord().getType());
            OffsetAndMetadata offsetAndMetadata = apiTimeout > -1 ? GetOffsets.getOffsetAndMetadataWithDuration(kafkaConsumer, tp, apiTimeout) : (defaultApiTimeout > -1 ? GetOffsets.getOffsetAndMetadataWithDuration(kafkaConsumer, tp, defaultApiTimeout) : kafkaConsumer.committed(tp));
            if (Objects.isNull(offsetAndMetadata)) {
                return offset;
            }
            offset = KafkaUtils.populatePartitionOffsetRecord(topicPartition, offsetAndMetadata.offset());
            return offset;
        }
        catch (KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "get_committed_offset");
            return KafkaUtils.createKafkaError("Failed to retrieve committed offsets: " + e.getMessage(), "{ballerina/kafka}ConsumerError");
        }
    }

    public static Object getEndOffsets(ObjectValue consumerObject, BArray topicPartitions, long duration) {
        Map<TopicPartition, Long> offsetMap;
        KafkaTracingUtil.traceResourceInvocation(Scheduler.getStrand(), consumerObject);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        Properties consumerProperties = (Properties)consumerObject.getNativeData("KafkaConsumerConfig");
        int defaultApiTimeout = KafkaUtils.getDefaultApiTimeout(consumerProperties);
        int apiTimeout = KafkaUtils.getIntFromLong(duration, logger, "duration");
        ArrayList<TopicPartition> partitionList = KafkaUtils.getTopicPartitionList(topicPartitions, logger);
        try {
            offsetMap = apiTimeout > -1 ? GetOffsets.getEndOffsetsWithDuration(kafkaConsumer, partitionList, apiTimeout) : (defaultApiTimeout > -1 ? GetOffsets.getEndOffsetsWithDuration(kafkaConsumer, partitionList, defaultApiTimeout) : kafkaConsumer.endOffsets(partitionList));
        }
        catch (KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "get_end_offsets");
            return KafkaUtils.createKafkaError("Failed to retrieve end offsets for the consumer: " + e.getMessage(), "{ballerina/kafka}ConsumerError");
        }
        return KafkaUtils.getPartitionOffsetArrayFromOffsetMap(offsetMap);
    }

    public static Object getPositionOffset(ObjectValue consumerObject, MapValue<String, Object> topicPartition, long duration) {
        KafkaTracingUtil.traceResourceInvocation(Scheduler.getStrand(), consumerObject);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        Properties consumerProperties = (Properties)consumerObject.getNativeData("KafkaConsumerConfig");
        int defaultApiTimeout = KafkaUtils.getDefaultApiTimeout(consumerProperties);
        int apiTimeout = KafkaUtils.getIntFromLong(duration, logger, "duration");
        String topic = topicPartition.getStringValue("topic");
        Long partition = topicPartition.getIntValue("partition");
        TopicPartition tp = new TopicPartition(topic, KafkaUtils.getIntFromLong(partition, logger, "partition"));
        try {
            long position = apiTimeout > -1 ? GetOffsets.getPositionWithDuration(kafkaConsumer, tp, apiTimeout) : (defaultApiTimeout > -1 ? GetOffsets.getPositionWithDuration(kafkaConsumer, tp, defaultApiTimeout) : kafkaConsumer.position(tp));
            return position;
        }
        catch (IllegalStateException | KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "get_position_offset");
            return KafkaUtils.createKafkaError("Failed to retrieve position offset: " + e.getMessage(), "{ballerina/kafka}ConsumerError");
        }
    }

    private static Map<TopicPartition, Long> getBeginningOffsetsWithDuration(KafkaConsumer consumer, List<TopicPartition> partitions, long timeout) {
        Duration duration = Duration.ofMillis(timeout);
        return consumer.beginningOffsets(partitions, duration);
    }

    private static OffsetAndMetadata getOffsetAndMetadataWithDuration(KafkaConsumer kafkaConsumer, TopicPartition topicPartition, long timeout) {
        Duration duration = Duration.ofMillis(timeout);
        return kafkaConsumer.committed(topicPartition, duration);
    }

    private static Map<TopicPartition, Long> getEndOffsetsWithDuration(KafkaConsumer consumer, ArrayList<TopicPartition> partitions, long timeout) {
        Duration duration = Duration.ofMillis(timeout);
        return consumer.endOffsets(partitions, duration);
    }

    private static long getPositionWithDuration(KafkaConsumer kafkaConsumer, TopicPartition topicPartition, long timeout) {
        Duration duration = Duration.ofMillis(timeout);
        return kafkaConsumer.position(topicPartition, duration);
    }
}

