/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.utils;

import java.util.List;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedResourceParamTypes;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;

@SupportedResourceParamTypes(expectedListenerType=@SupportedResourceParamTypes.Type(packageName="kafka:1.1.0", name="Consumer"), paramTypes={@SupportedResourceParamTypes.Type(packageName="kafka", name="Consumer")})
public class KafkaServiceCompilerPlugin
extends AbstractCompilerPlugin {
    private DiagnosticLog diagnosticLog = null;

    public void init(DiagnosticLog diagnosticLog) {
        this.diagnosticLog = diagnosticLog;
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        this.validateService(serviceNode);
    }

    private void validateService(ServiceNode serviceNode) {
        List resources = serviceNode.getResources();
        if (resources.size() > 1) {
            String message = "More than one resources found in Kafka service " + serviceNode.getName().getValue() + ". Kafka Service should only have one resource";
            this.logError(message, serviceNode.getPosition());
            return;
        }
        this.validateResource((FunctionNode)resources.get(0));
    }

    private void validateResource(FunctionNode resource) {
        String resourceName = resource.getName().getValue();
        Diagnostic.DiagnosticPosition position = resource.getPosition();
        if (!"onMessage".equals(resourceName)) {
            String message = "Kafka service has invalid resource: " + resourceName + ". Valid resource name:" + "onMessage";
            this.logError(message, position);
            return;
        }
        List inputParameters = resource.getParameters();
        if (inputParameters.size() == 2) {
            this.validateResourceWithTwoInputParameters(inputParameters, position);
        } else if (inputParameters.size() == 4) {
            this.validateResourceWithFourInputParameters(inputParameters, position);
        } else {
            this.logError("Invalid number of input parameters found in resource " + resourceName, position);
            return;
        }
    }

    private void validateResourceWithTwoInputParameters(List<? extends SimpleVariableNode> parameters, Diagnostic.DiagnosticPosition position) {
        this.checkParameter(this.getParameterTypeName(parameters.get(0)), "ballerina/kafka:Consumer", position);
        this.checkParameter(this.getParameterTypeName(parameters.get(1)), "ballerina/kafka:ConsumerRecord[]", position);
    }

    private void validateResourceWithFourInputParameters(List<? extends SimpleVariableNode> parameters, Diagnostic.DiagnosticPosition position) {
        this.checkParameter(this.getParameterTypeName(parameters.get(0)), "ballerina/kafka:Consumer", position);
        this.checkParameter(this.getParameterTypeName(parameters.get(1)), "ballerina/kafka:ConsumerRecord[]", position);
        this.checkParameter(this.getParameterTypeName(parameters.get(2)), "ballerina/kafka:PartitionOffset[]", position);
        this.checkParameter(this.getParameterTypeName(parameters.get(3)), BTypes.typeString.getName(), position);
    }

    private void checkParameter(String parameterName, String expectedValue, Diagnostic.DiagnosticPosition position) {
        String parameter = this.clearParameter(parameterName);
        if (!parameter.equals(expectedValue)) {
            String message = "Resource parameter " + parameterName + " is invalid. Expected: " + expectedValue + ".";
            this.logError(message, position);
        }
    }

    private String clearParameter(String parameter) {
        String clearedParameter = parameter.replace("wso2/", "").replace(":0.0.0", "");
        return clearedParameter;
    }

    private String getParameterTypeName(SimpleVariableNode parameter) {
        return ((BLangSimpleVariable)parameter).getTypeNode().type.toString();
    }

    private void logError(String message, Diagnostic.DiagnosticPosition position) {
        this.diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, position, (CharSequence)message);
    }
}

