/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.cli.module;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Authenticator;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.net.ssl.HttpsURLConnection;
import org.ballerinalang.cli.module.util.ErrorUtil;
import org.ballerinalang.cli.module.util.Utils;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;

public class Search {
    private static PrintStream outStream = System.out;

    private Search() {
    }

    public static void execute(String url, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword, String terminalWidth) {
        HttpsURLConnection conn = Utils.createHttpsUrlConnection(Utils.convertToUrl(url), proxyHost, proxyPort, proxyUsername, proxyPassword);
        conn.setInstanceFollowRedirects(false);
        Utils.setRequestMethod(conn, Utils.RequestMethod.GET);
        Search.handleResponse(conn, Utils.getStatusCode(conn), terminalWidth);
        Authenticator.setDefault(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleResponse(HttpsURLConnection conn, int statusCode, String terminalWidth) {
        block37: {
            try {
                if (statusCode == 200) {
                    MapValue payload;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));){
                        String line;
                        StringBuilder result = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            result.append(line);
                        }
                        payload = (MapValue)JSONParser.parse((String)result.toString());
                    }
                    catch (IOException e) {
                        throw ErrorUtil.createCommandException(e.getMessage());
                    }
                    if (payload.getIntValue("count") > 0L) {
                        ArrayValue modules = payload.getArrayValue("modules");
                        Search.printModules(modules, terminalWidth);
                    } else {
                        outStream.println("no modules found");
                    }
                    break block37;
                }
                StringBuilder result = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getErrorStream(), Charset.defaultCharset()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        result.append(line);
                    }
                }
                catch (IOException e) {
                    throw ErrorUtil.createCommandException(e.getMessage());
                }
                MapValue payload = (MapValue)JSONParser.parse((String)result.toString());
                throw ErrorUtil.createCommandException(payload.getStringValue("message"));
            }
            finally {
                conn.disconnect();
            }
        }
    }

    public static void printModules(ArrayValue modules, String terminalWidth) {
        int rightMargin = 3;
        int width = Integer.parseInt(terminalWidth) - rightMargin;
        int dateColWidth = 15;
        int versionColWidth = 8;
        int authorsColWidth = 15;
        double nameColFactor = 9.0;
        double descColFactor = 16.0;
        int additionalSpace = 7;
        double remainingWidth = (double)width - (double)(dateColWidth + versionColWidth + additionalSpace);
        int nameColWidth = (int)Math.round(remainingWidth * (nameColFactor / (nameColFactor + descColFactor)));
        int descColWidth = (int)Math.round(remainingWidth * (descColFactor / (nameColFactor + descColFactor)));
        int minDescColWidth = 60;
        Search.printTitle();
        Search.printTableHeader(dateColWidth, versionColWidth, nameColWidth, descColWidth, minDescColWidth, authorsColWidth);
        for (int i = 0; i < modules.size(); ++i) {
            Search.printModule((MapValue)modules.get((long)i), dateColWidth, versionColWidth, authorsColWidth, nameColWidth, descColWidth, minDescColWidth);
            outStream.println();
        }
        outStream.println();
        outStream.println(modules.size() + " modules found");
    }

    private static void printModule(MapValue module, int dateColWidth, int versionColWidth, int authorsColWidth, int nameColWidth, int descColWidth, int minDescColWidth) {
        String orgName = module.getStringValue("orgName");
        String packageName = module.getStringValue("name");
        Search.printInCLI("|" + orgName + "/" + packageName, nameColWidth);
        String summary = module.getStringValue("summary");
        if (descColWidth >= minDescColWidth) {
            Search.printInCLI(summary, descColWidth - authorsColWidth);
            String authors = "";
            ArrayValue authorsArr = module.getArrayValue("authors");
            if (authorsArr.size() > 0) {
                for (int j = 0; j < authorsArr.size(); ++j) {
                    authors = j == 0 ? (String)authorsArr.get((long)j) : (j == authorsArr.size() - 1 ? (String)authorsArr.get((long)j) : ", " + authorsArr.get((long)j));
                }
            }
            Search.printInCLI(authors, authorsColWidth);
        } else {
            Search.printInCLI(summary, descColWidth);
        }
        long createTimeJson = module.getIntValue("createdDate");
        Search.printInCLI(Search.getDateCreated(createTimeJson), dateColWidth);
        String packageVersion = module.getStringValue("version");
        Search.printInCLI(packageVersion, versionColWidth);
    }

    private static void printTitle() {
        outStream.println();
        outStream.println("Ballerina Central");
        outStream.println("=================");
        outStream.println();
    }

    private static void printInCLI(String element, int charactersAllowed) {
        int lengthOfElement = element.length();
        if (lengthOfElement > charactersAllowed || lengthOfElement == charactersAllowed) {
            int margin = 3;
            String trimmedElement = element.substring(0, charactersAllowed - margin) + "...";
            outStream.print(trimmedElement + " |");
        } else {
            Search.printCharacter(element, charactersAllowed, " ", false);
        }
    }

    private static void printCharacter(String element, int charactersAllowed, String separator, boolean isDashElement) {
        int lengthOfElement = element.length();
        StringBuilder print = new StringBuilder(element);
        for (int i = 0; i < charactersAllowed - lengthOfElement; ++i) {
            print.append(separator);
        }
        if (isDashElement) {
            outStream.print(print + "-|");
        } else {
            outStream.print(print + " |");
        }
    }

    private static String getDateCreated(long timeInMillis) {
        Date date = new Date(timeInMillis);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-E");
        return df.format(date);
    }

    private static void printTableHeader(int dateColWidth, int versionColWidth, int nameColWidth, int descColWidth, int minDescColWidth, int authorsColWidth) {
        Search.printHeadingRow(dateColWidth, versionColWidth, nameColWidth, descColWidth, minDescColWidth, authorsColWidth);
        Search.printDashRow(dateColWidth, versionColWidth, nameColWidth, descColWidth, minDescColWidth, authorsColWidth);
    }

    private static void printHeadingRow(int dateColWidth, int versionColWidth, int nameColWidth, int descColWidth, int minDescColWidth, int authorsColWidth) {
        Search.printInCLI("|NAME", nameColWidth);
        if (descColWidth >= minDescColWidth) {
            Search.printInCLI("DESCRIPTION", descColWidth - authorsColWidth);
            Search.printInCLI("AUTHOR", authorsColWidth);
        } else {
            Search.printInCLI("DESCRIPTION", descColWidth);
        }
        Search.printInCLI("DATE", dateColWidth);
        Search.printInCLI("VERSION", versionColWidth);
        outStream.println();
    }

    private static void printDashRow(int dateColWidth, int versionColWidth, int nameColWidth, int descColWidth, int minDescColWidth, int authorsColWidth) {
        Search.printCharacter("|-", nameColWidth, "-", true);
        if (descColWidth >= minDescColWidth) {
            Search.printCharacter("-", descColWidth - authorsColWidth, "-", true);
            Search.printCharacter("-", authorsColWidth, "-", true);
        } else {
            Search.printCharacter("-", descColWidth, "-", true);
        }
        Search.printCharacter("-", dateColWidth, "-", true);
        Search.printCharacter("-", versionColWidth, "-", true);
        outStream.println();
    }
}

