/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.encoding.nativeimpl;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.stdlib.encoding.EncodingUtil;

public class Encode {
    public static String encodeBase64Url(ArrayValue input) {
        byte[] encodedValue = Base64.getUrlEncoder().withoutPadding().encode(input.getBytes());
        return new String(encodedValue, StandardCharsets.ISO_8859_1);
    }

    public static Object encodeUriComponent(String url, String charset) {
        try {
            String encoded = URLEncoder.encode(url, charset);
            StringBuilder buf = new StringBuilder(encoded.length());
            for (int i = 0; i < encoded.length(); ++i) {
                char focus = encoded.charAt(i);
                if (focus == '*') {
                    buf.append("%2A");
                    continue;
                }
                if (focus == '+') {
                    buf.append("%20");
                    continue;
                }
                if (focus == '%' && i + 1 < encoded.length() && encoded.charAt(i + 1) == '7' && encoded.charAt(i + 2) == 'E') {
                    buf.append('~');
                    i += 2;
                    continue;
                }
                buf.append(focus);
            }
            return buf.toString();
        }
        catch (Throwable e) {
            return EncodingUtil.createError("Error occurred while encoding the URI component. " + e.getMessage());
        }
    }
}

