/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.impl.reservoir;

import com.codahale.metrics.Snapshot;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramIterationValue;

public final class HdrHistogramSnapshot
extends Snapshot {
    private final Histogram histogram;

    public HdrHistogramSnapshot(Histogram histogram) {
        this.histogram = histogram;
    }

    public double getValue(double quantile) {
        return this.histogram.getValueAtPercentile(quantile * 100.0);
    }

    public long[] getValues() {
        long[] values = new long[(int)this.histogram.getTotalCount()];
        int i = 0;
        for (HistogramIterationValue value : this.histogram.recordedValues()) {
            long v = value.getValueIteratedTo();
            int j = 0;
            while ((long)j < value.getCountAddedInThisIterationStep()) {
                values[i] = v;
                ++i;
                ++j;
            }
        }
        return values;
    }

    public int size() {
        return (int)this.histogram.getTotalCount();
    }

    public long getMax() {
        return this.histogram.getMaxValue();
    }

    public double getMean() {
        return this.histogram.getMean();
    }

    public long getMin() {
        return this.histogram.getMinValue();
    }

    public double getStdDev() {
        return this.histogram.getStdDeviation();
    }

    public void dump(OutputStream output) {
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));){
            for (HistogramIterationValue value : this.histogram.recordedValues()) {
                long v = value.getValueIteratedTo();
                int j = 0;
                while ((long)j < value.getCountAddedInThisIterationStep()) {
                    out.printf("%d%n", v);
                    ++j;
                }
            }
        }
    }
}

