/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.net.http.HttpUtil;
import org.wso2.transport.http.netty.contract.HttpWsConnectorFactory;
import org.wso2.transport.http.netty.contract.ServerConnector;
import org.wso2.transport.http.netty.contract.config.ListenerConfiguration;
import org.wso2.transport.http.netty.contract.config.SenderConfiguration;
import org.wso2.transport.http.netty.contract.config.ServerBootstrapConfiguration;
import org.wso2.transport.http.netty.contract.config.TransportProperty;
import org.wso2.transport.http.netty.contract.config.TransportsConfiguration;
import org.wso2.transport.http.netty.contract.websocket.WebSocketClientConnector;
import org.wso2.transport.http.netty.contract.websocket.WebSocketClientConnectorConfig;
import org.wso2.transport.http.netty.message.HttpConnectorUtil;

public class HttpConnectionManager {
    private static HttpConnectionManager instance = new HttpConnectionManager();
    private Map<String, ServerConnector> startupDelayedHTTPServerConnectors = new HashMap<String, ServerConnector>();
    private Map<String, HttpServerConnectorContext> serverConnectorPool = new HashMap<String, HttpServerConnectorContext>();
    private ServerBootstrapConfiguration serverBootstrapConfiguration;
    private TransportsConfiguration trpConfig;
    private HttpWsConnectorFactory httpConnectorFactory = HttpUtil.createHttpWsConnectionFactory();

    private HttpConnectionManager() {
        this.trpConfig = this.buildDefaultTransportConfig();
        this.serverBootstrapConfiguration = HttpConnectorUtil.getServerBootstrapConfiguration((Set)this.trpConfig.getTransportProperties());
    }

    public static HttpConnectionManager getInstance() {
        return instance;
    }

    public ServerConnector createHttpServerConnector(ListenerConfiguration listenerConfig) throws Exception {
        String listenerInterface = listenerConfig.getHost() + ":" + listenerConfig.getPort();
        HttpServerConnectorContext httpServerConnectorContext = this.serverConnectorPool.get(listenerInterface);
        if (httpServerConnectorContext != null) {
            if (this.checkForConflicts(listenerConfig, httpServerConnectorContext)) {
                throw new Exception("Conflicting configuration detected for listener configuration id " + listenerConfig.getId());
            }
            httpServerConnectorContext.incrementReferenceCount();
            return httpServerConnectorContext.getServerConnector();
        }
        if (this.isHTTPTraceLoggerEnabled()) {
            listenerConfig.setHttpTraceLogEnabled(true);
        }
        if (this.isHTTPAccessLoggerEnabled()) {
            listenerConfig.setHttpAccessLogEnabled(true);
        }
        this.serverBootstrapConfiguration = HttpConnectorUtil.getServerBootstrapConfiguration((Set)this.trpConfig.getTransportProperties());
        ServerConnector serverConnector = this.httpConnectorFactory.createServerConnector(this.serverBootstrapConfiguration, listenerConfig);
        httpServerConnectorContext = new HttpServerConnectorContext(serverConnector, listenerConfig);
        this.serverConnectorPool.put(serverConnector.getConnectorID(), httpServerConnectorContext);
        httpServerConnectorContext.incrementReferenceCount();
        this.addStartupDelayedHTTPServerConnector(listenerInterface, serverConnector);
        return serverConnector;
    }

    public void addStartupDelayedHTTPServerConnector(String id, ServerConnector serverConnector) {
        this.startupDelayedHTTPServerConnectors.put(id, serverConnector);
    }

    private boolean checkForConflicts(ListenerConfiguration listenerConfiguration, HttpServerConnectorContext context) {
        if (context == null) {
            return false;
        }
        if (listenerConfiguration.getScheme().equalsIgnoreCase("https")) {
            ListenerConfiguration config = context.getListenerConfiguration();
            if (!listenerConfiguration.getKeyStoreFile().equals(config.getKeyStoreFile()) || !listenerConfiguration.getKeyStorePass().equals(config.getKeyStorePass())) {
                return true;
            }
        }
        return false;
    }

    public WebSocketClientConnector getWebSocketClientConnector(WebSocketClientConnectorConfig configuration) throws Exception {
        return this.httpConnectorFactory.createWsClientConnectorWithSSL(configuration);
    }

    public TransportsConfiguration getTransportConfig() {
        return this.trpConfig;
    }

    public boolean isHTTPTraceLoggerEnabled() {
        return Boolean.parseBoolean(System.getProperty("http.tracelog.enabled"));
    }

    private boolean isHTTPAccessLoggerEnabled() {
        return Boolean.parseBoolean(System.getProperty("http.accesslog.enabled"));
    }

    private TransportsConfiguration buildDefaultTransportConfig() {
        TransportsConfiguration transportsConfiguration = new TransportsConfiguration();
        SenderConfiguration httpSender = new SenderConfiguration("http-sender");
        SenderConfiguration httpsSender = new SenderConfiguration("https-sender");
        httpsSender.setScheme("https");
        TransportProperty latencyMetrics = new TransportProperty();
        latencyMetrics.setName("latency.metrics.enabled");
        latencyMetrics.setValue((Object)true);
        TransportProperty serverSocketTimeout = new TransportProperty();
        serverSocketTimeout.setName("server.bootstrap.socket.timeout");
        serverSocketTimeout.setValue((Object)60);
        TransportProperty clientSocketTimeout = new TransportProperty();
        clientSocketTimeout.setName("client.bootstrap.socket.timeout");
        clientSocketTimeout.setValue((Object)60);
        HashSet<SenderConfiguration> senderConfigurationSet = new HashSet<SenderConfiguration>();
        senderConfigurationSet.add(httpSender);
        senderConfigurationSet.add(httpsSender);
        transportsConfiguration.setSenderConfigurations(senderConfigurationSet);
        HashSet<TransportProperty> transportPropertySet = new HashSet<TransportProperty>();
        transportPropertySet.add(latencyMetrics);
        transportPropertySet.add(serverSocketTimeout);
        transportPropertySet.add(clientSocketTimeout);
        transportsConfiguration.setTransportProperties(transportPropertySet);
        return transportsConfiguration;
    }

    private static class HttpServerConnectorContext {
        private ServerConnector serverConnector;
        private ListenerConfiguration listenerConfiguration;
        private int referenceCount = 0;

        HttpServerConnectorContext(ServerConnector serverConnector, ListenerConfiguration listenerConfiguration) {
            this.serverConnector = serverConnector;
            this.listenerConfiguration = listenerConfiguration;
        }

        void incrementReferenceCount() {
            ++this.referenceCount;
        }

        void decrementReferenceCount() {
            --this.referenceCount;
        }

        ServerConnector getServerConnector() {
            return this.serverConnector;
        }

        ListenerConfiguration getListenerConfiguration() {
            return this.listenerConfiguration;
        }

        int getReferenceCount() {
            return this.referenceCount;
        }
    }
}

