/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.PortBindingEventListener;

public class HttpConnectorPortBindingListener
implements PortBindingEventListener {
    private static final Logger log = LoggerFactory.getLogger(HttpConnectorPortBindingListener.class);
    private static final PrintStream console = System.out;

    public void onOpen(String serverConnectorId, boolean isHttps) {
        if (isHttps) {
            console.println("[ballerina/http] started HTTPS/WSS listener " + serverConnectorId);
        } else {
            console.println("[ballerina/http] started HTTP/WS listener " + serverConnectorId);
        }
    }

    public void onClose(String serverConnectorId, boolean isHttps) {
        if (isHttps) {
            console.println("[ballerina/http] stopped HTTPS/WSS listener " + serverConnectorId);
        } else {
            console.println("[ballerina/http] stopped HTTP/WS listener " + serverConnectorId);
        }
    }

    public void onError(Throwable throwable) {
        log.debug("Error in http endpoint", throwable);
    }
}

