/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.JSONGenerator;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.services.ErrorHandlerUtils;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BErrorType;
import org.ballerinalang.jvm.types.BFiniteType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.TypeFlags;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.StreamingJsonValue;
import org.ballerinalang.jvm.values.XMLItem;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.mime.util.EntityBodyChannel;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.EntityWrapper;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.mime.util.MultipartDataSource;
import org.ballerinalang.mime.util.MultipartDecoder;
import org.ballerinalang.net.http.CompressionConfigState;
import org.ballerinalang.net.http.CorsHeaderGenerator;
import org.ballerinalang.net.http.HttpConstants;
import org.ballerinalang.net.http.HttpErrorType;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpResourceArguments;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.net.http.ValueCreatorUtils;
import org.ballerinalang.net.http.caching.RequestCacheControlObj;
import org.ballerinalang.net.http.caching.ResponseCacheControlObj;
import org.ballerinalang.net.http.nativeimpl.pipelining.PipeliningHandler;
import org.ballerinalang.stdlib.io.utils.IOConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.HttpWsConnectorFactory;
import org.wso2.transport.http.netty.contract.config.ChunkConfig;
import org.wso2.transport.http.netty.contract.config.ForwardedExtensionConfig;
import org.wso2.transport.http.netty.contract.config.InboundMsgSizeValidationConfig;
import org.wso2.transport.http.netty.contract.config.KeepAliveConfig;
import org.wso2.transport.http.netty.contract.config.ListenerConfiguration;
import org.wso2.transport.http.netty.contract.config.Parameter;
import org.wso2.transport.http.netty.contract.config.ProxyServerConfiguration;
import org.wso2.transport.http.netty.contract.config.SenderConfiguration;
import org.wso2.transport.http.netty.contract.config.SslConfiguration;
import org.wso2.transport.http.netty.contract.exceptions.ClientConnectorException;
import org.wso2.transport.http.netty.contract.exceptions.ConnectionTimedOutException;
import org.wso2.transport.http.netty.contract.exceptions.EndpointTimeOutException;
import org.wso2.transport.http.netty.contract.exceptions.PromiseRejectedException;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.contract.exceptions.SslException;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpWsConnectorFactory;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.ConnectionManager;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.PoolConfiguration;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;

public class HttpUtil {
    public static final boolean TRUE = true;
    public static final boolean FALSE = false;
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final String METHOD_ACCESSED = "isMethodAccessed";
    private static final String IO_EXCEPTION_OCCURRED = "I/O exception occurred";
    private static final String CHUNKING_CONFIG = "chunking_config";

    public static ObjectValue createNewEntity(ObjectValue httpMessageStruct) {
        ObjectValue entity = ValueCreatorUtils.createEntityObject();
        HttpCarbonMessage httpCarbonMessage = HttpUtil.getCarbonMsg(httpMessageStruct, HttpUtil.createHttpCarbonMessage(HttpUtil.isRequest(httpMessageStruct)));
        entity.addNativeData("entity_headers", (Object)httpCarbonMessage.getHeaders());
        entity.addNativeData("entity_trailer_headers", (Object)httpCarbonMessage.getTrailerHeaders());
        entity.addNativeData("entity_byte_channel", null);
        httpMessageStruct.set(HttpUtil.isRequest(httpMessageStruct) ? "entity" : "entity", (Object)entity);
        httpMessageStruct.addNativeData("is_byte_channel_set", (Object)false);
        return entity;
    }

    public static void setEntity(ObjectValue messageObj, ObjectValue entityObj, boolean isRequest) {
        HttpCarbonMessage httpCarbonMessage = HttpUtil.getCarbonMsg(messageObj, HttpUtil.createHttpCarbonMessage(isRequest));
        String contentType = MimeUtil.getContentTypeWithParameters((ObjectValue)entityObj);
        if (EntityBodyHandler.checkEntityBodyAvailability((ObjectValue)entityObj)) {
            httpCarbonMessage.waitAndReleaseAllEntities();
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            HeaderUtil.setHeaderToEntity((ObjectValue)entityObj, (String)HttpHeaderNames.CONTENT_TYPE.toString(), (String)contentType);
        }
        messageObj.set(isRequest ? "entity" : "entity", (Object)entityObj);
        messageObj.addNativeData("is_byte_channel_set", (Object)EntityBodyHandler.checkEntityBodyAvailability((ObjectValue)entityObj));
    }

    public static ObjectValue getEntity(ObjectValue messageObj, boolean isRequest, boolean entityBodyRequired) {
        ObjectValue entity = (ObjectValue)messageObj.get(isRequest ? "entity" : "entity");
        boolean byteChannelAlreadySet = false;
        if (messageObj.getNativeData("is_byte_channel_set") != null) {
            byteChannelAlreadySet = (Boolean)messageObj.getNativeData("is_byte_channel_set");
        }
        if (entityBodyRequired && !byteChannelAlreadySet) {
            HttpUtil.populateEntityBody(messageObj, entity, isRequest, false);
        }
        return entity;
    }

    public static void populateEntityBody(ObjectValue messageObj, ObjectValue entityObj, boolean request, boolean streaming) {
        HttpCarbonMessage httpCarbonMessage = HttpUtil.getCarbonMsg(messageObj, HttpUtil.createHttpCarbonMessage(request));
        String contentType = httpCarbonMessage.getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
        if (MimeUtil.isNotNullAndEmpty((String)contentType) && contentType.startsWith("multipart/") && !streaming) {
            MultipartDecoder.parseBody((ObjectValue)entityObj, (String)contentType, (InputStream)new HttpMessageDataStreamer(httpCarbonMessage).getInputStream());
        } else {
            long contentLength = MimeUtil.extractContentLength((HttpCarbonMessage)httpCarbonMessage);
            if (contentLength > 0L) {
                if (streaming) {
                    entityObj.addNativeData("entity_byte_channel", (Object)new EntityWrapper(new EntityBodyChannel(new HttpMessageDataStreamer(httpCarbonMessage).getInputStream())));
                } else {
                    entityObj.addNativeData("transport_message", (Object)httpCarbonMessage);
                }
            } else if (HttpHeaderValues.CHUNKED.toString().equals(httpCarbonMessage.getHeader(HttpHeaderNames.TRANSFER_ENCODING.toString()))) {
                entityObj.addNativeData("transport_message", (Object)httpCarbonMessage);
            }
        }
        messageObj.set(request ? "entity" : "entity", (Object)entityObj);
        messageObj.addNativeData("is_byte_channel_set", (Object)true);
    }

    public static ObjectValue extractEntity(ObjectValue request) {
        Object isEntityBodyAvailable = request.getNativeData("is_byte_channel_set");
        if (isEntityBodyAvailable == null || !((Boolean)isEntityBodyAvailable).booleanValue()) {
            return null;
        }
        return (ObjectValue)request.get(HttpUtil.isRequest(request) ? "entity" : "entity");
    }

    public static void closeMessageOutputStream(OutputStream messageOutputStream) {
        try {
            if (messageOutputStream != null) {
                messageOutputStream.close();
            }
        }
        catch (IOException e) {
            log.error("Couldn't close message output stream", (Throwable)e);
        }
    }

    public static void prepareOutboundResponse(ObjectValue connectionObj, HttpCarbonMessage inboundRequestMsg, HttpCarbonMessage outboundResponseMsg, ObjectValue outboundResponseObj) {
        HttpUtil.checkEntityAvailability(outboundResponseObj);
        HttpUtil.addCorsHeaders(inboundRequestMsg, outboundResponseMsg);
        HttpUtil.enrichOutboundMessage(outboundResponseMsg, outboundResponseObj);
        HttpService httpService = (HttpService)connectionObj.getNativeData("HTTP_SERVICE");
        HttpUtil.setCompressionHeaders(httpService.getCompressionConfig(), inboundRequestMsg, outboundResponseMsg);
        HttpUtil.setChunkingHeader(httpService.getChunkingConfig(), outboundResponseMsg);
    }

    private static void addCorsHeaders(HttpCarbonMessage requestMsg, HttpCarbonMessage responseMsg) {
        if (requestMsg.getHeader(HttpHeaderNames.ORIGIN.toString()) != null) {
            CorsHeaderGenerator.process(requestMsg, responseMsg, true);
        }
    }

    public static HttpResponseFuture sendOutboundResponse(HttpCarbonMessage requestMsg, HttpCarbonMessage responseMsg) {
        HttpResponseFuture responseFuture;
        try {
            responseFuture = requestMsg.respond(responseMsg);
        }
        catch (ServerConnectorException e) {
            throw new BallerinaConnectorException("Error occurred during response", (Throwable)e);
        }
        return responseFuture;
    }

    public static HttpResponseFuture pushResponse(HttpCarbonMessage requestMsg, HttpCarbonMessage pushResponse, Http2PushPromise pushPromise) {
        HttpResponseFuture responseFuture;
        try {
            responseFuture = requestMsg.pushResponse(pushResponse, pushPromise);
        }
        catch (ServerConnectorException e) {
            throw new BallerinaConnectorException("Error occurred while sending a server push message", (Throwable)e);
        }
        return responseFuture;
    }

    public static HttpResponseFuture pushPromise(HttpCarbonMessage requestMsg, Http2PushPromise pushPromise) {
        HttpResponseFuture responseFuture;
        try {
            responseFuture = requestMsg.pushPromise(pushPromise);
        }
        catch (ServerConnectorException e) {
            throw new BallerinaConnectorException("Error occurred during response", (Throwable)e);
        }
        return responseFuture;
    }

    public static void handleFailure(HttpCarbonMessage requestMessage, BallerinaConnectorException ex) {
        String errorMsg = ex.getMessage();
        int statusCode = HttpUtil.getStatusCode(requestMessage, errorMsg);
        PipeliningHandler.sendPipelinedResponse(requestMessage, HttpUtil.createErrorMessage(errorMsg, statusCode));
    }

    static void handleFailure(HttpCarbonMessage requestMessage, ErrorValue error) {
        String errorMsg = HttpUtil.getErrorMessage(error);
        int statusCode = HttpUtil.getStatusCode(requestMessage, errorMsg);
        ErrorHandlerUtils.printError((String)("error: " + error.getPrintableStackTrace()));
        PipeliningHandler.sendPipelinedResponse(requestMessage, HttpUtil.createErrorMessage(errorMsg, statusCode));
    }

    private static String getErrorMessage(ErrorValue error) {
        MapValue errorDetails = (MapValue)error.getDetails();
        if (!errorDetails.isEmpty()) {
            return errorDetails.get((Object)"message").toString();
        }
        return error.getReason();
    }

    private static int getStatusCode(HttpCarbonMessage requestMessage, String errorMsg) {
        Integer carbonStatusCode = requestMessage.getHttpStatusCode();
        if (carbonStatusCode == null) {
            log.error(errorMsg);
            return HttpResponseStatus.INTERNAL_SERVER_ERROR.code();
        }
        return carbonStatusCode;
    }

    public static HttpCarbonMessage createErrorMessage(String payload, int statusCode) {
        HttpCarbonMessage response = HttpUtil.createHttpCarbonMessage(false);
        response.waitAndReleaseAllEntities();
        if (payload != null) {
            payload = HttpUtil.lowerCaseTheFirstLetter(payload);
            response.addHttpContent((HttpContent)new DefaultLastHttpContent(Unpooled.wrappedBuffer((byte[])payload.getBytes())));
            response.setHeader("X-Content-Type-Options", "nosniff");
        } else {
            response.addHttpContent((HttpContent)new DefaultLastHttpContent());
        }
        HttpUtil.setHttpStatusCodes(statusCode, response);
        return response;
    }

    private static String lowerCaseTheFirstLetter(String payload) {
        if (!payload.isEmpty()) {
            char[] characters = payload.toCharArray();
            characters[0] = Character.toLowerCase(characters[0]);
            payload = new String(characters);
        }
        return payload;
    }

    private static void setHttpStatusCodes(int statusCode, HttpCarbonMessage response) {
        HttpHeaders httpHeaders = response.getHeaders();
        httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
        response.setHttpStatusCode(Integer.valueOf(statusCode));
    }

    public static ErrorValue getError(String errMsg) {
        MapValue<String, Object> httpErrorRecord = HttpUtil.createHttpErrorDetailRecord(errMsg, null);
        httpErrorRecord.put((Object)"message", (Object)errMsg);
        return BallerinaErrors.createError((String)"{ballerina/http}HTTPError", httpErrorRecord);
    }

    public static ErrorValue getError(Throwable throwable) {
        if (throwable instanceof ClientConnectorException) {
            return HttpUtil.createHttpError(throwable);
        }
        if (throwable.getMessage() == null) {
            return HttpUtil.createHttpError(IO_EXCEPTION_OCCURRED);
        }
        return HttpUtil.createHttpError(throwable.getMessage());
    }

    public static ErrorValue createHttpError(String errorMessage) {
        HttpErrorType errorType = HttpUtil.getErrorType(errorMessage);
        return HttpUtil.createHttpError(errorMessage, errorType);
    }

    public static ErrorValue createHttpError(Throwable throwable) {
        if (throwable instanceof EndpointTimeOutException) {
            return HttpUtil.createHttpError(throwable.getMessage(), HttpErrorType.IDLE_TIMEOUT_TRIGGERED);
        }
        if (throwable instanceof SslException) {
            return HttpUtil.createHttpError(throwable.getMessage(), HttpErrorType.SSL_ERROR);
        }
        if (throwable instanceof PromiseRejectedException) {
            return HttpUtil.createHttpError(throwable.getMessage(), HttpErrorType.HTTP2_CLIENT_ERROR);
        }
        if (throwable instanceof ConnectionTimedOutException) {
            ErrorValue cause = HttpUtil.createErrorCause(throwable.getMessage(), IOConstants.ErrorCode.ConnectionTimedOut.errorCode(), IOConstants.IO_PACKAGE_ID, "Detail");
            return HttpUtil.createHttpError("Something wrong with the connection", HttpErrorType.GENERIC_CLIENT_ERROR, cause);
        }
        if (throwable instanceof ClientConnectorException) {
            ErrorValue cause = HttpUtil.createErrorCause(throwable.getMessage(), IOConstants.ErrorCode.GenericError.errorCode(), IOConstants.IO_PACKAGE_ID, "Detail");
            return HttpUtil.createHttpError("Something wrong with the connection", HttpErrorType.GENERIC_CLIENT_ERROR, cause);
        }
        return HttpUtil.createHttpError(throwable.getMessage(), HttpErrorType.GENERIC_CLIENT_ERROR);
    }

    public static ErrorValue createHttpError(String message, HttpErrorType errorType) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("message", message);
        MapValue detail = BallerinaValues.createRecordValue((BPackage)HttpConstants.PROTOCOL_HTTP_PKG_ID, (String)"Detail", values);
        return BallerinaErrors.createError((String)errorType.getReason(), (MapValue)detail);
    }

    public static ErrorValue createHttpError(String message, HttpErrorType errorType, ErrorValue cause) {
        MapValue<String, Object> detailRecord = HttpUtil.createHttpErrorDetailRecord(message, cause);
        return BallerinaErrors.createError((String)errorType.getReason(), detailRecord);
    }

    private static MapValue<String, Object> createHttpErrorDetailRecord(String message, ErrorValue cause) {
        MapValue detail = BallerinaValues.createRecordValue((BPackage)HttpConstants.PROTOCOL_HTTP_PKG_ID, (String)"Detail");
        return cause == null ? BallerinaValues.createRecord((MapValue)detail, (Object[])new Object[]{message}) : BallerinaValues.createRecord((MapValue)detail, (Object[])new Object[]{message, cause});
    }

    private static HttpErrorType getErrorType(String errorMessage) {
        if (errorMessage.contains("Idle timeout triggered")) {
            return HttpErrorType.IDLE_TIMEOUT_TRIGGERED;
        }
        switch (errorMessage) {
            case "Remote host closed the connection before initiating inbound response": {
                return HttpErrorType.INIT_INBOUND_RESPONSE_FAILED;
            }
            case "Remote host closed the connection while reading inbound response headers": {
                return HttpErrorType.READING_INBOUND_RESPONSE_HEADERS_FAILED;
            }
            case "Remote host closed the connection while reading inbound response body": {
                return HttpErrorType.READING_INBOUND_RESPONSE_BODY_FAILED;
            }
            case "Remote host closed the connection before initiating outbound request": {
                return HttpErrorType.INIT_OUTBOUND_REQUEST_FAILED;
            }
            case "Remote host closed the connection while writing outbound request headers": {
                return HttpErrorType.WRITING_OUTBOUND_REQUEST_HEADER_FAILED;
            }
            case "Remote host closed the connection while writing outbound request entity body": {
                return HttpErrorType.WRITING_OUTBOUND_REQUEST_BODY_FAILED;
            }
            case "Remote client closed the connection before initiating inbound request": {
                return HttpErrorType.INIT_INBOUND_REQUEST_FAILED;
            }
            case "Remote client closed the connection while reading inbound request headers": {
                return HttpErrorType.READING_INBOUND_REQUEST_HEADER_FAILED;
            }
            case "Remote client closed the connection while reading inbound request entity body": {
                return HttpErrorType.READING_INBOUND_REQUEST_BODY_FAILED;
            }
            case "Remote client closed the connection before initiating outbound response": {
                return HttpErrorType.INIT_OUTBOUND_RESPONSE_FAILED;
            }
            case "Remote client closed the connection while writing outbound response headers": {
                return HttpErrorType.WRITING_OUTBOUND_RESPONSE_HEADERS_FAILED;
            }
            case "Remote client closed the connection while writing outbound response entity body": {
                return HttpErrorType.WRITING_OUTBOUND_RESPONSE_BODY_FAILED;
            }
            case "Remote client closed the connection before initiating 100 continue response": {
                return HttpErrorType.INIT_100_CONTINUE_RESPONSE_FAILED;
            }
            case "Remote client closed the connection while writing 100 continue response": {
                return HttpErrorType.WRITING_100_CONTINUE_RESPONSE_FAILED;
            }
            case "Promised stream is already rejected or stream is no longer valid": {
                return HttpErrorType.HTTP2_CLIENT_ERROR;
            }
        }
        return HttpErrorType.GENERIC_CLIENT_ERROR;
    }

    private static ErrorValue createErrorCause(String message, String reason, BPackage packageName, String recordName) {
        MapValue detailRecordType = BallerinaValues.createRecordValue((BPackage)packageName, (String)recordName);
        MapValue detailRecord = BallerinaValues.createRecord((MapValue)detailRecordType, (Object[])new Object[]{message, null});
        return BallerinaErrors.createError((String)reason, (MapValue)detailRecord);
    }

    public static HttpCarbonMessage getCarbonMsg(ObjectValue objectValue, HttpCarbonMessage defaultMsg) {
        HttpCarbonMessage httpCarbonMessage = (HttpCarbonMessage)objectValue.getNativeData("transport_message");
        if (httpCarbonMessage != null) {
            return httpCarbonMessage;
        }
        HttpUtil.addCarbonMsg(objectValue, defaultMsg);
        return defaultMsg;
    }

    public static Http2PushPromise getPushPromise(ObjectValue pushPromiseObj, Http2PushPromise defaultPushPromise) {
        Http2PushPromise pushPromise = (Http2PushPromise)pushPromiseObj.getNativeData("transport_push_promise");
        if (pushPromise != null) {
            return pushPromise;
        }
        pushPromiseObj.addNativeData("transport_push_promise", (Object)defaultPushPromise);
        return defaultPushPromise;
    }

    public static void populatePushPromiseStruct(ObjectValue pushPromiseObj, Http2PushPromise pushPromise) {
        pushPromiseObj.addNativeData("transport_push_promise", (Object)pushPromise);
        pushPromiseObj.set("path", (Object)pushPromise.getPath());
        pushPromiseObj.set("method", (Object)pushPromise.getMethod());
    }

    public static Http2PushPromise createHttpPushPromise(ObjectValue pushPromiseObj) {
        String path;
        String method = pushPromiseObj.get("method").toString();
        if (method == null || method.isEmpty()) {
            method = "GET";
        }
        if ((path = pushPromiseObj.get("path").toString()) == null || path.isEmpty()) {
            path = "/";
        }
        return new Http2PushPromise(method, path);
    }

    public static void addCarbonMsg(ObjectValue struct, HttpCarbonMessage httpCarbonMessage) {
        struct.addNativeData("transport_message", (Object)httpCarbonMessage);
    }

    public static void populateInboundRequest(ObjectValue inboundRequest, ObjectValue entity, HttpCarbonMessage inboundRequestMsg) {
        inboundRequest.addNativeData("transport_message", (Object)inboundRequestMsg);
        inboundRequest.addNativeData("Request", (Object)true);
        MapValue<String, Object> mutualSslRecord = ValueCreatorUtils.createHTTPRecordValue("MutualSslHandshake");
        mutualSslRecord.put((Object)"status", inboundRequestMsg.getProperty("MUTUAL_SSL_HANDSHAKE_RESULT"));
        mutualSslRecord.put((Object)"base64EncodedCert", inboundRequestMsg.getProperty("BASE_64_ENCODED_CERT"));
        inboundRequest.set("mutualSslHandshake", mutualSslRecord);
        HttpUtil.enrichWithInboundRequestInfo(inboundRequest, inboundRequestMsg);
        HttpUtil.enrichWithInboundRequestHeaders(inboundRequest, inboundRequestMsg);
        HttpUtil.populateEntity(entity, inboundRequestMsg);
        inboundRequest.set("entity", (Object)entity);
        inboundRequest.addNativeData("is_byte_channel_set", (Object)false);
        String cacheControlHeader = inboundRequestMsg.getHeader(HttpHeaderNames.CACHE_CONTROL.toString());
        if (cacheControlHeader != null) {
            ObjectValue cacheControlObj = ValueCreatorUtils.createRequestCacheControlObject();
            RequestCacheControlObj requestCacheControl = new RequestCacheControlObj(cacheControlObj);
            requestCacheControl.populateStruct(cacheControlHeader);
            inboundRequest.set("cacheControl", (Object)requestCacheControl.getObj());
        }
    }

    private static void enrichWithInboundRequestHeaders(ObjectValue inboundRequestObj, HttpCarbonMessage inboundRequestMsg) {
        if (inboundRequestMsg.getHeader(HttpHeaderNames.USER_AGENT.toString()) != null) {
            String agent = inboundRequestMsg.getHeader(HttpHeaderNames.USER_AGENT.toString());
            inboundRequestObj.set("userAgent", (Object)agent);
            inboundRequestMsg.removeHeader(HttpHeaderNames.USER_AGENT.toString());
        }
    }

    private static void enrichWithInboundRequestInfo(ObjectValue inboundRequestObj, HttpCarbonMessage inboundRequestMsg) {
        inboundRequestObj.set("rawPath", (Object)inboundRequestMsg.getRequestUrl());
        inboundRequestObj.set("method", (Object)inboundRequestMsg.getHttpMethod());
        inboundRequestObj.set("httpVersion", (Object)inboundRequestMsg.getHttpVersion());
        HttpResourceArguments resourceArgValues = (HttpResourceArguments)inboundRequestMsg.getProperty("RESOURCE_ARGS");
        if (resourceArgValues != null && resourceArgValues.getMap().get("EXTRA_PATH_INFO") != null) {
            inboundRequestObj.set("extraPathInfo", (Object)resourceArgValues.getMap().get("EXTRA_PATH_INFO"));
        }
    }

    public static void enrichHttpCallerWithNativeData(ObjectValue caller, HttpCarbonMessage inboundMsg, MapValue config) {
        caller.addNativeData("transport_message", (Object)inboundMsg);
        caller.set("config", (Object)config);
    }

    public static void enrichHttpCallerWithConnectionInfo(ObjectValue httpCaller, HttpCarbonMessage inboundMsg, HttpResource httpResource, MapValue config) {
        MapValue<String, Object> remote = ValueCreatorUtils.createHTTPRecordValue("Remote");
        MapValue<String, Object> local = ValueCreatorUtils.createHTTPRecordValue("Local");
        Object remoteSocketAddress = inboundMsg.getProperty("REMOTE_ADDRESS");
        if (remoteSocketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteSocketAddress;
            String remoteHost = inetSocketAddress.getHostString();
            long remotePort = inetSocketAddress.getPort();
            remote.put((Object)"host", (Object)remoteHost);
            remote.put((Object)"port", (Object)remotePort);
        }
        httpCaller.set("remoteAddress", remote);
        Object localSocketAddress = inboundMsg.getProperty("LOCAL_ADDRESS");
        if (localSocketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)localSocketAddress;
            String localHost = inetSocketAddress.getHostName();
            long localPort = inetSocketAddress.getPort();
            local.put((Object)"host", (Object)localHost);
            local.put((Object)"port", (Object)localPort);
        }
        httpCaller.set("localAddress", local);
        httpCaller.set("protocol", inboundMsg.getProperty("PROTOCOL"));
        httpCaller.set("config", (Object)config);
        httpCaller.addNativeData("HTTP_SERVICE", (Object)httpResource.getParentService());
        httpCaller.addNativeData("remoteSocketAddress", remoteSocketAddress);
    }

    public static void populateInboundResponse(ObjectValue inboundResponse, ObjectValue entity, HttpCarbonMessage inboundResponseMsg) {
        String cacheControlHeader;
        inboundResponse.addNativeData("transport_message", (Object)inboundResponseMsg);
        int statusCode = inboundResponseMsg.getHttpStatusCode();
        inboundResponse.set("statusCode", (Object)statusCode);
        String reasonPhrase = inboundResponseMsg.getReasonPhrase();
        inboundResponse.set("reasonPhrase", (Object)reasonPhrase);
        if (inboundResponseMsg.getHeader(HttpHeaderNames.SERVER.toString()) != null) {
            inboundResponse.set("server", (Object)inboundResponseMsg.getHeader(HttpHeaderNames.SERVER.toString()));
            inboundResponseMsg.removeHeader(HttpHeaderNames.SERVER.toString());
        }
        if (inboundResponseMsg.getProperty("RESOLVED_REQUESTED_URI") != null) {
            inboundResponse.set("resolvedRequestedURI", (Object)inboundResponseMsg.getProperty("RESOLVED_REQUESTED_URI").toString());
        }
        if ((cacheControlHeader = inboundResponseMsg.getHeader(HttpHeaderNames.CACHE_CONTROL.toString())) != null) {
            ResponseCacheControlObj responseCacheControl = new ResponseCacheControlObj(HttpConstants.PROTOCOL_HTTP_PKG_ID, "ResponseCacheControl");
            responseCacheControl.populateStruct(cacheControlHeader);
            inboundResponse.set("cacheControl", (Object)responseCacheControl.getObj());
        }
        HttpUtil.populateEntity(entity, inboundResponseMsg);
        inboundResponse.set("entity", (Object)entity);
        inboundResponse.addNativeData("is_byte_channel_set", (Object)false);
    }

    private static void populateEntity(ObjectValue entity, HttpCarbonMessage cMsg) {
        long contentLength = -1L;
        String lengthStr = cMsg.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        try {
            contentLength = lengthStr != null ? Long.parseLong(lengthStr) : contentLength;
            MimeUtil.setContentLength((ObjectValue)entity, (long)contentLength);
        }
        catch (NumberFormatException e) {
            throw HttpUtil.createHttpError("Invalid content length", HttpErrorType.INVALID_CONTENT_LENGTH);
        }
        entity.addNativeData("entity_headers", (Object)cMsg.getHeaders());
        entity.addNativeData("entity_trailer_headers", (Object)cMsg.getTrailerHeaders());
    }

    public static void enrichOutboundMessage(HttpCarbonMessage outboundMsg, ObjectValue outboundMsgObj) {
        HttpUtil.setHeadersToTransportMessage(outboundMsg, outboundMsgObj);
        HttpUtil.setPropertiesToTransportMessage(outboundMsg, outboundMsgObj);
    }

    private static void setHeadersToTransportMessage(HttpCarbonMessage outboundMsg, ObjectValue messageObj) {
        HttpHeaders httpHeaders;
        boolean request = HttpUtil.isRequest(messageObj);
        ObjectValue entityObj = (ObjectValue)messageObj.get(request ? "entity" : "entity");
        HttpHeaders transportHeaders = outboundMsg.getHeaders();
        if (request || HttpUtil.isResponse(messageObj)) {
            HttpUtil.addRemovedPropertiesBackToHeadersMap(messageObj, transportHeaders);
        }
        if ((httpHeaders = (HttpHeaders)entityObj.getNativeData("entity_headers")) != transportHeaders) {
            if (httpHeaders != null) {
                transportHeaders.add(httpHeaders);
            }
            entityObj.addNativeData("entity_headers", (Object)outboundMsg.getHeaders());
        }
        if (!request) {
            HttpHeaders transportTrailingHeaders = outboundMsg.getTrailerHeaders();
            HttpHeaders trailingHeaders = (HttpHeaders)entityObj.getNativeData("entity_trailer_headers");
            if (trailingHeaders != null && trailingHeaders != transportTrailingHeaders) {
                transportTrailingHeaders.add(trailingHeaders);
            }
        }
    }

    private static boolean isRequest(ObjectValue value) {
        return value.getType().getName().equals("Request");
    }

    private static boolean isResponse(ObjectValue value) {
        return value.getType().getName().equals("Response");
    }

    private static void addRemovedPropertiesBackToHeadersMap(ObjectValue messageObj, HttpHeaders transportHeaders) {
        if (HttpUtil.isRequest(messageObj)) {
            Object userAgent = messageObj.get("userAgent");
            if (userAgent != null && !userAgent.toString().isEmpty()) {
                transportHeaders.set(HttpHeaderNames.USER_AGENT.toString(), (Object)userAgent.toString());
            }
        } else {
            Object server = messageObj.get("server");
            if (server != null && !server.toString().isEmpty()) {
                transportHeaders.set(HttpHeaderNames.SERVER.toString(), (Object)server.toString());
            }
        }
    }

    private static void setPropertiesToTransportMessage(HttpCarbonMessage outboundResponseMsg, ObjectValue messageObj) {
        if (HttpUtil.isResponse(messageObj)) {
            Object respPhrase;
            long statusCode = (Long)messageObj.get("statusCode");
            if (statusCode != 0L) {
                outboundResponseMsg.setHttpStatusCode(Integer.valueOf(HttpUtil.getIntValue(statusCode)));
            }
            if ((respPhrase = messageObj.get("reasonPhrase")) != null && !respPhrase.toString().isEmpty()) {
                outboundResponseMsg.setProperty("HTTP_REASON_PHRASE", (Object)respPhrase.toString());
            }
        }
    }

    public static void checkEntityAvailability(ObjectValue value) {
        ObjectValue entity = (ObjectValue)value.get(HttpUtil.isRequest(value) ? "entity" : "entity");
        if (entity == null) {
            HttpUtil.createNewEntity(value);
        }
    }

    public static Boolean checkRequestBodySizeHeadersAvailability(HttpCarbonMessage message) {
        String contentLength = message.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        String transferEncoding = message.getHeader(HttpHeaderNames.TRANSFER_ENCODING.toString());
        return contentLength != null || transferEncoding != null;
    }

    public static boolean isEntityDataSourceAvailable(ObjectValue value) {
        ObjectValue entityObj = (ObjectValue)value.get(HttpUtil.isRequest(value) ? "entity" : "entity");
        return entityObj != null && EntityBodyHandler.getMessageDataSource((ObjectValue)entityObj) != null;
    }

    private static void setCompressionHeaders(MapValue<String, Object> compressionConfig, HttpCarbonMessage requestMsg, HttpCarbonMessage outboundResponseMsg) {
        if (!HttpUtil.checkConfigAnnotationAvailability(compressionConfig)) {
            return;
        }
        String contentEncoding = outboundResponseMsg.getHeaders().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
        if (contentEncoding != null) {
            return;
        }
        CompressionConfigState compressionState = HttpUtil.getCompressionState(compressionConfig.getStringValue("enable"));
        if (compressionState == CompressionConfigState.NEVER) {
            outboundResponseMsg.getHeaders().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)"identity");
            return;
        }
        String acceptEncodingValue = requestMsg.getHeaders().get((CharSequence)HttpHeaderNames.ACCEPT_ENCODING);
        List<String> contentTypesAnnotationValues = HttpUtil.getAsStringList(compressionConfig.getArrayValue("contentTypes").getStringArray());
        String contentType = outboundResponseMsg.getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
        if (contentTypesAnnotationValues.isEmpty() || HttpUtil.isContentTypeMatched(contentTypesAnnotationValues, contentType)) {
            if (compressionState == CompressionConfigState.ALWAYS && (acceptEncodingValue == null || "identity".equals(acceptEncodingValue))) {
                outboundResponseMsg.getHeaders().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)"gzip");
            }
        } else {
            outboundResponseMsg.getHeaders().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)"identity");
        }
    }

    public static CompressionConfigState getCompressionState(String compressionState) {
        switch (compressionState) {
            case "AUTO": {
                return CompressionConfigState.AUTO;
            }
            case "ALWAYS": {
                return CompressionConfigState.ALWAYS;
            }
            case "NEVER": {
                return CompressionConfigState.NEVER;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isContentTypeMatched(List<String> contentTypes, String contentType) {
        if (contentType == null) return false;
        if (!contentTypes.stream().anyMatch(contentType.toLowerCase()::contains)) return false;
        return true;
    }

    private static List<String> getAsStringList(Object[] values) {
        ArrayList<String> valuesList = new ArrayList<String>();
        if (values == null) {
            return valuesList;
        }
        for (Object val : values) {
            valuesList.add(val.toString().trim().toLowerCase());
        }
        return valuesList;
    }

    public static String getListenerInterface(String host, int port) {
        host = host != null ? host : "0.0.0.0";
        return host + ":" + port;
    }

    public static ChunkConfig getChunkConfig(String chunkConfig) {
        switch (chunkConfig) {
            case "AUTO": {
                return ChunkConfig.AUTO;
            }
            case "ALWAYS": {
                return ChunkConfig.ALWAYS;
            }
            case "NEVER": {
                return ChunkConfig.NEVER;
            }
        }
        throw new BallerinaConnectorException("Invalid configuration found for Transfer-Encoding: " + chunkConfig);
    }

    public static KeepAliveConfig getKeepAliveConfig(String keepAliveConfig) {
        switch (keepAliveConfig) {
            case "AUTO": {
                return KeepAliveConfig.AUTO;
            }
            case "ALWAYS": {
                return KeepAliveConfig.ALWAYS;
            }
            case "NEVER": {
                return KeepAliveConfig.NEVER;
            }
        }
        throw new BallerinaConnectorException("Invalid configuration found for Keep-Alive: " + keepAliveConfig);
    }

    public static ForwardedExtensionConfig getForwardedExtensionConfig(String forwarded) {
        ForwardedExtensionConfig forwardedConfig;
        if ("enable".equalsIgnoreCase(forwarded)) {
            forwardedConfig = ForwardedExtensionConfig.ENABLE;
        } else if ("transition".equalsIgnoreCase(forwarded)) {
            forwardedConfig = ForwardedExtensionConfig.TRANSITION;
        } else if ("disable".equalsIgnoreCase(forwarded)) {
            forwardedConfig = ForwardedExtensionConfig.DISABLE;
        } else {
            throw new BallerinaConnectorException("Invalid configuration found for Forwarded : " + forwarded);
        }
        return forwardedConfig;
    }

    public static HttpCarbonMessage createHttpCarbonMessage(boolean isRequest) {
        HttpCarbonMessage httpCarbonMessage = isRequest ? new HttpCarbonMessage((HttpMessage)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "")) : new HttpCarbonMessage((HttpMessage)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK));
        httpCarbonMessage.completeMessage();
        return httpCarbonMessage;
    }

    public static void checkFunctionValidity(ObjectValue connectionObj, HttpCarbonMessage reqMsg, HttpCarbonMessage outboundResponseMsg) {
        HttpUtil.serverConnectionStructCheck(reqMsg);
        int statusCode = outboundResponseMsg.getHttpStatusCode();
        HttpUtil.methodInvocationCheck(connectionObj, reqMsg, statusCode);
    }

    private static void methodInvocationCheck(ObjectValue connectionObj, HttpCarbonMessage reqMsg, int statusCode) {
        if (connectionObj.getNativeData(METHOD_ACCESSED) != null || reqMsg == null) {
            throw new IllegalStateException("illegal function invocation");
        }
        if (!HttpUtil.is100ContinueRequest(reqMsg, statusCode)) {
            connectionObj.addNativeData(METHOD_ACCESSED, (Object)true);
        }
    }

    public static void serverConnectionStructCheck(HttpCarbonMessage reqMsg) {
        if (reqMsg == null) {
            throw HttpUtil.createHttpError("operation not allowed:invalid Connection variable", HttpErrorType.GENERIC_LISTENER_ERROR);
        }
    }

    private static boolean is100ContinueRequest(HttpCarbonMessage reqMsg, int statusCode) {
        return "100-continue".equalsIgnoreCase(reqMsg.getHeader(HttpHeaderNames.EXPECT.toString())) || statusCode == 100;
    }

    public static MapValue getTransactionConfigAnnotation(AttachedFunction resource, String transactionPackagePath) {
        return (MapValue)resource.getAnnotation(transactionPackagePath, "Participant");
    }

    private static int getIntValue(long val) {
        int intVal = (int)val;
        if ((long)intVal != val) {
            throw new IllegalArgumentException("invalid argument: " + val);
        }
        return intVal;
    }

    public static String getContentTypeFromTransportMessage(HttpCarbonMessage transportMessage) {
        return transportMessage.getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
    }

    public static String addBoundaryIfNotExist(HttpCarbonMessage transportMessage, String contentType) {
        String boundaryValue = HeaderUtil.extractBoundaryParameter((String)contentType);
        if (boundaryValue != null) {
            boundaryValue = HttpUtil.sanitizeBoundary(boundaryValue);
            boolean validateContentType = MimeUtil.isValidateContentType((String)contentType);
            if (!validateContentType) {
                String headerValue = HeaderUtil.getHeaderValue((String)contentType);
                MapValue paramMap = HeaderUtil.getParamMap((String)contentType);
                paramMap.put((Object)"boundary", (Object)MimeUtil.includeQuotes((String)boundaryValue));
                contentType = HeaderUtil.appendHeaderParams((StringBuilder)new StringBuilder(headerValue).append(";"), (MapValue)paramMap);
                transportMessage.setHeader(String.valueOf(HttpHeaderNames.CONTENT_TYPE), contentType);
            }
            return boundaryValue;
        }
        return HttpUtil.addBoundaryParameter(transportMessage, contentType);
    }

    private static String addBoundaryParameter(HttpCarbonMessage transportMessage, String contentType) {
        String boundaryString = null;
        if (contentType != null && contentType.startsWith("multipart/")) {
            boundaryString = MimeUtil.getNewMultipartDelimiter();
            transportMessage.setHeader(HttpHeaderNames.CONTENT_TYPE.toString(), contentType + "; " + "boundary" + "=" + boundaryString);
        }
        return boundaryString;
    }

    private static String sanitizeBoundary(String boundaryString) {
        return boundaryString.replaceAll("^\"|\"$", "");
    }

    public static HttpWsConnectorFactory createHttpWsConnectionFactory() {
        return new DefaultHttpWsConnectorFactory();
    }

    public static void checkAndObserveHttpRequest(Strand strand, HttpCarbonMessage message) {
        Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Strand)strand);
        observerContext.ifPresent(ctx -> {
            HttpUtil.injectHeaders(message, ObserveUtils.getContextProperties((ObserverContext)strand.observerContext));
            strand.observerContext.addTag("http.method", message.getHttpMethod());
            if (!ConfigRegistry.getInstance().getAsBoolean("b7a.observability.metrics.client.http.url.disabled")) {
                strand.observerContext.addTag("http.url", String.valueOf(message.getProperty("TO")));
            }
            strand.observerContext.addTag("peer.address", message.getProperty("host") + ":" + message.getProperty("port"));
            strand.observerContext.addTag("http.status_code", Integer.toString(0));
        });
    }

    public static void injectHeaders(HttpCarbonMessage msg, Map<String, String> headers) {
        if (headers != null) {
            headers.forEach((key, value) -> msg.setHeader(key, String.valueOf(value)));
        }
    }

    private static void setChunkingHeader(String transferValue, HttpCarbonMessage outboundResponseMsg) {
        if (transferValue == null) {
            return;
        }
        outboundResponseMsg.setProperty(CHUNKING_CONFIG, (Object)HttpUtil.getChunkConfig(transferValue));
    }

    public static ObjectValue createResponseStruct(HttpCarbonMessage httpCarbonMessage) {
        ObjectValue responseObj = ValueCreatorUtils.createResponseObject();
        ObjectValue entity = ValueCreatorUtils.createEntityObject();
        HttpUtil.populateInboundResponse(responseObj, entity, httpCarbonMessage);
        return responseObj;
    }

    public static void populateSenderConfigurations(SenderConfiguration senderConfiguration, MapValue<String, Object> clientEndpointConfig, String scheme) {
        long timeoutMillis;
        MapValue http1Settings;
        MapValue proxy;
        MapValue secureSocket = clientEndpointConfig.getMapValue("secureSocket");
        String httpVersion = clientEndpointConfig.getStringValue("httpVersion");
        if (secureSocket != null) {
            HttpUtil.populateSSLConfiguration((SslConfiguration)senderConfiguration, secureSocket);
        } else if (scheme.equals("https")) {
            if (httpVersion.equals("2.0")) {
                throw HttpUtil.createHttpError("To enable https you need to configure secureSocket record", HttpErrorType.SSL_ERROR);
            }
            senderConfiguration.useJavaDefaults();
        }
        if ("1.1".equals(httpVersion) && (proxy = (http1Settings = (MapValue)clientEndpointConfig.get((Object)"http1Settings")).getMapValue("proxy")) != null) {
            ProxyServerConfiguration proxyServerConfiguration;
            String proxyHost = proxy.getStringValue("host");
            int proxyPort = proxy.getIntValue("port").intValue();
            String proxyUserName = proxy.getStringValue("userName");
            String proxyPassword = proxy.getStringValue("password");
            try {
                proxyServerConfiguration = new ProxyServerConfiguration(proxyHost, proxyPort);
            }
            catch (UnknownHostException e) {
                throw new BallerinaConnectorException("Failed to resolve host" + proxyHost, (Throwable)e);
            }
            if (!proxyUserName.isEmpty()) {
                proxyServerConfiguration.setProxyUsername(proxyUserName);
            }
            if (!proxyPassword.isEmpty()) {
                proxyServerConfiguration.setProxyPassword(proxyPassword);
            }
            senderConfiguration.setProxyServerConfiguration(proxyServerConfiguration);
        }
        if ((timeoutMillis = clientEndpointConfig.getIntValue("timeoutInMillis").longValue()) < 0L) {
            senderConfiguration.setSocketIdleTimeout(0);
        } else {
            senderConfiguration.setSocketIdleTimeout(HttpUtil.validateConfig(timeoutMillis, "timeoutInMillis"));
        }
        if (httpVersion != null) {
            senderConfiguration.setHttpVersion(httpVersion);
        }
        String forwardedExtension = clientEndpointConfig.getStringValue("forwarded");
        senderConfiguration.setForwardedExtensionConfig(HttpUtil.getForwardedExtensionConfig(forwardedExtension));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionManager getConnectionManager(MapValue<String, Long> poolStruct) {
        ConnectionManager poolManager = (ConnectionManager)poolStruct.getNativeData("ConnectionManager");
        if (poolManager == null) {
            MapValue<String, Long> mapValue = poolStruct;
            synchronized (mapValue) {
                if (poolStruct.getNativeData("ConnectionManager") == null) {
                    PoolConfiguration userDefinedPool = new PoolConfiguration();
                    HttpUtil.populatePoolingConfig(poolStruct, userDefinedPool);
                    poolManager = new ConnectionManager(userDefinedPool);
                    poolStruct.addNativeData("ConnectionManager", (Object)poolManager);
                }
            }
        }
        return poolManager;
    }

    public static void populatePoolingConfig(MapValue<String, Long> poolRecord, PoolConfiguration poolConfiguration) {
        long maxActiveConnections = (Long)poolRecord.get((Object)"maxActiveConnections");
        poolConfiguration.setMaxActivePerPool(HttpUtil.validateConfig(maxActiveConnections, "maxActiveConnections"));
        long maxIdleConnections = (Long)poolRecord.get((Object)"maxIdleConnections");
        poolConfiguration.setMaxIdlePerPool(HttpUtil.validateConfig(maxIdleConnections, "maxIdleConnections"));
        long waitTime = (Long)poolRecord.get((Object)"waitTimeInMillis");
        poolConfiguration.setMaxWaitTime(waitTime);
        long maxActiveStreamsPerConnection = (Long)poolRecord.get((Object)"maxActiveStreamsPerConnection");
        poolConfiguration.setHttp2MaxActiveStreamsPerConnection(maxActiveStreamsPerConnection == -1L ? Integer.MAX_VALUE : HttpUtil.validateConfig(maxActiveStreamsPerConnection, "maxActiveStreamsPerConnection"));
    }

    private static int validateConfig(long value, String configName) {
        try {
            return Math.toIntExact(value);
        }
        catch (ArithmeticException e) {
            log.warn("The value set for the configuration needs to be less than {}. The " + configName + "value is set to {}", (Object)Integer.MAX_VALUE);
            return Integer.MAX_VALUE;
        }
    }

    public static void populateSSLConfiguration(SslConfiguration sslConfiguration, MapValue secureSocket) {
        List<String> ciphersValueList;
        MapValue trustStore = secureSocket.getMapValue("trustStore");
        MapValue keyStore = secureSocket.getMapValue("keyStore");
        MapValue protocols = secureSocket.getMapValue("protocol");
        MapValue validateCert = secureSocket.getMapValue("certValidation");
        String keyFile = secureSocket.getStringValue("keyFile");
        String certFile = secureSocket.getStringValue("certFile");
        String trustCerts = secureSocket.getStringValue("trustedCertFile");
        String keyPassword = secureSocket.getStringValue("keyPassword");
        boolean disableSslValidation = secureSocket.getBooleanValue("disable");
        ArrayList<Parameter> clientParams = new ArrayList<Parameter>();
        if (disableSslValidation) {
            sslConfiguration.disableSsl();
            return;
        }
        if (StringUtils.isEmpty((CharSequence)trustCerts) && trustStore == null) {
            sslConfiguration.useJavaDefaults();
            return;
        }
        if (trustStore != null && StringUtils.isNotBlank((CharSequence)trustCerts)) {
            throw HttpUtil.createHttpError("Cannot configure both trustStore and trustCerts at the same time.", HttpErrorType.SSL_ERROR);
        }
        if (trustStore != null) {
            String trustStorePassword;
            String trustStoreFile = trustStore.getStringValue("path");
            if (StringUtils.isNotBlank((CharSequence)trustStoreFile)) {
                sslConfiguration.setTrustStoreFile(trustStoreFile);
            }
            if (StringUtils.isNotBlank((CharSequence)(trustStorePassword = trustStore.getStringValue("password")))) {
                sslConfiguration.setTrustStorePass(trustStorePassword);
            }
        } else if (StringUtils.isNotBlank((CharSequence)trustCerts)) {
            sslConfiguration.setClientTrustCertificates(trustCerts);
        }
        if (keyStore != null && StringUtils.isNotBlank((CharSequence)keyFile)) {
            throw HttpUtil.createHttpError("Cannot configure both keyStore and keyFile.", HttpErrorType.SSL_ERROR);
        }
        if (StringUtils.isNotBlank((CharSequence)keyFile) && StringUtils.isBlank((CharSequence)certFile)) {
            throw HttpUtil.createHttpError("Need to configure certFile containing client ssl certificates.", HttpErrorType.SSL_ERROR);
        }
        if (keyStore != null) {
            String keyStorePassword;
            String keyStoreFile = keyStore.getStringValue("path");
            if (StringUtils.isNotBlank((CharSequence)keyStoreFile)) {
                sslConfiguration.setKeyStoreFile(keyStoreFile);
            }
            if (StringUtils.isNotBlank((CharSequence)(keyStorePassword = keyStore.getStringValue("password")))) {
                sslConfiguration.setKeyStorePass(keyStorePassword);
            }
        } else if (StringUtils.isNotBlank((CharSequence)keyFile)) {
            sslConfiguration.setClientKeyFile(keyFile);
            sslConfiguration.setClientCertificates(certFile);
            if (StringUtils.isNotBlank((CharSequence)keyPassword)) {
                sslConfiguration.setClientKeyPassword(keyPassword);
            }
        }
        if (protocols != null) {
            String sslProtocol;
            List<String> sslEnabledProtocolsValueList = Arrays.asList(protocols.getArrayValue("versions").getStringArray());
            if (!sslEnabledProtocolsValueList.isEmpty()) {
                String sslEnabledProtocols = sslEnabledProtocolsValueList.stream().collect(Collectors.joining(",", "", ""));
                Parameter clientProtocols = new Parameter("sslEnabledProtocols", sslEnabledProtocols);
                clientParams.add(clientProtocols);
            }
            if (StringUtils.isNotBlank((CharSequence)(sslProtocol = protocols.getStringValue("name")))) {
                sslConfiguration.setSSLProtocol(sslProtocol);
            }
        }
        if (validateCert != null) {
            boolean validateCertEnabled = validateCert.getBooleanValue("enable");
            int cacheSize = validateCert.getIntValue("cacheSize").intValue();
            int cacheValidityPeriod = validateCert.getIntValue("cacheValidityPeriod").intValue();
            sslConfiguration.setValidateCertEnabled(validateCertEnabled);
            if (cacheValidityPeriod != 0) {
                sslConfiguration.setCacheValidityPeriod(cacheValidityPeriod);
            }
            if (cacheSize != 0) {
                sslConfiguration.setCacheSize(cacheSize);
            }
        }
        boolean hostNameVerificationEnabled = secureSocket.getBooleanValue("verifyHostname");
        boolean ocspStaplingEnabled = secureSocket.getBooleanValue("ocspStapling");
        sslConfiguration.setOcspStaplingEnabled(ocspStaplingEnabled);
        sslConfiguration.setHostNameVerificationEnabled(hostNameVerificationEnabled);
        sslConfiguration.setSslSessionTimeOut((int)secureSocket.getDefaultableIntValue("sessionTimeoutInSeconds"));
        sslConfiguration.setSslHandshakeTimeOut(secureSocket.getDefaultableIntValue("handshakeTimeoutInSeconds"));
        String[] cipherConfigs = secureSocket.getArrayValue("ciphers").getStringArray();
        if (cipherConfigs != null && (ciphersValueList = Arrays.asList(cipherConfigs)).size() > 0) {
            String ciphers = ciphersValueList.stream().map(Object::toString).collect(Collectors.joining(",", "", ""));
            Parameter clientCiphers = new Parameter("ciphers", ciphers);
            clientParams.add(clientCiphers);
        }
        String enableSessionCreation = String.valueOf(secureSocket.getBooleanValue("shareSession"));
        Parameter clientEnableSessionCreation = new Parameter("shareSession", enableSessionCreation);
        clientParams.add(clientEnableSessionCreation);
        if (!clientParams.isEmpty()) {
            sslConfiguration.setParameters(clientParams);
        }
    }

    public static String sanitizeBasePath(String basePath) {
        if (!(basePath = basePath.trim()).startsWith("/")) {
            basePath = "/".concat(basePath);
        }
        if (basePath.endsWith("/") && basePath.length() != 1) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        if (basePath.endsWith("*")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        return basePath;
    }

    public static void serializeDataSource(Object outboundMessageSource, ObjectValue entity, OutputStream messageOutputStream) throws IOException {
        if (MimeUtil.generateAsJSON((Object)outboundMessageSource, (ObjectValue)entity)) {
            JSONGenerator gen = new JSONGenerator(messageOutputStream);
            gen.serialize(outboundMessageSource);
            gen.flush();
        } else {
            HttpUtil.serialize(outboundMessageSource, messageOutputStream);
        }
    }

    public static void serialize(Object value, OutputStream outputStream) throws IOException {
        if (value == null) {
            throw HttpUtil.createHttpError("error occurred while serializing null data");
        }
        if (value instanceof ArrayValue) {
            if (value instanceof StreamingJsonValue) {
                ((StreamingJsonValue)value).serialize(outputStream);
            } else {
                ((ArrayValue)value).serialize(outputStream);
            }
        } else if (value instanceof MultipartDataSource) {
            ((MultipartDataSource)value).serialize(outputStream);
        } else if (value instanceof XMLItem) {
            ((XMLItem)value).serialize(outputStream);
        } else if (value instanceof XMLSequence) {
            ((XMLSequence)value).serialize(outputStream);
        } else if (value instanceof Long || value instanceof String || value instanceof Double || value instanceof Integer || value instanceof Boolean) {
            outputStream.write(value.toString().getBytes(Charset.defaultCharset()));
        } else {
            ((RefValue)value).serialize(outputStream);
        }
    }

    public static boolean checkConfigAnnotationAvailability(MapValue configAnnotation) {
        return configAnnotation != null;
    }

    public static ListenerConfiguration getListenerConfig(long port, MapValue endpointConfig) {
        String host = endpointConfig.getStringValue("host");
        MapValue sslConfig = endpointConfig.getMapValue("secureSocket");
        String httpVersion = endpointConfig.getStringValue("httpVersion");
        long idleTimeout = endpointConfig.getIntValue("timeoutInMillis");
        ListenerConfiguration listenerConfiguration = new ListenerConfiguration();
        if ("1.1".equals(httpVersion)) {
            MapValue http1Settings = (MapValue)endpointConfig.get((Object)"http1Settings");
            listenerConfiguration.setPipeliningLimit(http1Settings.getIntValue("maxPipelinedRequests").longValue());
            String keepAlive = http1Settings.getStringValue("keepAlive");
            listenerConfiguration.setKeepAliveConfig(HttpUtil.getKeepAliveConfig(keepAlive));
        }
        MapValue requestLimits = endpointConfig.getMapValue("requestLimits");
        HttpUtil.setInboundMgsSizeValidationConfig(requestLimits.getIntValue("maxUriLength"), requestLimits.getIntValue("maxHeaderSize"), requestLimits.getIntValue("maxEntityBodySize"), listenerConfiguration.getMsgSizeValidationConfig());
        if (host == null || host.trim().isEmpty()) {
            listenerConfiguration.setHost(ConfigRegistry.getInstance().getConfigOrDefault("b7a.http.host", "0.0.0.0"));
        } else {
            listenerConfiguration.setHost(host);
        }
        if (port == 0L) {
            throw new BallerinaConnectorException("Listener port is not defined!");
        }
        listenerConfiguration.setPort(Math.toIntExact(port));
        if (idleTimeout < 0L) {
            throw new BallerinaConnectorException("Idle timeout cannot be negative. If you want to disable the timeout please use value 0");
        }
        listenerConfiguration.setSocketIdleTimeout(Math.toIntExact(idleTimeout));
        if (httpVersion != null) {
            listenerConfiguration.setVersion(httpVersion);
        }
        if (endpointConfig.getType().getName().equalsIgnoreCase("ListenerConfiguration")) {
            String serverName = endpointConfig.getStringValue("server");
            listenerConfiguration.setServerHeader(serverName != null ? serverName : HttpUtil.getServerName());
        } else {
            listenerConfiguration.setServerHeader(HttpUtil.getServerName());
        }
        if (sslConfig != null) {
            return HttpUtil.setSslConfig(sslConfig, listenerConfiguration);
        }
        listenerConfiguration.setPipeliningEnabled(true);
        Object webSocketCompressionEnabled = endpointConfig.get((Object)"webSocketCompressionEnabled");
        if (webSocketCompressionEnabled != null) {
            listenerConfiguration.setWebSocketCompressionEnabled(((Boolean)webSocketCompressionEnabled).booleanValue());
        }
        return listenerConfiguration;
    }

    public static void setInboundMgsSizeValidationConfig(long maxInitialLineLength, long maxHeaderSize, long maxEntityBodySize, InboundMsgSizeValidationConfig sizeValidationConfig) {
        if (maxInitialLineLength < 0L) {
            throw new BallerinaConnectorException("Invalid configuration found for max initial line length : " + maxInitialLineLength);
        }
        sizeValidationConfig.setMaxInitialLineLength(Math.toIntExact(maxInitialLineLength));
        if (maxHeaderSize < 0L) {
            throw new BallerinaConnectorException("Invalid configuration found for maxHeaderSize : " + maxHeaderSize);
        }
        sizeValidationConfig.setMaxHeaderSize(Math.toIntExact(maxHeaderSize));
        if (maxEntityBodySize != -1L) {
            if (maxEntityBodySize >= 0L) {
                sizeValidationConfig.setMaxEntityBodySize(maxEntityBodySize);
            } else {
                throw new BallerinaConnectorException("Invalid configuration found for maxEntityBodySize : " + maxEntityBodySize);
            }
        }
    }

    private static String getServerName() {
        String version = System.getProperty("ballerina.version");
        String userAgent = version != null ? "ballerina/" + version : "ballerina";
        return userAgent;
    }

    private static ListenerConfiguration setSslConfig(MapValue sslConfig, ListenerConfiguration listenerConfiguration) {
        long cacheValidationPeriod;
        long cacheSize;
        List<String> ciphersValueList;
        Parameter serverParameters;
        listenerConfiguration.setScheme("https");
        MapValue trustStore = sslConfig.getMapValue("trustStore");
        MapValue keyStore = sslConfig.getMapValue("keyStore");
        MapValue protocols = sslConfig.getMapValue("protocol");
        MapValue validateCert = sslConfig.getMapValue("certValidation");
        MapValue ocspStapling = sslConfig.getMapValue("ocspStapling");
        String keyFile = sslConfig.getStringValue("keyFile");
        String certFile = sslConfig.getStringValue("certFile");
        String trustCerts = sslConfig.getStringValue("trustedCertFile");
        String keyPassword = sslConfig.getStringValue("keyPassword");
        if (keyStore != null && StringUtils.isNotBlank((CharSequence)keyFile)) {
            throw HttpUtil.createHttpError("Cannot configure both keyStore and keyFile at the same time.", HttpErrorType.SSL_ERROR);
        }
        if (keyStore == null && (StringUtils.isBlank((CharSequence)keyFile) || StringUtils.isBlank((CharSequence)certFile))) {
            throw HttpUtil.createHttpError("Either keystore or certificateKey and server certificates must be provided for secure connection", HttpErrorType.SSL_ERROR);
        }
        if (keyStore != null) {
            String keyStoreFile = keyStore.getStringValue("path");
            if (StringUtils.isBlank((CharSequence)keyStoreFile)) {
                throw HttpUtil.createHttpError("Keystore file location must be provided for secure connection.", HttpErrorType.SSL_ERROR);
            }
            String keyStorePassword = keyStore.getStringValue("password");
            if (StringUtils.isBlank((CharSequence)keyStorePassword)) {
                throw HttpUtil.createHttpError("Keystore password must be provided for secure connection", HttpErrorType.SSL_ERROR);
            }
            listenerConfiguration.setKeyStoreFile(keyStoreFile);
            listenerConfiguration.setKeyStorePass(keyStorePassword);
        } else {
            listenerConfiguration.setServerKeyFile(keyFile);
            listenerConfiguration.setServerCertificates(certFile);
            if (StringUtils.isNotBlank((CharSequence)keyPassword)) {
                listenerConfiguration.setServerKeyPassword(keyPassword);
            }
        }
        String sslVerifyClient = sslConfig.getStringValue("sslVerifyClient");
        listenerConfiguration.setVerifyClient(sslVerifyClient);
        listenerConfiguration.setSslSessionTimeOut((int)sslConfig.getDefaultableIntValue("sessionTimeoutInSeconds"));
        listenerConfiguration.setSslHandshakeTimeOut(sslConfig.getDefaultableIntValue("handshakeTimeoutInSeconds"));
        if (trustStore == null && StringUtils.isNotBlank((CharSequence)sslVerifyClient) && StringUtils.isBlank((CharSequence)trustCerts)) {
            throw HttpUtil.createHttpError("Truststore location or trustCertificates must be provided to enable Mutual SSL", HttpErrorType.SSL_ERROR);
        }
        if (trustStore != null) {
            String trustStoreFile = trustStore.getStringValue("path");
            String trustStorePassword = trustStore.getStringValue("password");
            if (StringUtils.isBlank((CharSequence)trustStoreFile) && StringUtils.isNotBlank((CharSequence)sslVerifyClient)) {
                throw HttpUtil.createHttpError("Truststore location must be provided to enable Mutual SSL", HttpErrorType.SSL_ERROR);
            }
            if (StringUtils.isBlank((CharSequence)trustStorePassword) && StringUtils.isNotBlank((CharSequence)sslVerifyClient)) {
                throw HttpUtil.createHttpError("Truststore password value must be provided to enable Mutual SSL", HttpErrorType.SSL_ERROR);
            }
            listenerConfiguration.setTrustStoreFile(trustStoreFile);
            listenerConfiguration.setTrustStorePass(trustStorePassword);
        } else if (StringUtils.isNotBlank((CharSequence)trustCerts)) {
            listenerConfiguration.setServerTrustCertificates(trustCerts);
        }
        ArrayList<Parameter> serverParamList = new ArrayList<Parameter>();
        if (protocols != null) {
            String sslProtocol;
            List<String> sslEnabledProtocolsValueList = Arrays.asList(protocols.getArrayValue("versions").getStringArray());
            if (!sslEnabledProtocolsValueList.isEmpty()) {
                String sslEnabledProtocols = sslEnabledProtocolsValueList.stream().collect(Collectors.joining(",", "", ""));
                serverParameters = new Parameter("sslEnabledProtocols", sslEnabledProtocols);
                serverParamList.add(serverParameters);
            }
            if (StringUtils.isNotBlank((CharSequence)(sslProtocol = protocols.getStringValue("name")))) {
                listenerConfiguration.setSSLProtocol(sslProtocol);
            }
        }
        if (!(ciphersValueList = Arrays.asList(sslConfig.getArrayValue("ciphers").getStringArray())).isEmpty()) {
            String ciphers = ciphersValueList.stream().collect(Collectors.joining(",", "", ""));
            serverParameters = new Parameter("ciphers", ciphers);
            serverParamList.add(serverParameters);
        }
        if (validateCert != null) {
            boolean validateCertificateEnabled = validateCert.getBooleanValue("enable");
            cacheSize = validateCert.getIntValue("cacheSize");
            cacheValidationPeriod = validateCert.getIntValue("cacheValidityPeriod");
            listenerConfiguration.setValidateCertEnabled(validateCertificateEnabled);
            if (validateCertificateEnabled) {
                if (cacheSize != 0L) {
                    listenerConfiguration.setCacheSize(Math.toIntExact(cacheSize));
                }
                if (cacheValidationPeriod != 0L) {
                    listenerConfiguration.setCacheValidityPeriod(Math.toIntExact(cacheValidationPeriod));
                }
            }
        }
        if (ocspStapling != null) {
            boolean ocspStaplingEnabled = ocspStapling.getBooleanValue("enable");
            listenerConfiguration.setOcspStaplingEnabled(ocspStaplingEnabled);
            cacheSize = ocspStapling.getIntValue("cacheSize");
            cacheValidationPeriod = ocspStapling.getIntValue("cacheValidityPeriod");
            listenerConfiguration.setValidateCertEnabled(ocspStaplingEnabled);
            if (ocspStaplingEnabled) {
                if (cacheSize != 0L) {
                    listenerConfiguration.setCacheSize(Math.toIntExact(cacheSize));
                }
                if (cacheValidationPeriod != 0L) {
                    listenerConfiguration.setCacheValidityPeriod(Math.toIntExact(cacheValidationPeriod));
                }
            }
        }
        listenerConfiguration.setTLSStoreType("PKCS12");
        String serverEnableSessionCreation = String.valueOf(sslConfig.getBooleanValue("shareSession"));
        Parameter enableSessionCreationParam = new Parameter("shareSession", serverEnableSessionCreation);
        serverParamList.add(enableSessionCreationParam);
        if (!serverParamList.isEmpty()) {
            listenerConfiguration.setParameters(serverParamList);
        }
        listenerConfiguration.setId(HttpUtil.getListenerInterface(listenerConfiguration.getHost(), listenerConfiguration.getPort()));
        return listenerConfiguration;
    }

    public static String getServiceName(ObjectValue balService) {
        String serviceTypeName = balService.getType().getName();
        int serviceIndex = serviceTypeName.lastIndexOf("$$service$");
        return serviceTypeName.substring(0, serviceIndex);
    }

    public static ErrorValue createHttpError(String reason, String errorName, String reasonType, String errorMsg) {
        BType detailType = BValueCreator.createRecordValue((BPackage)new BPackage("ballerina", "http"), (String)"Detail").getType();
        int mask = TypeFlags.asMask((int[])new int[]{2, 4});
        HashSet<String> valueSpace = new HashSet<String>();
        valueSpace.add(reason);
        return BallerinaErrors.createError((BType)new BErrorType(errorName, new BPackage("ballerina", "http", "1.0.0"), (BType)new BFiniteType("Reason", valueSpace, mask), detailType), (String)reasonType, (String)errorMsg);
    }

    private HttpUtil() {
    }
}

