/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.ValueCreator;
import org.ballerinalang.mime.util.MimeConstants;
import org.ballerinalang.net.http.HttpConstants;

public class ValueCreatorUtils {
    private static final ValueCreator httpValueCreator = ValueCreator.getValueCreator((String)HttpConstants.PROTOCOL_HTTP_PKG_ID.toString());
    private static final ValueCreator mimeValueCreator = ValueCreator.getValueCreator((String)MimeConstants.PROTOCOL_MIME_PKG_ID.toString());

    public static ObjectValue createRequestObject() {
        return ValueCreatorUtils.createObjectValue(httpValueCreator, "Request", new Object[0]);
    }

    public static ObjectValue createResponseObject() {
        return ValueCreatorUtils.createObjectValue(httpValueCreator, "Response", new Object[0]);
    }

    public static ObjectValue createEntityObject() {
        return ValueCreatorUtils.createObjectValue(mimeValueCreator, "Entity", new Object[0]);
    }

    public static ObjectValue createMediaTypeObject() {
        return ValueCreatorUtils.createObjectValue(mimeValueCreator, "MediaType", new Object[0]);
    }

    public static ObjectValue createPushPromiseObject() {
        return ValueCreatorUtils.createObjectValue(httpValueCreator, "PushPromise", "/", "GET");
    }

    public static ObjectValue createRequestCacheControlObject() {
        return ValueCreatorUtils.createObjectValue(httpValueCreator, "RequestCacheControl", new Object[0]);
    }

    public static ObjectValue createResponseCacheControlObject() {
        return ValueCreatorUtils.createObjectValue(httpValueCreator, "ResponseCacheControl", new Object[0]);
    }

    public static ObjectValue createCallerObject() {
        return ValueCreatorUtils.createObjectValue(httpValueCreator, "Caller", new Object[0]);
    }

    public static MapValue<String, Object> createHTTPRecordValue(String recordTypeName) {
        return httpValueCreator.createRecordValue(recordTypeName);
    }

    private static ObjectValue createObjectValue(ValueCreator valueCreator, String objectTypeName, Object ... fieldValues) {
        Object[] fields = new Object[fieldValues.length * 2];
        int j = 0;
        for (int i = 0; i < fieldValues.length; ++i) {
            fields[j++] = fieldValues[i];
            fields[j++] = true;
        }
        return valueCreator.createObjectValue(objectTypeName, null, null, null, fields);
    }
}

