/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.caching;

import java.util.Map;
import java.util.StringJoiner;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.caching.CacheControlDirective;
import org.ballerinalang.net.http.caching.CacheControlParser;

public class ResponseCacheControlObj {
    private ObjectValue responseCacheControl;

    public ResponseCacheControlObj(BPackage bPackage, String objectTypeName) {
        this.responseCacheControl = BallerinaValues.createObjectValue((BPackage)bPackage, (String)objectTypeName, (Object[])new Object[0]);
        this.init();
    }

    public ResponseCacheControlObj(ObjectValue responseCacheControl) {
        this.responseCacheControl = responseCacheControl;
    }

    public ObjectValue getObj() {
        return this.responseCacheControl;
    }

    public void setObj(ObjectValue responseCacheControl) {
        this.responseCacheControl = responseCacheControl;
    }

    public void init() {
        this.responseCacheControl.set("noTransform", (Object)true);
        this.responseCacheControl.set("maxAge", (Object)-1);
        this.responseCacheControl.set("sMaxAge", (Object)-1);
    }

    public ResponseCacheControlObj setMustRevalidate(boolean mustRevalidate) {
        this.responseCacheControl.set("mustRevalidate", (Object)mustRevalidate);
        return this;
    }

    public ResponseCacheControlObj setNoCache(boolean noCache) {
        this.responseCacheControl.set("noCache", (Object)noCache);
        return this;
    }

    public ResponseCacheControlObj setNoCache(boolean noCache, String[] noCacheFields) {
        this.responseCacheControl.set("noCache", (Object)noCache);
        this.responseCacheControl.set("noCacheFields", (Object)noCacheFields);
        return this;
    }

    public ResponseCacheControlObj setNoStore(boolean noStore) {
        this.responseCacheControl.set("noStore", (Object)noStore);
        return this;
    }

    public ResponseCacheControlObj setNoTransform(boolean noTransform) {
        this.responseCacheControl.set("noTransform", (Object)noTransform);
        return this;
    }

    public ResponseCacheControlObj setPrivate(boolean isPrivate) {
        this.responseCacheControl.set("isPrivate", (Object)isPrivate);
        return this;
    }

    public ResponseCacheControlObj setPrivate(boolean isPrivate, String[] privateFields) {
        this.responseCacheControl.set("isPrivate", (Object)isPrivate);
        this.responseCacheControl.set("privateFields", (Object)privateFields);
        return this;
    }

    public ResponseCacheControlObj setProxyRevalidate(boolean proxyRevalidate) {
        this.responseCacheControl.set("proxyRevalidate", (Object)proxyRevalidate);
        return this;
    }

    public ResponseCacheControlObj setMaxAge(long maxAge) {
        this.responseCacheControl.set("maxAge", (Object)maxAge);
        return this;
    }

    public ResponseCacheControlObj setSMaxAge(long sMaxAge) {
        this.responseCacheControl.set("sMaxAge", (Object)sMaxAge);
        return this;
    }

    public void populateStruct(String cacheControlHeaderVal) {
        Map<CacheControlDirective, String> controlDirectives = CacheControlParser.parse(cacheControlHeaderVal);
        controlDirectives.forEach((directive, value) -> {
            switch (directive) {
                case MUST_REVALIDATE: {
                    this.responseCacheControl.set("mustRevalidate", (Object)true);
                    break;
                }
                case NO_CACHE: {
                    this.responseCacheControl.set("noCache", (Object)true);
                    if (value == null) break;
                    value = value.replace("\"", "");
                    this.responseCacheControl.set("noCacheFields", (Object)new ArrayValueImpl(value.split(",")));
                    break;
                }
                case NO_STORE: {
                    this.responseCacheControl.set("noStore", (Object)true);
                    break;
                }
                case NO_TRANSFORM: {
                    this.responseCacheControl.set("noTransform", (Object)true);
                    break;
                }
                case PRIVATE: {
                    this.responseCacheControl.set("isPrivate", (Object)true);
                    if (value == null) break;
                    value = value.replace("\"", "");
                    this.responseCacheControl.set("privateFields", (Object)new ArrayValueImpl(value.split(",")));
                    break;
                }
                case PUBLIC: {
                    this.responseCacheControl.set("isPrivate", (Object)false);
                    break;
                }
                case PROXY_REVALIDATE: {
                    this.responseCacheControl.set("proxyRevalidate", (Object)true);
                    break;
                }
                case MAX_AGE: {
                    try {
                        this.responseCacheControl.set("maxAge", (Object)Long.parseLong(value));
                    }
                    catch (NumberFormatException e) {
                        this.responseCacheControl.set("maxAge", (Object)0);
                    }
                    break;
                }
                case S_MAXAGE: {
                    try {
                        this.responseCacheControl.set("sMaxAge", (Object)Long.parseLong(value));
                    }
                    catch (NumberFormatException e) {
                        this.responseCacheControl.set("sMaxAge", (Object)0);
                    }
                    break;
                }
            }
        });
    }

    public String buildCacheControlDirectives() {
        StringJoiner directivesBuilder = new StringJoiner(",");
        if (this.getBooleanValue(this.responseCacheControl, "mustRevalidate")) {
            directivesBuilder.add("must-revalidate");
        }
        if (this.getBooleanValue(this.responseCacheControl, "noCache")) {
            directivesBuilder.add("no-cache" + this.appendFields((ArrayValue)this.responseCacheControl.get("noCacheFields")));
        }
        if (this.getBooleanValue(this.responseCacheControl, "noStore")) {
            directivesBuilder.add("no-store");
        }
        if (this.getBooleanValue(this.responseCacheControl, "noTransform")) {
            directivesBuilder.add("no-transform");
        }
        if (this.getBooleanValue(this.responseCacheControl, "isPrivate")) {
            directivesBuilder.add("private" + this.appendFields((ArrayValue)this.responseCacheControl.get("privateFields")));
        } else {
            directivesBuilder.add("public");
        }
        if (this.getBooleanValue(this.responseCacheControl, "proxyRevalidate")) {
            directivesBuilder.add("proxy-revalidate");
        }
        if (this.getIntValue(this.responseCacheControl, "maxAge") >= 0L) {
            directivesBuilder.add("max-age=" + this.responseCacheControl.get("maxAge"));
        }
        if (this.getIntValue(this.responseCacheControl, "sMaxAge") >= 0L) {
            directivesBuilder.add("s-maxage=" + this.responseCacheControl.get("sMaxAge"));
        }
        return directivesBuilder.toString();
    }

    private String appendFields(ArrayValue values) {
        if (values.size() > 0) {
            StringJoiner joiner = new StringJoiner(",");
            for (int i = 0; i < values.size(); ++i) {
                joiner.add(values.getString((long)i));
            }
            return "=\"" + joiner.toString() + "\"";
        }
        return "";
    }

    private boolean getBooleanValue(ObjectValue responseCacheControl, String fieldName) {
        return (Boolean)responseCacheControl.get(fieldName);
    }

    private long getIntValue(ObjectValue responseCacheControl, String fieldName) {
        return Long.parseLong(responseCacheControl.get(fieldName).toString());
    }
}

