/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.nativeimpl.pipelining;

import java.util.Objects;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.DataContext;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class PipelinedResponse
implements Comparable<PipelinedResponse> {
    private final HttpCarbonMessage inboundRequestMsg;
    private final HttpCarbonMessage outboundResponseMsg;
    private DataContext dataContext;
    private ObjectValue outboundResponseObj;
    private final long sequenceId;

    public PipelinedResponse(HttpCarbonMessage inboundRequestMsg, HttpCarbonMessage outboundResponseMsg, DataContext dataContext, ObjectValue outboundResponseObj) {
        this.inboundRequestMsg = inboundRequestMsg;
        this.outboundResponseMsg = outboundResponseMsg;
        this.dataContext = dataContext;
        this.outboundResponseObj = outboundResponseObj;
        this.sequenceId = inboundRequestMsg.getSequenceId();
    }

    PipelinedResponse(HttpCarbonMessage inboundRequestMsg, HttpCarbonMessage outboundResponseMsg) {
        this.inboundRequestMsg = inboundRequestMsg;
        this.outboundResponseMsg = outboundResponseMsg;
        this.sequenceId = inboundRequestMsg.getSequenceId();
    }

    long getSequenceId() {
        return this.sequenceId;
    }

    HttpCarbonMessage getOutboundResponseMsg() {
        return this.outboundResponseMsg;
    }

    HttpCarbonMessage getInboundRequestMsg() {
        return this.inboundRequestMsg;
    }

    DataContext getDataContext() {
        return this.dataContext;
    }

    ObjectValue getOutboundResponseObj() {
        return this.outboundResponseObj;
    }

    @Override
    public int compareTo(PipelinedResponse other) {
        return Long.compare(this.sequenceId, other.getSequenceId());
    }

    public boolean equals(Object obj) {
        if (obj instanceof PipelinedResponse) {
            return this.compareTo((PipelinedResponse)obj) == 0;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hashCode(this.sequenceId);
    }
}

