/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.client.listener;

import java.io.IOException;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.client.listener.ExtendedConnectorListener;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketCloseMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketHandshaker;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;

public class FailoverConnectorListener
implements ExtendedConnectorListener {
    private WebSocketConnectionInfo connectionInfo = null;
    private ExtendedConnectorListener connectorListener;

    public FailoverConnectorListener(ExtendedConnectorListener connectorListener) {
        this.connectorListener = connectorListener;
    }

    @Override
    public void setConnectionInfo(WebSocketConnectionInfo connectionInfo) {
        this.connectorListener.setConnectionInfo(connectionInfo);
        this.connectionInfo = connectionInfo;
    }

    public void onHandshake(WebSocketHandshaker webSocketHandshaker) {
    }

    public void onMessage(WebSocketTextMessage textMessage) {
        this.connectorListener.onMessage(textMessage);
    }

    public void onMessage(WebSocketBinaryMessage binaryMessage) {
        this.connectorListener.onMessage(binaryMessage);
    }

    public void onMessage(WebSocketControlMessage controlMessage) {
        this.connectorListener.onMessage(controlMessage);
    }

    public void onMessage(WebSocketCloseMessage webSocketCloseMessage) {
        int statusCode = webSocketCloseMessage.getCloseCode();
        if (statusCode != 1006 || !WebSocketUtil.failover(this.connectionInfo.getWebSocketEndpoint(), this.connectionInfo.getService())) {
            this.connectorListener.onMessage(webSocketCloseMessage);
        }
    }

    public void onClose(WebSocketConnection webSocketConnection) {
        this.connectorListener.onClose(webSocketConnection);
    }

    public void onError(WebSocketConnection webSocketConnection, Throwable throwable) {
        if (!(throwable instanceof IOException) || !WebSocketUtil.failover(this.connectionInfo.getWebSocketEndpoint(), this.connectionInfo.getService())) {
            this.connectorListener.onError(webSocketConnection, throwable);
        }
    }

    public void onIdleTimeout(WebSocketControlMessage controlMessage) {
        this.connectorListener.onIdleTimeout(controlMessage);
    }
}

