/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.observability;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.websocket.WebSocketService;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.client.FailoverContext;
import org.ballerinalang.net.http.websocket.observability.WebSocketMetricsUtil;
import org.ballerinalang.net.http.websocket.observability.WebSocketObserverContext;
import org.ballerinalang.net.http.websocket.observability.WebSocketTracingUtil;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;
import org.ballerinalang.net.http.websocket.server.WebSocketServerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketObservabilityUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketObservabilityUtil.class);

    public static void observeConnection(WebSocketConnectionInfo connectionInfo) {
        WebSocketObserverContext observerContext = new WebSocketObserverContext(connectionInfo);
        WebSocketMetricsUtil.reportConnectionMetrics(observerContext);
        LOGGER.debug("WebSocket new connection established. connectionID: {}, service/url: {}", (Object)observerContext.getConnectionId(), (Object)observerContext.getServicePathOrClientUrl());
    }

    public static void observeSend(String type, WebSocketConnectionInfo connectionInfo) {
        WebSocketObserverContext observerContext = new WebSocketObserverContext(connectionInfo);
        WebSocketMetricsUtil.reportSendMetrics(observerContext, type);
        LOGGER.debug("WebSocket message sent. connectionID: {}, service/url: {}, type: {}", new Object[]{observerContext.getConnectionId(), observerContext.getServicePathOrClientUrl(), type});
    }

    public static void observeOnMessage(String type, WebSocketConnectionInfo connectionInfo) {
        WebSocketObserverContext observerContext = new WebSocketObserverContext(connectionInfo);
        WebSocketMetricsUtil.reportReceivedMetrics(observerContext, type);
        LOGGER.debug("WebSocket message received. connectionID: {}, service/url: {}, type:{}", new Object[]{observerContext.getConnectionId(), observerContext.getServicePathOrClientUrl(), type});
    }

    public static void observeClose(WebSocketConnectionInfo connectionInfo) {
        WebSocketObserverContext observerContext = new WebSocketObserverContext(connectionInfo);
        WebSocketMetricsUtil.reportCloseMetrics(observerContext);
        LOGGER.debug("WebSocket connection closed. connectionID: {}, service/url: {}", (Object)observerContext.getConnectionId(), (Object)observerContext.getServicePathOrClientUrl());
    }

    public static void observeError(WebSocketConnectionInfo connectionInfo, String errorType, String errorMessage) {
        WebSocketObservabilityUtil.observeError(connectionInfo, errorType, null, errorMessage);
    }

    public static void observeError(WebSocketConnectionInfo connectionInfo, String errorType, String messageType, String errorMessage) {
        WebSocketObserverContext observerContext = new WebSocketObserverContext(connectionInfo);
        WebSocketMetricsUtil.reportErrorMetrics(observerContext, errorType, messageType);
        if (errorMessage == null) {
            errorMessage = "unknown";
        }
        if (messageType == null) {
            LOGGER.debug("WebSocket type:{}, message: {}, connectionId: {}, service/url: {}", new Object[]{errorType, errorMessage, observerContext.getConnectionId(), observerContext.getServicePathOrClientUrl()});
        } else {
            LOGGER.debug("WebSocket type:{}/{}, message: {}, connectionId: {}, service/url: {}", new Object[]{errorType, messageType, errorMessage, observerContext.getConnectionId(), observerContext.getServicePathOrClientUrl()});
        }
    }

    public static void observeError(String errorType, String errorMessage, String url, String clientOrServer) {
        WebSocketMetricsUtil.reportErrorMetrics(errorType, url, clientOrServer);
        LOGGER.debug("WebSocket type:{}, message: {}, service/url: {}", new Object[]{errorType, errorMessage, url});
    }

    public static void observeResourceInvocation(Strand strand, WebSocketConnectionInfo connectionInfo, String resource) {
        WebSocketTracingUtil.traceResourceInvocation(strand, connectionInfo);
        WebSocketObservabilityUtil.observeResourceInvocation(connectionInfo, resource);
    }

    public static void observeResourceInvocation(WebSocketConnectionInfo connectionInfo, String resource) {
        WebSocketObserverContext observerContext = new WebSocketObserverContext(connectionInfo);
        WebSocketMetricsUtil.reportResourceInvocationMetrics(observerContext, resource);
        LOGGER.debug("WebSocket resource invoked. connectionID: {}, service/url: {}, resource: {}", new Object[]{observerContext.getConnectionId(), observerContext.getServicePathOrClientUrl(), resource});
    }

    static String getClientOrServerContext(WebSocketConnectionInfo connectionInfo) {
        WebSocketService service = connectionInfo.getService();
        if (service instanceof WebSocketServerService) {
            return "server";
        }
        return "client";
    }

    static String getServicePathOrClientUrl(WebSocketConnectionInfo connectionInfo) {
        WebSocketService service = connectionInfo.getService();
        if (service instanceof WebSocketServerService) {
            return ((WebSocketServerService)service).getBasePath();
        }
        if (WebSocketUtil.isFailoverClient(connectionInfo.getWebSocketEndpoint())) {
            FailoverContext failoverConfig = (FailoverContext)connectionInfo.getWebSocketEndpoint().getNativeData("failoverContext");
            return failoverConfig.getTargetUrls().get(failoverConfig.getCurrentIndex());
        }
        return connectionInfo.getWebSocketEndpoint().getStringValue("url");
    }

    public static WebSocketConnectionInfo getConnectionInfo(ObjectValue wsConnection) {
        return (WebSocketConnectionInfo)wsConnection.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO");
    }

    static String getConnectionId(WebSocketConnectionInfo connectionInfo) {
        try {
            return connectionInfo.getWebSocketConnection().getChannelId();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private WebSocketObservabilityUtil() {
    }
}

