/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.uri.parser;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.net.uri.URITemplateException;
import org.ballerinalang.net.uri.parser.DataElement;
import org.ballerinalang.net.uri.parser.Node;
import org.ballerinalang.net.uri.parser.Variable;

public abstract class Expression<DataType, InboundMsgType>
extends Node<DataType, InboundMsgType> {
    protected List<Variable> variableList = new ArrayList<Variable>(4);

    public Expression(DataElement<DataType, InboundMsgType> dataElement, String token) throws URITemplateException {
        super(dataElement, token);
        int startIndex = 0;
        for (int i = 0; i < token.length(); ++i) {
            if (token.charAt(i) == ',') {
                if (startIndex == i) {
                    throw new URITemplateException("Illegal variable reference with zero length");
                }
                this.variableList.add(new Variable(token.substring(startIndex, i)));
                startIndex = i + 1;
                continue;
            }
            if (i != token.length() - 1 || startIndex >= token.length()) continue;
            this.variableList.add(new Variable(token.substring(startIndex, i + 1)));
        }
    }

    @Override
    String getToken() {
        String str = "{";
        boolean first = true;
        for (Variable var : this.variableList) {
            if (!first) {
                str = str.concat(",");
            } else {
                first = false;
            }
            str = str.concat(var.getName());
        }
        str = str.concat("}");
        return str;
    }

    protected String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error while encoding value: " + value, e);
        }
    }

    protected String decodeValue(String value) {
        try {
            return URLDecoder.decode(value.replaceAll("\\+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error while encoding value: " + value, e);
        }
    }
}

