/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.crypto.nativeimpl;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.stdlib.crypto.CryptoUtils;

public class Encrypt {
    public static Object encryptAesCbc(ArrayValue inputValue, ArrayValue keyValue, ArrayValue ivValue, Object padding) {
        byte[] input = inputValue.getBytes();
        byte[] key = keyValue.getBytes();
        byte[] iv = null;
        if (ivValue != null) {
            iv = ivValue.getBytes();
        }
        return CryptoUtils.aesEncryptDecrypt(CryptoUtils.CipherMode.ENCRYPT, "CBC", padding.toString(), key, input, iv, -1L);
    }

    public static Object encryptAesEcb(ArrayValue inputValue, ArrayValue keyValue, Object padding) {
        byte[] input = inputValue.getBytes();
        byte[] key = keyValue.getBytes();
        return CryptoUtils.aesEncryptDecrypt(CryptoUtils.CipherMode.ENCRYPT, "ECB", padding.toString(), key, input, null, -1L);
    }

    public static Object encryptAesGcm(ArrayValue inputValue, ArrayValue keyValue, ArrayValue ivValue, Object padding, long tagSize) {
        byte[] input = inputValue.getBytes();
        byte[] key = keyValue.getBytes();
        byte[] iv = null;
        if (ivValue != null) {
            iv = ivValue.getBytes();
        }
        return CryptoUtils.aesEncryptDecrypt(CryptoUtils.CipherMode.ENCRYPT, "GCM", padding.toString(), key, input, iv, tagSize);
    }

    public static Object encryptRsaEcb(ArrayValue inputValue, Object keyUnion, Object padding) {
        Key key;
        byte[] input = inputValue.getBytes();
        MapValue keyMap = (MapValue)keyUnion;
        if (keyMap.getNativeData("NATIVE_DATA_PRIVATE_KEY") != null) {
            key = (PrivateKey)keyMap.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        } else if (keyMap.getNativeData("NATIVE_DATA_PUBLIC_KEY") != null) {
            key = (PublicKey)keyMap.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        } else {
            return CryptoUtils.createError("Uninitialized private/public key");
        }
        return CryptoUtils.rsaEncryptDecrypt(CryptoUtils.CipherMode.ENCRYPT, "ECB", padding.toString(), key, input, null, -1L);
    }
}

