/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.map;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.MapUtils;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.exceptions.BLangFreezeException;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.map", functionName="remove", args={@Argument(name="m", type=TypeKind.MAP), @Argument(name="k", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.ANY)}, isPublic=true)
public class Remove {
    public static Object remove(Strand strand, MapValue<?, ?> m, String k) {
        BType type = m.getType();
        MapUtils.checkIsMapOnlyOperation((BType)type, (String)"remove()");
        MapUtils.validateRequiredFieldForRecord(m, (String)k);
        if (m.containsKey((Object)k)) {
            try {
                return m.remove((Object)k);
            }
            catch (BLangFreezeException e) {
                throw BallerinaErrors.createError((String)e.getMessage(), (String)("Failed to remove element from map: " + e.getDetail()));
            }
        }
        throw BallerinaErrors.createError((String)BallerinaErrorReasons.MAP_KEY_NOT_FOUND_ERROR, (String)("cannot find key '" + k + "'"));
    }
}

