/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.nio.charset.Charset;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.jvm.values.utils.StringUtils;
import org.ballerinalang.mime.nativeimpl.AbstractGetPayloadHandler;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeUtil;

public class MimeDataSourceBuilder
extends AbstractGetPayloadHandler {
    public static Object getByteArray(ObjectValue entityObj) {
        NonBlockingCallback callback = null;
        ArrayValue result = null;
        try {
            Object messageDataSource = EntityBodyHandler.getMessageDataSource(entityObj);
            if (messageDataSource != null) {
                if (messageDataSource instanceof ArrayValue) {
                    result = (ArrayValue)messageDataSource;
                } else {
                    String contentTypeValue = HeaderUtil.getHeaderValue(entityObj, HttpHeaderNames.CONTENT_TYPE.toString());
                    if (MimeUtil.isNotNullAndEmpty(contentTypeValue)) {
                        String charsetValue = MimeUtil.getContentTypeParamValue(contentTypeValue, "charset");
                        result = MimeUtil.isNotNullAndEmpty(charsetValue) ? new ArrayValueImpl(StringUtils.getJsonString((Object)messageDataSource).getBytes(charsetValue)) : new ArrayValueImpl(StringUtils.getJsonString((Object)messageDataSource).getBytes(Charset.defaultCharset()));
                    }
                }
                return result != null ? result : new ArrayValueImpl(new byte[0]);
            }
            Object transportMessage = entityObj.getNativeData("transport_message");
            if (EntityBodyHandler.isStreamingRequired(entityObj) || transportMessage == null) {
                result = EntityBodyHandler.constructBlobDataSource(entityObj);
                MimeDataSourceBuilder.updateDataSource(entityObj, result);
            } else {
                callback = new NonBlockingCallback(Scheduler.getStrand());
                MimeDataSourceBuilder.constructNonBlockingDataSource(callback, entityObj, AbstractGetPayloadHandler.SourceType.BLOB);
            }
        }
        catch (Exception ex) {
            if (ex instanceof ErrorValue) {
                return MimeDataSourceBuilder.createParsingEntityBodyFailedErrorAndNotify(callback, "Error occurred while extracting blob data from entity", (ErrorValue)ex);
            }
            MimeDataSourceBuilder.createParsingEntityBodyFailedErrorAndNotify(callback, "Error occurred while extracting blob data from entity : " + MimeDataSourceBuilder.getErrorMsg(ex), null);
        }
        return result;
    }

    public static Object getJson(ObjectValue entityObj) {
        NonBlockingCallback callback = null;
        RefValue result = null;
        try {
            Object dataSource = EntityBodyHandler.getMessageDataSource(entityObj);
            if (dataSource != null) {
                if (MimeDataSourceBuilder.isJSON(dataSource)) {
                    result = (RefValue)dataSource;
                } else {
                    String payload = MimeUtil.getMessageAsString(dataSource);
                    result = (RefValue)JSONParser.parse((String)payload);
                }
                return result;
            }
            if (EntityBodyHandler.isStreamingRequired(entityObj)) {
                result = (RefValue)EntityBodyHandler.constructJsonDataSource(entityObj);
                MimeDataSourceBuilder.updateJsonDataSource(entityObj, result);
            } else {
                callback = new NonBlockingCallback(Scheduler.getStrand());
                MimeDataSourceBuilder.constructNonBlockingDataSource(callback, entityObj, AbstractGetPayloadHandler.SourceType.JSON);
            }
        }
        catch (Exception ex) {
            if (ex instanceof ErrorValue) {
                return MimeDataSourceBuilder.createParsingEntityBodyFailedErrorAndNotify(callback, "Error occurred while extracting json data from entity", (ErrorValue)ex);
            }
            return MimeDataSourceBuilder.createParsingEntityBodyFailedErrorAndNotify(callback, "Error occurred while extracting json data from entity: " + MimeDataSourceBuilder.getErrorMsg(ex), null);
        }
        return result;
    }

    private static boolean isJSON(Object value) {
        BType objectType = TypeChecker.getType((Object)value);
        return objectType.getTag() != 5 && MimeUtil.isJSONCompatible(objectType);
    }

    public static Object getText(ObjectValue entityObj) {
        NonBlockingCallback callback = null;
        String result = null;
        try {
            Object dataSource = EntityBodyHandler.getMessageDataSource(entityObj);
            if (dataSource != null) {
                return MimeUtil.getMessageAsString(dataSource);
            }
            if (EntityBodyHandler.isStreamingRequired(entityObj)) {
                result = EntityBodyHandler.constructStringDataSource(entityObj);
                MimeDataSourceBuilder.updateDataSource(entityObj, result);
            } else {
                callback = new NonBlockingCallback(Scheduler.getStrand());
                MimeDataSourceBuilder.constructNonBlockingDataSource(callback, entityObj, AbstractGetPayloadHandler.SourceType.TEXT);
            }
        }
        catch (Exception ex) {
            if (ex instanceof ErrorValue) {
                return MimeDataSourceBuilder.createParsingEntityBodyFailedErrorAndNotify(callback, "Error occurred while extracting text data from entity", (ErrorValue)ex);
            }
            return MimeDataSourceBuilder.createParsingEntityBodyFailedErrorAndNotify(callback, "Error occurred while extracting text data from entity : " + MimeDataSourceBuilder.getErrorMsg(ex), null);
        }
        return result;
    }

    public static Object getXml(ObjectValue entityObj) {
        NonBlockingCallback callback = null;
        XMLValue result = null;
        try {
            Object dataSource = EntityBodyHandler.getMessageDataSource(entityObj);
            if (dataSource != null) {
                if (dataSource instanceof XMLValue) {
                    result = (XMLValue)dataSource;
                } else {
                    String payload = MimeUtil.getMessageAsString(dataSource);
                    result = XMLFactory.parse((String)payload);
                }
                return result;
            }
            if (EntityBodyHandler.isStreamingRequired(entityObj)) {
                result = EntityBodyHandler.constructXmlDataSource(entityObj);
                MimeDataSourceBuilder.updateDataSource(entityObj, result);
            } else {
                callback = new NonBlockingCallback(Scheduler.getStrand());
                MimeDataSourceBuilder.constructNonBlockingDataSource(callback, entityObj, AbstractGetPayloadHandler.SourceType.XML);
            }
        }
        catch (Exception ex) {
            if (ex instanceof ErrorValue) {
                return MimeDataSourceBuilder.createParsingEntityBodyFailedErrorAndNotify(callback, "Error occurred while extracting xml data from entity", (ErrorValue)ex);
            }
            return MimeDataSourceBuilder.createParsingEntityBodyFailedErrorAndNotify(callback, "Error occurred while extracting xml data from entity : " + MimeDataSourceBuilder.getErrorMsg(ex), null);
        }
        return result;
    }
}

