/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.jdbc.datasource;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.XADataSource;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinax.jdbc.datasource.PoolOptionsWrapper;
import org.ballerinax.jdbc.datasource.SQLDatasourceUtils;
import org.ballerinax.jdbc.exceptions.ErrorGenerator;
import org.ballerinax.jdbc.exceptions.PanickingApplicationException;
import org.ballerinax.jdbc.exceptions.PanickingDatabaseException;

public class SQLDatasource {
    private HikariDataSource hikariDataSource;
    private String peerAddress;
    private String databaseProductName;
    private boolean xaConn;
    private boolean globalDatasource;
    private AtomicInteger clientCounter = new AtomicInteger(0);
    private Lock mutex = new ReentrantLock();
    private boolean poolShutdown = false;
    private boolean supportsGetGeneratedKeys;

    public SQLDatasource init(SQLDatasourceParams sqlDatasourceParams) {
        this.globalDatasource = sqlDatasourceParams.isGlobalDatasource;
        this.peerAddress = sqlDatasourceParams.jdbcUrl;
        this.buildDataSource(sqlDatasourceParams);
        try {
            this.xaConn = this.isXADataSource();
        }
        catch (PanickingDatabaseException e) {
            throw ErrorGenerator.getSQLDatabaseError(e);
        }
        try (Connection con = this.getSQLConnection();){
            this.databaseProductName = con.getMetaData().getDatabaseProductName().toLowerCase(Locale.ENGLISH);
            this.supportsGetGeneratedKeys = con.getMetaData().supportsGetGeneratedKeys();
        }
        catch (SQLException e) {
            throw ErrorGenerator.getSQLDatabaseError(e, "error while obtaining connection for ClientConnector, ");
        }
        return this;
    }

    public String getPeerAddress() {
        return this.peerAddress;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public Connection getSQLConnection() throws SQLException {
        return this.hikariDataSource.getConnection();
    }

    public boolean isXAConnection() {
        return this.xaConn;
    }

    public XADataSource getXADataSource() throws PanickingDatabaseException {
        XADataSource xaDataSource;
        try {
            xaDataSource = (XADataSource)this.hikariDataSource.unwrap(XADataSource.class);
        }
        catch (SQLException e) {
            throw new PanickingDatabaseException("error while obtaining distributed data source", e);
        }
        return xaDataSource;
    }

    private void closeConnectionPool() {
        this.hikariDataSource.close();
        this.poolShutdown = true;
    }

    public boolean isGlobalDatasource() {
        return this.globalDatasource;
    }

    public boolean isPoolShutdown() {
        return this.poolShutdown;
    }

    public boolean supportsGetGeneratedKeys() {
        return this.supportsGetGeneratedKeys;
    }

    public void incrementClientCounter() {
        this.clientCounter.incrementAndGet();
    }

    public void decrementClientCounterAndAttemptPoolShutdown() {
        this.acquireMutex();
        if (!this.poolShutdown && this.clientCounter.decrementAndGet() == 0) {
            this.closeConnectionPool();
        }
        this.releaseMutex();
    }

    public void releaseMutex() {
        this.mutex.unlock();
    }

    public void acquireMutex() {
        this.mutex.lock();
    }

    private void buildDataSource(SQLDatasourceParams sqlDatasourceParams) {
        try {
            HikariConfig config = new HikariConfig();
            config.setUsername(sqlDatasourceParams.username);
            config.setPassword(sqlDatasourceParams.password);
            if (sqlDatasourceParams.poolOptionsWrapper != null) {
                long validationTimeout;
                long maxLifetime;
                int minimumIdle;
                long idleTimeout;
                long connectionTimeout;
                int maximumPoolSize;
                boolean isXA = sqlDatasourceParams.poolOptionsWrapper.getBoolean("isXA");
                String dataSourceClassName = sqlDatasourceParams.poolOptionsWrapper.getString("dataSourceClassName");
                if (isXA && dataSourceClassName.isEmpty()) {
                    dataSourceClassName = this.getXADatasourceClassName(sqlDatasourceParams.dbType, sqlDatasourceParams.jdbcUrl, sqlDatasourceParams.username, sqlDatasourceParams.password);
                }
                if (!dataSourceClassName.isEmpty()) {
                    config.setDataSourceClassName(dataSourceClassName);
                    if (sqlDatasourceParams.dbOptionsMap == null || !sqlDatasourceParams.dbOptionsMap.containsKey((Object)"url")) {
                        config.addDataSourceProperty("url", (Object)sqlDatasourceParams.jdbcUrl);
                    }
                    config.addDataSourceProperty("user", (Object)sqlDatasourceParams.username);
                    config.addDataSourceProperty("password", (Object)sqlDatasourceParams.password);
                } else {
                    config.setJdbcUrl(sqlDatasourceParams.jdbcUrl);
                }
                String connectionInitSQL = sqlDatasourceParams.poolOptionsWrapper.getString("connectionInitSql");
                if (!connectionInitSQL.isEmpty()) {
                    config.setConnectionInitSql(connectionInitSQL);
                }
                if ((maximumPoolSize = sqlDatasourceParams.poolOptionsWrapper.getInt("maximumPoolSize").intValue()) != -1) {
                    config.setMaximumPoolSize(maximumPoolSize);
                }
                if ((connectionTimeout = sqlDatasourceParams.poolOptionsWrapper.getInt("connectionTimeoutInMillis").longValue()) != -1L) {
                    config.setConnectionTimeout(connectionTimeout);
                }
                if ((idleTimeout = sqlDatasourceParams.poolOptionsWrapper.getInt("idleTimeoutInMillis").longValue()) != -1L) {
                    config.setIdleTimeout(idleTimeout);
                }
                if ((minimumIdle = sqlDatasourceParams.poolOptionsWrapper.getInt("minimumIdle").intValue()) != -1) {
                    config.setMinimumIdle(minimumIdle);
                }
                if ((maxLifetime = sqlDatasourceParams.poolOptionsWrapper.getInt("maxLifetimeInMillis").longValue()) != -1L) {
                    config.setMaxLifetime(maxLifetime);
                }
                if ((validationTimeout = sqlDatasourceParams.poolOptionsWrapper.getInt("validationTimeoutInMillis").longValue()) != -1L) {
                    config.setValidationTimeout(validationTimeout);
                }
                boolean autoCommit = sqlDatasourceParams.poolOptionsWrapper.getBoolean("autoCommit");
                config.setAutoCommit(autoCommit);
            } else {
                config.setJdbcUrl(sqlDatasourceParams.jdbcUrl);
            }
            if (sqlDatasourceParams.dbOptionsMap != null) {
                sqlDatasourceParams.dbOptionsMap.entrySet().forEach(entry -> {
                    if (!SQLDatasourceUtils.isSupportedDbOptionType(entry.getValue())) {
                        throw ErrorGenerator.getSQLApplicationError("unsupported type " + (String)entry.getKey() + " for the db option");
                    }
                    config.addDataSourceProperty((String)entry.getKey(), entry.getValue());
                });
            }
            this.hikariDataSource = new HikariDataSource(config);
            Runtime.getRuntime().addShutdownHook(new Thread(this::closeConnectionPool));
        }
        catch (Throwable t) {
            String message = "error in sql connector configuration: " + t.getMessage();
            if (t.getCause() != null) {
                message = message + ":" + t.getCause().getMessage();
            }
            throw ErrorGenerator.getSQLApplicationError(message);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String getXADatasourceClassName(String dbType, String url, String userName, String password) throws PanickingApplicationException, PanickingDatabaseException {
        xaDataSource = null;
        var6_6 = dbType;
        var7_7 = -1;
        switch (var6_6.hashCode()) {
            case 73844866: {
                if (!var6_6.equals("MYSQL")) break;
                var7_7 = 0;
                break;
            }
            case 912124529: {
                if (!var6_6.equals("SQLSERVER")) break;
                var7_7 = 1;
                break;
            }
            case -1955532418: {
                if (!var6_6.equals("ORACLE")) break;
                var7_7 = 2;
                break;
            }
            case -1834523081: {
                if (!var6_6.equals("SYBASE")) break;
                var7_7 = 3;
                break;
            }
            case -1620389036: {
                if (!var6_6.equals("POSTGRESQL")) break;
                var7_7 = 4;
                break;
            }
            case 67444: {
                if (!var6_6.equals("DB2")) break;
                var7_7 = 5;
                break;
            }
            case 2140439396: {
                if (!var6_6.equals("HSQLDB")) break;
                var7_7 = 6;
                break;
            }
            case -1831025538: {
                if (!var6_6.equals("HSQLDB_SERVER")) break;
                var7_7 = 7;
                break;
            }
            case 1472569719: {
                if (!var6_6.equals("HSQLDB_FILE")) break;
                var7_7 = 8;
                break;
            }
            case 2282: {
                if (!var6_6.equals("H2")) break;
                var7_7 = 9;
                break;
            }
            case 809442360: {
                if (!var6_6.equals("H2_SERVER")) break;
                var7_7 = 10;
                break;
            }
            case 997105585: {
                if (!var6_6.equals("H2_FILE")) break;
                var7_7 = 11;
                break;
            }
            case 637512182: {
                if (!var6_6.equals("H2_MEMORY")) break;
                var7_7 = 12;
                break;
            }
            case -162746534: {
                if (!var6_6.equals("DERBY_SERVER")) break;
                var7_7 = 13;
                break;
            }
            case 1621791571: {
                if (!var6_6.equals("DERBY_FILE")) break;
                var7_7 = 14;
            }
        }
        switch (var7_7) {
            case 0: {
                try {
                    conn = DriverManager.getConnection(url, userName, password);
                    var10_10 = null;
                    driverMajorVersion = conn.getMetaData().getDriverMajorVersion();
                    if (driverMajorVersion == 5) {
                        xaDataSource = "com.mysql.jdbc.jdbc2.optional.MysqlXADataSource";
                    } else if (driverMajorVersion > 5) {
                        xaDataSource = "com.mysql.cj.jdbc.MysqlXADataSource";
                    }
                    if (conn == null) break;
                    if (var10_10 == null) ** GOTO lbl84
                    try {
                        conn.close();
                    }
                    catch (Throwable var11_12) {
                        var10_10.addSuppressed(var11_12);
                    }
                    break;
lbl84:
                    // 1 sources

                    conn.close();
                    ** break;
                    catch (Throwable var11_13) {
                        try {
                            var10_10 = var11_13;
                            throw var11_13;
                        }
                        catch (Throwable var12_14) {
                            if (conn != null) {
                                if (var10_10 != null) {
                                    try {
                                        conn.close();
                                    }
                                    catch (Throwable var13_15) {
                                        var10_10.addSuppressed(var13_15);
                                    }
                                } else {
                                    conn.close();
                                }
                            }
                            throw var12_14;
lbl101:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (SQLException e) {
                    throw new PanickingDatabaseException("error while obtaining the connection for ClientConnector: ", e);
                }
            }
            case 1: {
                xaDataSource = "com.microsoft.sqlserver.jdbc.SQLServerXADataSource";
                break;
            }
            case 2: {
                xaDataSource = "oracle.jdbc.xa.client.OracleXADataSource";
                break;
            }
            case 3: {
                xaDataSource = "com.sybase.jdbc3.jdbc.SybXADataSource";
                break;
            }
            case 4: {
                xaDataSource = "org.postgresql.xa.PGXADataSource";
                break;
            }
            case 5: {
                xaDataSource = "com.ibm.db2.jdbc.DB2XADataSource";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                xaDataSource = "org.hsqldb.jdbc.pool.JDBCXADataSource";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                xaDataSource = "org.h2.jdbcx.JdbcDataSource";
                break;
            }
            case 13: {
                xaDataSource = "org.apache.derby.jdbc.ClientXADataSource";
                break;
            }
            case 14: {
                xaDataSource = "org.apache.derby.jdbc.EmbeddedXADataSource";
                break;
            }
            default: {
                throw new PanickingApplicationException("unknown database type " + dbType + " used for xa connection");
            }
        }
        return xaDataSource;
    }

    private boolean isXADataSource() throws PanickingDatabaseException {
        try {
            return this.hikariDataSource.isWrapperFor(XADataSource.class);
        }
        catch (SQLException e) {
            throw new PanickingDatabaseException("error while checking distributed data source: ", e);
        }
    }

    public static class SQLDatasourceParamsBuilder {
        private PoolOptionsWrapper poolOptions;
        private String jdbcUrl;
        private String dbType;
        private String username;
        private String password;
        private boolean isGlobalDatasource;
        private MapValue<String, Object> dbOptionsMap;

        public SQLDatasourceParamsBuilder(String dbType) {
            this.dbType = dbType;
        }

        public SQLDatasourceParams build() {
            return new SQLDatasourceParams(this);
        }

        public SQLDatasourceParamsBuilder withJdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public SQLDatasourceParamsBuilder withUsername(String username) {
            this.username = username;
            return this;
        }

        public SQLDatasourceParamsBuilder withPassword(String password) {
            this.password = password;
            return this;
        }

        public SQLDatasourceParamsBuilder withDbOptionsMap(MapValue<String, Object> dbOptionsMap) {
            this.dbOptionsMap = dbOptionsMap;
            return this;
        }

        public SQLDatasourceParamsBuilder withPoolOptions(PoolOptionsWrapper options) {
            this.poolOptions = options;
            return this;
        }

        public SQLDatasourceParamsBuilder withIsGlobalDatasource(boolean isGlobalDatasource) {
            this.isGlobalDatasource = isGlobalDatasource;
            return this;
        }
    }

    public static class SQLDatasourceParams {
        private PoolOptionsWrapper poolOptionsWrapper;
        private String jdbcUrl;
        private String dbType;
        private String username;
        private String password;
        private boolean isGlobalDatasource;
        private MapValue<String, Object> dbOptionsMap;

        private SQLDatasourceParams(SQLDatasourceParamsBuilder builder) {
            this.poolOptionsWrapper = builder.poolOptions;
            this.jdbcUrl = builder.jdbcUrl;
            this.dbType = builder.dbType;
            this.username = builder.username;
            this.password = builder.password;
            this.isGlobalDatasource = builder.isGlobalDatasource;
            this.dbOptionsMap = builder.dbOptionsMap;
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }

        public PoolOptionsWrapper getPoolOptionsWrapper() {
            return this.poolOptionsWrapper;
        }
    }
}

