/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.jdbc.methods;

import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinax.jdbc.datasource.SQLDatasource;
import org.ballerinax.jdbc.statement.BatchUpdateStatement;
import org.ballerinax.jdbc.statement.CallStatement;
import org.ballerinax.jdbc.statement.SelectStatement;
import org.ballerinax.jdbc.statement.UpdateStatement;

public class ExternActions {
    private ExternActions() {
    }

    public static MapValue<String, Object> nativeBatchUpdate(ObjectValue client, String sqlQuery, boolean rollbackAllInFailure, ArrayValue ... parameters) {
        SQLDatasource datasource = (SQLDatasource)client.getNativeData("Client");
        BatchUpdateStatement batchUpdateStatement = new BatchUpdateStatement(client, datasource, sqlQuery, rollbackAllInFailure, Scheduler.getStrand(), parameters);
        return (MapValue)batchUpdateStatement.execute();
    }

    public static Object nativeCall(ObjectValue client, String sqlQuery, Object recordType, ArrayValue parameters) {
        SQLDatasource datasource = (SQLDatasource)client.getNativeData("Client");
        CallStatement callStatement = new CallStatement(client, datasource, sqlQuery, (ArrayValue)recordType, parameters, Scheduler.getStrand());
        return callStatement.execute();
    }

    public static Object nativeSelect(ObjectValue client, String query, Object recordType, ArrayValue parameters) {
        SQLDatasource sqlDatasource = (SQLDatasource)client.getNativeData("Client");
        SelectStatement selectStatement = new SelectStatement(client, sqlDatasource, query, parameters, (TypedescValue)recordType, Scheduler.getStrand());
        return selectStatement.execute();
    }

    public static Object nativeUpdate(ObjectValue client, String query, ArrayValue parameters) {
        SQLDatasource sqlDatasource = (SQLDatasource)client.getNativeData("Client");
        UpdateStatement updateStatement = new UpdateStatement(client, sqlDatasource, query, parameters, Scheduler.getStrand());
        return updateStatement.execute();
    }
}

