/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.jdbc.statement;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinax.jdbc.exceptions.ApplicationException;
import org.ballerinax.jdbc.statement.StatementProcessUtils;

class ProcessedStatement {
    private Connection conn;
    private PreparedStatement stmt;
    private ArrayValue params;
    private String databaseProductName;
    private Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private static final String POSTGRES_DOUBLE = "float8";
    private static final int ORACLE_CURSOR_TYPE = -10;

    ProcessedStatement(Connection conn, PreparedStatement stmt, ArrayValue generatedParams, String databaseProductName) {
        this.conn = conn;
        this.stmt = stmt;
        this.params = generatedParams;
        this.databaseProductName = databaseProductName;
    }

    PreparedStatement prepare() throws ApplicationException, SQLException {
        if (this.params == null) {
            return null;
        }
        int paramCount = this.params.size();
        int currentOrdinal = 0;
        for (int index = 0; index < paramCount; ++index) {
            MapValue paramRecord = (MapValue)this.params.getRefValue((long)index);
            if (paramRecord != null) {
                String sqlType = StatementProcessUtils.getSQLType((MapValue<String, Object>)paramRecord);
                Object value = paramRecord.get((Object)"value");
                BType type = TypeChecker.getType((Object)value);
                int direction = StatementProcessUtils.getParameterDirection((MapValue<String, Object>)paramRecord);
                if (value != null && type.getTag() == 20 && ((BArrayType)type).getElementType().getTag() != 2 && !"ARRAY".equalsIgnoreCase(sqlType)) {
                    int arrayLength = ((ArrayValue)value).size();
                    int typeTagOfArrayElement = ((BArrayType)type).getElementType().getTag();
                    for (int i = 0; i < arrayLength; ++i) {
                        Object paramValue;
                        switch (typeTagOfArrayElement) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                paramValue = ((ArrayValue)value).get((long)i);
                                break;
                            }
                            case 20: {
                                Object array = ((ArrayValue)value).get((long)i);
                                BType arrayElementType = TypeChecker.getType((Object)array);
                                if (((BArrayType)arrayElementType).getElementType().getTag() == 2) {
                                    paramValue = array;
                                    break;
                                }
                                throw new ApplicationException("unsupported array type specified as a parameter at index " + index + " and array element type being an array is supported only when the inner array element type is BYTE");
                            }
                            default: {
                                throw new ApplicationException("unsupported array type specified as a parameter at index " + index);
                            }
                        }
                        if ("REFCURSOR".equals(sqlType) || "BLOB".equals(sqlType)) {
                            this.setParameter(this.conn, this.stmt, sqlType, paramValue, direction, currentOrdinal, this.databaseProductName);
                        } else {
                            this.setParameter(this.conn, this.stmt, sqlType, paramValue, direction, currentOrdinal);
                        }
                        ++currentOrdinal;
                    }
                    continue;
                }
                if ("REFCURSOR".equals(sqlType) || "ARRAY".equals(sqlType) || "BLOB".equals(sqlType)) {
                    this.setParameter(this.conn, this.stmt, sqlType, value, direction, currentOrdinal, this.databaseProductName);
                } else {
                    this.setParameter(this.conn, this.stmt, sqlType, value, direction, currentOrdinal);
                }
                ++currentOrdinal;
                continue;
            }
            this.setNullObject(this.stmt, index);
            ++currentOrdinal;
        }
        return this.stmt;
    }

    private void setParameter(Connection conn, PreparedStatement stmt, String sqlType, Object value, int direction, int index) throws SQLException, ApplicationException {
        this.setParameter(conn, stmt, sqlType, value, direction, index, null);
    }

    private void setParameter(Connection conn, PreparedStatement stmt, String sqlType, Object value, int direction, int index, String databaseProductName) throws ApplicationException, SQLException {
        if (sqlType == null || sqlType.isEmpty()) {
            this.setStringValue(stmt, value, index, direction, 12);
        } else {
            String sqlDataType;
            switch (sqlDataType = sqlType.toUpperCase(Locale.getDefault())) {
                case "SMALLINT": 
                case "TINYINT": {
                    this.setSmallIntValue(stmt, value, index, direction);
                    break;
                }
                case "VARCHAR": {
                    this.setStringValue(stmt, value, index, direction, 12);
                    break;
                }
                case "CHAR": {
                    this.setStringValue(stmt, value, index, direction, 1);
                    break;
                }
                case "LONGVARCHAR": {
                    this.setStringValue(stmt, value, index, direction, -1);
                    break;
                }
                case "NCHAR": {
                    this.setNStringValue(stmt, value, index, direction, -15);
                    break;
                }
                case "NVARCHAR": {
                    this.setNStringValue(stmt, value, index, direction, -9);
                    break;
                }
                case "LONGNVARCHAR": {
                    this.setNStringValue(stmt, value, index, direction, -16);
                    break;
                }
                case "DOUBLE": {
                    this.setDoubleValue(stmt, value, index, direction);
                    break;
                }
                case "NUMERIC": {
                    this.setNumericValue(stmt, value, index, direction, 2);
                    break;
                }
                case "DECIMAL": {
                    this.setNumericValue(stmt, value, index, direction, 3);
                    break;
                }
                case "BIT": 
                case "BOOLEAN": {
                    this.setBooleanValue(stmt, value, index, direction);
                    break;
                }
                case "BIGINT": {
                    this.setBigIntValue(stmt, value, index, direction);
                    break;
                }
                case "INTEGER": {
                    this.setIntValue(stmt, value, index, direction);
                    break;
                }
                case "REAL": {
                    this.setRealValue(stmt, value, index, direction, 7);
                    break;
                }
                case "FLOAT": {
                    this.setRealValue(stmt, value, index, direction, 6);
                    break;
                }
                case "DATE": {
                    this.setDateValue(stmt, value, index, direction);
                    break;
                }
                case "TIMESTAMP": 
                case "DATETIME": {
                    this.setTimeStampValue(stmt, value, index, direction, this.utcCalendar);
                    break;
                }
                case "TIME": {
                    this.setTimeValue(stmt, value, index, direction, this.utcCalendar);
                    break;
                }
                case "BINARY": {
                    this.setBinaryValue(stmt, value, index, direction, -2);
                    break;
                }
                case "BLOB": {
                    this.setBlobValue(stmt, value, index, direction, 2004);
                    break;
                }
                case "LONGVARBINARY": {
                    this.setBlobValue(stmt, value, index, direction, -4);
                    break;
                }
                case "VARBINARY": {
                    this.setBinaryValue(stmt, value, index, direction, -3);
                    break;
                }
                case "CLOB": {
                    this.setClobValue(stmt, value, index, direction);
                    break;
                }
                case "NCLOB": {
                    this.setNClobValue(stmt, value, index, direction);
                    break;
                }
                case "ARRAY": {
                    this.setArrayValue(conn, stmt, value, index, direction, databaseProductName);
                    break;
                }
                case "STRUCT": {
                    this.setUserDefinedValue(conn, stmt, value, index, direction);
                    break;
                }
                case "REFCURSOR": {
                    this.setRefCursorValue(stmt, index, direction, databaseProductName);
                    break;
                }
                default: {
                    throw new ApplicationException("unsupported data type " + sqlType + " specified as a parameter at index " + index);
                }
            }
        }
    }

    private void setIntValue(PreparedStatement stmt, Object value, int index, int direction) throws SQLException, ApplicationException {
        block9: {
            Integer val = ProcessedStatement.obtainIntegerValue(value);
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, 4);
                    } else {
                        stmt.setInt(index + 1, val);
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, 4);
                    } else {
                        stmt.setInt(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 4);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 4);
                    break block9;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting integer value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private void setSmallIntValue(PreparedStatement stmt, Object value, int index, int direction) throws ApplicationException, SQLException {
        block9: {
            Integer val = ProcessedStatement.obtainIntegerValue(value);
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, 5);
                    } else {
                        stmt.setShort(index + 1, val.shortValue());
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, 5);
                    } else {
                        stmt.setShort(index + 1, val.shortValue());
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 5);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 5);
                    break block9;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting integer value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private void setStringValue(PreparedStatement stmt, Object value, int index, int direction, int sqlType) throws ApplicationException, SQLException {
        block9: {
            try {
                if (0 == direction) {
                    if (value == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setString(index + 1, (String)value);
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (value == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setString(index + 1, (String)value);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting string value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private void setNStringValue(PreparedStatement stmt, Object value, int index, int direction, int sqlType) throws ApplicationException, SQLException {
        block9: {
            try {
                if (0 == direction) {
                    if (value == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setNString(index + 1, (String)value);
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (value == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setNString(index + 1, (String)value);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting string value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private void setDoubleValue(PreparedStatement stmt, Object value, int index, int direction) throws ApplicationException, SQLException {
        block16: {
            Double val = null;
            if (value != null) {
                BType type = TypeChecker.getType((Object)value);
                switch (type.getTag()) {
                    case 3: {
                        val = (Double)value;
                        break;
                    }
                    case 1: 
                    case 2: {
                        val = ((Long)value).doubleValue();
                        break;
                    }
                    case 4: {
                        val = ((DecimalValue)value).value().doubleValue();
                        break;
                    }
                    case 5: {
                        val = Double.parseDouble((String)value);
                        break;
                    }
                    default: {
                        throw new ApplicationException("invalid input value \"" + value.toString() + "\" specified for double");
                    }
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, 8);
                    } else {
                        stmt.setDouble(index + 1, val);
                    }
                    break block16;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, 8);
                    } else {
                        stmt.setDouble(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 8);
                    break block16;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 8);
                    break block16;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting double value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private void setNumericValue(PreparedStatement stmt, Object value, int index, int direction, int sqlType) throws ApplicationException, SQLException {
        block16: {
            BigDecimal val = null;
            if (value != null) {
                BType type = TypeChecker.getType((Object)value);
                switch (type.getTag()) {
                    case 4: {
                        val = ((DecimalValue)value).value();
                        break;
                    }
                    case 1: {
                        val = BigDecimal.valueOf((Long)value);
                        break;
                    }
                    case 3: {
                        val = BigDecimal.valueOf((Double)value);
                        break;
                    }
                    case 5: {
                        val = new BigDecimal((String)value);
                        break;
                    }
                    default: {
                        throw new ApplicationException("invalid input value \"" + value.toString() + "\" specified for numeric type");
                    }
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBigDecimal(index + 1, val);
                    }
                    break block16;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBigDecimal(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block16;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block16;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting numeric value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private void setBooleanValue(PreparedStatement stmt, Object value, int index, int direction) throws ApplicationException, SQLException {
        block16: {
            Boolean val = null;
            if (value != null) {
                BType type = TypeChecker.getType((Object)value);
                switch (type.getTag()) {
                    case 6: {
                        val = (Boolean)value;
                        break;
                    }
                    case 5: {
                        val = Boolean.valueOf((String)value);
                        break;
                    }
                    case 1: {
                        Long lVal = (Long)value;
                        if (lVal == 0L || lVal == 1L) {
                            val = lVal == 1L;
                            break;
                        }
                        throw new ApplicationException("invalid integer value \"" + lVal + "\" specified for boolean");
                    }
                    default: {
                        throw new ApplicationException("invalid input value \"" + value.toString() + "\" specified for boolean");
                    }
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, -7);
                    } else {
                        stmt.setBoolean(index + 1, val);
                    }
                    break block16;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, -7);
                    } else {
                        stmt.setBoolean(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, -7);
                    break block16;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, -7);
                    break block16;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting boolean value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private void setBigIntValue(PreparedStatement stmt, Object value, int index, int direction) throws ApplicationException, SQLException {
        block14: {
            Long val = null;
            if (value != null) {
                BType type = TypeChecker.getType((Object)value);
                switch (type.getTag()) {
                    case 1: 
                    case 2: {
                        val = (Long)value;
                        break;
                    }
                    case 5: {
                        val = Long.parseLong((String)value);
                        break;
                    }
                    default: {
                        throw new ApplicationException("invalid input value \"" + value.toString() + "\" specified for bigint");
                    }
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, -5);
                    } else {
                        stmt.setLong(index + 1, val);
                    }
                    break block14;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, -5);
                    } else {
                        stmt.setLong(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, -5);
                    break block14;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, -5);
                    break block14;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting bigint value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private void setRealValue(PreparedStatement stmt, Object value, int index, int direction, int sqlType) throws ApplicationException, SQLException {
        block15: {
            Float val = null;
            if (value != null) {
                BType type = TypeChecker.getType((Object)value);
                switch (type.getTag()) {
                    case 3: {
                        val = Float.valueOf(((Double)value).floatValue());
                        break;
                    }
                    case 1: 
                    case 2: {
                        val = Float.valueOf(((Long)value).floatValue());
                        break;
                    }
                    case 5: {
                        val = Float.valueOf(Float.parseFloat((String)value));
                        break;
                    }
                    default: {
                        throw new ApplicationException("invalid input value \"" + value.toString() + "\" specified for float ");
                    }
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setFloat(index + 1, val.floatValue());
                    }
                    break block15;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setFloat(index + 1, val.floatValue());
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block15;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block15;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting float value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private void setDateValue(PreparedStatement stmt, Object value, int index, int direction) throws ApplicationException, SQLException {
        block16: {
            Date val = null;
            if (value != null) {
                BType type = TypeChecker.getType((Object)value);
                if (value instanceof MapValue && type.getName().equals("Time") && type.getPackage().toString().equals("ballerina/time")) {
                    long timeVal = ((MapValue)value).getIntValue("time");
                    val = new Date(timeVal);
                } else if (type.getTag() == 1) {
                    val = new Date((Long)value);
                } else if (type.getTag() == 5) {
                    val = this.convertToDate((String)value);
                } else {
                    throw new ApplicationException("invalid input type for date parameter at index " + index);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, 91);
                    } else {
                        stmt.setDate(index + 1, val);
                    }
                    break block16;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, 91);
                    } else {
                        stmt.setDate(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 91);
                    break block16;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 91);
                    break block16;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting date value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private Date convertToDate(String source) throws ApplicationException {
        int timeZoneOffSet;
        int day;
        int month;
        int year;
        if (source == null || source.trim().equals("")) {
            return null;
        }
        source = source.trim();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setLenient(false);
        if (source.startsWith("-")) {
            source = source.substring(1);
            calendar.set(0, 0);
        }
        if (source.length() >= 10) {
            if (source.charAt(4) != '-' || source.charAt(7) != '-') {
                throw new ApplicationException("invalid date format " + source + " specified");
            }
            year = Integer.parseInt(source.substring(0, 4));
            month = Integer.parseInt(source.substring(5, 7));
            day = Integer.parseInt(source.substring(8, 10));
            timeZoneOffSet = TimeZone.getDefault().getRawOffset();
            if (source.length() > 10) {
                String restpart = source.substring(10);
                timeZoneOffSet = ProcessedStatement.getTimeZoneOffset(restpart);
                calendar.set(16, 0);
            }
        } else {
            throw new ApplicationException("invalid date string " + source + " to parse");
        }
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(15, timeZoneOffSet);
        return new Date(calendar.getTime().getTime());
    }

    private void setTimeStampValue(PreparedStatement stmt, Object value, int index, int direction, Calendar utcCalendar) throws ApplicationException, SQLException {
        block16: {
            Timestamp val = null;
            if (value != null) {
                BType type = TypeChecker.getType((Object)value);
                if (value instanceof MapValue && type.getName().equals("Time") && type.getPackage().toString().equals("ballerina/time")) {
                    Object timeVal = ((MapValue)value).get((Object)"time");
                    long time = (Long)timeVal;
                    val = new Timestamp(time);
                } else if (value instanceof Long) {
                    val = new Timestamp((Long)value);
                } else if (value instanceof String) {
                    val = this.convertToTimeStamp((String)value);
                } else {
                    throw new ApplicationException("invalid input type specified for timestamp parameter at index " + index);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, 93);
                    } else {
                        stmt.setTimestamp(index + 1, val, utcCalendar);
                    }
                    break block16;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, 93);
                    } else {
                        stmt.setTimestamp(index + 1, val, utcCalendar);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 93);
                    break block16;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 93);
                    break block16;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting timestamp value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private Timestamp convertToTimeStamp(String source) throws ApplicationException {
        int timeZoneOffSet;
        long miliSecond;
        int second;
        int minite;
        int hour;
        int day;
        int month;
        int year;
        if (source == null || source.trim().equals("")) {
            return null;
        }
        source = source.trim();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setLenient(false);
        if (source.startsWith("-")) {
            source = source.substring(1);
            calendar.set(0, 0);
        }
        if (source.length() >= 19) {
            if (source.charAt(4) != '-' || source.charAt(7) != '-' || source.charAt(10) != 'T' || source.charAt(13) != ':' || source.charAt(16) != ':') {
                throw new ApplicationException("invalid datetime format " + source + " specified");
            }
            year = Integer.parseInt(source.substring(0, 4));
            month = Integer.parseInt(source.substring(5, 7));
            day = Integer.parseInt(source.substring(8, 10));
            hour = Integer.parseInt(source.substring(11, 13));
            minite = Integer.parseInt(source.substring(14, 16));
            second = Integer.parseInt(source.substring(17, 19));
            miliSecond = 0L;
            timeZoneOffSet = TimeZone.getDefault().getRawOffset();
            if (source.length() > 19) {
                String rest = source.substring(19);
                int[] offsetData = this.getTimeZoneWithMilliSeconds(rest);
                miliSecond = offsetData[0];
                int calculatedtimeZoneOffSet = offsetData[1];
                if (calculatedtimeZoneOffSet != -1) {
                    timeZoneOffSet = calculatedtimeZoneOffSet;
                }
                calendar.set(16, 0);
            }
        } else {
            throw new ApplicationException("datetime string of " + source + " can not be less than 19 characters");
        }
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minite);
        calendar.set(13, second);
        calendar.set(14, (int)miliSecond);
        calendar.set(15, timeZoneOffSet);
        return new Timestamp(calendar.getTimeInMillis());
    }

    private int[] getTimeZoneWithMilliSeconds(String fractionStr) throws ApplicationException {
        int miliSecond = 0;
        int timeZoneOffSet = -1;
        if (fractionStr.startsWith(".")) {
            int milliSecondPartLength;
            if (fractionStr.endsWith("Z")) {
                timeZoneOffSet = 0;
                String fractionPart = fractionStr.substring(1, fractionStr.lastIndexOf("Z"));
                miliSecond = Integer.parseInt(fractionPart);
                milliSecondPartLength = fractionPart.trim().length();
            } else {
                int lastIndexOfPlus = fractionStr.lastIndexOf("+");
                int lastIndexofMinus = fractionStr.lastIndexOf("-");
                if (lastIndexOfPlus > 0 || lastIndexofMinus > 0) {
                    String fractionPart;
                    String timeOffSetStr;
                    if (lastIndexOfPlus > 0) {
                        timeOffSetStr = fractionStr.substring(lastIndexOfPlus + 1);
                        fractionPart = fractionStr.substring(1, lastIndexOfPlus);
                        miliSecond = Integer.parseInt(fractionPart);
                        milliSecondPartLength = fractionPart.trim().length();
                        timeZoneOffSet = 1;
                    } else {
                        timeOffSetStr = fractionStr.substring(lastIndexofMinus + 1);
                        fractionPart = fractionStr.substring(1, lastIndexofMinus);
                        miliSecond = Integer.parseInt(fractionPart);
                        milliSecondPartLength = fractionPart.trim().length();
                        timeZoneOffSet = -1;
                    }
                    if (timeOffSetStr.charAt(2) != ':') {
                        throw new ApplicationException("invalid time zone format " + fractionStr + " specified");
                    }
                    int hours = Integer.parseInt(timeOffSetStr.substring(0, 2));
                    int minits = Integer.parseInt(timeOffSetStr.substring(3, 5));
                    timeZoneOffSet = (hours * 60 + minits) * 60000 * timeZoneOffSet;
                } else {
                    miliSecond = Integer.parseInt(fractionStr.substring(1));
                    milliSecondPartLength = fractionStr.substring(1).trim().length();
                }
            }
            if (milliSecondPartLength != 3) {
                miliSecond *= 1000;
                for (int i = 0; i < milliSecondPartLength; ++i) {
                    miliSecond /= 10;
                }
            }
        } else {
            timeZoneOffSet = ProcessedStatement.getTimeZoneOffset(fractionStr);
        }
        return new int[]{miliSecond, timeZoneOffSet};
    }

    private static int getTimeZoneOffset(String timezoneStr) throws ApplicationException {
        int timeZoneOffSet;
        if (timezoneStr.startsWith("Z")) {
            timeZoneOffSet = 0;
        } else if (timezoneStr.startsWith("+") || timezoneStr.startsWith("-")) {
            if (timezoneStr.charAt(3) != ':') {
                throw new ApplicationException("invalid time zone format " + timezoneStr + " specified");
            }
            int hours = Integer.parseInt(timezoneStr.substring(1, 3));
            int minits = Integer.parseInt(timezoneStr.substring(4, 6));
            timeZoneOffSet = (hours * 60 + minits) * 60000;
            if (timezoneStr.startsWith("-")) {
                timeZoneOffSet *= -1;
            }
        } else {
            throw new ApplicationException("invalid prefix of " + timezoneStr + " specified for timezone");
        }
        return timeZoneOffSet;
    }

    private void setTimeValue(PreparedStatement stmt, Object value, int index, int direction, Calendar utcCalendar) throws ApplicationException, SQLException {
        block15: {
            Time val = null;
            if (value != null) {
                BType type = TypeChecker.getType((Object)value);
                if (value instanceof MapValue && type.getName().equals("Time") && type.getPackage().toString().equals("ballerina/time")) {
                    Object timeVal = ((MapValue)value).get((Object)"time");
                    long time = (Long)timeVal;
                    val = new Time(time);
                } else if (value instanceof Long) {
                    val = new Time((Long)value);
                } else if (value instanceof String) {
                    val = this.convertToTime((String)value);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, 92);
                    } else {
                        stmt.setTime(index + 1, val, utcCalendar);
                    }
                    break block15;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, 92);
                    } else {
                        stmt.setTime(index + 1, val, utcCalendar);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 92);
                    break block15;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 92);
                    break block15;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting timestamp value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private Time convertToTime(String source) throws ApplicationException {
        int timeZoneOffSet;
        int miliSecond;
        int second;
        int minite;
        int hour;
        if (source == null || source.trim().equals("")) {
            return null;
        }
        source = source.trim();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setLenient(false);
        if (source.length() >= 8) {
            if (source.charAt(2) != ':' || source.charAt(5) != ':') {
                throw new ApplicationException("invalid time format " + source + " specified");
            }
            hour = Integer.parseInt(source.substring(0, 2));
            minite = Integer.parseInt(source.substring(3, 5));
            second = Integer.parseInt(source.substring(6, 8));
            miliSecond = 0;
            timeZoneOffSet = TimeZone.getDefault().getRawOffset();
            if (source.length() > 8) {
                String rest = source.substring(8);
                int[] offsetData = this.getTimeZoneWithMilliSeconds(rest);
                miliSecond = offsetData[0];
                timeZoneOffSet = offsetData[1];
                calendar.set(16, 0);
            }
        } else {
            throw new ApplicationException("time string of " + source + " can not be less than 8 characters");
        }
        calendar.set(11, hour);
        calendar.set(12, minite);
        calendar.set(13, second);
        calendar.set(14, miliSecond);
        calendar.set(15, timeZoneOffSet);
        return new Time(calendar.getTimeInMillis());
    }

    private void setBinaryValue(PreparedStatement stmt, Object value, int index, int direction, int sqlType) throws ApplicationException, SQLException {
        block9: {
            byte[] val = this.getByteArray(value);
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBinaryStream(index + 1, (InputStream)new ByteArrayInputStream(val), val.length);
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBinaryStream(index + 1, (InputStream)new ByteArrayInputStream(val), val.length);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting binary value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private void setBlobValue(PreparedStatement stmt, Object value, int index, int direction, int sqlType) throws ApplicationException, SQLException {
        block9: {
            byte[] val = this.getByteArray(value);
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBlob(index + 1, new ByteArrayInputStream(val), val.length);
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBlob(index + 1, new ByteArrayInputStream(val), val.length);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting binary value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private static Integer obtainIntegerValue(Object value) throws ApplicationException {
        if (value != null) {
            BType type = TypeChecker.getType((Object)value);
            switch (type.getTag()) {
                case 1: 
                case 2: {
                    return ((Long)value).intValue();
                }
                case 5: {
                    return Integer.parseInt((String)value);
                }
            }
            throw new ApplicationException("invalid value \"" + value.toString() + "\" specified for integer ");
        }
        return null;
    }

    private byte[] getByteArray(Object value) throws ApplicationException {
        byte[] val = null;
        if (value instanceof ArrayValue) {
            val = ((ArrayValue)value).getBytes();
            val = Arrays.copyOfRange(val, 0, ((ArrayValue)value).size());
        } else if (value instanceof String) {
            val = this.getBytesFromBase64String((String)value);
        }
        return val;
    }

    private byte[] getBytesFromBase64String(String base64Str) throws ApplicationException {
        try {
            return Base64.getDecoder().decode(base64Str.getBytes(Charset.defaultCharset()));
        }
        catch (Exception e) {
            throw new ApplicationException("error while processing base64 string", e.getMessage());
        }
    }

    private void setClobValue(PreparedStatement stmt, Object value, int index, int direction) throws ApplicationException, SQLException {
        block10: {
            BufferedReader val = null;
            if (value != null) {
                val = new BufferedReader(new StringReader((String)value));
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, 2005);
                    } else {
                        stmt.setClob(index + 1, val, ((String)value).length());
                    }
                    break block10;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, 2005);
                    } else {
                        stmt.setClob(index + 1, val, ((String)value).length());
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 2005);
                    break block10;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 2005);
                    break block10;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting binary value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private void setNClobValue(PreparedStatement stmt, Object value, int index, int direction) throws ApplicationException, SQLException {
        block10: {
            BufferedReader val = null;
            if (value != null) {
                val = new BufferedReader(new StringReader((String)value));
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, 2011);
                    } else {
                        stmt.setNClob(index + 1, val, ((String)value).length());
                    }
                    break block10;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, 2011);
                    } else {
                        stmt.setNClob(index + 1, val, ((String)value).length());
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 2011);
                    break block10;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 2011);
                    break block10;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting binary value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private void setRefCursorValue(PreparedStatement stmt, int index, int direction, String databaseProductName) throws ApplicationException, SQLException {
        block5: {
            try {
                if (1 == direction) {
                    if ("oracle".equals(databaseProductName)) {
                        ((CallableStatement)stmt).registerOutParameter(index + 1, -10);
                    } else {
                        ((CallableStatement)stmt).registerOutParameter(index + 1, 2012);
                    }
                    break block5;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting ref cursor value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private void setArrayValue(Connection conn, PreparedStatement stmt, Object value, int index, int direction, String databaseProductName) throws ApplicationException, SQLException {
        block5: {
            Object[] arrayData = ProcessedStatement.getArrayData(value);
            Object[] arrayValue = (Object[])arrayData[0];
            String structuredSQLType = (String)arrayData[1];
            try {
                if (0 == direction) {
                    this.setArrayValue(arrayValue, conn, stmt, index, databaseProductName, structuredSQLType);
                    break block5;
                }
                if (2 == direction) {
                    this.setArrayValue(arrayValue, conn, stmt, index, databaseProductName, structuredSQLType);
                    this.registerArrayOutParameter(stmt, index, structuredSQLType, databaseProductName);
                    break block5;
                }
                if (1 == direction) {
                    this.registerArrayOutParameter(stmt, index, structuredSQLType, databaseProductName);
                    break block5;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting array value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private void registerArrayOutParameter(PreparedStatement stmt, int index, String structuredSQLType, String databaseProductName) throws SQLException {
        if (databaseProductName.equals("postgresql")) {
            ((CallableStatement)stmt).registerOutParameter(index + 1, 2003);
        } else {
            ((CallableStatement)stmt).registerOutParameter(index + 1, 2003, structuredSQLType);
        }
    }

    private void setArrayValue(Object[] arrayValue, Connection conn, PreparedStatement stmt, int index, String databaseProductName, String structuredSQLType) throws SQLException {
        if (arrayValue == null) {
            stmt.setNull(index + 1, 2003);
        } else {
            if ("DOUBLE".equals(structuredSQLType) && "postgresql".equals(databaseProductName)) {
                structuredSQLType = POSTGRES_DOUBLE;
            }
            Array array = conn.createArrayOf(structuredSQLType, arrayValue);
            stmt.setArray(index + 1, array);
        }
    }

    private void setNullObject(PreparedStatement stmt, int index) throws SQLException {
        try {
            stmt.setObject(index + 1, null);
        }
        catch (SQLException e) {
            throw new SQLException("error while setting null value to the parameter at index " + index + ". " + e.getMessage(), e.getSQLState(), e.getErrorCode());
        }
    }

    private static Object[] getArrayData(Object value) throws ApplicationException {
        BType type = TypeChecker.getType((Object)value);
        if (value == null || type.getTag() != 20) {
            return new Object[]{null, null};
        }
        BType elementType = ((BArrayType)type).getElementType();
        int typeTag = elementType.getTag();
        switch (typeTag) {
            case 1: {
                int arrayLength = ((ArrayValue)value).size();
                Long[] arrayData = new Long[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((ArrayValue)value).getInt((long)i);
                }
                return new Object[]{arrayData, "BIGINT"};
            }
            case 3: {
                int arrayLength = ((ArrayValue)value).size();
                Double[] arrayData = new Double[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((ArrayValue)value).getFloat((long)i);
                }
                return new Object[]{arrayData, "DOUBLE"};
            }
            case 4: {
                int arrayLength = ((ArrayValue)value).size();
                BigDecimal[] arrayData = new BigDecimal[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((DecimalValue)((ArrayValue)value).getRefValue((long)i)).value();
                }
                return new Object[]{arrayData, "DECIMAL"};
            }
            case 5: {
                int arrayLength = ((ArrayValue)value).size();
                String[] arrayData = new String[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((ArrayValue)value).getString((long)i);
                }
                return new Object[]{arrayData, "VARCHAR"};
            }
            case 6: {
                int arrayLength = ((ArrayValue)value).size();
                Boolean[] arrayData = new Boolean[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((ArrayValue)value).getBoolean((long)i);
                }
                return new Object[]{arrayData, "BOOLEAN"};
            }
            case 20: {
                BType elementTypeOfArrayElement = ((BArrayType)elementType).getElementType();
                if (elementTypeOfArrayElement.getTag() == 2) {
                    int arrayLength = ((ArrayValue)value).size();
                    Blob[] arrayData = new Blob[arrayLength];
                    for (int i = 0; i < arrayLength; ++i) {
                        arrayData[i] = ((ArrayValue)value).getByte((long)i);
                    }
                    return new Object[]{arrayData, "BLOB"};
                }
                throw new ApplicationException("unsupported data type specified as an array parameter");
            }
        }
        throw new ApplicationException("unsupported data type specified as an array parameter");
    }

    private void setUserDefinedValue(Connection conn, PreparedStatement stmt, Object value, int index, int direction) throws ApplicationException, SQLException {
        block9: {
            try {
                Object[] structData = this.getStructData(value, conn);
                Object[] dataArray = (Object[])structData[0];
                String structuredSQLType = (String)structData[1];
                if (0 == direction) {
                    if (dataArray == null) {
                        stmt.setNull(index + 1, 2002);
                    } else {
                        Struct struct = conn.createStruct(structuredSQLType, dataArray);
                        stmt.setObject(index + 1, struct);
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (dataArray == null) {
                        stmt.setNull(index + 1, 2002);
                    } else {
                        Struct struct = conn.createStruct(structuredSQLType, dataArray);
                        stmt.setObject(index + 1, struct);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 2002, structuredSQLType);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, 2002, structuredSQLType);
                    break block9;
                }
                throw new ApplicationException("invalid direction specified in the jdbc:Parameter at index " + index);
            }
            catch (SQLException e) {
                throw new SQLException("error while setting struct value to statement. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
    }

    private Object[] getStructData(Object value, Connection conn) throws SQLException, ApplicationException {
        BType type = TypeChecker.getType((Object)value);
        if (value == null || type.getTag() != 34 && type.getTag() != 12) {
            return new Object[]{null, null};
        }
        String structuredSQLType = type.getName().toUpperCase(Locale.getDefault());
        Map structFields = ((BStructureType)type).getFields();
        int fieldCount = structFields.size();
        Object[] structData = new Object[fieldCount];
        Iterator fieldIterator = structFields.values().iterator();
        block5: for (int i = 0; i < fieldCount; ++i) {
            BField field = (BField)fieldIterator.next();
            Object bValue = ((MapValue)value).get((Object)field.getFieldName());
            int typeTag = field.getFieldType().getTag();
            switch (typeTag) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    structData[i] = bValue;
                    continue block5;
                }
                case 20: {
                    BType elementType = ((BArrayType)field.getFieldType()).getElementType();
                    if (elementType.getTag() == 2) {
                        structData[i] = ((ArrayValue)bValue).getBytes();
                        continue block5;
                    }
                    throw new ApplicationException("unsupported data type of " + structuredSQLType + " specified for struct parameter");
                }
                case 12: {
                    Object structValue = bValue;
                    Object[] internalStructData = this.getStructData(structValue, conn);
                    Object[] dataArray = (Object[])internalStructData[0];
                    String internalStructType = (String)internalStructData[1];
                    structData[i] = structValue = conn.createStruct(internalStructType, dataArray);
                    continue block5;
                }
                default: {
                    throw new ApplicationException("unsupported data type of " + structuredSQLType + " specified for struct parameter");
                }
            }
        }
        return new Object[]{structData, structuredSQLType};
    }
}

