/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.jdbc.statement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.ballerinalang.jvm.ColumnDefinition;
import org.ballerinalang.jvm.TableResourceManager;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinax.jdbc.datasource.SQLDatasource;
import org.ballerinax.jdbc.exceptions.ApplicationException;
import org.ballerinax.jdbc.exceptions.ErrorGenerator;
import org.ballerinax.jdbc.statement.AbstractSQLStatement;
import org.ballerinax.jdbc.statement.ProcessedStatement;

public class SelectStatement
extends AbstractSQLStatement {
    private final ObjectValue client;
    private final SQLDatasource datasource;
    private final String query;
    private final ArrayValue parameters;
    private final BStructureType structType;

    public SelectStatement(ObjectValue client, SQLDatasource datasource, String query, ArrayValue parameters, TypedescValue recordType, Strand strand) {
        super(strand);
        this.client = client;
        this.datasource = datasource;
        this.query = query;
        this.parameters = parameters;
        this.structType = recordType != null ? (BStructureType)recordType.getDescribingType() : null;
    }

    @Override
    public Object execute() {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.checkAndObserveSQLAction(this.strand, this.datasource, this.query);
        String errorMessagePrefix = "failed to execute select query: ";
        try {
            ArrayValue generatedParams = this.constructParameters(this.parameters);
            conn = this.getDatabaseConnection(this.strand, this.client, this.datasource);
            String processedQuery = this.createProcessedQueryString(this.query, generatedParams);
            stmt = this.getPreparedStatement(conn, this.datasource, processedQuery);
            ProcessedStatement processedStatement = new ProcessedStatement(conn, stmt, generatedParams, this.datasource.getDatabaseProductName());
            stmt = processedStatement.prepare();
            rs = stmt.executeQuery();
            TableResourceManager rm = new TableResourceManager(conn, (Statement)stmt, !this.strand.isInTransaction());
            List<ColumnDefinition> columnDefinitions = this.getColumnDefinitions(rs);
            rm.addResultSet(rs);
            return this.constructTable(rm, rs, this.structType, columnDefinitions, this.datasource.getDatabaseProductName());
        }
        catch (SQLException e) {
            this.cleanupResources(rs, stmt, conn, true);
            this.handleErrorOnTransaction(this.strand);
            this.checkAndObserveSQLError(this.strand, "execute query failed: " + e.getMessage());
            return ErrorGenerator.getSQLDatabaseError(e, errorMessagePrefix);
        }
        catch (ApplicationException e) {
            this.cleanupResources(null, stmt, conn, true);
            this.handleErrorOnTransaction(this.strand);
            this.checkAndObserveSQLError(this.strand, "execute query failed: " + e.getMessage());
            return ErrorGenerator.getSQLApplicationError(e, errorMessagePrefix);
        }
    }

    private PreparedStatement getPreparedStatement(Connection conn, SQLDatasource datasource, String query) throws SQLException {
        PreparedStatement stmt;
        boolean mysql = datasource.getDatabaseProductName().contains("mysql");
        if (mysql) {
            stmt = conn.prepareStatement(query, 1003, 1007);
            try {
                stmt.setFetchSize(Integer.MIN_VALUE);
            }
            catch (SQLException e) {
                stmt.close();
            }
        } else {
            stmt = conn.prepareStatement(query);
        }
        return stmt;
    }
}

