/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.jdbc.table;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.ballerinalang.jvm.ColumnDefinition;
import org.ballerinalang.jvm.TableResourceManager;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.TableIterator;
import org.ballerinalang.stdlib.time.util.TimeUtils;
import org.ballerinax.jdbc.datasource.SQLDatasourceUtils;
import org.ballerinax.jdbc.exceptions.ErrorGenerator;
import org.ballerinax.jdbc.exceptions.PanickingApplicationException;

public class SQLDataIterator
extends TableIterator {
    private Calendar utcCalendar;
    private static final String UNASSIGNABLE_UNIONTYPE_EXCEPTION = "corresponding Union type in the record is not an assignable nillable type";
    private static final String MISMATCHING_FIELD_ASSIGNMENT = "trying to assign to a mismatching type";
    private String sourceDatabase;
    private static final String POSTGRES_OID_COLUMN_TYPE_NAME = "oid";
    private ErrorHandlerFunction mismatchingFieldAssignmentHandler = this::handleMismatchingFieldAssignment;
    private ErrorHandlerFunction unassignableUnionTypeAssignmentHandler = this::handleUnAssignableUnionTypeAssignment;

    public SQLDataIterator(TableResourceManager rm, ResultSet rs, Calendar utcCalendar, List<ColumnDefinition> columnDefs, BStructureType structType, String databaseProductName) {
        super(rm, rs, structType, columnDefs);
        this.utcCalendar = utcCalendar;
        this.sourceDatabase = databaseProductName;
    }

    public void close() {
        try {
            if (this.rs != null && !this.rs.isClosed()) {
                this.rs.close();
            }
            this.resourceManager.gracefullyReleaseResources();
            this.rs = null;
        }
        catch (SQLException e) {
            throw ErrorGenerator.getSQLDatabaseError(e);
        }
    }

    public void reset() {
        this.close();
    }

    public String getBlob(int columnIndex) {
        try {
            Blob bValue = this.rs.getBlob(columnIndex);
            return this.rs.wasNull() ? null : SQLDatasourceUtils.getString(bValue);
        }
        catch (SQLException e) {
            throw ErrorGenerator.getSQLDatabaseError(e);
        }
    }

    public MapValue<String, Object> generateNext() {
        if (this.type == null) {
            throw ErrorGenerator.getSQLApplicationError("the expected record type is not specified in the remote function");
        }
        MapValueImpl bStruct = new MapValueImpl((BType)this.type);
        int index = 0;
        String columnName = null;
        int sqlType = -1;
        try {
            BField[] structFields = this.type.getFields().values().toArray(new BField[0]);
            if (this.columnDefs.size() != structFields.length) {
                throw ErrorGenerator.getSQLApplicationError("number of fields in the constraint type is " + (structFields.length > this.columnDefs.size() ? "greater" : "lower") + " than column count of the result set");
            }
            for (ColumnDefinition columnDef : this.columnDefs) {
                if (!(columnDef instanceof SQLColumnDefinition)) continue;
                SQLColumnDefinition def = (SQLColumnDefinition)columnDef;
                columnName = def.getName();
                sqlType = def.getSqlType();
                BField field = structFields[++index - 1];
                BType fieldType = field.getFieldType();
                String fieldName = field.getFieldName();
                switch (sqlType) {
                    case 2003: {
                        Array data = this.rs.getArray(index);
                        this.handleArrayValue((MapValue<String, Object>)bStruct, fieldName, data, fieldType);
                        break;
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: {
                        String sValue = this.rs.getString(index);
                        this.handleStringValue(sValue, fieldName, (MapValue<String, Object>)bStruct, fieldType);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        byte[] binaryValue = this.rs.getBytes(index);
                        this.handleBinaryValue((MapValue<String, Object>)bStruct, fieldName, binaryValue, fieldType);
                        break;
                    }
                    case 2004: {
                        Blob blobValue = this.rs.getBlob(index);
                        this.handleBinaryValue((MapValue<String, Object>)bStruct, fieldName, blobValue == null ? null : blobValue.getBytes(1L, (int)blobValue.length()), fieldType);
                        break;
                    }
                    case 2005: {
                        String clobValue = SQLDatasourceUtils.getString(this.rs.getClob(index));
                        this.handleStringValue(clobValue, fieldName, (MapValue<String, Object>)bStruct, fieldType);
                        break;
                    }
                    case 2011: {
                        String nClobValue = SQLDatasourceUtils.getString(this.rs.getNClob(index));
                        this.handleStringValue(nClobValue, fieldName, (MapValue<String, Object>)bStruct, fieldType);
                        break;
                    }
                    case 91: {
                        Date date = this.rs.getDate(index);
                        this.handleDateValue((MapValue<String, Object>)bStruct, fieldName, date, fieldType);
                        break;
                    }
                    case 92: 
                    case 2013: {
                        Time time = this.rs.getTime(index, this.utcCalendar);
                        this.handleDateValue((MapValue<String, Object>)bStruct, fieldName, time, fieldType);
                        break;
                    }
                    case 93: 
                    case 2014: {
                        Timestamp timestamp = this.rs.getTimestamp(index, this.utcCalendar);
                        this.handleDateValue((MapValue<String, Object>)bStruct, fieldName, timestamp, fieldType);
                        break;
                    }
                    case -8: {
                        String sValue = new String(this.rs.getRowId(index).getBytes(), StandardCharsets.UTF_8);
                        this.handleStringValue(sValue, fieldName, (MapValue<String, Object>)bStruct, fieldType);
                        break;
                    }
                    case -6: 
                    case 5: {
                        long iValue = this.rs.getInt(index);
                        this.handleLongValue(iValue, (MapValue<String, Object>)bStruct, fieldName, fieldType);
                        break;
                    }
                    case -5: 
                    case 4: {
                        if (this.sourceDatabase.equalsIgnoreCase("postgresql")) {
                            boolean isOID = this.rs.getMetaData().getColumnTypeName(index).equalsIgnoreCase(POSTGRES_OID_COLUMN_TYPE_NAME);
                            if (isOID) {
                                this.handleOIDValue(index, (MapValue<String, Object>)bStruct, fieldName, fieldType);
                                break;
                            }
                            long lValue = this.rs.getLong(index);
                            this.handleLongValue(lValue, (MapValue<String, Object>)bStruct, fieldName, fieldType);
                            break;
                        }
                        long lValue = this.rs.getLong(index);
                        this.handleLongValue(lValue, (MapValue<String, Object>)bStruct, fieldName, fieldType);
                        break;
                    }
                    case 6: 
                    case 7: {
                        double fValue = this.rs.getFloat(index);
                        this.handleDoubleValue(fValue, (MapValue<String, Object>)bStruct, fieldName, fieldType);
                        break;
                    }
                    case 8: {
                        double dValue = this.rs.getDouble(index);
                        this.handleDoubleValue(dValue, (MapValue<String, Object>)bStruct, fieldName, fieldType);
                        break;
                    }
                    case 2: 
                    case 3: {
                        BigDecimal bigDecimalValue = this.rs.getBigDecimal(index);
                        this.handleDecimalValue(bigDecimalValue, (MapValue<String, Object>)bStruct, fieldName, fieldType);
                        break;
                    }
                    case -7: 
                    case 16: {
                        boolean boolValue = this.rs.getBoolean(index);
                        this.handleBooleanValue((MapValue<String, Object>)bStruct, fieldName, boolValue, fieldType);
                        break;
                    }
                    case 2002: {
                        Struct structData = (Struct)this.rs.getObject(index);
                        this.handleStructValue((MapValue<String, Object>)bStruct, fieldName, structData, fieldType);
                        break;
                    }
                    default: {
                        throw ErrorGenerator.getSQLApplicationError("unsupported sql type " + sqlType + " found for the column " + columnName + " at index " + index);
                    }
                }
            }
        }
        catch (IOException | SQLException e) {
            throw ErrorGenerator.getSQLApplicationError("error while retrieving next value for column " + columnName + " of SQL Type " + sqlType + " at index " + index + ", " + e.getMessage());
        }
        catch (PanickingApplicationException e) {
            throw ErrorGenerator.getSQLApplicationError(e);
        }
        return bStruct;
    }

    private void validateAndSetRefRecordField(MapValue<String, Object> bStruct, String fieldName, int expectedTypeTag, int actualTypeTag, Object value, String exceptionMessage) throws PanickingApplicationException {
        this.setMatchingRefRecordField(bStruct, fieldName, value, expectedTypeTag == actualTypeTag, exceptionMessage);
    }

    private void validateAndSetRefRecordField(MapValue<String, Object> bStruct, String fieldName, int[] expectedTypeTags, int actualTypeTag, Object value, String exceptionMessage) throws PanickingApplicationException {
        boolean typeMatches = Arrays.stream(expectedTypeTags).anyMatch(tag -> actualTypeTag == tag);
        this.setMatchingRefRecordField(bStruct, fieldName, value, typeMatches, exceptionMessage);
    }

    private void setMatchingRefRecordField(MapValue<String, Object> bStruct, String fieldName, Object value, boolean typeMatches, String exceptionMessage) throws PanickingApplicationException {
        if (!typeMatches) {
            throw new PanickingApplicationException(exceptionMessage);
        }
        bStruct.put((Object)fieldName, value);
    }

    private void validateAndSetDecimalValue(MapValue<String, Object> bStruct, String fieldName, int actualTypeTag, DecimalValue value, String exceptionMessage) throws PanickingApplicationException {
        boolean typeMatches = this.isValidType(actualTypeTag, value);
        this.setMatchingRefRecordField(bStruct, fieldName, value, typeMatches, exceptionMessage);
    }

    private boolean isValidType(int actualTypeTag, DecimalValue value) {
        if (actualTypeTag == 4) {
            return true;
        }
        if (actualTypeTag == 1) {
            return value == null || value.value().scale() == 0;
        }
        return false;
    }

    private void handleNilToNonNillableFieldAssignment() throws PanickingApplicationException {
        throw new PanickingApplicationException("trying to assign a Nil value to a non-nillable field");
    }

    private void handleMismatchingFieldAssignment() throws PanickingApplicationException {
        throw new PanickingApplicationException(MISMATCHING_FIELD_ASSIGNMENT);
    }

    private void handleUnAssignableUnionTypeAssignment() throws PanickingApplicationException {
        throw new PanickingApplicationException(UNASSIGNABLE_UNIONTYPE_EXCEPTION);
    }

    private int retrieveNonNilTypeTag(BType fieldType) throws PanickingApplicationException {
        List members = ((BUnionType)fieldType).getMemberTypes();
        return this.retrieveNonNilType(members).getTag();
    }

    private MapValue<String, Object> createTimeStruct(long millis) {
        return TimeUtils.createTimeRecord((MapValue)TimeUtils.getTimeZoneRecord(), (MapValue)TimeUtils.getTimeRecord(), (long)millis, (String)"UTC");
    }

    private MapValue<String, Object> createUserDefinedType(Struct structValue, BStructureType structType) throws PanickingApplicationException {
        if (structValue == null) {
            return null;
        }
        BField[] internalStructFields = structType.getFields().values().toArray(new BField[0]);
        MapValueImpl struct = new MapValueImpl((BType)structType);
        try {
            Object[] dataArray = structValue.getAttributes();
            if (dataArray != null) {
                if (dataArray.length != internalStructFields.length) {
                    throw new PanickingApplicationException("specified record and the returned record types are not compatible");
                }
                int index = 0;
                for (BField internalField : internalStructFields) {
                    int type = internalField.getFieldType().getTag();
                    String fieldName = internalField.getFieldName();
                    Object value = dataArray[index];
                    switch (type) {
                        case 1: {
                            if (value instanceof BigDecimal) {
                                struct.put((Object)fieldName, (Object)((BigDecimal)value).intValue());
                                break;
                            }
                            struct.put((Object)fieldName, value);
                            break;
                        }
                        case 3: {
                            if (value instanceof BigDecimal) {
                                struct.put((Object)fieldName, (Object)((BigDecimal)value).doubleValue());
                                break;
                            }
                            struct.put((Object)fieldName, value);
                            break;
                        }
                        case 4: {
                            if (value instanceof BigDecimal) {
                                struct.put((Object)fieldName, value);
                                break;
                            }
                            struct.put((Object)fieldName, (Object)new DecimalValue((BigDecimal)value));
                            break;
                        }
                        case 5: {
                            struct.put((Object)fieldName, value);
                            break;
                        }
                        case 6: {
                            struct.put((Object)fieldName, (Object)((Integer)value == 1 ? 1 : 0));
                            break;
                        }
                        case 12: 
                        case 34: {
                            struct.put((Object)fieldName, this.createUserDefinedType((Struct)value, (BStructureType)internalField.getFieldType()));
                            break;
                        }
                        default: {
                            throw new PanickingApplicationException("error while retrieving UDT data for unsupported type " + type);
                        }
                    }
                    ++index;
                }
            }
        }
        catch (SQLException e) {
            throw new PanickingApplicationException("error while retrieving UDT data: " + e.getMessage());
        }
        return struct;
    }

    private void handleArrayValue(MapValue<String, Object> bStruct, String fieldName, Array data, BType fieldType) throws SQLException, PanickingApplicationException {
        int fieldTypeTag = fieldType.getTag();
        ArrayValue dataArray = this.getDataArray(data);
        if (dataArray != null) {
            BType nonNilType = fieldType;
            if (fieldTypeTag == 21) {
                nonNilType = this.retrieveNonNilType(((BUnionType)fieldType).getMemberTypes());
            }
            boolean containsNull = dataArray.getType().getTag() == 20 && ((BArrayType)dataArray.getType()).getElementType().getTag() == 21;
            this.handleMappingArrayValue(nonNilType, bStruct, dataArray, fieldName, containsNull);
        } else if (fieldTypeTag == 21) {
            bStruct.put((Object)fieldName, null);
        } else {
            this.handleNilToNonNillableFieldAssignment();
        }
    }

    private void handleMappingArrayValue(BType nonNilType, MapValue<String, Object> bStruct, ArrayValue dataArray, String fieldName, boolean containsNull) throws PanickingApplicationException {
        if (nonNilType.getTag() == 20) {
            BArrayType expectedArrayType = (BArrayType)nonNilType;
            if (((BArrayType)nonNilType).getElementType().getTag() == 21) {
                this.handleMappingArrayElementToUnionType(expectedArrayType, dataArray, fieldName, bStruct);
            } else {
                this.handleMappingArrayElementToNonUnionType(containsNull, nonNilType, dataArray, bStruct, fieldName);
            }
        } else {
            this.handleMismatchingFieldAssignment();
        }
    }

    private void handleMappingArrayElementToNonUnionType(boolean containsNull, BType nonNilType, ArrayValue newArray, MapValue<String, Object> bStruct, String fieldName) throws PanickingApplicationException {
        if (containsNull) {
            throw new PanickingApplicationException("trying to assign an array containing NULL values to an array of a non-nillable element type");
        }
        int expectedTypeTag = ((BArrayType)nonNilType).getElementType().getTag();
        int actualTypeTag = newArray.getType().getTag() == 4 ? 4 : ((BArrayType)newArray.getType()).getElementType().getTag();
        this.validateAndSetRefRecordField(bStruct, fieldName, expectedTypeTag, actualTypeTag, (Object)newArray, MISMATCHING_FIELD_ASSIGNMENT);
    }

    private void handleMappingArrayElementToUnionType(BArrayType expectedArrayType, ArrayValue arrayTobeSet, String fieldName, MapValue<String, Object> bStruct) throws PanickingApplicationException {
        BType arrayType = arrayTobeSet.getType().getTag() == 4 ? BTypes.typeDecimal : ((BArrayType)arrayTobeSet.getType()).getElementType();
        if (arrayType.getTag() == 10) {
            bStruct.put((Object)fieldName, (Object)arrayTobeSet);
        } else {
            BUnionType expectedArrayElementUnionType = (BUnionType)expectedArrayType.getElementType();
            BType expectedNonNilArrayElementType = this.retrieveNonNilType(expectedArrayElementUnionType.getMemberTypes());
            BType actualNonNilArrayElementType = this.getActualNonNilArrayElementType(arrayType);
            this.validateAndSetRefRecordField(bStruct, fieldName, expectedNonNilArrayElementType.getTag(), actualNonNilArrayElementType.getTag(), (Object)arrayTobeSet, UNASSIGNABLE_UNIONTYPE_EXCEPTION);
        }
    }

    private BType getActualNonNilArrayElementType(BType actualArrayElementType) {
        if (actualArrayElementType.getTag() == 21) {
            return (BType)((BUnionType)actualArrayElementType).getMemberTypes().get(0);
        }
        return actualArrayElementType;
    }

    private BType retrieveNonNilType(List<BType> members) throws PanickingApplicationException {
        if (members.size() != 2) {
            throw new PanickingApplicationException(UNASSIGNABLE_UNIONTYPE_EXCEPTION);
        }
        if (members.get(0).getTag() == 10) {
            return members.get(1);
        }
        if (members.get(1).getTag() == 10) {
            return members.get(0);
        }
        throw new PanickingApplicationException(UNASSIGNABLE_UNIONTYPE_EXCEPTION);
    }

    private void handleStructValue(MapValue<String, Object> bStruct, String fieldName, Struct structData, BType fieldType) throws PanickingApplicationException {
        int fieldTypeTag = fieldType.getTag();
        if (fieldTypeTag == 21) {
            BType structFieldType = this.retrieveNonNilType(((BUnionType)fieldType).getMemberTypes());
            if (structFieldType.getTag() == 12) {
                MapValue<String, Object> userDefinedType = this.createUserDefinedType(structData, (BStructureType)((BRecordType)structFieldType));
                bStruct.put((Object)fieldName, userDefinedType);
            } else {
                this.handleUnAssignableUnionTypeAssignment();
            }
        } else if (fieldTypeTag == 12) {
            this.validateAndSetRefRecordField(bStruct, fieldName, 12, fieldTypeTag, this.createUserDefinedType(structData, (BStructureType)((BRecordType)fieldType)), MISMATCHING_FIELD_ASSIGNMENT);
        } else {
            this.handleMismatchingFieldAssignment();
        }
    }

    private void handleBooleanValue(MapValue<String, Object> bStruct, String fieldName, boolean boolValue, BType fieldType) throws SQLException, PanickingApplicationException {
        int fieldTypeTag = fieldType.getTag();
        boolean isOriginalValueNull = this.rs.wasNull();
        if (fieldTypeTag == 21) {
            Boolean booleanValue = isOriginalValueNull ? null : Boolean.valueOf(boolValue);
            int[] expectedTypeTags = new int[]{1, 6};
            this.validateAndSetRefRecordField(bStruct, fieldName, expectedTypeTags, this.retrieveNonNilTypeTag(fieldType), (Object)booleanValue, UNASSIGNABLE_UNIONTYPE_EXCEPTION);
        } else if (isOriginalValueNull) {
            this.handleNilToNonNillableFieldAssignment();
        } else {
            int[] expectedTypeTags = new int[]{1, 6};
            this.validateAndSetRefRecordField(bStruct, fieldName, expectedTypeTags, fieldTypeTag, (Object)boolValue, MISMATCHING_FIELD_ASSIGNMENT);
        }
    }

    private void handleDateValue(MapValue<String, Object> record, String fieldName, java.util.Date date, BType fieldType) throws PanickingApplicationException {
        int fieldTypeTag = fieldType.getTag();
        if (fieldTypeTag == 21) {
            this.handleMappingDateValueToUnionType(fieldType, record, fieldName, date);
        } else {
            this.handleMappingDateValueToNonUnionType(date, fieldTypeTag, record, fieldName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleBinaryValue(MapValue<String, Object> bStruct, String fieldName, byte[] bytes, BType fieldType) throws PanickingApplicationException {
        int fieldTypeTag = fieldType.getTag();
        if (fieldTypeTag == 21) {
            BType nonNillType = this.retrieveNonNilType(((BUnionType)fieldType).getMemberTypes());
            if (nonNillType.getTag() == 20) {
                int elementTypeTag = ((BArrayType)nonNillType).getElementType().getTag();
                if (elementTypeTag == 2) {
                    ArrayValueImpl refValue = bytes == null ? null : new ArrayValueImpl(bytes);
                    bStruct.put((Object)fieldName, (Object)refValue);
                    return;
                } else {
                    this.handleUnAssignableUnionTypeAssignment();
                }
                return;
            } else {
                this.handleUnAssignableUnionTypeAssignment();
            }
            return;
        } else if (bytes != null) {
            if (20 != fieldTypeTag) throw new PanickingApplicationException(MISMATCHING_FIELD_ASSIGNMENT);
            int elementTypeTag = ((BArrayType)fieldType).getElementType().getTag();
            if (elementTypeTag != 2) throw new PanickingApplicationException(MISMATCHING_FIELD_ASSIGNMENT);
            bStruct.put((Object)fieldName, (Object)new ArrayValueImpl(bytes));
            return;
        } else {
            this.handleNilToNonNillableFieldAssignment();
        }
    }

    private void handleStringValue(String stringValue, String fieldName, MapValue<String, Object> bStruct, BType fieldType) throws PanickingApplicationException {
        int fieldTypeTag = fieldType.getTag();
        if (fieldTypeTag == 21) {
            int[] expectedTypeTags = new int[]{5, 7};
            this.validateAndSetRefRecordField(bStruct, fieldName, expectedTypeTags, this.retrieveNonNilTypeTag(fieldType), (Object)stringValue, UNASSIGNABLE_UNIONTYPE_EXCEPTION);
        } else if (stringValue != null) {
            int[] expectedTypeTags = new int[]{5, 7};
            this.validateAndSetRefRecordField(bStruct, fieldName, expectedTypeTags, fieldTypeTag, (Object)stringValue, MISMATCHING_FIELD_ASSIGNMENT);
        } else {
            this.handleNilToNonNillableFieldAssignment();
        }
    }

    private void handleOIDValue(int index, MapValue<String, Object> bStruct, String fieldName, BType fieldType) throws SQLException, PanickingApplicationException {
        int fieldTypeTag = fieldType.getTag();
        if (fieldTypeTag == 21) {
            BType nonNilType = this.retrieveNonNilType(((BUnionType)fieldType).getMemberTypes());
            this.assignOIDValue(nonNilType.getTag(), nonNilType, fieldName, index, bStruct, this.unassignableUnionTypeAssignmentHandler);
        } else {
            long longValue = this.rs.getLong(index);
            boolean isOriginalValueNull = this.rs.wasNull();
            if (longValue == 0L && isOriginalValueNull) {
                this.handleNilToNonNillableFieldAssignment();
            } else {
                this.assignOIDValue(fieldTypeTag, fieldType, fieldName, index, bStruct, this.mismatchingFieldAssignmentHandler);
            }
        }
    }

    private void assignOIDValue(int fieldTypeTag, BType fieldType, String fieldName, int index, MapValue<String, Object> bStruct, ErrorHandlerFunction errorHandlerFunction) throws SQLException, PanickingApplicationException {
        if (fieldTypeTag == 20) {
            int elementTypeTag = ((BArrayType)fieldType).getElementType().getTag();
            if (elementTypeTag == 2) {
                Blob blobValue = this.rs.getBlob(index);
                byte[] bytes = blobValue.getBytes(1L, (int)blobValue.length());
                bStruct.put((Object)fieldName, (Object)(bytes == null ? null : new ArrayValueImpl(bytes)));
            } else {
                errorHandlerFunction.apply();
            }
        } else if (fieldTypeTag == 1) {
            bStruct.put((Object)fieldName, (Object)this.rs.getLong(index));
        } else {
            errorHandlerFunction.apply();
        }
    }

    private void handleLongValue(long longValue, MapValue<String, Object> bStruct, String fieldName, BType fieldType) throws SQLException, PanickingApplicationException {
        boolean isOriginalValueNull = this.rs.wasNull();
        int fieldTypeTag = fieldType.getTag();
        if (fieldTypeTag == 21) {
            Long refValue = isOriginalValueNull ? null : Long.valueOf(longValue);
            this.validateAndSetRefRecordField(bStruct, fieldName, 1, this.retrieveNonNilTypeTag(fieldType), (Object)refValue, UNASSIGNABLE_UNIONTYPE_EXCEPTION);
        } else if (isOriginalValueNull) {
            this.handleNilToNonNillableFieldAssignment();
        } else {
            this.validateAndSetRefRecordField(bStruct, fieldName, 1, fieldTypeTag, (Object)longValue, MISMATCHING_FIELD_ASSIGNMENT);
        }
    }

    private void handleDoubleValue(double fValue, MapValue<String, Object> bStruct, String fieldName, BType fieldType) throws SQLException, PanickingApplicationException {
        boolean isOriginalValueNull = this.rs.wasNull();
        int fieldTypeTag = fieldType.getTag();
        if (fieldTypeTag == 21) {
            Double refValue = isOriginalValueNull ? null : Double.valueOf(fValue);
            this.validateAndSetRefRecordField(bStruct, fieldName, 3, this.retrieveNonNilTypeTag(fieldType), (Object)refValue, UNASSIGNABLE_UNIONTYPE_EXCEPTION);
        } else if (isOriginalValueNull) {
            this.handleNilToNonNillableFieldAssignment();
        } else {
            this.validateAndSetRefRecordField(bStruct, fieldName, 3, fieldTypeTag, (Object)fValue, MISMATCHING_FIELD_ASSIGNMENT);
        }
    }

    private void handleDecimalValue(BigDecimal fValue, MapValue<String, Object> bStruct, String fieldName, BType fieldType) throws SQLException, PanickingApplicationException {
        boolean isOriginalValueNull = this.rs.wasNull();
        int fieldTypeTag = fieldType.getTag();
        if (fieldTypeTag == 21) {
            DecimalValue refValue = isOriginalValueNull ? null : new DecimalValue(fValue);
            this.validateAndSetDecimalValue(bStruct, fieldName, this.retrieveNonNilTypeTag(fieldType), refValue, UNASSIGNABLE_UNIONTYPE_EXCEPTION);
        } else if (isOriginalValueNull) {
            this.handleNilToNonNillableFieldAssignment();
        } else {
            this.validateAndSetDecimalValue(bStruct, fieldName, fieldTypeTag, new DecimalValue(fValue), MISMATCHING_FIELD_ASSIGNMENT);
        }
    }

    private void handleMappingDateValueToUnionType(BType fieldType, MapValue<String, Object> record, String fieldName, java.util.Date date) throws PanickingApplicationException {
        int type = this.retrieveNonNilTypeTag(fieldType);
        switch (type) {
            case 5: {
                String dateValue = SQLDatasourceUtils.getString(date);
                record.put((Object)fieldName, (Object)dateValue);
                break;
            }
            case 12: 
            case 34: {
                record.put((Object)fieldName, date != null ? this.createTimeStruct(date.getTime()) : null);
                break;
            }
            case 1: {
                record.put((Object)fieldName, date != null ? Long.valueOf(date.getTime()) : null);
                break;
            }
            default: {
                this.handleMismatchingFieldAssignment();
            }
        }
    }

    private void handleMappingDateValueToNonUnionType(java.util.Date date, int fieldTypeTag, MapValue<String, Object> record, String fieldName) throws PanickingApplicationException {
        if (date != null) {
            switch (fieldTypeTag) {
                case 5: {
                    String dateValue = SQLDatasourceUtils.getString(date);
                    record.put((Object)fieldName, (Object)dateValue);
                    break;
                }
                case 12: 
                case 34: {
                    record.put((Object)fieldName, this.createTimeStruct(date.getTime()));
                    break;
                }
                case 1: {
                    record.put((Object)fieldName, (Object)date.getTime());
                    break;
                }
                default: {
                    this.handleMismatchingFieldAssignment();
                    break;
                }
            }
        } else {
            this.handleNilToNonNillableFieldAssignment();
        }
    }

    public static class SQLColumnDefinition
    extends ColumnDefinition {
        private int sqlType;

        public SQLColumnDefinition(String name, int mappedType, int sqlType) {
            super(name, mappedType);
            this.sqlType = sqlType;
        }

        public String getName() {
            return this.name;
        }

        public int getTypeTag() {
            return this.mappedTypeTag;
        }

        public int getSqlType() {
            return this.sqlType;
        }
    }

    @FunctionalInterface
    private static interface ErrorHandlerFunction {
        public void apply() throws PanickingApplicationException;
    }
}

