/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;

public class BXMLCodePointIterator
implements BIterator {
    private String charSequence;
    private int offset;

    public BXMLCodePointIterator(String charSequence) {
        this.charSequence = charSequence;
        this.offset = 0;
    }

    static BXMLCodePointIterator from(String seq) {
        return new BXMLCodePointIterator(seq);
    }

    @Override
    public BValue getNext() {
        int codePoint = this.charSequence.codePointAt(this.offset);
        this.offset += Character.charCount(codePoint);
        StringBuilder sb = new StringBuilder(2);
        sb.appendCodePoint(codePoint);
        return new BString(sb.toString());
    }

    @Override
    public boolean hasNext() {
        return this.offset < this.charSequence.length();
    }
}

