/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ballerinalang.model.ColumnDefinition;
import org.ballerinalang.model.DataIterator;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BField;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.types.BUnionType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.util.JsonParser;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BDecimal;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.model.values.BXMLItem;
import org.ballerinalang.util.TableResourceManager;
import org.ballerinalang.util.exceptions.BallerinaException;

public class TableIterator
implements DataIterator {
    protected ResultSet rs;
    protected TableResourceManager resourceManager;
    protected BStructureType type;
    protected List<ColumnDefinition> columnDefs;

    public TableIterator(TableResourceManager rm, ResultSet rs, BStructureType type, List<ColumnDefinition> columnDefs) {
        this.resourceManager = rm;
        this.rs = rs;
        this.type = type;
        this.columnDefs = columnDefs;
    }

    public TableIterator(TableResourceManager rm, ResultSet rs, BStructureType type) {
        this.resourceManager = rm;
        this.rs = rs;
        this.type = type;
        this.generateColumnDefinitions();
    }

    @Override
    public boolean next() {
        if (this.rs == null) {
            return false;
        }
        try {
            return this.rs.next();
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.rs != null && !this.rs.isClosed()) {
                this.rs.close();
            }
            this.resourceManager.releaseResources();
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    @Override
    public void reset() {
        this.close();
    }

    @Override
    public String getString(int columnIndex) {
        try {
            String val = this.rs.getString(columnIndex);
            return this.rs.wasNull() ? null : val;
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    @Override
    public Long getInt(int columnIndex) {
        try {
            long val = this.rs.getLong(columnIndex);
            return this.rs.wasNull() ? null : Long.valueOf(val);
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    @Override
    public Double getFloat(int columnIndex) {
        try {
            double val = this.rs.getDouble(columnIndex);
            return this.rs.wasNull() ? null : Double.valueOf(val);
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getBoolean(int columnIndex) {
        try {
            boolean val = this.rs.getBoolean(columnIndex);
            return this.rs.wasNull() ? null : Boolean.valueOf(val);
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    @Override
    public String getBlob(int columnIndex) {
        try {
            Blob bValue = this.rs.getBlob(columnIndex);
            return this.rs.wasNull() ? null : new String(bValue.getBytes(1L, (int)bValue.length()));
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    @Override
    public BigDecimal getDecimal(int columnIndex) {
        try {
            BigDecimal val = this.rs.getBigDecimal(columnIndex);
            return this.rs.wasNull() ? null : val;
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    @Override
    public Object[] getStruct(int columnIndex) {
        Object[] objArray = null;
        try {
            Struct data = (Struct)this.rs.getObject(columnIndex);
            if (!this.rs.wasNull() && data != null) {
                objArray = data.getAttributes();
            }
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
        return objArray;
    }

    @Override
    public Object[] getArray(int columnIndex) {
        try {
            return this.generateArrayDataResult(this.rs.getArray(columnIndex));
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), e);
        }
    }

    private Object[] generateArrayDataResult(Array array) throws SQLException {
        Object[] objArray = null;
        if (!this.rs.wasNull()) {
            objArray = (Object[])array.getArray();
        }
        return objArray;
    }

    public BMap<String, BValue> generateNext() {
        BMap<String, BValue> bStruct = new BMap<String, BValue>(this.type);
        int index = 0;
        try {
            Collection<BField> structFields = this.type.getFields().values();
            for (BField sf : structFields) {
                BType type = sf.getFieldType();
                String fieldName = sf.fieldName;
                BRefType<String> value = null;
                ++index;
                switch (type.getTag()) {
                    case 1: {
                        long iValue = this.rs.getInt(index);
                        value = new BInteger(iValue);
                        break;
                    }
                    case 5: {
                        String sValue = this.rs.getString(index);
                        value = new BString(sValue);
                        break;
                    }
                    case 3: {
                        double dValue = this.rs.getDouble(index);
                        value = new BFloat(dValue);
                        break;
                    }
                    case 4: {
                        BigDecimal decimalValue = this.rs.getBigDecimal(index);
                        value = new BDecimal(decimalValue);
                        break;
                    }
                    case 6: {
                        boolean boolValue = this.rs.getBoolean(index);
                        value = new BBoolean(boolValue);
                        break;
                    }
                    case 7: {
                        String jsonValue = this.rs.getString(index);
                        value = JsonParser.parse(jsonValue);
                        break;
                    }
                    case 8: {
                        String xmlValue = this.rs.getString(index);
                        value = new BXMLItem(xmlValue);
                        break;
                    }
                    case 19: {
                        BType arrayElementType = ((BArrayType)type).getElementType();
                        if (arrayElementType.getTag() == 2) {
                            Blob blobValue = this.rs.getBlob(index);
                            value = new BValueArray(blobValue.getBytes(1L, (int)blobValue.length()));
                            break;
                        }
                        Array arrayValue = this.rs.getArray(index);
                        value = this.getDataArray(arrayValue);
                    }
                }
                bStruct.put(fieldName, value);
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("error in generating next row of data :" + e.getMessage());
        }
        return bStruct;
    }

    @Override
    public List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefs;
    }

    @Override
    public BStructureType getStructType() {
        return this.type;
    }

    protected BNewArray getDataArray(Array array) throws SQLException {
        Object[] dataArray = this.generateArrayDataResult(array);
        if (dataArray == null || dataArray.length == 0) {
            return null;
        }
        ArrayElementAttributes nullabilityAttributes = this.getArrayElementNullabilityInfo(dataArray);
        Object firstNonNullElement = nullabilityAttributes.getFirstNonNullElement();
        boolean containsNull = nullabilityAttributes.containsNull();
        int length = dataArray.length;
        if (firstNonNullElement == null) {
            return new BValueArray(new BRefType[length], new BArrayType(BTypes.typeNull));
        }
        if (containsNull) {
            return this.createAndPopulateRefValueArray(firstNonNullElement, dataArray);
        }
        return this.createAndPopulatePrimitiveValueArray(firstNonNullElement, dataArray);
    }

    private BNewArray createAndPopulatePrimitiveValueArray(Object firstNonNullElement, Object[] dataArray) {
        int length = dataArray.length;
        if (firstNonNullElement instanceof String) {
            BValueArray stringDataArray = new BValueArray(BTypes.typeString);
            for (int i = 0; i < length; ++i) {
                stringDataArray.add((long)i, (String)dataArray[i]);
            }
            return stringDataArray;
        }
        if (firstNonNullElement instanceof Boolean) {
            BValueArray boolDataArray = new BValueArray(BTypes.typeBoolean);
            for (int i = 0; i < length; ++i) {
                boolDataArray.add((long)i, (Boolean)dataArray[i] != false ? 1 : 0);
            }
            return boolDataArray;
        }
        if (firstNonNullElement instanceof Integer) {
            BValueArray intDataArray = new BValueArray(BTypes.typeInt);
            for (int i = 0; i < length; ++i) {
                intDataArray.add((long)i, (Integer)dataArray[i]);
            }
            return intDataArray;
        }
        if (firstNonNullElement instanceof Long) {
            BValueArray longDataArray = new BValueArray(BTypes.typeInt);
            for (int i = 0; i < length; ++i) {
                longDataArray.add((long)i, (Long)dataArray[i]);
            }
            return longDataArray;
        }
        if (firstNonNullElement instanceof Float) {
            BValueArray floatDataArray = new BValueArray(BTypes.typeFloat);
            for (int i = 0; i < length; ++i) {
                floatDataArray.add((long)i, ((Float)dataArray[i]).floatValue());
            }
            return floatDataArray;
        }
        if (firstNonNullElement instanceof Double) {
            BValueArray doubleDataArray = new BValueArray(BTypes.typeFloat);
            for (int i = 0; i < dataArray.length; ++i) {
                doubleDataArray.add((long)i, (Double)dataArray[i]);
            }
            return doubleDataArray;
        }
        if (firstNonNullElement instanceof BigDecimal) {
            BValueArray decimalDataArray = new BValueArray(BTypes.typeDecimal);
            for (int i = 0; i < dataArray.length; ++i) {
                decimalDataArray.add((long)i, new BDecimal((BigDecimal)dataArray[i]));
            }
            return decimalDataArray;
        }
        return null;
    }

    private BValueArray createAndPopulateRefValueArray(Object firstNonNullElement, Object[] dataArray) {
        BValueArray refValueArray;
        block8: {
            int length;
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block7: {
                                    refValueArray = null;
                                    length = dataArray.length;
                                    if (!(firstNonNullElement instanceof String)) break block7;
                                    refValueArray = this.createEmptyRefValueArray(BTypes.typeString, length);
                                    for (int i = 0; i < length; ++i) {
                                        refValueArray.add((long)i, dataArray[i] != null ? new BString((String)dataArray[i]) : null);
                                    }
                                    break block8;
                                }
                                if (!(firstNonNullElement instanceof Boolean)) break block9;
                                refValueArray = this.createEmptyRefValueArray(BTypes.typeBoolean, length);
                                for (int i = 0; i < length; ++i) {
                                    refValueArray.add((long)i, dataArray[i] != null ? new BBoolean((Boolean)dataArray[i]) : null);
                                }
                                break block8;
                            }
                            if (!(firstNonNullElement instanceof Integer)) break block10;
                            refValueArray = this.createEmptyRefValueArray(BTypes.typeInt, length);
                            for (int i = 0; i < length; ++i) {
                                refValueArray.add((long)i, dataArray[i] != null ? new BInteger(((Integer)dataArray[i]).intValue()) : null);
                            }
                            break block8;
                        }
                        if (!(firstNonNullElement instanceof Long)) break block11;
                        refValueArray = this.createEmptyRefValueArray(BTypes.typeInt, length);
                        for (int i = 0; i < length; ++i) {
                            refValueArray.add((long)i, dataArray[i] != null ? new BInteger((Long)dataArray[i]) : null);
                        }
                        break block8;
                    }
                    if (!(firstNonNullElement instanceof Float)) break block12;
                    refValueArray = this.createEmptyRefValueArray(BTypes.typeFloat, length);
                    for (int i = 0; i < length; ++i) {
                        refValueArray.add((long)i, dataArray[i] != null ? new BFloat(((Float)dataArray[i]).floatValue()) : null);
                    }
                    break block8;
                }
                if (!(firstNonNullElement instanceof Double)) break block13;
                refValueArray = this.createEmptyRefValueArray(BTypes.typeFloat, length);
                for (int i = 0; i < length; ++i) {
                    refValueArray.add((long)i, dataArray[i] != null ? new BFloat((Double)dataArray[i]) : null);
                }
                break block8;
            }
            if (!(firstNonNullElement instanceof BigDecimal)) break block8;
            refValueArray = this.createEmptyRefValueArray(BTypes.typeDecimal, length);
            for (int i = 0; i < length; ++i) {
                refValueArray.add((long)i, dataArray[i] != null ? new BDecimal((BigDecimal)dataArray[i]) : null);
            }
        }
        return refValueArray;
    }

    private BValueArray createEmptyRefValueArray(BType type, int length) {
        ArrayList<BType> memberTypes = new ArrayList<BType>(2);
        memberTypes.add(type);
        memberTypes.add(BTypes.typeNull);
        BUnionType unionType = new BUnionType(memberTypes);
        return new BValueArray(new BRefType[length], new BArrayType(unionType));
    }

    private ArrayElementAttributes getArrayElementNullabilityInfo(Object[] objects) {
        int i;
        ArrayElementAttributes arrayElementAttributes = new ArrayElementAttributes();
        for (i = 0; i < objects.length; ++i) {
            if (objects[i] == null) continue;
            arrayElementAttributes.setFirstNonNullElement(objects[i]);
            if (i > 0) {
                arrayElementAttributes.setContainsNull(true);
            }
            ++i;
            break;
        }
        if (!arrayElementAttributes.containsNull()) {
            while (i < objects.length) {
                if (objects[i] == null) {
                    arrayElementAttributes.setContainsNull(true);
                    break;
                }
                ++i;
            }
        }
        return arrayElementAttributes;
    }

    private void generateColumnDefinitions() {
        Collection<BField> structFields = this.type.getFields().values();
        this.columnDefs = new ArrayList<ColumnDefinition>(structFields.size());
        for (BField sf : structFields) {
            BType type = sf.getFieldType();
            TypeKind typeKind = TypeKind.ANY;
            switch (type.getTag()) {
                case 1: {
                    typeKind = TypeKind.INT;
                    break;
                }
                case 5: {
                    typeKind = TypeKind.STRING;
                    break;
                }
                case 3: {
                    typeKind = TypeKind.FLOAT;
                    break;
                }
                case 6: {
                    typeKind = TypeKind.BOOLEAN;
                    break;
                }
                case 7: {
                    typeKind = TypeKind.JSON;
                    break;
                }
                case 8: {
                    typeKind = TypeKind.XML;
                    break;
                }
                case 19: {
                    BType elementType = ((BArrayType)type).getElementType();
                    typeKind = elementType.getTag() == 2 ? TypeKind.BLOB : TypeKind.ARRAY;
                }
            }
            ColumnDefinition def = new ColumnDefinition(sf.fieldName, typeKind);
            this.columnDefs.add(def);
        }
    }

    private static class ArrayElementAttributes {
        private Object firstNonNullElement;
        private boolean containsNull;

        private ArrayElementAttributes() {
        }

        private void setFirstNonNullElement(Object firstNonNullElement) {
            this.firstNonNullElement = firstNonNullElement;
        }

        private void setContainsNull(boolean containsNull) {
            this.containsNull = containsNull;
        }

        private Object getFirstNonNullElement() {
            return this.firstNonNullElement;
        }

        private boolean containsNull() {
            return this.containsNull;
        }
    }
}

